/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public class SimpleFeatureImplTest
extends TestCase {
    SimpleFeatureType schema;
    SimpleFeature feature;

    protected void setUp() throws Exception {
        super.setUp();
        this.schema = DataUtilities.createType((String)"buildings", (String)"the_geom:MultiPolygon,name:String,ADDRESS:String");
        this.feature = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{null, "ABC", "Random Road, 12"}, (String)"building.1");
    }

    public void testGetProperty() {
        SimpleFeatureImplTest.assertEquals((Object)"ABC", (Object)this.feature.getProperty("name").getValue());
        SimpleFeatureImplTest.assertNull((Object)this.feature.getProperty("NOWHERE"));
        SimpleFeatureImplTest.assertEquals((int)0, (int)this.feature.getProperties("NOWHERE").size());
    }

    public void testGetPropertyNullValue() {
        SimpleFeatureImplTest.assertNotNull((Object)this.feature.getProperty("the_geom"));
        SimpleFeatureImplTest.assertNull((Object)this.feature.getProperty("the_geom").getValue());
    }

    public void testGeometryPropertyType() {
        SimpleFeatureImplTest.assertTrue((String)("expected GeometryAttribute, got " + this.feature.getProperty("the_geom").getClass().getName()), (boolean)(this.feature.getProperty("the_geom") instanceof GeometryAttribute));
    }

    public void testDefaultGeometryProperty() {
        SimpleFeatureImplTest.assertTrue((String)("expected GeometryAttribute, got " + this.feature.getProperty("the_geom").getClass().getName()), (boolean)(this.feature.getProperty("the_geom") instanceof GeometryAttribute));
        GeometryAttribute defaultGeometryProperty = this.feature.getDefaultGeometryProperty();
        SimpleFeatureImplTest.assertNotNull((Object)defaultGeometryProperty);
        SimpleFeatureImplTest.assertNull((Object)defaultGeometryProperty.getValue());
        SimpleFeatureImplTest.assertNotNull((Object)defaultGeometryProperty.getDescriptor());
        SimpleFeatureImplTest.assertTrue((boolean)(defaultGeometryProperty.getDescriptor() instanceof GeometryDescriptor));
    }

    public void testGetName() {
        SimpleFeatureImplTest.assertNotNull((Object)this.feature.getName());
        SimpleFeatureImplTest.assertEquals((Object)this.feature.getFeatureType().getName(), (Object)this.feature.getName());
    }

    public void testGetDescriptor() {
        SimpleFeatureImplTest.assertNotNull((Object)this.feature.getDescriptor());
        SimpleFeatureImplTest.assertSame((Object)this.feature.getType(), (Object)this.feature.getDescriptor().getType());
        SimpleFeatureImplTest.assertTrue((boolean)this.feature.getDescriptor().isNillable());
        SimpleFeatureImplTest.assertEquals((int)0, (int)this.feature.getDescriptor().getMinOccurs());
        SimpleFeatureImplTest.assertEquals((int)Integer.MAX_VALUE, (int)this.feature.getDescriptor().getMaxOccurs());
    }
}

