/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.Types;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public class TypesTest
extends TestCase {
    public void testWithoutRestriction() {
        FilterFactory fac = CommonFactoryFinder.getFilterFactory(null);
        String attributeName = "string";
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("test");
        builder.add(attributeName, String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"Value"}, null);
        TypesTest.assertNotNull((Object)feature);
    }

    public void testRestrictionCheck() {
        FilterFactory fac = CommonFactoryFinder.getFilterFactory(null);
        String attributeName = "string";
        PropertyIsEqualTo filter = fac.equals((Expression)fac.property("."), (Expression)fac.literal((Object)"Value"));
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("test");
        builder.restriction((Filter)filter).add(attributeName, String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"Value"}, null);
        TypesTest.assertNotNull((Object)feature);
    }

    public void testAssertNamedAssignable() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Test");
        builder.add("name", String.class);
        builder.add("age", Double.class);
        SimpleFeatureType test = builder.buildFeatureType();
        builder.setName("Test");
        builder.add("age", Double.class);
        builder.add("name", String.class);
        SimpleFeatureType test2 = builder.buildFeatureType();
        builder.setName("Test");
        builder.add("name", String.class);
        SimpleFeatureType test3 = builder.buildFeatureType();
        builder.setName("Test");
        builder.add("name", String.class);
        builder.add("distance", Double.class);
        SimpleFeatureType test4 = builder.buildFeatureType();
        Types.assertNameAssignable((FeatureType)test, (FeatureType)test);
        Types.assertNameAssignable((FeatureType)test, (FeatureType)test2);
        Types.assertNameAssignable((FeatureType)test2, (FeatureType)test);
        try {
            Types.assertNameAssignable((FeatureType)test, (FeatureType)test3);
            TypesTest.fail((String)"Expected assertNameAssignable to fail as age is not covered");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        Types.assertOrderAssignable((SimpleFeatureType)test, (SimpleFeatureType)test4);
    }
}

