/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.ArrayList;
import org.geotools.filter.function.SEFunctionTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class CategorizeFunctionTest
extends SEFunctionTestBase {
    @Before
    public void setup() {
        this.parameters = new ArrayList();
    }

    @Test
    public void testFindCategorizeFunction() throws Exception {
        System.out.println("   testFindCategorizeFunction");
        Literal fallback = this.ff2.literal((Object)"NOT_FOUND");
        this.parameters.add(this.ff2.property("value"));
        this.parameters.add(this.ff2.literal(0));
        Function fn = this.finder.findFunction("categorize", this.parameters, fallback);
        Object result = fn.evaluate((Object)this.feature(0));
        Assert.assertFalse((String)"Could not locate 'categorize' function", (boolean)result.equals(fallback.getValue()));
    }

    @Test
    public void testNoThresholds() throws Exception {
        System.out.println("   testNoThresholds");
        int categoryValue = 42;
        this.parameters.add(this.ff2.property("value"));
        this.parameters.add(this.ff2.literal(42));
        Function fn = this.finder.findFunction("categorize", this.parameters);
        Integer result = (Integer)fn.evaluate((Object)this.feature(0), Integer.class);
        Assert.assertEquals((long)42L, (long)result.intValue());
    }

    @Test
    public void testSucceedingThresholds() throws Exception {
        String result;
        System.out.println("   testSucceedingThresholds");
        Object[] categories = new String[]{"low", "mid", "high", "super"};
        Object[] thresholds = new Double[]{0.0, 50.0, 100.0};
        this.setupParameters(categories, thresholds);
        Function fn = this.finder.findFunction("categorize", this.parameters);
        for (int i = 0; i < thresholds.length; ++i) {
            result = (String)fn.evaluate((Object)this.feature(((Double)thresholds[i]).intValue() - 1), String.class);
            Assert.assertEquals((Object)categories[i], (Object)result);
            result = (String)fn.evaluate((Object)this.feature(((Double)thresholds[i]).intValue()), String.class);
            Assert.assertEquals((Object)categories[i + 1], (Object)result);
        }
        result = (String)fn.evaluate((Object)this.feature(((Double)thresholds[thresholds.length - 1]).intValue() + 1), String.class);
        Assert.assertEquals((Object)categories[categories.length - 1], (Object)result);
    }

    @Test
    public void testPrecedingThresholds() throws Exception {
        String result;
        System.out.println("   testPrecedingThresholds");
        Object[] categories = new String[]{"low", "mid", "high", "super"};
        Object[] thresholds = new Double[]{0.0, 50.0, 100.0};
        this.setupParameters(categories, thresholds);
        this.parameters.add(this.ff2.literal((Object)"preceding"));
        Function fn = this.finder.findFunction("categorize", this.parameters);
        for (int i = 0; i < thresholds.length; ++i) {
            result = (String)fn.evaluate((Object)this.feature(((Double)thresholds[i]).intValue() - 1), String.class);
            Assert.assertEquals((Object)categories[i], (Object)result);
            result = (String)fn.evaluate((Object)this.feature(((Double)thresholds[i]).intValue()), String.class);
            Assert.assertEquals((Object)categories[i], (Object)result);
        }
        result = (String)fn.evaluate((Object)this.feature(((Double)thresholds[thresholds.length - 1]).intValue() + 1), String.class);
        Assert.assertEquals((Object)categories[categories.length - 1], (Object)result);
    }

    @Ignore(value="WRITE ME")
    @Test
    public void testRasterData() {
    }

    private void setupParameters(Object[] categories, Object[] thresholds) {
        if (thresholds.length != categories.length - 1) {
            throw new IllegalArgumentException("should be n thresholds and n+1 categories");
        }
        this.parameters = new ArrayList();
        this.parameters.add(this.ff2.property("value"));
        for (int i = 0; i < thresholds.length; ++i) {
            this.parameters.add(this.ff2.literal(categories[i]));
            this.parameters.add(this.ff2.literal(thresholds[i]));
        }
        this.parameters.add(this.ff2.literal(categories[categories.length - 1]));
    }
}

