/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.geotools.data.DataUtilities;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.filter.spatial.BBOXImpl;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;

public class BBOXImplTest
extends TestCase {
    public static Test suite() {
        return new TestSuite(BBOXImplTest.class);
    }

    public void testBbox() {
        Coordinate[] coords;
        FilterFactoryImpl ff = new FilterFactoryImpl();
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        coords = new Coordinate[]{new Coordinate(0.0, 1.5), new Coordinate(0.0, 2.5), new Coordinate(1.5, 3.0), new Coordinate(4.0, 2.5), new Coordinate(0.5, 1.0), coords[0]};
        Polygon p = gf.createPolygon(gf.createLinearRing(coords), null);
        SimpleFeatureType type = null;
        try {
            type = DataUtilities.createType((String)"testSchema", (String)"name:String,*geom:Geometry");
        }
        catch (SchemaException e) {
            e.printStackTrace();
        }
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("testFeature");
        attributes.add((String)p);
        SimpleFeature f = null;
        f = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{"testFeature", p}, null);
        Envelope e1 = new Envelope(3.0, 6.0, 0.0, 2.0);
        Envelope e2 = new Envelope(3.25, 3.75, 1.25, 1.75);
        BBOXImplTest.assertTrue((boolean)e1.contains(e2));
        BBOXImplTest.assertTrue((boolean)p.getEnvelopeInternal().contains(e2));
        BBOXImplTest.assertTrue((boolean)p.getEnvelopeInternal().intersects(e1));
        BBOXImpl bbox1 = (BBOXImpl)ff.bbox((Expression)ff.createAttributeExpression("geom"), e1.getMinX(), e1.getMinY(), e1.getMaxX(), e1.getMaxY(), "");
        BBOXImpl bbox2 = (BBOXImpl)ff.bbox((Expression)ff.createAttributeExpression("geom"), e2.getMinX(), e2.getMinY(), e2.getMaxX(), e2.getMaxY(), "");
        BBOXImplTest.assertFalse((boolean)bbox2.evaluate((Object)f));
        BBOXImplTest.assertFalse((boolean)bbox1.evaluate((Object)f));
    }
}

