/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.SpatialFilterVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;

public class SpatialFilterVisitorTest {
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    private SpatialFilterVisitor visitor;

    @Before
    public void setUp() throws Exception {
        this.visitor = new SpatialFilterVisitor();
    }

    @Test
    public void testInclude() {
        Filter.INCLUDE.accept((FilterVisitor)this.visitor, null);
        Assert.assertFalse((boolean)this.visitor.hasSpatialFilter);
    }

    @Test
    public void testExclude() {
        Filter.EXCLUDE.accept((FilterVisitor)this.visitor, null);
        Assert.assertFalse((boolean)this.visitor.hasSpatialFilter);
    }

    @Test
    public void testBBOX() {
        this.ff.bbox("geom", 0.0, 0.0, 10.0, 10.0, "EPSG:4326").accept((FilterVisitor)this.visitor, null);
        Assert.assertTrue((boolean)this.visitor.hasSpatialFilter);
    }

    @Test
    public void testIntersects() {
        this.ff.intersects((Expression)this.ff.property("geom"), (Expression)this.ff.literal(null)).accept((FilterVisitor)this.visitor, null);
        Assert.assertTrue((boolean)this.visitor.hasSpatialFilter);
    }

    @Test
    public void testOverlaps() {
        this.ff.overlaps((Expression)this.ff.property("geom"), (Expression)this.ff.literal(null)).accept((FilterVisitor)this.visitor, null);
        Assert.assertTrue((boolean)this.visitor.hasSpatialFilter);
    }
}

