/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.coordinatesequence;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.coordinatesequence.CoordinateSequences;
import org.junit.Assert;
import org.junit.Test;

public class CoordinateSequencesTest {
    static GeometryFactory gf = new GeometryFactory();
    static LiteCoordinateSequenceFactory liteCSF = new LiteCoordinateSequenceFactory();
    static GeometryFactory liteGF = new GeometryFactory((CoordinateSequenceFactory)liteCSF);

    @Test
    public void testCoordinateDimensionPointLite2D() {
        Point geom = liteGF.createPoint((CoordinateSequence)new LiteCoordinateSequence(new double[]{1.0, 2.0}, 2));
        Assert.assertEquals((long)2L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }

    @Test
    public void testCoordinateDimensionPointLite3D() {
        Point geom = liteGF.createPoint((CoordinateSequence)new LiteCoordinateSequence(new double[]{1.0, 2.0, 99.0}, 3));
        Assert.assertEquals((long)3L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }

    @Test
    public void testCoordinateDimensionLineString2D() {
        LineString geom = gf.createLineString(new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0)});
        Assert.assertEquals((long)2L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }

    @Test
    public void testCoordinateDimensionLineStringLite3D() {
        LineString geom = liteGF.createLineString(liteCSF.create(new double[]{1.0, 2.0, 100.0, 3.0, 4.0, 200.0}, 3));
        Assert.assertEquals((long)3L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }

    @Test
    public void testCoordinateDimensionPolygonLite2D() {
        Polygon geom = liteGF.createPolygon(liteGF.createLinearRing(liteCSF.create(new double[]{1.0, 1.0, 2.0, 1.0, 2.0, 2.0, 1.0, 2.0, 1.0, 1.0}, 2)), null);
        Assert.assertEquals((long)2L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }

    @Test
    public void testCoordinateDimensionPolygonLite3D() {
        Polygon geom = liteGF.createPolygon(liteGF.createLinearRing(liteCSF.create(new double[]{1.0, 1.0, 100.0, 2.0, 1.0, 99.0, 2.0, 2.0, 98.0, 1.0, 2.0, 97.0, 1.0, 1.0, 100.0}, 3)), null);
        Assert.assertEquals((long)3L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }
}

