/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml.producer;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geotools.feature.FeatureCollection;
import org.geotools.gml.producer.FeatureTransformer;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class FeatureTransformerTest {
    @Before
    public void setup() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("gml", "http://www.opengis.net/gml");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    @Test
    public void testEncodeEmptyArray() throws Exception {
        FeatureTransformer tx = new FeatureTransformer();
        tx.setIndentation(2);
        tx.setCollectionBounding(true);
        tx.setFeatureBounding(true);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        tx.transform((Object)new FeatureCollection[0], (OutputStream)bos);
        String result = bos.toString();
        Document dom = XMLUnit.buildControlDocument((String)result);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"unknown", (String)"/wfs:FeatureCollection/gml:boundedBy/gml:null", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//gml:featureMember)", (Document)dom);
    }
}

