/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.ResourceLocator;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.junit.Assert;
import org.junit.Test;

public class SLDParserTest {
    public static String SLD = "<StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\" version=\"1.0.0\"> <NamedLayer>  <Name>layer</Name>  <UserStyle>   <Name>style</Name>   <FeatureTypeStyle>    <Rule>     <PolygonSymbolizer>      <Fill>       <CssParameter name=\"fill\">#FF0000</CssParameter>      </Fill>     </PolygonSymbolizer>    </Rule>   </FeatureTypeStyle>  </UserStyle> </NamedLayer></StyledLayerDescriptor>";
    static String SLD_DEFAULT_POINT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<StyledLayerDescriptor version=\"1.0.0\" \n        xsi:schemaLocation=\"http://www.opengis.net/sld StyledLayerDescriptor.xsd\" \n        xmlns=\"http://www.opengis.net/sld\" xmlns:ogc=\"http://www.opengis.net/ogc\" \n        xmlns:xlink=\"http://www.w3.org/1999/xlink\" \n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n    <UserStyle>\n        <Name>Default Styler</Name>\n        <Title>Default Styler</Title>\n        <Abstract></Abstract>\n        <FeatureTypeStyle>\n            <FeatureTypeName>Feature</FeatureTypeName>\n            <Rule>\n                <PointSymbolizer>\n                    <Graphic>\n                    </Graphic>\n                </PointSymbolizer>\n            </Rule>\n        </FeatureTypeStyle>\n    </UserStyle>\n</StyledLayerDescriptor>";
    static String SLD_EXTERNAL_GRAPHIC = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<StyledLayerDescriptor version=\"1.0.0\" \n        xsi:schemaLocation=\"http://www.opengis.net/sld StyledLayerDescriptor.xsd\" \n        xmlns=\"http://www.opengis.net/sld\" xmlns:ogc=\"http://www.opengis.net/ogc\" \n        xmlns:xlink=\"http://www.w3.org/1999/xlink\" \n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n    <UserStyle>\n        <Name>Default Styler</Name>\n        <Title>Default Styler</Title>\n        <Abstract></Abstract>\n        <FeatureTypeStyle>\n            <FeatureTypeName>Feature</FeatureTypeName>\n            <Rule>\n                <PointSymbolizer>\n                    <Graphic>\n                        <ExternalGraphic>\n                            <OnlineResource xlink:type=\"simple\"\n                                xlink:href=\"test-data/blob.gif\">\n                            </OnlineResource>\n                            <Format>image/png</Format>\n                        </ExternalGraphic>\n                        <Size>20</Size>\n                    </Graphic>\n                </PointSymbolizer>\n            </Rule>\n        </FeatureTypeStyle>\n    </UserStyle>\n</StyledLayerDescriptor>";
    static StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);

    @Test
    public void testBasic() throws Exception {
        SLDParser parser = new SLDParser(styleFactory, this.input(SLD));
        Style[] styles = parser.readXML();
        this.assertStyles(styles);
    }

    @Test
    public void testMultipleParse() throws Exception {
        SLDParser parser = new SLDParser(styleFactory, this.input(SLD));
        Style[] styles = parser.readXML();
        this.assertStyles(styles);
        styles = parser.readDOM();
        this.assertStyles(styles);
        try {
            parser.readXML();
            Assert.fail((String)"Parsing again Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDefaultPoint() throws Exception {
        SLDParser parser = new SLDParser(styleFactory, this.input(SLD_DEFAULT_POINT));
        Style[] styles = parser.readXML();
        Assert.assertEquals((long)1L, (long)styles.length);
        List fts = styles[0].featureTypeStyles();
        Assert.assertEquals((long)1L, (long)fts.size());
        List rules = ((FeatureTypeStyle)fts.get(0)).rules();
        Assert.assertEquals((long)1L, (long)rules.size());
        List symbolizers = ((Rule)rules.get(0)).symbolizers();
        Assert.assertEquals((long)1L, (long)symbolizers.size());
        PointSymbolizer ps = (PointSymbolizer)symbolizers.get(0);
        List graphicalSymbols = ps.getGraphic().graphicalSymbols();
        Assert.assertEquals((long)1L, (long)graphicalSymbols.size());
        Mark mark = (Mark)graphicalSymbols.get(0);
        Assert.assertEquals((Object)mark, (Object)CommonFactoryFinder.getStyleFactory(null).createMark());
    }

    @Test
    public void testOnlineResourceLocator() throws MalformedURLException {
        SLDParser parser = new SLDParser(styleFactory, this.input(SLD_EXTERNAL_GRAPHIC));
        parser.setOnLineResourceLocator(new ResourceLocator(){

            public URL locateResource(String uri) {
                junit.framework.Assert.assertEquals((String)"test-data/blob.gif", (String)uri);
                return this.getClass().getResource(uri);
            }
        });
        Style[] styles = parser.readXML();
        Assert.assertEquals((long)1L, (long)styles.length);
        List fts = styles[0].featureTypeStyles();
        Assert.assertEquals((long)1L, (long)fts.size());
        List rules = ((FeatureTypeStyle)fts.get(0)).rules();
        Assert.assertEquals((long)1L, (long)rules.size());
        List symbolizers = ((Rule)rules.get(0)).symbolizers();
        Assert.assertEquals((long)1L, (long)symbolizers.size());
        PointSymbolizer ps = (PointSymbolizer)symbolizers.get(0);
        List graphicalSymbols = ps.getGraphic().graphicalSymbols();
        Assert.assertEquals((long)1L, (long)graphicalSymbols.size());
        ExternalGraphic graphic = (ExternalGraphic)graphicalSymbols.get(0);
        Assert.assertEquals((Object)this.getClass().getResource("test-data/blob.gif"), (Object)graphic.getLocation());
    }

    void assertStyles(Style[] styles) {
        Assert.assertEquals((long)1L, (long)styles.length);
        Assert.assertEquals((Object)"style", (Object)styles[0].getName());
    }

    InputStream input(String sld) {
        return new ByteArrayInputStream(sld.getBytes());
    }
}

