/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import junit.framework.TestCase;
import org.geotools.data.DataStore;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.memory.MemoryFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.SLDParser;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.UserLayer;
import org.geotools.test.TestData;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class UserLayerTest
extends TestCase {
    private static final String CRS_WKT = "GEOGCS[\"WGS 84\",   DATUM[\"WGS_1984\",    SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],    AUTHORITY[\"EPSG\",\"6326\"]],  PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\", 0.017453292519943295],  AXIS[\"Lon\", EAST],  AXIS[\"Lat\", NORTH],  AUTHORITY[\"EPSG\",\"4326\"]]";
    private static final int SRID = 4326;
    private static final String LAYER_NAME = "user-layer-1";
    private static final String ID_COLUMN = "id";
    private static final String GEOMETRY_COLUMN = "geometry";
    private static final String LABEL_COLUMN = "label";
    private static final String ID_1 = "point-1";
    private static final double X_1 = -180.0;
    private static final double Y_1 = -90.0;
    private static final String LABEL_1 = "point location #1";
    private static final String ID_2 = "point-2";
    private static final double X_2 = 180.0;
    private static final double Y_2 = 90.0;
    private static final String LABEL_2 = "point location #2";
    private static final double OPACITY = 0.75;
    private static final String IMAGE_EXT = "jpg";
    private static final String IMAGE_URL = "file:/somewhere/image.jpg";
    private static final String MY_NAMESPACE = "integeo";
    private static final URI MY_URI;
    private static final String MY_FEATURE = "myFeature";

    public void testUserLayerWithInlineFeatures() throws Exception {
        CoordinateReferenceSystem crs = CRS.parseWKT((String)CRS_WKT);
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.add(ID_COLUMN, Integer.class);
        ftb.add(GEOMETRY_COLUMN, Point.class, crs);
        ftb.add(LABEL_COLUMN, String.class);
        ftb.setName(MY_FEATURE);
        SimpleFeatureType schema = ftb.buildFeatureType();
        MemoryFeatureCollection fc = new MemoryFeatureCollection(schema);
        PrecisionModel pm = new PrecisionModel(PrecisionModel.FLOATING);
        GeometryFactory jtsFactory = new GeometryFactory(pm, 4326);
        Point g1 = jtsFactory.createPoint(new Coordinate(-180.0, -90.0));
        fc.add((Feature)SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])new Object[]{new Integer(1), g1, LABEL_1}, (String)ID_1));
        Point g2 = jtsFactory.createPoint(new Coordinate(180.0, 90.0));
        fc.add((Feature)SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])new Object[]{new Integer(2), g2, LABEL_2}, (String)ID_2));
        MemoryDataStore ds = new MemoryDataStore((SimpleFeatureCollection)fc);
        StyleFactory sf = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
        UserLayer layer = sf.createUserLayer();
        layer.setName(LAYER_NAME);
        layer.setInlineFeatureType(schema);
        layer.setInlineFeatureDatastore((DataStore)ds);
        Style style = sf.createStyle();
        StyleBuilder sb = new StyleBuilder(sf);
        ExternalGraphic overlay = sb.createExternalGraphic(IMAGE_URL, "image/jpg");
        Graphic g = sb.createGraphic(overlay, null, null, 0.75, Double.NaN, 0.0);
        PointSymbolizer ps = sb.createPointSymbolizer(g);
        FeatureTypeStyle fts = sb.createFeatureTypeStyle((Symbolizer)ps);
        fts.setFeatureTypeName("integeo:myFeature");
        style.addFeatureTypeStyle(fts);
        layer.addUserStyle(style);
        StyledLayerDescriptor sld1 = sf.createStyledLayerDescriptor();
        sld1.addStyledLayer((StyledLayer)layer);
        HashMap<URI, String> nsMap = new HashMap<URI, String>();
        nsMap.put(MY_URI, MY_NAMESPACE);
        SLDTransformer sldTransformer = new SLDTransformer(nsMap);
        sldTransformer.setIndentation(2);
        String xml = sldTransformer.transform((Object)sld1);
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        SLDParser parser = new SLDParser(sf);
        parser.setInput((InputStream)is);
        StyledLayerDescriptor sld2 = parser.parseSLD();
        xml = sldTransformer.transform((Object)sld2);
        StyledLayer[] layers = sld2.getStyledLayers();
        UserLayerTest.assertNotNull((String)"Styled layers array MUST NOT be null", (Object)layers);
        UserLayerTest.assertEquals((String)"Styled layers array MUST be 1-element long", (int)1, (int)layers.length);
        StyledLayer sLayer = layers[0];
        UserLayerTest.assertNotNull((String)"Single styled layer MUST NOT be null", (Object)sLayer);
        UserLayerTest.assertTrue((String)"Single layer MUST be a UserLayer", (boolean)UserLayer.class.isAssignableFrom(sLayer.getClass()));
        UserLayer uLayer = (UserLayer)sLayer;
        String lName = uLayer.getName();
        UserLayerTest.assertEquals((String)"Read layer name MUST match", (String)LAYER_NAME, (String)lName);
        SimpleFeatureType ft = uLayer.getInlineFeatureType();
        UserLayerTest.assertNotNull((String)"Unmarshalled feature type MUST NOT be null", (Object)ft);
        String fName = ft.getTypeName();
        UserLayerTest.assertEquals((String)"Read feature type name MUST match", (String)MY_FEATURE, (String)fName);
        UserLayerTest.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)ft.getGeometryDescriptor().getCoordinateReferenceSystem());
    }

    public void testUserLayerWithRemoteOWS() throws Exception {
        URL sldUrl = TestData.getResource((Object)((Object)this), (String)"remoteOws.sld");
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        SLDParser stylereader = new SLDParser(factory, sldUrl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        UserLayerTest.assertEquals((int)1, (int)sld.getStyledLayers().length);
        UserLayerTest.assertTrue((boolean)(sld.getStyledLayers()[0] instanceof UserLayer));
        UserLayer layer = (UserLayer)sld.getStyledLayers()[0];
        UserLayerTest.assertEquals((String)"LayerWithRemoteOWS", (String)layer.getName());
        UserLayerTest.assertNotNull((Object)layer.getRemoteOWS());
        UserLayerTest.assertEquals((String)"WFS", (String)layer.getRemoteOWS().getService());
        UserLayerTest.assertEquals((String)"http://sigma.openplans.org:8080/geoserver/wfs?", (String)layer.getRemoteOWS().getOnlineResource());
        UserLayerTest.assertEquals((int)1, (int)layer.getLayerFeatureConstraints().length);
        FeatureTypeConstraint ftc = layer.getLayerFeatureConstraints()[0];
        UserLayerTest.assertEquals((String)"topp:states", (String)ftc.getFeatureTypeName());
        UserLayerTest.assertNotNull((Object)ftc.getFilter());
        UserLayerTest.assertTrue((boolean)(ftc.getFilter() instanceof PropertyIsLessThan));
    }

    static {
        try {
            MY_URI = new URI("http://geotools.org");
        }
        catch (URISyntaxException x) {
            throw new ExceptionInInitializerError(x);
        }
    }
}

