/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.awt.Color;
import java.net.URL;
import java.util.Collections;
import javax.xml.transform.TransformerException;
import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.GraphicImpl;
import org.geotools.styling.Halo;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.OtherText;
import org.geotools.styling.OtherTextImpl;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.UomOgcMapping;
import org.geotools.styling.UserLayer;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.util.Utilities;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.style.ContrastMethod;
import org.opengis.util.Cloneable;

public class DuplicatorStyleVisitorTest
extends TestCase {
    StyleBuilder sb;
    StyleFactory sf;
    FilterFactory2 ff;
    DuplicatingStyleVisitor visitor;

    public DuplicatorStyleVisitorTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.sf = CommonFactoryFinder.getStyleFactory(null);
        this.ff = CommonFactoryFinder.getFilterFactory2(null);
        this.sb = new StyleBuilder(this.sf, (FilterFactory)this.ff);
        this.visitor = new DuplicatingStyleVisitor(this.sf, this.ff);
    }

    public void testRasterSymbolizerDuplication() {
        RasterSymbolizer original = this.sb.createRasterSymbolizer();
        original.accept((StyleVisitor)this.visitor);
        RasterSymbolizer copy = (RasterSymbolizer)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertNotNull((Object)copy);
        DuplicatorStyleVisitorTest.assertEquals((Object)original, (Object)copy);
    }

    public void testStyleDuplication() throws IllegalFilterException {
        Style oldStyle = this.sb.createStyle("FTSName", (Symbolizer)this.sf.createPolygonSymbolizer());
        oldStyle.getFeatureTypeStyles()[0].setSemanticTypeIdentifiers(new String[]{"simple", "generic:geometry"});
        oldStyle.accept((StyleVisitor)this.visitor);
        Style newStyle = (Style)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertNotNull((Object)newStyle);
        DuplicatorStyleVisitorTest.assertEquals((int)2, (int)newStyle.getFeatureTypeStyles()[0].getSemanticTypeIdentifiers().length);
        DuplicatorStyleVisitorTest.assertTrue((boolean)this.areStylesEqualByXml(oldStyle, newStyle));
    }

    private String styleToXML(Style style) throws TransformerException {
        StyledLayerDescriptor sld = this.sf.createStyledLayerDescriptor();
        UserLayer layer = this.sf.createUserLayer();
        layer.setLayerFeatureConstraints(new FeatureTypeConstraint[]{null});
        sld.addStyledLayer((StyledLayer)layer);
        layer.addUserStyle(style);
        SLDTransformer styleTransform = new SLDTransformer();
        String xml = styleTransform.transform((Object)sld);
        return xml;
    }

    private boolean areStylesEqualByXml(Style s1, Style s2) {
        try {
            String xmlS1 = this.styleToXML(s1);
            String xmlS2 = this.styleToXML(s2);
            return xmlS1.equals(xmlS2);
        }
        catch (TransformerException te) {
            te.printStackTrace();
            return false;
        }
    }

    public void testStyle() throws Exception {
        FeatureTypeStyle fts = this.sf.createFeatureTypeStyle();
        fts.setFeatureTypeName("feature-type-1");
        FeatureTypeStyle fts2 = this.fts2();
        Style style = this.sf.getDefaultStyle();
        style.addFeatureTypeStyle(fts);
        style.addFeatureTypeStyle(fts2);
        style.accept((StyleVisitor)this.visitor);
        Style copy = (Style)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertEqualsContract(style, copy);
        Style notEq = this.sf.getDefaultStyle();
        fts2 = this.fts2();
        notEq.addFeatureTypeStyle(fts2);
        DuplicatorStyleVisitorTest.assertEqualsContract(copy, notEq, style);
    }

    private FeatureTypeStyle fts2() {
        FeatureTypeStyle fts2 = this.sf.createFeatureTypeStyle();
        Rule rule = this.sf.createRule();
        fts2.addRule(rule);
        fts2.setFeatureTypeName("feature-type-2");
        return fts2;
    }

    public void testFeatureTypeStyle() throws Exception {
        FeatureTypeStyle fts = this.sf.createFeatureTypeStyle();
        fts.setFeatureTypeName("feature-type");
        Rule rule1 = this.sf.createRule();
        rule1.setName("rule1");
        rule1.setFilter((Filter)this.ff.id(Collections.singleton(this.ff.featureId("FID"))));
        Rule rule2 = this.sf.createRule();
        rule2.setIsElseFilter(true);
        rule2.setName("rule2");
        fts.addRule(rule1);
        fts.addRule(rule2);
        fts.accept((StyleVisitor)this.visitor);
        FeatureTypeStyle clone = (FeatureTypeStyle)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertEqualsContract(fts, clone);
        rule1 = this.sf.createRule();
        rule1.setName("rule1");
        rule1.setFilter((Filter)this.ff.id(Collections.singleton(this.ff.featureId("FID"))));
        FeatureTypeStyle notEq = this.sf.createFeatureTypeStyle();
        notEq.setName("fts-not-equal");
        notEq.addRule(rule1);
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, notEq, fts);
    }

    public void testRule() throws Exception {
        LineSymbolizer symb1 = this.sf.createLineSymbolizer(this.sf.getDefaultStroke(), "geometry");
        PolygonSymbolizer symb2 = this.sf.createPolygonSymbolizer(this.sf.getDefaultStroke(), this.sf.getDefaultFill(), "shape");
        Rule rule = this.sf.createRule();
        rule.setSymbolizers(new Symbolizer[]{symb1, symb2});
        rule.accept((StyleVisitor)this.visitor);
        Rule clone = (Rule)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertCopy(rule, clone);
        DuplicatorStyleVisitorTest.assertEqualsContract(rule, clone);
        symb2 = this.sf.createPolygonSymbolizer(this.sf.getDefaultStroke(), this.sf.getDefaultFill(), "shape");
        Rule notEq = this.sf.createRule();
        notEq.setSymbolizers(new Symbolizer[]{symb2});
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, notEq, rule);
        symb1 = this.sf.createLineSymbolizer(this.sf.getDefaultStroke(), "geometry");
        clone.setSymbolizers(new Symbolizer[]{symb1});
        DuplicatorStyleVisitorTest.assertTrue((!rule.equals(clone) ? 1 : 0) != 0);
    }

    public void testPointSymbolizer() throws Exception {
        URL urlExternal = ((Object)((Object)this)).getClass().getResource("/data/sld/blob.gif");
        ExternalGraphic extg = this.sb.createExternalGraphic(urlExternal, "image/svg+xml");
        Graphic graphic = this.sb.createGraphic(extg, null, null);
        PointSymbolizer pointSymb = this.sb.createPointSymbolizer(graphic);
        pointSymb.accept((StyleVisitor)this.visitor);
        PointSymbolizer clone = (PointSymbolizer)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertCopy(pointSymb, clone);
        DuplicatorStyleVisitorTest.assertEqualsContract(pointSymb, clone);
        PointSymbolizer notEq = this.sf.getDefaultPointSymbolizer();
        notEq.setGeometryPropertyName("something_else");
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, notEq, pointSymb);
    }

    public void testRasterSymbolizerWithUOM() throws Exception {
        RasterSymbolizer rasterSymb = this.sf.createRasterSymbolizer();
        rasterSymb.setUnitOfMeasure(UomOgcMapping.FOOT.getUnit());
        rasterSymb.accept((StyleVisitor)this.visitor);
        RasterSymbolizer clone = (RasterSymbolizer)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertEquals((Object)clone.getUnitOfMeasure(), (Object)rasterSymb.getUnitOfMeasure());
        RasterSymbolizer notEq = this.sf.createRasterSymbolizer();
        DuplicatorStyleVisitorTest.assertFalse((boolean)Utilities.equals((Object)notEq.getUnitOfMeasure(), (Object)rasterSymb.getUnitOfMeasure()));
    }

    public void testPointSymbolizerWithUOM() throws Exception {
        PointSymbolizer pointSymb = this.sf.createPointSymbolizer();
        pointSymb.setUnitOfMeasure(UomOgcMapping.FOOT.getUnit());
        pointSymb.accept((StyleVisitor)this.visitor);
        PointSymbolizer clone = (PointSymbolizer)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertCopy(pointSymb, clone);
        DuplicatorStyleVisitorTest.assertEqualsContract(pointSymb, clone);
        PointSymbolizer notEq = this.sf.getDefaultPointSymbolizer();
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, notEq, pointSymb);
    }

    public void testTextSymbolizer() {
        TextSymbolizer textSymb = this.sf.createTextSymbolizer();
        Literal offset = this.ff.literal(10);
        textSymb.setLabelPlacement((org.opengis.style.LabelPlacement)this.sf.createLinePlacement((Expression)offset));
        textSymb.accept((StyleVisitor)this.visitor);
        TextSymbolizer clone = (TextSymbolizer)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertCopy(textSymb, clone);
        DuplicatorStyleVisitorTest.assertEqualsContract(textSymb, clone);
        TextSymbolizer notEq = this.sf.getDefaultTextSymbolizer();
        Literal ancX = this.ff.literal(10);
        Literal ancY = this.ff.literal(10);
        AnchorPoint ancPoint = this.sf.createAnchorPoint((Expression)ancX, (Expression)ancY);
        PointPlacement placement = this.sf.createPointPlacement(ancPoint, null, null);
        notEq.setLabelPlacement((org.opengis.style.LabelPlacement)placement);
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, notEq, textSymb);
    }

    public void testTextSymbolizerVendorParams() {
        TextSymbolizer textSymb = this.sf.createTextSymbolizer();
        textSymb.getOptions().put("autoWrap", "100");
        textSymb.accept((StyleVisitor)this.visitor);
        TextSymbolizer clone = (TextSymbolizer)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertCopy(textSymb, clone);
        DuplicatorStyleVisitorTest.assertEqualsContract(textSymb, clone);
        DuplicatorStyleVisitorTest.assertEquals((int)1, (int)clone.getOptions().size());
        DuplicatorStyleVisitorTest.assertEquals((String)"100", (String)((String)clone.getOptions().get("autoWrap")));
    }

    public void testTextSymbolizerVendorOptions() {
        TextSymbolizer textSymb = this.sf.createTextSymbolizer();
        textSymb.getOptions().put("autoWrap", "100");
        textSymb.accept((StyleVisitor)this.visitor);
        TextSymbolizer clone = (TextSymbolizer)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertCopy(textSymb, clone);
        DuplicatorStyleVisitorTest.assertEqualsContract(textSymb, clone);
    }

    public void testTextSymbolizerWithUOM() {
        TextSymbolizer textSymb = this.sf.createTextSymbolizer();
        textSymb.setUnitOfMeasure(UomOgcMapping.METRE.getUnit());
        Literal offset = this.ff.literal(10);
        textSymb.setLabelPlacement((org.opengis.style.LabelPlacement)this.sf.createLinePlacement((Expression)offset));
        textSymb.accept((StyleVisitor)this.visitor);
        TextSymbolizer clone = (TextSymbolizer)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertCopy(textSymb, clone);
        DuplicatorStyleVisitorTest.assertEqualsContract(textSymb, clone);
        TextSymbolizer notEq = this.sf.getDefaultTextSymbolizer();
        Literal ancX = this.ff.literal(10);
        Literal ancY = this.ff.literal(10);
        AnchorPoint ancPoint = this.sf.createAnchorPoint((Expression)ancX, (Expression)ancY);
        PointPlacement placement = this.sf.createPointPlacement(ancPoint, null, null);
        notEq.setLabelPlacement((org.opengis.style.LabelPlacement)placement);
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, notEq, textSymb);
    }

    public void testFont() {
        Font font = this.sf.getDefaultFont();
        Font clone = this.visitor.copy(font);
        DuplicatorStyleVisitorTest.assertCopy(font, clone);
        DuplicatorStyleVisitorTest.assertEqualsContract(font, clone);
        Font other = this.sf.createFont((Expression)this.ff.literal((Object)"other"), (Expression)this.ff.literal((Object)"normal"), (Expression)this.ff.literal((Object)"BOLD"), (Expression)this.ff.literal(12));
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, other, font);
    }

    public void testHalo() {
        Halo halo = this.sf.createHalo(this.sf.getDefaultFill(), (Expression)this.ff.literal(10));
        halo.accept((StyleVisitor)this.visitor);
        Halo clone = (Halo)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertCopy(halo, clone);
        Halo other = this.sf.createHalo(this.sf.getDefaultFill(), (Expression)this.ff.literal(12));
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, other, halo);
    }

    public void testLinePlacement() throws Exception {
        LinePlacement linePlacement = this.sf.createLinePlacement((Expression)this.ff.literal(12));
        linePlacement.accept((StyleVisitor)this.visitor);
        LinePlacement clone = (LinePlacement)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertCopy(linePlacement, clone);
        LinePlacement other = this.sf.createLinePlacement((Expression)this.ff.property("NAME"));
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, other, linePlacement);
    }

    public void testAnchorPoint() {
        AnchorPoint anchorPoint = this.sf.createAnchorPoint((Expression)this.ff.literal(1), (Expression)this.ff.literal(2));
        anchorPoint.accept((StyleVisitor)this.visitor);
        AnchorPoint clone = (AnchorPoint)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertCopy(anchorPoint, clone);
        AnchorPoint other = this.sf.createAnchorPoint((Expression)this.ff.literal(3), (Expression)this.ff.literal(4));
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, other, anchorPoint);
    }

    public void testDisplacement() {
        Displacement displacement = this.sf.createDisplacement((Expression)this.ff.literal(1), (Expression)this.ff.literal(2));
        displacement.accept((StyleVisitor)this.visitor);
        Displacement clone = (Displacement)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertCopy(displacement, clone);
        Displacement other = this.sf.createDisplacement((Expression)this.ff.literal(3), (Expression)this.ff.literal(4));
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, other, displacement);
    }

    public void testPointPlacement() {
        PointPlacement pointPl = this.sf.getDefaultPointPlacement();
        PointPlacement clone = (PointPlacement)this.visitor.copy((LabelPlacement)pointPl);
        DuplicatorStyleVisitorTest.assertCopy(pointPl, clone);
        PointPlacement other = (PointPlacement)((Cloneable)pointPl).clone();
        other.setRotation((Expression)this.ff.literal(274.0));
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, other, pointPl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPolygonSymbolizer() {
        try {
            PolygonSymbolizer polygonSymb = this.sf.createPolygonSymbolizer();
            PolygonSymbolizer clone = (PolygonSymbolizer)this.visitor.copy((Symbolizer)polygonSymb);
            DuplicatorStyleVisitorTest.assertCopy(polygonSymb, clone);
            PolygonSymbolizer notEq = this.sf.getDefaultPolygonSymbolizer();
            notEq.setGeometryPropertyName("something_else");
            DuplicatorStyleVisitorTest.assertEqualsContract(clone, notEq, polygonSymb);
        }
        finally {
            this.visitor.setStrict(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPolygonSymbolizerWithUOM() {
        try {
            PolygonSymbolizer polygonSymb = this.sf.createPolygonSymbolizer();
            polygonSymb.setUnitOfMeasure(UomOgcMapping.FOOT.getUnit());
            PolygonSymbolizer clone = (PolygonSymbolizer)this.visitor.copy((Symbolizer)polygonSymb);
            DuplicatorStyleVisitorTest.assertCopy(polygonSymb, clone);
            PolygonSymbolizer notEq = this.sf.getDefaultPolygonSymbolizer();
            notEq.setUnitOfMeasure(UomOgcMapping.PIXEL.getUnit());
            DuplicatorStyleVisitorTest.assertEqualsContract(clone, notEq, polygonSymb);
        }
        finally {
            this.visitor.setStrict(false);
        }
    }

    public void testLineSymbolizer() {
        LineSymbolizer lineSymb = this.sf.createLineSymbolizer();
        LineSymbolizer clone = (LineSymbolizer)this.visitor.copy((Symbolizer)lineSymb);
        DuplicatorStyleVisitorTest.assertCopy(lineSymb, clone);
        LineSymbolizer notEq = this.sf.getDefaultLineSymbolizer();
        notEq.setGeometryPropertyName("something_else");
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, notEq, lineSymb);
    }

    public void testLineSymbolizerWithUOM() {
        LineSymbolizer lineSymb = this.sf.createLineSymbolizer();
        LineSymbolizer clone = (LineSymbolizer)this.visitor.copy((Symbolizer)lineSymb);
        DuplicatorStyleVisitorTest.assertCopy(lineSymb, clone);
        LineSymbolizer notEq = this.sf.getDefaultLineSymbolizer();
        notEq.setUnitOfMeasure(UomOgcMapping.METRE.getUnit());
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, notEq, lineSymb);
    }

    public void testGraphic() {
        Graphic graphic = this.sf.getDefaultGraphic();
        graphic.addMark(this.sf.getDefaultMark());
        Graphic clone = this.visitor.copy(graphic);
        DuplicatorStyleVisitorTest.assertCopy(graphic, clone);
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, graphic);
        DuplicatorStyleVisitorTest.assertEquals((int)clone.getSymbols().length, (int)graphic.getSymbols().length);
        Graphic notEq = this.sf.getDefaultGraphic();
        notEq.setGeometryPropertyName("geomprop");
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, notEq, graphic);
    }

    public void testExternalGraphic() {
        ExternalGraphic exGraphic = this.sf.createExternalGraphic("http://somewhere", "image/png");
        ExternalGraphic clone = this.visitor.copy(exGraphic);
        DuplicatorStyleVisitorTest.assertCopy(exGraphic, clone);
        ExternalGraphic notEq = this.sf.createExternalGraphic("http://somewhereelse", "image/jpeg");
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, notEq, exGraphic);
        ExternalGraphic notEq2 = this.visitor.copy(clone);
        notEq2.setFormat("image/jpeg");
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, notEq2, exGraphic);
    }

    public void testMark() {
        Mark mark = this.sf.getCircleMark();
        Mark clone = this.visitor.copy(mark);
        DuplicatorStyleVisitorTest.assertCopy(mark, clone);
        Mark notEq = this.sf.getStarMark();
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, notEq, mark);
    }

    public void testFill() {
        Fill fill = this.sf.getDefaultFill();
        Fill clone = this.visitor.copy(fill);
        DuplicatorStyleVisitorTest.assertCopy(fill, clone);
        Fill notEq = this.sf.createFill((Expression)this.ff.literal((Object)"#FF0000"));
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, notEq, fill);
    }

    public void testStroke() {
        Stroke stroke = this.sf.getDefaultStroke();
        Stroke clone = this.visitor.copy(stroke);
        DuplicatorStyleVisitorTest.assertCopy(stroke, clone);
        Stroke notEq = this.sf.createStroke((Expression)this.ff.literal((Object)"#FF0000"), (Expression)this.ff.literal(10));
        DuplicatorStyleVisitorTest.assertEqualsContract(clone, notEq, stroke);
        Stroke dashArray = this.sf.getDefaultStroke();
        dashArray.setDashArray(new float[]{1.0f, 2.0f, 3.0f});
        Stroke dashArray2 = (Stroke)((Cloneable)dashArray).clone();
        DuplicatorStyleVisitorTest.assertEqualsContract(dashArray, dashArray2);
    }

    private static void assertCopy(Object real, Object clone) {
        DuplicatorStyleVisitorTest.assertNotNull((String)"Real was null", (Object)real);
        DuplicatorStyleVisitorTest.assertNotNull((String)"Clone was null", (Object)clone);
        DuplicatorStyleVisitorTest.assertTrue((String)("" + real.getClass().getName() + " was not cloned"), (real != clone ? 1 : 0) != 0);
    }

    private static void assertEqualsContract(Object controlEqual, Object controlNe, Object test) {
        DuplicatorStyleVisitorTest.assertNotNull((Object)controlEqual);
        DuplicatorStyleVisitorTest.assertNotNull((Object)controlNe);
        DuplicatorStyleVisitorTest.assertNotNull((Object)test);
        DuplicatorStyleVisitorTest.assertTrue((String)"Reflexivity test failed", (boolean)test.equals(test));
        DuplicatorStyleVisitorTest.assertTrue((String)"Symmetry test failed", (boolean)controlEqual.equals(test));
        DuplicatorStyleVisitorTest.assertTrue((String)"Symmetry test failed", (boolean)test.equals(controlEqual));
        DuplicatorStyleVisitorTest.assertTrue((String)"Symmetry test failed", (!test.equals(controlNe) ? 1 : 0) != 0);
        DuplicatorStyleVisitorTest.assertTrue((String)"Symmetry test failed", (!controlNe.equals(test) ? 1 : 0) != 0);
        DuplicatorStyleVisitorTest.assertTrue((String)"Transitivity test failed", (!controlEqual.equals(controlNe) ? 1 : 0) != 0);
        DuplicatorStyleVisitorTest.assertTrue((String)"Transitivity test failed", (!test.equals(controlNe) ? 1 : 0) != 0);
        DuplicatorStyleVisitorTest.assertTrue((String)"Transitivity test failed", (!controlNe.equals(controlEqual) ? 1 : 0) != 0);
        DuplicatorStyleVisitorTest.assertTrue((String)"Transitivity test failed", (!controlNe.equals(test) ? 1 : 0) != 0);
        DuplicatorStyleVisitorTest.assertTrue((String)"Non-null test failed", (!test.equals(null) ? 1 : 0) != 0);
        int controlEqHash = controlEqual.hashCode();
        int testHash = test.hashCode();
        if (controlEqHash != testHash) {
            System.out.println("Warning  - Equal objects should return equal hashcodes");
        }
    }

    private static void assertEqualsContract(Object controlEqual, Object test) {
        DuplicatorStyleVisitorTest.assertNotNull((Object)controlEqual);
        DuplicatorStyleVisitorTest.assertNotNull((Object)test);
        DuplicatorStyleVisitorTest.assertTrue((String)"Reflexivity test failed", (boolean)test.equals(test));
        DuplicatorStyleVisitorTest.assertTrue((String)"Symmetry test failed", (boolean)controlEqual.equals(test));
        DuplicatorStyleVisitorTest.assertTrue((String)"Symmetry test failed", (boolean)test.equals(controlEqual));
        DuplicatorStyleVisitorTest.assertTrue((String)"Non-null test failed", (!test.equals(null) ? 1 : 0) != 0);
        int controlEqHash = controlEqual.hashCode();
        int testHash = test.hashCode();
        DuplicatorStyleVisitorTest.assertTrue((String)"Equal objects should return equal hashcodes", (controlEqHash == testHash ? 1 : 0) != 0);
    }

    public void testContrastEnhancementDuplication() throws Exception {
        ContrastEnhancement ce = this.sf.createContrastEnhancement();
        ce.setGammaValue(this.sb.literalExpression(0.5));
        ce.setMethod(ContrastMethod.HISTOGRAM);
        ce.setHistogram();
        ce.accept((StyleVisitor)this.visitor);
        ContrastEnhancement ce2 = (ContrastEnhancement)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertEquals((String)"Gamma value incorrest after duplication", (Object)((Literal)ce.getGammaValue()).getValue(), (Object)((Literal)ce2.getGammaValue()).getValue());
        DuplicatorStyleVisitorTest.assertEquals((String)"ContrastMethod must be equal after duplication ", (Object)ce.getMethod(), (Object)ce2.getMethod());
        DuplicatorStyleVisitorTest.assertEquals((String)"Contrast Type must be equal after duplication ", (Object)((Literal)ce.getType()).getValue(), (Object)((Literal)ce2.getType()).getValue());
    }

    public void testColorMapEntryDuplication() throws Exception {
        ColorMapEntry cme = this.sf.createColorMapEntry();
        cme.setColor(this.sb.colorExpression(Color.YELLOW));
        cme.setLabel("thelabel");
        cme.setQuantity(this.sb.literalExpression(66.66));
        cme.setOpacity(this.sb.literalExpression(0.77));
        cme.accept((StyleVisitor)this.visitor);
        ColorMapEntry cme2 = (ColorMapEntry)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertEquals((String)"Colormaps LABEL must be equal after duplication ", (String)cme.getLabel(), (String)cme2.getLabel());
        DuplicatorStyleVisitorTest.assertEquals((String)"Colormaps QUANTITY must be equal after duplication ", (Object)cme.getQuantity(), (Object)cme2.getQuantity());
        DuplicatorStyleVisitorTest.assertEquals((String)"Colormaps COLOR must be equal after duplication ", (Object)cme.getColor(), (Object)cme2.getColor());
        DuplicatorStyleVisitorTest.assertEquals((String)"Colormaps OPACITY must be equal after duplication ", (Object)cme.getOpacity(), (Object)cme2.getOpacity());
    }

    public void testPointSymbolizerWithGeomFunction() throws Exception {
        URL urlExternal = ((Object)((Object)this)).getClass().getResource("/data/sld/blob.gif");
        ExternalGraphic extg = this.sb.createExternalGraphic(urlExternal, "image/svg+xml");
        Graphic graphic = this.sb.createGraphic(extg, null, null);
        PointSymbolizer pointSymb = this.sb.createPointSymbolizer(graphic);
        Function geomFunc = this.ff.function("centroid", new Expression[]{this.ff.property("thr_geom")});
        pointSymb.setGeometry((Expression)geomFunc);
        pointSymb.accept((StyleVisitor)this.visitor);
        PointSymbolizer copy = (PointSymbolizer)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertEquals((String)"Any Expression set as Geometry must be correctly replicated", (Object)geomFunc, (Object)copy.getGeometry());
    }

    public void testRasterSymbolizerDuplicationWithGeometryFunction() {
        RasterSymbolizer original = this.sb.createRasterSymbolizer();
        Function geomFunc = this.ff.function("centroid", new Expression[]{this.ff.property("thr_geom")});
        original.setGeometry((Expression)geomFunc);
        original.accept((StyleVisitor)this.visitor);
        RasterSymbolizer copy = (RasterSymbolizer)this.visitor.getCopy();
        DuplicatorStyleVisitorTest.assertEquals((String)"Any Expression set as Geometry must be correctly replicated", (Object)geomFunc, (Object)copy.getGeometry());
    }

    public void testLineSymbolizerWithGeometryFunction() {
        LineSymbolizer lineSymb = this.sf.createLineSymbolizer();
        Function geomFunc = this.ff.function("centroid", new Expression[]{this.ff.property("thr_geom")});
        lineSymb.setGeometry((Expression)geomFunc);
        LineSymbolizer copy = (LineSymbolizer)this.visitor.copy((Symbolizer)lineSymb);
        DuplicatorStyleVisitorTest.assertEquals((String)"Any Expression set as Geometry must be correctly replicated", (Object)geomFunc, (Object)copy.getGeometry());
    }

    public void testPolygonSymbolizerWithGeometryFunction() {
        PolygonSymbolizer symb = this.sf.createPolygonSymbolizer();
        Function geomFunc = this.ff.function("centroid", new Expression[]{this.ff.property("thr_geom")});
        symb.setGeometry((Expression)geomFunc);
        PolygonSymbolizer copy = (PolygonSymbolizer)this.visitor.copy((Symbolizer)symb);
        DuplicatorStyleVisitorTest.assertEquals((String)"Any Expression set as Geometry must be correctly replicated", (Object)geomFunc, (Object)copy.getGeometry());
    }

    public void testTextSymbolizerWithGeometryFunction() {
        TextSymbolizer symb = this.sf.createTextSymbolizer();
        Function geomFunc = this.ff.function("centroid", new Expression[]{this.ff.property("the_geom")});
        symb.setGeometry((Expression)geomFunc);
        TextSymbolizer copy = (TextSymbolizer)this.visitor.copy((Symbolizer)symb);
        DuplicatorStyleVisitorTest.assertEquals((String)"Any Expression set as Geometry must be correctly replicated", (Object)geomFunc, (Object)copy.getGeometry());
    }

    public void testTextSymbolizer2() {
        TextSymbolizer2 symb = (TextSymbolizer2)this.sf.createTextSymbolizer();
        GraphicImpl gr = new GraphicImpl((FilterFactory)this.ff);
        gr.setOpacity((Expression)this.ff.literal(0.77));
        gr.setSize((Expression)this.ff.literal(77));
        symb.setGraphic((Graphic)gr);
        Literal snippet = this.ff.literal((Object)"no idea what a snipet is good for");
        symb.setSnippet((Expression)snippet);
        Literal fD = this.ff.literal((Object)"some description");
        symb.setFeatureDescription((Expression)fD);
        OtherTextImpl otherText = new OtherTextImpl();
        otherText.setTarget("otherTextTarget");
        otherText.setText((Expression)this.ff.literal((Object)"otherTextText"));
        symb.setOtherText((OtherText)otherText);
        TextSymbolizer2 copy = (TextSymbolizer2)this.visitor.copy((Symbolizer)symb);
        DuplicatorStyleVisitorTest.assertEquals((String)"Graphic of TextSymbolizer2 has not been correctly duplicated", (Object)gr, (Object)copy.getGraphic());
        DuplicatorStyleVisitorTest.assertEquals((String)"Graphic of TextSymbolizer2 has not been correctly duplicated", (Object)gr.getOpacity(), (Object)copy.getGraphic().getOpacity());
        DuplicatorStyleVisitorTest.assertEquals((String)"Graphic of TextSymbolizer2 has not been correctly duplicated", (Object)gr.getSize(), (Object)copy.getGraphic().getSize());
        DuplicatorStyleVisitorTest.assertEquals((String)"Snippet of TextSymbolizer2 has not been correctly duplicated", (Object)snippet, (Object)copy.getSnippet());
        DuplicatorStyleVisitorTest.assertEquals((String)"FeatureDescription of TextSymbolizer2 has not been correctly duplicated", (Object)fD, (Object)copy.getFeatureDescription());
        DuplicatorStyleVisitorTest.assertEquals((String)"OtherText of TextSymbolizer2 has not been correctly duplicated", (String)otherText.getTarget(), (String)copy.getOtherText().getTarget());
        DuplicatorStyleVisitorTest.assertEquals((String)"OtherText of TextSymbolizer2 has not been correctly duplicated", (Object)otherText.getText(), (Object)copy.getOtherText().getText());
    }
}

