/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.xml.sax.ContentHandler;

public class ExampleTransformer
extends TransformerBase {
    private final int bufferEveryNth;
    private final int exceptionEveryNth;
    private final boolean ignoreErrors;

    public ExampleTransformer(int bufferEveryNth, int exceptionEveryNth, boolean ignoreErrors) {
        this.bufferEveryNth = bufferEveryNth;
        this.exceptionEveryNth = exceptionEveryNth;
        this.ignoreErrors = ignoreErrors;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new ExampleTranslator(handler);
    }

    private class ExampleTranslator
    extends TransformerBase.TranslatorSupport {
        public ExampleTranslator(ContentHandler handler) {
            super(handler, "test", "http://geotools.org/test");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void encode(Object o) {
            Integer i = (Integer)o;
            this.start("integers");
            for (int j = 1; j <= i; ++j) {
                boolean buffer = ExampleTransformer.this.bufferEveryNth != 0 && j % ExampleTransformer.this.bufferEveryNth == 0;
                boolean exception = ExampleTransformer.this.exceptionEveryNth != 0 && j % ExampleTransformer.this.exceptionEveryNth == 0;
                try {
                    if (buffer) {
                        this.mark();
                    }
                    this.element("integer", String.valueOf(j));
                    if (exception) {
                        throw new RuntimeException();
                    }
                    if (!buffer) continue;
                    this.commit();
                    continue;
                }
                catch (RuntimeException e) {
                    if (ExampleTransformer.this.ignoreErrors) continue;
                    throw e;
                }
                finally {
                    this.reset();
                }
            }
            this.end("integers");
        }
    }
}

