/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import junit.framework.TestCase;
import org.geotools.data.crs.ForceCoordinateSystemIterator;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ForceCoordinateSystemFeatureIteratorTest
extends TestCase {
    private static final String FEATURE_TYPE_NAME = "testType";

    protected void setUp() throws Exception {
        super.setUp();
    }

    private MemoryDataStore createDatastore(CoordinateReferenceSystem crs, Point p) throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(FEATURE_TYPE_NAME);
        builder.setCRS(crs);
        builder.add("geom", Point.class);
        SimpleFeatureType ft = builder.buildFeatureType();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(ft);
        b.add((Object)p);
        SimpleFeature[] features = new SimpleFeature[]{b.buildFeature(null)};
        return new MemoryDataStore(features);
    }

    public void testSameCRS() throws Exception {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        MemoryDataStore ds = this.createDatastore((CoordinateReferenceSystem)crs, p);
        SimpleFeatureCollection collection = ds.getFeatureSource(FEATURE_TYPE_NAME).getFeatures();
        SimpleFeatureIterator original = collection.features();
        ForceCoordinateSystemIterator modified = new ForceCoordinateSystemIterator((FeatureIterator)collection.features(), (SimpleFeatureType)collection.getSchema(), (CoordinateReferenceSystem)crs);
        SimpleFeature f1 = (SimpleFeature)original.next();
        SimpleFeature f2 = modified.next();
        ForceCoordinateSystemFeatureIteratorTest.assertEquals((Object)f1, (Object)f2);
        ForceCoordinateSystemFeatureIteratorTest.assertFalse((boolean)original.hasNext());
        ForceCoordinateSystemFeatureIteratorTest.assertFalse((boolean)modified.hasNext());
    }

    public void testDifferentCRS() throws Exception {
        DefaultGeographicCRS srcCRS = DefaultGeographicCRS.WGS84;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        MemoryDataStore ds = this.createDatastore((CoordinateReferenceSystem)srcCRS, p);
        SimpleFeatureCollection collection = ds.getFeatureSource(FEATURE_TYPE_NAME).getFeatures();
        SimpleFeatureIterator original = collection.features();
        DefaultEngineeringCRS destCRS = DefaultEngineeringCRS.CARTESIAN_2D;
        ForceCoordinateSystemIterator modified = new ForceCoordinateSystemIterator((FeatureIterator)collection.features(), (SimpleFeatureType)collection.getSchema(), (CoordinateReferenceSystem)destCRS);
        SimpleFeature f1 = (SimpleFeature)original.next();
        SimpleFeature f2 = modified.next();
        ForceCoordinateSystemFeatureIteratorTest.assertEquals((Object)((Geometry)f1.getDefaultGeometry()).getCoordinate(), (Object)((Geometry)f2.getDefaultGeometry()).getCoordinate());
        ForceCoordinateSystemFeatureIteratorTest.assertFalse((boolean)f1.getFeatureType().getCoordinateReferenceSystem().equals(f2.getFeatureType().getCoordinateReferenceSystem()));
        ForceCoordinateSystemFeatureIteratorTest.assertEquals((Object)srcCRS, (Object)f1.getFeatureType().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureIteratorTest.assertEquals((Object)srcCRS, (Object)f1.getFeatureType().getGeometryDescriptor().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureIteratorTest.assertEquals((Object)destCRS, (Object)f2.getFeatureType().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureIteratorTest.assertEquals((Object)destCRS, (Object)f2.getFeatureType().getGeometryDescriptor().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureIteratorTest.assertFalse((boolean)original.hasNext());
        ForceCoordinateSystemFeatureIteratorTest.assertFalse((boolean)modified.hasNext());
        ForceCoordinateSystemFeatureIteratorTest.assertNotNull((Object)modified.builder);
    }

    public void testNullDestination() throws Exception {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        MemoryDataStore ds = this.createDatastore((CoordinateReferenceSystem)crs, p);
        try {
            SimpleFeatureCollection collection = ds.getFeatureSource(FEATURE_TYPE_NAME).getFeatures();
            new ForceCoordinateSystemIterator((FeatureIterator)collection.features(), (SimpleFeatureType)collection.getSchema(), (CoordinateReferenceSystem)null);
            ForceCoordinateSystemFeatureIteratorTest.fail();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public void testNullSource() throws Exception {
        CoordinateReferenceSystem srcCRS = null;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        MemoryDataStore ds = this.createDatastore(srcCRS, p);
        SimpleFeatureCollection collection = ds.getFeatureSource(FEATURE_TYPE_NAME).getFeatures();
        SimpleFeatureIterator original = collection.features();
        DefaultEngineeringCRS destCRS = DefaultEngineeringCRS.CARTESIAN_2D;
        ForceCoordinateSystemIterator modified = new ForceCoordinateSystemIterator((FeatureIterator)collection.features(), (SimpleFeatureType)collection.getSchema(), (CoordinateReferenceSystem)destCRS);
        SimpleFeature f1 = (SimpleFeature)original.next();
        SimpleFeature f2 = modified.next();
        ForceCoordinateSystemFeatureIteratorTest.assertEquals((Object)((Geometry)f1.getDefaultGeometry()).getCoordinate(), (Object)((Geometry)f2.getDefaultGeometry()).getCoordinate());
        ForceCoordinateSystemFeatureIteratorTest.assertFalse((boolean)f2.getFeatureType().getCoordinateReferenceSystem().equals(f1.getFeatureType().getCoordinateReferenceSystem()));
        ForceCoordinateSystemFeatureIteratorTest.assertEquals(srcCRS, (Object)f1.getFeatureType().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureIteratorTest.assertEquals(srcCRS, (Object)f1.getFeatureType().getGeometryDescriptor().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureIteratorTest.assertEquals((Object)destCRS, (Object)f2.getFeatureType().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureIteratorTest.assertEquals((Object)destCRS, (Object)f2.getFeatureType().getGeometryDescriptor().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureIteratorTest.assertFalse((boolean)original.hasNext());
        ForceCoordinateSystemFeatureIteratorTest.assertFalse((boolean)modified.hasNext());
        ForceCoordinateSystemFeatureIteratorTest.assertNotNull((Object)modified.builder);
    }
}

