/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class SampleFeatureFixtures {
    public static SimpleFeature createFeature() {
        try {
            SimpleFeatureType testType = SampleFeatureFixtures.createTestType();
            Object[] attributes = SampleFeatureFixtures.createAttributes();
            return SimpleFeatureBuilder.build((SimpleFeatureType)testType, (Object[])attributes, null);
        }
        catch (Exception e) {
            AssertionError ae = new AssertionError((Object)"Sample Feature for tests has been misscoded");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
    }

    public static SimpleFeature createAddressFeature() {
        try {
            return SampleFeatureFixtures.createFeature();
        }
        catch (Exception e) {
            AssertionError ae = new AssertionError((Object)"Sample Feature for tests has been misscoded");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
    }

    public static Object[] createAttributes() {
        Object[] attributes = new Object[10];
        GeometryFactory gf = new GeometryFactory();
        attributes[0] = gf.createPoint(new Coordinate(1.0, 2.0));
        attributes[1] = new Boolean(true);
        attributes[2] = new Character('t');
        attributes[3] = new Byte("10");
        attributes[4] = new Short("101");
        attributes[5] = new Integer(1002);
        attributes[6] = new Long(10003L);
        attributes[7] = new Float(10000.4);
        attributes[8] = new Double(100000.5);
        attributes[9] = "test string data";
        return attributes;
    }

    public static AttributeDescriptor getChoiceAttrType1() {
        return SampleFeatureFixtures.createChoiceAttrType("choiceTest1", SampleFeatureFixtures.createType1Choices());
    }

    public static AttributeDescriptor[] createType1Choices() {
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        AttributeDescriptor[] choices = new AttributeDescriptor[3];
        ab.setBinding(Byte.class);
        choices[0] = ab.buildDescriptor("testByte");
        ab.setBinding(Double.class);
        choices[1] = ab.buildDescriptor("testDouble");
        ab.setBinding(String.class);
        choices[2] = ab.buildDescriptor("testString");
        return choices;
    }

    public static AttributeDescriptor getChoiceAttrType2() {
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        AttributeDescriptor[] choices = new AttributeDescriptor[2];
        ab.setBinding(String.class);
        choices[0] = ab.buildDescriptor("testString");
        ab.setBinding(Integer.class);
        choices[1] = ab.buildDescriptor("testInt");
        return SampleFeatureFixtures.createChoiceAttrType("choiceTest2", choices);
    }

    public static AttributeDescriptor createChoiceAttrType(String name, AttributeDescriptor[] choices) {
        throw new RuntimeException("Figure out how to handle choice");
    }

    public static AttributeDescriptor createGeomChoiceAttrType(String name, GeometryDescriptor[] choices) {
        throw new RuntimeException("Figure out how to handle choice");
    }

    public static AttributeDescriptor getChoiceGeomType() {
        throw new RuntimeException("Figure out how to handle choice");
    }

    public static SimpleFeatureType createChoiceFeatureType() {
        throw new RuntimeException("Figure out how to handle choice");
    }

    public static SimpleFeatureType createTestType() throws SchemaException {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("test");
        tb.add("testGeometry", Point.class);
        tb.add("testBoolean", Boolean.class);
        tb.add("testCharacter", Character.class);
        tb.add("testByte", Byte.class);
        tb.add("testShort", Short.class);
        tb.add("testInteger", Integer.class);
        tb.add("testLong", Long.class);
        tb.add("testFloat", Float.class);
        tb.add("testDouble", Double.class);
        tb.add("testString", String.class);
        tb.setDefaultGeometry("testGeometry");
        return tb.buildFeatureType();
    }
}

