/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.math.BigInteger;
import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpressionImpl;
import org.opengis.filter.FilterFactory;

public class LiteralTest
extends TestCase {
    FilterFactory ff;

    protected void setUp() throws Exception {
        this.ff = CommonFactoryFinder.getFilterFactory(null);
    }

    public void testValidConstruction() throws Exception {
        LiteralExpressionImpl a = new LiteralExpressionImpl((Object)new Double(10.0));
        LiteralExpressionImpl b = new LiteralExpressionImpl("Label");
        LiteralExpressionImpl c = new LiteralExpressionImpl((Object)new Integer(10));
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        LiteralExpressionImpl d = new LiteralExpressionImpl((Object)gf.createGeometryCollection(null));
    }

    public void testInvalidConstruction1() throws Exception {
        try {
            LiteralExpressionImpl a = new LiteralExpressionImpl((Object)new Double(10.0));
            LiteralExpressionImpl literalExpressionImpl = new LiteralExpressionImpl((Object)a);
        }
        catch (IllegalFilterException ife) {
            return;
        }
    }

    public void testConversion() throws Exception {
        LiteralTest.assertEquals((Object)"abc", (Object)this.ff.literal((Object)"abc").evaluate(null));
        LiteralTest.assertEquals((Object)new Integer(12), (Object)this.ff.literal((Object)"12").evaluate(null));
        LiteralTest.assertEquals((Object)new Double(12.0), (Object)this.ff.literal((Object)"12.0").evaluate(null));
        LiteralTest.assertEquals((Object)new Double(12.5), (Object)this.ff.literal((Object)"12.5").evaluate(null));
        LiteralTest.assertEquals((Object)new Long(Long.MAX_VALUE), (Object)this.ff.literal((Object)"9223372036854775807").evaluate(null));
        BigInteger doubleMaxLong = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L));
        LiteralTest.assertEquals((Object)doubleMaxLong, (Object)this.ff.literal((Object)doubleMaxLong.toString()).evaluate(null));
    }
}

