/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import junit.framework.Assert;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Test;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class StringFunctionTest {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    @Test
    public void testStrReplace() {
        Literal foo = this.ff.literal((Object)"foo");
        Literal o = this.ff.literal((Object)"o");
        Literal bar = this.ff.literal((Object)"bar");
        Function f = this.ff.function("strReplace", new Expression[]{foo, o, bar, this.ff.literal(true)});
        String s = (String)f.evaluate(null, String.class);
        Assert.assertEquals((String)"fbarbar", (String)s);
        f = this.ff.function("strReplace", new Expression[]{foo, o, bar, this.ff.literal(false)});
        s = (String)f.evaluate(null, String.class);
        Assert.assertEquals((String)"fbaro", (String)s);
    }

    @Test
    public void testParseLong() {
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)this.ff.function("parseLong", new Expression[]{this.ff.literal((Object)"9223372036854775807")}).evaluate(null));
        Assert.assertEquals((Object)5L, (Object)this.ff.function("parseLong", new Expression[]{this.ff.literal((Object)"5.0")}).evaluate(null));
    }

    @Test
    public void testCapitalize() {
        Assert.assertEquals((Object)"United Kingdom", (Object)this.ff.function("strCapitalize", new Expression[]{this.ff.literal((Object)"UNITED KINGDOM")}).evaluate(null));
        Assert.assertEquals((Object)"United Kingdom", (Object)this.ff.function("strCapitalize", new Expression[]{this.ff.literal((Object)"UnItEd kInGdOm")}).evaluate(null));
    }

    @Test
    public void testNull() {
        Assert.assertEquals(null, (Object)this.ff.function("strCapitalize", new Expression[]{this.ff.literal(null)}).evaluate(null));
        Assert.assertEquals(null, (Object)this.ff.function("strToUpperCase", new Expression[]{this.ff.literal(null)}).evaluate(null));
        Assert.assertEquals((Object)0, (Object)this.ff.function("strLength", new Expression[]{this.ff.literal(null)}).evaluate(null));
        Assert.assertEquals((Object)false, (Object)this.ff.function("strMatches", new Expression[]{this.ff.literal(null), this.ff.literal(null)}).evaluate(null));
    }

    @Test
    public void testStrTrim2() throws Exception {
        Assert.assertEquals((Object)"hello", (Object)this.ff.function("strTrim2", new Expression[]{this.ff.literal((Object)"  hello  "), this.ff.literal((Object)"both"), this.ff.literal((Object)" ")}).evaluate(null));
        Assert.assertEquals((Object)"hello  ", (Object)this.ff.function("strTrim2", new Expression[]{this.ff.literal((Object)"  hello  "), this.ff.literal((Object)"leading"), this.ff.literal((Object)" ")}).evaluate(null));
        Assert.assertEquals((Object)"  hello", (Object)this.ff.function("strTrim2", new Expression[]{this.ff.literal((Object)"  hello  "), this.ff.literal((Object)"trailing"), this.ff.literal((Object)" ")}).evaluate(null));
        Assert.assertEquals((Object)"hello", (Object)this.ff.function("strTrim2", new Expression[]{this.ff.literal((Object)"xxhelloxx"), this.ff.literal((Object)"both"), this.ff.literal((Object)"x")}).evaluate(null));
    }

    @Test
    public void testStrPosition() throws Exception {
        Assert.assertEquals((String)"1", (String)((String)this.ff.function("strPosition", new Expression[]{this.ff.literal((Object)"he"), this.ff.literal((Object)"hello"), this.ff.literal((Object)"frontToBack")}).evaluate(null, String.class)));
        Assert.assertEquals((String)"1", (String)((String)this.ff.function("strPosition", new Expression[]{this.ff.literal((Object)"he"), this.ff.literal((Object)"hello"), this.ff.literal((Object)"backToFront")}).evaluate(null, String.class)));
        Assert.assertEquals((String)"0", (String)((String)this.ff.function("strPosition", new Expression[]{this.ff.literal((Object)"x"), this.ff.literal((Object)"hello"), this.ff.literal((Object)"backToFront")}).evaluate(null, String.class)));
        Assert.assertEquals((String)"0", (String)((String)this.ff.function("strPosition", new Expression[]{this.ff.literal((Object)"x"), this.ff.literal((Object)"hello"), this.ff.literal((Object)"frontToBack")}).evaluate(null, String.class)));
        Assert.assertEquals((String)"3", (String)((String)this.ff.function("strPosition", new Expression[]{this.ff.literal((Object)"l"), this.ff.literal((Object)"hello"), this.ff.literal((Object)"frontToBack")}).evaluate(null, String.class)));
        Assert.assertEquals((String)"4", (String)((String)this.ff.function("strPosition", new Expression[]{this.ff.literal((Object)"l"), this.ff.literal((Object)"hello"), this.ff.literal((Object)"backToFront")}).evaluate(null, String.class)));
    }

    @Test
    public void testStrSubstring() throws Exception {
        Assert.assertNull((Object)this.ff.function("strSubstring", new Expression[]{this.ff.literal((Object)"ABCD"), this.ff.literal(-1), this.ff.literal(2)}).evaluate(null));
        Assert.assertNull((Object)this.ff.function("strSubstring", new Expression[]{this.ff.literal((Object)"ABCD"), this.ff.literal(2), this.ff.literal(5)}).evaluate(null));
        Assert.assertNull((Object)this.ff.function("strSubstring", new Expression[]{this.ff.literal((Object)"ABCD"), this.ff.literal(3), this.ff.literal(2)}).evaluate(null));
        Assert.assertEquals((Object)"", (Object)this.ff.function("strSubstring", new Expression[]{this.ff.literal((Object)""), this.ff.literal(0), this.ff.literal(0)}).evaluate(null));
        Assert.assertEquals((Object)"", (Object)this.ff.function("strSubstring", new Expression[]{this.ff.literal((Object)"ABCD"), this.ff.literal(0), this.ff.literal(0)}).evaluate(null));
        Assert.assertEquals((Object)"", (Object)this.ff.function("strSubstring", new Expression[]{this.ff.literal((Object)"ABCD"), this.ff.literal(2), this.ff.literal(2)}).evaluate(null));
        Assert.assertEquals((Object)"", (Object)this.ff.function("strSubstring", new Expression[]{this.ff.literal((Object)"ABCD"), this.ff.literal(4), this.ff.literal(4)}).evaluate(null));
        Assert.assertEquals((Object)"ABCD", (Object)this.ff.function("strSubstring", new Expression[]{this.ff.literal((Object)"ABCD"), this.ff.literal(0), this.ff.literal(4)}).evaluate(null));
        Assert.assertEquals((Object)"A", (Object)this.ff.function("strSubstring", new Expression[]{this.ff.literal((Object)"ABCD"), this.ff.literal(0), this.ff.literal(1)}).evaluate(null));
        Assert.assertEquals((Object)"AB", (Object)this.ff.function("strSubstring", new Expression[]{this.ff.literal((Object)"ABCD"), this.ff.literal(0), this.ff.literal(2)}).evaluate(null));
        Assert.assertEquals((Object)"BC", (Object)this.ff.function("strSubstring", new Expression[]{this.ff.literal((Object)"ABCD"), this.ff.literal(1), this.ff.literal(3)}).evaluate(null));
        Assert.assertEquals((Object)"CD", (Object)this.ff.function("strSubstring", new Expression[]{this.ff.literal((Object)"ABCD"), this.ff.literal(2), this.ff.literal(4)}).evaluate(null));
        Assert.assertEquals((Object)"D", (Object)this.ff.function("strSubstring", new Expression[]{this.ff.literal((Object)"ABCD"), this.ff.literal(3), this.ff.literal(4)}).evaluate(null));
    }

    @Test
    public void testStrSubstringStart() throws Exception {
        Assert.assertNull((Object)this.ff.function("strSubstringStart", new Expression[]{this.ff.literal((Object)"ABCD"), this.ff.literal(-1)}).evaluate(null));
        Assert.assertNull((Object)this.ff.function("strSubstringStart", new Expression[]{this.ff.literal((Object)"ABCD"), this.ff.literal(5)}).evaluate(null));
        Assert.assertEquals((Object)"", (Object)this.ff.function("strSubstringStart", new Expression[]{this.ff.literal((Object)""), this.ff.literal(0)}).evaluate(null));
        Assert.assertEquals((Object)"", (Object)this.ff.function("strSubstringStart", new Expression[]{this.ff.literal((Object)"ABCD"), this.ff.literal(4)}).evaluate(null));
        Assert.assertEquals((Object)"ABCD", (Object)this.ff.function("strSubstringStart", new Expression[]{this.ff.literal((Object)"ABCD"), this.ff.literal(0)}).evaluate(null));
        Assert.assertEquals((Object)"CD", (Object)this.ff.function("strSubstringStart", new Expression[]{this.ff.literal((Object)"ABCD"), this.ff.literal(2)}).evaluate(null));
        Assert.assertEquals((Object)"D", (Object)this.ff.function("strSubstringStart", new Expression[]{this.ff.literal((Object)"ABCD"), this.ff.literal(3)}).evaluate(null));
    }
}

