/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.Collections;
import java.util.HashSet;
import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.EnvFunction;
import org.geotools.filter.function.math.FilterFunction_random;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.identity.FeatureId;

public class SimplifyingFilterVisitorTest
extends TestCase {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    Id emptyFid;
    SimplifyingFilterVisitor visitor;
    PropertyIsEqualTo property;

    protected void setUp() throws Exception {
        System.setProperty("org.geotools.filter.function.simplify", "true");
        this.emptyFid = this.ff.id(new HashSet());
        this.property = this.ff.equal((Expression)this.ff.property("test"), (Expression)this.ff.literal((Object)"oneTwoThree"), false);
        this.visitor = new SimplifyingFilterVisitor();
    }

    protected void tearDown() throws Exception {
        System.setProperty("org.geotools.filter.function.simplify", "false");
    }

    public void testIncludeAndInclude() {
        Filter result = (Filter)this.ff.and((Filter)Filter.INCLUDE, (Filter)Filter.INCLUDE).accept((FilterVisitor)this.visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)result);
    }

    public void testIncludeAndExclude() {
        Filter result = (Filter)this.ff.and((Filter)Filter.INCLUDE, (Filter)Filter.EXCLUDE).accept((FilterVisitor)this.visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)result);
    }

    public void testExcludeAndExclude() {
        Filter result = (Filter)this.ff.and((Filter)Filter.EXCLUDE, (Filter)Filter.EXCLUDE).accept((FilterVisitor)this.visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)result);
    }

    public void testIncludeAndProperty() {
        Filter result = (Filter)this.ff.and((Filter)Filter.INCLUDE, (Filter)this.property).accept((FilterVisitor)this.visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.property, (Object)result);
    }

    public void testExcludeAndProperty() {
        Filter result = (Filter)this.ff.or((Filter)Filter.EXCLUDE, (Filter)this.property).accept((FilterVisitor)this.visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.property, (Object)result);
    }

    public void testIncludeOrInclude() {
        Filter result = (Filter)this.ff.or((Filter)Filter.INCLUDE, (Filter)Filter.INCLUDE).accept((FilterVisitor)this.visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)result);
    }

    public void testIncludeOrExclude() {
        Filter result = (Filter)this.ff.or((Filter)Filter.INCLUDE, (Filter)Filter.EXCLUDE).accept((FilterVisitor)this.visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)result);
    }

    public void testExcludeOrExclude() {
        Filter result = (Filter)this.ff.or((Filter)Filter.EXCLUDE, (Filter)Filter.EXCLUDE).accept((FilterVisitor)this.visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)result);
    }

    public void testIncludeOrProperty() {
        Filter result = (Filter)this.ff.or((Filter)Filter.INCLUDE, (Filter)this.property).accept((FilterVisitor)this.visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)result);
    }

    public void testExcludeOrProperty() {
        Filter result = (Filter)this.ff.or((Filter)Filter.EXCLUDE, (Filter)this.property).accept((FilterVisitor)this.visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.property, (Object)result);
    }

    public void testEmptyFid() {
        Filter result = (Filter)this.emptyFid.accept((FilterVisitor)this.visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)result);
    }

    public void testRecurseAnd() {
        And test = this.ff.and((Filter)Filter.INCLUDE, (Filter)this.ff.or((Filter)this.property, (Filter)Filter.EXCLUDE));
        SimplifyingFilterVisitorTest.assertEquals((Object)this.property, (Object)test.accept((FilterVisitor)this.visitor, null));
    }

    public void testRecurseOr() {
        Or test = this.ff.or((Filter)Filter.EXCLUDE, (Filter)this.ff.and((Filter)this.property, (Filter)Filter.INCLUDE));
        SimplifyingFilterVisitorTest.assertEquals((Object)this.property, (Object)test.accept((FilterVisitor)this.visitor, null));
    }

    public void testFidValidity() {
        this.visitor.setFIDValidator(new SimplifyingFilterVisitor.FIDValidator(){

            public boolean isValid(String fid) {
                return fid.startsWith("pass");
            }
        });
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        ids.add(this.ff.featureId("notPass"));
        Id filter = this.ff.id(ids);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)filter.accept((FilterVisitor)this.visitor, null));
        ids.add(this.ff.featureId("pass1"));
        ids.add(this.ff.featureId("pass2"));
        filter = this.ff.id(ids);
        HashSet<FeatureId> validIds = new HashSet<FeatureId>();
        validIds.add(this.ff.featureId("pass2"));
        validIds.add(this.ff.featureId("pass1"));
        Id expected = this.ff.id(validIds);
        SimplifyingFilterVisitorTest.assertEquals((Object)expected, (Object)filter.accept((FilterVisitor)this.visitor, null));
    }

    public void testRegExFIDValidator() {
        SimplifyingFilterVisitor.RegExFIDValidator validator = new SimplifyingFilterVisitor.RegExFIDValidator("abc\\.\\d+");
        this.visitor.setFIDValidator((SimplifyingFilterVisitor.FIDValidator)validator);
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        ids.add(this.ff.featureId("abc.."));
        ids.add(this.ff.featureId(".abc.1"));
        ids.add(this.ff.featureId("abc.123"));
        ids.add(this.ff.featureId("abc.ax"));
        Id filter = this.ff.id(ids);
        Filter result = (Filter)filter.accept((FilterVisitor)this.visitor, null);
        Id expected = this.ff.id(Collections.singleton(this.ff.featureId("abc.123")));
        SimplifyingFilterVisitorTest.assertEquals((Object)expected, (Object)result);
    }

    public void testTypeNameDotNumberValidator() {
        String typeName = "states";
        SimplifyingFilterVisitor.TypeNameDotNumberFidValidator validator = new SimplifyingFilterVisitor.TypeNameDotNumberFidValidator("states");
        this.visitor.setFIDValidator((SimplifyingFilterVisitor.FIDValidator)validator);
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        ids.add(this.ff.featureId("_states"));
        ids.add(this.ff.featureId("states.abc"));
        ids.add(this.ff.featureId("states.."));
        ids.add(this.ff.featureId("states.123"));
        Id filter = this.ff.id(ids);
        Filter result = (Filter)filter.accept((FilterVisitor)this.visitor, null);
        Id expected = this.ff.id(Collections.singleton(this.ff.featureId("states.123")));
        SimplifyingFilterVisitorTest.assertEquals((Object)expected, (Object)result);
    }

    public void testSingleNegation() {
        Not f = this.ff.not((Filter)this.ff.equals((Expression)this.ff.property("prop"), (Expression)this.ff.literal(10)));
        Filter result = (Filter)f.accept((FilterVisitor)this.visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)f, (Object)result);
    }

    public void testDoubleNegation() {
        PropertyIsEqualTo equal = this.ff.equals((Expression)this.ff.property("prop"), (Expression)this.ff.literal(10));
        Not f = this.ff.not((Filter)this.ff.not((Filter)equal));
        Filter result = (Filter)f.accept((FilterVisitor)this.visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)equal, (Object)result);
    }

    public void testTripleNegation() {
        PropertyIsEqualTo equal = this.ff.equals((Expression)this.ff.property("prop"), (Expression)this.ff.literal(10));
        Not f = this.ff.not((Filter)this.ff.not((Filter)this.ff.not((Filter)equal)));
        Filter result = (Filter)f.accept((FilterVisitor)this.visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.not((Filter)equal), (Object)result);
    }

    public void testStableFunction() {
        EnvFunction.setLocalValue((String)"var", (Object)"123");
        Function f = this.ff.function("env", new Expression[]{this.ff.literal((Object)"var")});
        Expression result = (Expression)f.accept((ExpressionVisitor)this.visitor, null);
        SimplifyingFilterVisitorTest.assertTrue((boolean)(result instanceof Literal));
        SimplifyingFilterVisitorTest.assertEquals((String)"123", (String)((String)result.evaluate(null, String.class)));
    }

    public void testVolatileFunction() {
        Function f = this.ff.function("random", new Expression[0]);
        Expression result = (Expression)f.accept((ExpressionVisitor)this.visitor, null);
        SimplifyingFilterVisitorTest.assertTrue((boolean)(result instanceof FilterFunction_random));
    }

    public void testNestedVolatile() {
        EnvFunction.setLocalValue((String)"power", (Object)3);
        Function f = this.ff.function("pow", new Expression[]{this.ff.function("random", new Expression[0]), this.ff.function("env", new Expression[]{this.ff.literal((Object)"power")})});
        Function result = (Function)f.accept((ExpressionVisitor)this.visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((String)"pow", (String)result.getName());
        Function param1 = (Function)result.getParameters().get(0);
        SimplifyingFilterVisitorTest.assertEquals((String)"random", (String)param1.getName());
        Expression param2 = (Expression)result.getParameters().get(1);
        SimplifyingFilterVisitorTest.assertTrue((boolean)(param2 instanceof Literal));
        SimplifyingFilterVisitorTest.assertEquals((Object)3, (Object)param2.evaluate(null, Integer.class));
    }
}

