/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import junit.framework.Assert;
import org.geotools.util.SubProgressListener;
import org.junit.Test;
import org.opengis.util.InternationalString;
import org.opengis.util.ProgressListener;

public class SubProgressListenerTest {
    @Test
    public void testSubProgressStartComplete() {
        SimpleProgressListener parent = new SimpleProgressListener();
        SubProgressListener sub = new SubProgressListener((ProgressListener)parent, 50.0f);
        sub.started();
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(sub.getProgress()));
        sub.complete();
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(sub.getProgress()));
    }

    @Test
    public void testSubProgressBounds() {
        SimpleProgressListener parent = new SimpleProgressListener();
        parent.progress(50.0f);
        SubProgressListener sub = new SubProgressListener((ProgressListener)parent, 50.0f);
        sub.started();
        sub.progress(50.0f);
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)Float.valueOf(sub.getProgress()));
        Assert.assertEquals((Object)Float.valueOf(75.0f), (Object)Float.valueOf(parent.getProgress()));
        sub.progress(100.0f);
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(sub.getProgress()));
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(parent.getProgress()));
    }

    private static class SimpleProgressListener
    implements ProgressListener {
        private float progress;

        private SimpleProgressListener() {
        }

        public void progress(float percent) {
            this.progress = percent;
        }

        public float getProgress() {
            return this.progress;
        }

        public void complete() {
        }

        public void started() {
        }

        public void dispose() {
        }

        public void exceptionOccurred(Throwable exception) {
        }

        public String getDescription() {
            return null;
        }

        public InternationalString getTask() {
            return null;
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean cancel) {
        }

        public void setDescription(String description) {
        }

        public void setTask(InternationalString task) {
        }

        public void warningOccurred(String source, String location, String warning) {
        }
    }
}

