/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.geotools.data.CollectionFeatureReader;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayFeatureReaderTest
extends TestCase {
    private CollectionFeatureReader arrayReader;
    private CollectionFeatureReader collectionReader;
    private CollectionFeatureReader featureCollectionReader;
    private SimpleFeatureType type;
    private SimpleFeature[] features;

    protected void setUp() throws Exception {
        this.type = DataUtilities.createType((String)"TestType", (String)"geom:Geometry");
        this.features = new SimpleFeature[]{SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{null}, (String)"f1"), SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{null}, (String)"f2"), SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{null}, (String)"f3"), SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{null}, (String)"f4"), SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{null}, (String)"f5"), SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{null}, (String)"f6")};
        FeatureCollection collection = FeatureCollections.newCollection();
        List<SimpleFeature> list = Arrays.asList(this.features);
        collection.addAll(list);
        this.arrayReader = new CollectionFeatureReader(this.features);
        this.collectionReader = new CollectionFeatureReader(list, this.type);
        this.featureCollectionReader = new CollectionFeatureReader(collection, this.type);
    }

    public void testGetFeatureType() {
        ArrayFeatureReaderTest.assertEquals((Object)this.type, (Object)this.arrayReader.getFeatureType());
        ArrayFeatureReaderTest.assertEquals((Object)this.type, (Object)this.collectionReader.getFeatureType());
        ArrayFeatureReaderTest.assertEquals((Object)this.type, (Object)this.featureCollectionReader.getFeatureType());
    }

    public void testNext() throws Exception {
        ArrayFeatureReaderTest.assertEquals((Object)this.features[0], (Object)this.arrayReader.next());
        ArrayFeatureReaderTest.assertEquals((Object)this.features[1], (Object)this.arrayReader.next());
        ArrayFeatureReaderTest.assertEquals((Object)this.features[2], (Object)this.arrayReader.next());
        ArrayFeatureReaderTest.assertEquals((Object)this.features[3], (Object)this.arrayReader.next());
        ArrayFeatureReaderTest.assertEquals((Object)this.features[4], (Object)this.arrayReader.next());
        ArrayFeatureReaderTest.assertEquals((Object)this.features[5], (Object)this.arrayReader.next());
        ArrayFeatureReaderTest.assertEquals((Object)this.features[0], (Object)this.collectionReader.next());
        ArrayFeatureReaderTest.assertEquals((Object)this.features[1], (Object)this.collectionReader.next());
        ArrayFeatureReaderTest.assertEquals((Object)this.features[2], (Object)this.collectionReader.next());
        ArrayFeatureReaderTest.assertEquals((Object)this.features[3], (Object)this.collectionReader.next());
        ArrayFeatureReaderTest.assertEquals((Object)this.features[4], (Object)this.collectionReader.next());
        ArrayFeatureReaderTest.assertEquals((Object)this.features[5], (Object)this.collectionReader.next());
        ArrayFeatureReaderTest.assertEquals((Object)this.features[0], (Object)this.featureCollectionReader.next());
        ArrayFeatureReaderTest.assertEquals((Object)this.features[1], (Object)this.featureCollectionReader.next());
        ArrayFeatureReaderTest.assertEquals((Object)this.features[2], (Object)this.featureCollectionReader.next());
        ArrayFeatureReaderTest.assertEquals((Object)this.features[3], (Object)this.featureCollectionReader.next());
        ArrayFeatureReaderTest.assertEquals((Object)this.features[4], (Object)this.featureCollectionReader.next());
        ArrayFeatureReaderTest.assertEquals((Object)this.features[5], (Object)this.featureCollectionReader.next());
    }

    public void testHasNext() throws Exception {
        this.testHasNext((FeatureReader<SimpleFeatureType, SimpleFeature>)this.arrayReader);
        this.testHasNext((FeatureReader<SimpleFeatureType, SimpleFeature>)this.collectionReader);
        this.testHasNext((FeatureReader<SimpleFeatureType, SimpleFeature>)this.featureCollectionReader);
    }

    private void testHasNext(FeatureReader<SimpleFeatureType, SimpleFeature> arrayReader) throws IOException, IllegalAttributeException {
        ArrayFeatureReaderTest.assertTrue((boolean)arrayReader.hasNext());
        arrayReader.next();
        ArrayFeatureReaderTest.assertTrue((boolean)arrayReader.hasNext());
        arrayReader.next();
        ArrayFeatureReaderTest.assertTrue((boolean)arrayReader.hasNext());
        arrayReader.next();
        ArrayFeatureReaderTest.assertTrue((boolean)arrayReader.hasNext());
        arrayReader.next();
        ArrayFeatureReaderTest.assertTrue((boolean)arrayReader.hasNext());
        arrayReader.next();
        ArrayFeatureReaderTest.assertTrue((boolean)arrayReader.hasNext());
        arrayReader.next();
        ArrayFeatureReaderTest.assertFalse((boolean)arrayReader.hasNext());
    }

    public void testClose() throws Exception {
        this.arrayReader.close();
        ArrayFeatureReaderTest.assertFalse((boolean)this.arrayReader.hasNext());
        try {
            this.arrayReader.next();
            ArrayFeatureReaderTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.collectionReader.close();
        ArrayFeatureReaderTest.assertFalse((boolean)this.collectionReader.hasNext());
        try {
            this.collectionReader.next();
            ArrayFeatureReaderTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.featureCollectionReader.close();
        ArrayFeatureReaderTest.assertFalse((boolean)this.featureCollectionReader.hasNext());
        try {
            this.featureCollectionReader.next();
            ArrayFeatureReaderTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

