/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.textui.TestRunner;
import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.test.TestData;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.And;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.PropertyName;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DataUtilitiesTest
extends DataTestCase {
    public DataUtilitiesTest(String arg0) {
        super(arg0);
    }

    public void testUrlToFile() throws Exception {
        this.handleFile(System.getProperty("user.home"));
        this.handleFile(System.getProperty("user.dir"));
        String os = System.getProperty("os.name");
        if (os.toUpperCase().contains("WINDOWS")) {
            this.handleFile("C:\\");
            this.handleFile("C:\\one");
            this.handleFile("C:\\one\\two");
            this.handleFile("C:\\one\\two\\and three");
            this.handleFile("D:\\");
            if (TestData.isExtensiveTest()) {
                this.handleFile("\\\\host\\share\\file");
            }
        } else {
            this.handleFile("/one");
            this.handleFile("one");
            this.handleFile("/one/two/and three");
            this.handleFile("/hello world/this++().file");
        }
        this.assertURL("one", "file:one");
        this.assertURL("/one", "file:///one");
        this.assertURL(this.replaceSlashes("C:\\"), "file://C:/");
        this.assertURL(this.replaceSlashes("C:\\one"), "file://C:/one");
        this.assertURL(this.replaceSlashes("C:\\one\\two"), "file://C:/one/two");
        this.assertURL(this.replaceSlashes("C:\\one\\two\\and three"), "file://C:/one/two/and three");
        File file = File.createTempFile("hello", "world");
        this.handleFile(file.getAbsolutePath());
        this.handleFile(file.getPath());
    }

    private String replaceSlashes(String string) {
        return string.replaceAll("\\\\", "/");
    }

    private void assertURL(String expectedFilePath, String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        File file = DataUtilities.urlToFile((URL)url);
        String os = System.getProperty("os.name");
        if (os.toUpperCase().contains("WINDOWS")) {
            DataUtilitiesTest.assertEquals((String)expectedFilePath.replaceAll("/", "\\\\"), (String)file.getPath());
        } else {
            if (expectedFilePath.endsWith("/")) {
                expectedFilePath = expectedFilePath.substring(0, expectedFilePath.length() - 1);
            }
            DataUtilitiesTest.assertEquals((String)expectedFilePath, (String)file.getPath());
        }
    }

    public void handleFile(String path) throws Exception {
        File file = new File(path);
        URI uri = file.toURI();
        URL url = file.toURI().toURL();
        URL url2 = file.toURI().toURL();
        DataUtilitiesTest.assertEquals((String)"jdk contract", (Object)file.getAbsoluteFile(), (Object)new File(uri));
        File toFile = DataUtilities.urlToFile((URL)url);
        DataUtilitiesTest.assertEquals((String)(path + ":url"), (Object)file.getAbsoluteFile(), (Object)toFile);
        File toFile2 = DataUtilities.urlToFile((URL)url2);
        DataUtilitiesTest.assertEquals((String)(path + ":url2"), (Object)file.getAbsoluteFile(), (Object)toFile2);
    }

    public void testAttributeNamesFeatureType() {
        String[] names = DataUtilities.attributeNames((SimpleFeatureType)this.roadType);
        DataUtilitiesTest.assertEquals((int)3, (int)names.length);
        DataUtilitiesTest.assertEquals((String)"id", (String)names[0]);
        DataUtilitiesTest.assertEquals((String)"geom", (String)names[1]);
        DataUtilitiesTest.assertEquals((String)"name", (String)names[2]);
        names = DataUtilities.attributeNames((SimpleFeatureType)this.subRoadType);
        DataUtilitiesTest.assertEquals((int)2, (int)names.length);
        DataUtilitiesTest.assertEquals((String)"id", (String)names[0]);
        DataUtilitiesTest.assertEquals((String)"geom", (String)names[1]);
    }

    public void testAttributeNamesFilter() throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        Filter filter = null;
        String[] names = DataUtilities.attributeNames(filter);
        DataUtilitiesTest.assertEquals((int)names.length, (int)0);
        Id fidFilter = factory.id(Collections.singleton(factory.featureId("fid")));
        names = DataUtilities.attributeNames((Filter)fidFilter);
        DataUtilitiesTest.assertEquals((int)0, (int)names.length);
        PropertyName id = factory.property("id");
        PropertyName name = factory.property("name");
        PropertyName geom = factory.property("geom");
        PropertyIsNull nullFilter = factory.isNull((Expression)id);
        names = DataUtilities.attributeNames((Filter)nullFilter);
        DataUtilitiesTest.assertEquals((int)1, (int)names.length);
        DataUtilitiesTest.assertEquals((String)"id", (String)names[0]);
        PropertyIsEqualTo equal = factory.equals((Expression)name, (Expression)id);
        names = DataUtilities.attributeNames((Filter)equal);
        DataUtilitiesTest.assertEquals((int)2, (int)names.length);
        List<String> list = Arrays.asList(names);
        DataUtilitiesTest.assertTrue((boolean)list.contains("name"));
        DataUtilitiesTest.assertTrue((boolean)list.contains("id"));
        Function fnCall = factory.function("Max", new Expression[]{id, name});
        PropertyIsLike fn = factory.like((Expression)fnCall, "does-not-matter");
        names = DataUtilities.attributeNames((Filter)fn);
        list = Arrays.asList(names);
        DataUtilitiesTest.assertTrue((boolean)list.contains("name"));
        DataUtilitiesTest.assertTrue((boolean)list.contains("id"));
        PropertyIsBetween between = factory.between((Expression)name, (Expression)id, (Expression)geom);
        names = DataUtilities.attributeNames((Filter)between);
        DataUtilitiesTest.assertEquals((int)3, (int)names.length);
        list = Arrays.asList(names);
        DataUtilitiesTest.assertTrue((boolean)list.contains("name"));
        DataUtilitiesTest.assertTrue((boolean)list.contains("id"));
        DataUtilitiesTest.assertTrue((boolean)list.contains("geom"));
        PropertyIsNull geomNull = factory.isNull((Expression)geom);
        names = DataUtilities.attributeNames((Filter)factory.and((Filter)geomNull, (Filter)equal));
        DataUtilitiesTest.assertEquals((int)3, (int)names.length);
        list = Arrays.asList(names);
        DataUtilitiesTest.assertTrue((boolean)list.contains("name"));
        DataUtilitiesTest.assertTrue((boolean)list.contains("id"));
        DataUtilitiesTest.assertTrue((boolean)list.contains("geom"));
        names = DataUtilities.attributeNames((Filter)factory.not((Filter)geomNull));
        DataUtilitiesTest.assertEquals((int)1, (int)names.length);
        DataUtilitiesTest.assertEquals((String)"geom", (String)names[0]);
        PropertyIsEqualTo equalToWithPrefix = factory.equals((Expression)factory.property("gml:name"), (Expression)id);
        names = DataUtilities.attributeNames((Filter)equalToWithPrefix, (SimpleFeatureType)this.roadType);
        DataUtilitiesTest.assertEquals((int)2, (int)names.length);
        list = Arrays.asList(names);
        DataUtilitiesTest.assertTrue((boolean)list.contains("name"));
        DataUtilitiesTest.assertTrue((boolean)list.contains("id"));
    }

    public void testAttributeNamesFilterFeatureType() {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo filter = factory.equals((Expression)factory.property("id"), (Expression)factory.add((Expression)factory.property("geom"), (Expression)factory.property("gml:name")));
        String[] names = DataUtilities.attributeNames((Filter)filter, (SimpleFeatureType)this.roadType);
        DataUtilitiesTest.assertEquals((int)3, (int)names.length);
        List<String> namesList = Arrays.asList(names);
        DataUtilitiesTest.assertTrue((boolean)namesList.contains("id"));
        DataUtilitiesTest.assertTrue((boolean)namesList.contains("geom"));
        DataUtilitiesTest.assertTrue((boolean)namesList.contains("name"));
    }

    public void testAttributeExpressionFilterFeatureType() {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        Add expression = factory.add((Expression)factory.property("geom"), (Expression)factory.property("gml:name"));
        String[] names = DataUtilities.attributeNames((Expression)expression, (SimpleFeatureType)this.roadType);
        DataUtilitiesTest.assertEquals((int)2, (int)names.length);
        List<String> namesList = Arrays.asList(names);
        DataUtilitiesTest.assertTrue((boolean)namesList.contains("geom"));
        DataUtilitiesTest.assertTrue((boolean)namesList.contains("name"));
    }

    public void testCompare() throws SchemaException {
        DataUtilitiesTest.assertEquals((int)0, (int)DataUtilities.compare(null, null));
        DataUtilitiesTest.assertEquals((int)-1, (int)DataUtilities.compare((SimpleFeatureType)this.roadType, null));
        DataUtilitiesTest.assertEquals((int)-1, (int)DataUtilities.compare(null, (SimpleFeatureType)this.roadType));
        DataUtilitiesTest.assertEquals((int)-1, (int)DataUtilities.compare((SimpleFeatureType)this.riverType, (SimpleFeatureType)this.roadType));
        DataUtilitiesTest.assertEquals((int)-1, (int)DataUtilities.compare((SimpleFeatureType)this.roadType, (SimpleFeatureType)this.riverType));
        DataUtilitiesTest.assertEquals((int)0, (int)DataUtilities.compare((SimpleFeatureType)this.roadType, (SimpleFeatureType)this.roadType));
        DataUtilitiesTest.assertEquals((int)1, (int)DataUtilities.compare((SimpleFeatureType)this.subRoadType, (SimpleFeatureType)this.roadType));
        SimpleFeatureType road2 = DataUtilities.createType((String)"namespace.road", (String)"geom:LineString,name:String,id:0");
        DataUtilitiesTest.assertEquals((int)1, (int)DataUtilities.compare((SimpleFeatureType)road2, (SimpleFeatureType)this.roadType));
        SimpleFeatureType road3 = DataUtilities.createType((String)"test.road", (String)"id:0,geom:LineString,name:String");
        DataUtilitiesTest.assertEquals((int)0, (int)DataUtilities.compare((SimpleFeatureType)road3, (SimpleFeatureType)this.roadType));
    }

    public void testIsMatch() {
    }

    public void testReType() throws Exception {
        SimpleFeature rd1 = this.roadFeatures[0];
        DataUtilitiesTest.assertEquals((Object)rd1, (Object)rd1);
        SimpleFeature rdDuplicate = SimpleFeatureBuilder.copy((SimpleFeature)rd1);
        DataUtilitiesTest.assertEquals((Object)rd1, (Object)rdDuplicate);
        DataUtilitiesTest.assertNotSame((Object)rd1, (Object)rdDuplicate);
        SimpleFeature rd2 = DataUtilities.reType((SimpleFeatureType)this.roadType, (SimpleFeature)rd1);
        DataUtilitiesTest.assertEquals((Object)rd1, (Object)rd2);
        DataUtilitiesTest.assertNotSame((Object)rd1, (Object)rd2);
        SimpleFeature rd3 = DataUtilities.reType((SimpleFeatureType)this.subRoadType, (SimpleFeature)rd1);
        DataUtilitiesTest.assertFalse((boolean)rd1.equals(rd3));
        DataUtilitiesTest.assertEquals((int)2, (int)rd3.getAttributeCount());
        DataUtilitiesTest.assertEquals((String)rd1.getID(), (String)rd3.getID());
        DataUtilitiesTest.assertEquals((Object)rd1.getAttribute("id"), (Object)rd3.getAttribute("id"));
        this.assertEquals((Geometry)rd1.getAttribute("geom"), (Geometry)rd3.getAttribute("geom"));
        DataUtilitiesTest.assertNotNull((Object)rd3.getDefaultGeometry());
        SimpleFeature rv1 = this.riverFeatures[0];
        DataUtilitiesTest.assertEquals((Object)rv1, (Object)rv1);
        SimpleFeature rvDuplicate = SimpleFeatureBuilder.copy((SimpleFeature)rv1);
        DataUtilitiesTest.assertEquals((Object)rv1, (Object)rvDuplicate);
        DataUtilitiesTest.assertNotSame((Object)rv1, (Object)rvDuplicate);
        SimpleFeature rv2 = DataUtilities.reType((SimpleFeatureType)this.riverType, (SimpleFeature)rv1);
        DataUtilitiesTest.assertEquals((Object)rv1, (Object)rv2);
        DataUtilitiesTest.assertNotSame((Object)rv1, (Object)rv2);
        SimpleFeature rv3 = DataUtilities.reType((SimpleFeatureType)this.subRiverType, (SimpleFeature)rv1);
        DataUtilitiesTest.assertFalse((boolean)rv1.equals(rv3));
        DataUtilitiesTest.assertEquals((int)2, (int)rv3.getAttributeCount());
        DataUtilitiesTest.assertEquals((String)rv1.getID(), (String)rv3.getID());
        DataUtilitiesTest.assertEquals((Object)rv1.getAttribute("name"), (Object)rv3.getAttribute("name"));
        DataUtilitiesTest.assertEquals((Object)rv1.getAttribute("flow"), (Object)rv3.getAttribute("flow"));
        DataUtilitiesTest.assertNull((Object)rv3.getDefaultGeometry());
    }

    public void testTemplateFeatureType() throws IllegalAttributeException {
        SimpleFeature feature = DataUtilities.template((SimpleFeatureType)this.roadType);
        DataUtilitiesTest.assertNotNull((Object)feature);
        DataUtilitiesTest.assertEquals((int)this.roadType.getAttributeCount(), (int)feature.getAttributeCount());
    }

    public void testTemplateFeatureTypeString() throws IllegalAttributeException {
        SimpleFeature feature = DataUtilities.template((SimpleFeatureType)this.roadType, (String)"Foo");
        DataUtilitiesTest.assertNotNull((Object)feature);
        DataUtilitiesTest.assertEquals((int)this.roadType.getAttributeCount(), (int)feature.getAttributeCount());
        DataUtilitiesTest.assertEquals((String)"Foo", (String)feature.getID());
        DataUtilitiesTest.assertNull((Object)feature.getAttribute("name"));
        DataUtilitiesTest.assertNull((Object)feature.getAttribute("id"));
        DataUtilitiesTest.assertNull((Object)feature.getAttribute("geom"));
    }

    public void testDefaultValues() throws IllegalAttributeException {
        Object[] values = DataUtilities.defaultValues((SimpleFeatureType)this.roadType);
        DataUtilitiesTest.assertNotNull((Object)values);
        DataUtilitiesTest.assertEquals((int)values.length, (int)this.roadType.getAttributeCount());
    }

    public void testDefaultValue() throws IllegalAttributeException {
        DataUtilitiesTest.assertNull((Object)DataUtilities.defaultValue((AttributeDescriptor)this.roadType.getDescriptor("name")));
        DataUtilitiesTest.assertNull((Object)DataUtilities.defaultValue((AttributeDescriptor)this.roadType.getDescriptor("id")));
        DataUtilitiesTest.assertNull((Object)DataUtilities.defaultValue((AttributeDescriptor)this.roadType.getDescriptor("geom")));
    }

    public void testCollection() {
        FeatureCollection collection = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        DataUtilitiesTest.assertEquals((int)this.roadFeatures.length, (int)collection.size());
    }

    public void testReaderFeatureArray() throws Exception {
        FeatureReader reader = DataUtilities.reader((SimpleFeature[])this.roadFeatures);
        DataUtilitiesTest.assertEquals((int)this.roadFeatures.length, (int)this.count(reader));
    }

    public void testReaderCollection() throws Exception {
        FeatureCollection collection = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        DataUtilitiesTest.assertEquals((int)this.roadFeatures.length, (int)collection.size());
        FeatureReader reader = DataUtilities.reader((FeatureCollection)collection);
        DataUtilitiesTest.assertEquals((int)this.roadFeatures.length, (int)this.count(reader));
    }

    public void testCreateSubType() throws Exception {
        SimpleFeatureType before = DataUtilities.createType((String)"cities", (String)"the_geom:Point:srid=4326,name:String");
        SimpleFeatureType after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"the_geom"});
        DataUtilitiesTest.assertEquals((int)1, (int)after.getAttributeCount());
        before = DataUtilities.createType((String)"cities", (String)"the_geom:Point:srid=4326,name:String,population:Integer");
        URI here = new URI("http://localhost/");
        after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"the_geom"}, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (String)"now", (URI)here);
        DataUtilitiesTest.assertEquals((String)here.toString(), (String)after.getName().getNamespaceURI());
        DataUtilitiesTest.assertEquals((String)"now", (String)after.getName().getLocalPart());
        DataUtilitiesTest.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)after.getCoordinateReferenceSystem());
        DataUtilitiesTest.assertEquals((int)1, (int)after.getAttributeCount());
        DataUtilitiesTest.assertEquals((String)"the_geom", (String)after.getDescriptor(0).getLocalName());
        DataUtilitiesTest.assertNotNull((Object)after.getGeometryDescriptor());
    }

    public void testSource() throws Exception {
        FeatureSource s = DataUtilities.source((SimpleFeature[])this.roadFeatures);
        DataUtilitiesTest.assertEquals((int)-1, (int)s.getCount(Query.ALL));
        DataUtilitiesTest.assertEquals((int)3, (int)s.getFeatures().size());
        DataUtilitiesTest.assertEquals((int)3, (int)s.getFeatures(Query.ALL).size());
        DataUtilitiesTest.assertEquals((int)3, (int)s.getFeatures((Filter)Filter.INCLUDE).size());
        DataUtilitiesTest.assertEquals((int)0, (int)s.getFeatures((Filter)Filter.EXCLUDE).size());
        DataUtilitiesTest.assertEquals((int)1, (int)s.getFeatures(this.rd1Filter).size());
        DataUtilitiesTest.assertEquals((int)2, (int)s.getFeatures(this.rd12Filter).size());
    }

    public void testMixQueries() throws Exception {
        DefaultQuery firstQuery = new DefaultQuery("typeName", (Filter)Filter.EXCLUDE, 100, new String[]{"att1", "att2", "att3"}, "handle");
        DefaultQuery secondQuery = new DefaultQuery("typeName", (Filter)Filter.EXCLUDE, 20, new String[]{"att1", "att2", "att4"}, "handle2");
        secondQuery.setStartIndex(Integer.valueOf(4));
        Query mixed = DataUtilities.mixQueries((Query)firstQuery, (Query)secondQuery, (String)"newhandle");
        DataUtilitiesTest.assertEquals((String)"newhandle", (String)mixed.getHandle());
        DataUtilitiesTest.assertEquals((int)20, (int)mixed.getMaxFeatures());
        DataUtilitiesTest.assertEquals((int)4, (int)mixed.getPropertyNames().length);
        DataUtilitiesTest.assertEquals((int)4, (int)mixed.getStartIndex());
        PropertyIsEqualTo filter1 = null;
        PropertyIsEqualTo filter2 = null;
        FilterFactory ffac = CommonFactoryFinder.getFilterFactory(null);
        String typeSpec = "geom:Point,att1:String,att2:String,att3:String,att4:String";
        SimpleFeatureType testType = DataUtilities.createType((String)"testType", (String)typeSpec);
        filter1 = ffac.equals((Expression)ffac.property("att1"), (Expression)ffac.literal((Object)"val1"));
        filter2 = ffac.equals((Expression)ffac.property("att2"), (Expression)ffac.literal((Object)"val2"));
        firstQuery = new DefaultQuery("typeName", (Filter)filter1, 100, null, "handle");
        secondQuery = new DefaultQuery("typeName", (Filter)filter2, 20, new String[]{"att1", "att2", "att4"}, "handle2");
        mixed = DataUtilities.mixQueries((Query)firstQuery, (Query)secondQuery, (String)"newhandle");
        DataUtilitiesTest.assertEquals((String)"newhandle", (String)mixed.getHandle());
        DataUtilitiesTest.assertEquals((int)20, (int)mixed.getMaxFeatures());
        DataUtilitiesTest.assertEquals((int)3, (int)mixed.getPropertyNames().length);
        Filter mixedFilter = mixed.getFilter();
        DataUtilitiesTest.assertNotNull((Object)mixedFilter);
        DataUtilitiesTest.assertTrue((boolean)(mixedFilter instanceof BinaryLogicOperator));
        BinaryLogicOperator f = (BinaryLogicOperator)mixedFilter;
        DataUtilitiesTest.assertTrue((boolean)(f instanceof And));
        for (Filter subFilter : f.getChildren()) {
            DataUtilitiesTest.assertTrue((filter1.equals(subFilter) || filter2.equals(subFilter) ? 1 : 0) != 0);
        }
    }

    public void testSpecNoCRS() throws Exception {
        String spec = "id:String,polygonProperty:Polygon";
        SimpleFeatureType ft = DataUtilities.createType((String)"testType", (String)spec);
        String spec2 = DataUtilities.spec((FeatureType)ft);
        DataUtilitiesTest.assertEquals((String)spec, (String)spec2);
    }

    public void testSpecCRS() throws Exception {
        String spec = "id:String,polygonProperty:Polygon:srid=32615";
        SimpleFeatureType ft = DataUtilities.createType((String)"testType", (String)spec);
        String spec2 = DataUtilities.spec((FeatureType)ft);
        DataUtilitiesTest.assertEquals((String)spec, (String)spec2);
    }

    public void testSpecNotIdentifiable() throws Exception {
        String spec = "id:String,polygonProperty:Polygon:srid=32615";
        SimpleFeatureType ft = DataUtilities.createType((String)"testType", (String)spec);
        CoordinateReferenceSystem crsNoId = CRS.parseWKT((String)"PROJCS[\"Geoscience Australia Standard National Scale Lambert Projection\",GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS_1978\",6378135,298.26],TOWGS84[0,0,0]],PRIMEM[\"Greenwich\",0],UNIT[\"Decimal_Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"central_meridian\",134.0],PARAMETER[\"latitude_of_origin\",0.0],PARAMETER[\"standard_parallel_1\",-18.0],PARAMETER[\"standard_parallel_2\",-36.0],UNIT[\"Meter\",1]]");
        SimpleFeatureType transformedFt = FeatureTypes.transform((SimpleFeatureType)ft, (CoordinateReferenceSystem)crsNoId);
        String expected = "id:String,polygonProperty:Polygon";
        String spec2 = DataUtilities.spec((FeatureType)transformedFt);
        DataUtilitiesTest.assertEquals((String)expected, (String)spec2);
    }

    public static void main(String[] args) {
        TestRunner.run(DataUtilitiesTest.class);
    }
}

