/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.FilterFilter;
import org.geotools.filter.FilterHandler;
import org.geotools.filter.FilterTestSupport;
import org.geotools.filter.TestFilterHandler;
import org.geotools.gml.GMLFilterDocument;
import org.geotools.gml.GMLFilterGeometry;
import org.geotools.gml.GMLHandlerGeometry;
import org.geotools.gml.GMLHandlerJTS;
import org.geotools.test.TestData;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.ParserAdapter;

public class ParserTest
extends FilterTestSupport {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");
    TestSuite suite = null;
    String dataFolder = System.getProperty("dataFolder");
    boolean setup = false;

    public ParserTest(String testName) {
        super(testName);
        if (this.dataFolder == null) {
            this.dataFolder = System.getProperty("basedir");
            this.dataFolder = "file:////" + this.dataFolder + "/tests/unit/testData";
            LOGGER.fine("data folder is " + this.dataFolder);
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ParserTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ParserTest.class);
        return suite;
    }

    public void setUp() throws SchemaException, IllegalAttributeException {
        super.setUp();
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.init(testSchema);
        ftb.add("testZeroDouble", Double.class);
        testSchema = ftb.buildFeatureType();
        GeometryFactory geomFac = new GeometryFactory();
        Coordinate[] coords = new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 6.0)};
        Object[] attributes = new Object[]{geomFac.createLineString(coords), new Boolean(true), new Character('t'), new Byte("10"), new Short("101"), new Integer(1002), new Long(10003L), new Float(10000.4), new Double(100000.5), "test string data", new Double(0.0)};
        testFeature = SimpleFeatureBuilder.build((SimpleFeatureType)testSchema, (Object[])attributes, null);
    }

    public void test1() throws Exception {
        Filter test = this.parseDocument("test1.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public void test2() throws Exception {
        Filter test = this.parseDocument("test2.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public void test3a() throws Exception {
        Filter test = this.parseDocument("test3a.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public void test3b() throws Exception {
        Filter test = this.parseDocument("test3b.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public void test4() throws Exception {
        Filter test = this.parseDocument("test4.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public void test5() throws Exception {
        Filter test = this.parseDocument("test5.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public void test6() throws Exception {
        Filter test = this.parseDocument("test6.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public void test8() throws Exception {
        Filter test = this.parseDocument("test8.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public void test9() throws Exception {
        Filter test = this.parseDocument("test9.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public void test11() throws Exception {
        Filter test = this.parseDocument("test11.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public void test12() throws Exception {
        Filter test = this.parseDocument("test12.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public void test13() throws Exception {
        Filter test = this.parseDocument("test13.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public void test14() throws Exception {
        Filter test = this.parseDocument("test14.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public void test15() throws Exception {
        Filter test = this.parseDocument("test15.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public void test16() throws Exception {
        Filter test = this.parseDocument("test16.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public void test17() throws Exception {
        Filter test = this.parseDocument("test17.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public void test18() throws Exception {
        Filter test = this.parseDocument("test18.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public void test19() throws Exception {
        Filter test = this.parseDocument("test19.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public void test20() throws Exception {
        Filter test = this.parseDocument("test20.xml");
        LOGGER.fine("filter: " + test.getClass().toString());
        LOGGER.fine("parsed: " + test.toString());
    }

    public Filter parseDocument(String uri) throws Exception {
        LOGGER.finest("about to create parser");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        TestFilterHandler filterHandler = new TestFilterHandler();
        FilterFilter filterFilter = new FilterFilter((FilterHandler)filterHandler, null);
        GMLFilterGeometry geometryFilter = new GMLFilterGeometry((GMLHandlerJTS)filterFilter);
        GMLFilterDocument documentFilter = new GMLFilterDocument((GMLHandlerGeometry)geometryFilter);
        SAXParserFactory fac = SAXParserFactory.newInstance();
        SAXParser parser = fac.newSAXParser();
        ParserAdapter p = new ParserAdapter(parser.getParser());
        p.setContentHandler((ContentHandler)documentFilter);
        LOGGER.fine("just made parser, " + uri);
        p.parse(TestData.getResource((Object)((Object)this), (String)uri).toExternalForm());
        LOGGER.finest("just parsed: " + uri);
        return filterHandler.getFilter();
    }
}

