/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.SLDParser;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.UserLayer;
import org.geotools.test.TestData;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Disjoint;

public class SLDStyleTest
extends TestCase {
    StyleFactory sf = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
    FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
    StyleBuilder sb = new StyleBuilder(this.sf, this.ff);

    public SLDStyleTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SLDStyleTest.class);
        return suite;
    }

    public void testParseStyle() throws Exception {
        URL surl = TestData.getResource((Object)((Object)this), (String)"test-sld.xml");
        SLDParser stylereader = new SLDParser(this.sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        SLDStyleTest.assertEquals((String)"My Layer", (String)sld.getName());
        SLDStyleTest.assertEquals((String)"A layer by me", (String)sld.getTitle());
        SLDStyleTest.assertEquals((String)"this is a sample layer", (String)sld.getAbstract());
        SLDStyleTest.assertEquals((int)1, (int)sld.getStyledLayers().length);
        UserLayer layer = (UserLayer)sld.getStyledLayers()[0];
        SLDStyleTest.assertNull((Object)layer.getName());
        SLDStyleTest.assertEquals((int)1, (int)layer.getUserStyles().length);
        Style style = layer.getUserStyles()[0];
        SLDStyleTest.assertEquals((int)1, (int)style.getFeatureTypeStyles().length);
        SLDStyleTest.assertEquals((String)"My User Style", (String)style.getName());
        SLDStyleTest.assertEquals((String)"A style by me", (String)style.getTitle());
        SLDStyleTest.assertEquals((String)"this is a sample style", (String)style.getAbstract());
        SLDStyleTest.assertTrue((boolean)style.isDefault());
        FeatureTypeStyle fts = style.getFeatureTypeStyles()[0];
        Rule rule = fts.getRules()[0];
        LineSymbolizer lineSym = (LineSymbolizer)rule.getSymbolizers()[0];
        SLDStyleTest.assertEquals((int)4, (int)((Number)lineSym.getStroke().getWidth().evaluate(null, Number.class)).intValue());
    }

    public void testSLDParser() throws Exception {
        URL surl = TestData.getResource((Object)((Object)this), (String)"example-sld.xml");
        SLDParser stylereader = new SLDParser(this.sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        SLDTransformer aTransformer = new SLDTransformer();
        String xml = aTransformer.transform((Object)sld);
        SLDStyleTest.assertNotNull((Object)xml);
    }

    public void testSLDParserWithWhitespaceIsTrimmed() throws Exception {
        URL surl = TestData.getResource((Object)((Object)this), (String)"whitespace.sld");
        SLDParser stylereader = new SLDParser(this.sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        TextSymbolizer ts = (TextSymbolizer)((NamedLayer)sld.getStyledLayers()[0]).getStyles()[0].getFeatureTypeStyles()[0].getRules()[0].getSymbolizers()[0];
        PropertyName property = (PropertyName)ts.getLabel();
        SLDStyleTest.assertEquals((String)"testProperty", (String)property.getPropertyName());
        Expression color = ts.getFill().getColor();
        SLDStyleTest.assertEquals((Object)Color.BLACK, (Object)SLD.color((Expression)color));
    }

    public void testSLDParserWithhMixedContent() throws Exception {
        URL surl = TestData.getResource((Object)((Object)this), (String)"mixedContent.sld");
        SLDParser stylereader = new SLDParser(this.sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        Symbolizer[] symbolizers = ((NamedLayer)sld.getStyledLayers()[0]).getStyles()[0].getFeatureTypeStyles()[0].getRules()[0].getSymbolizers();
        PolygonSymbolizer polygon = (PolygonSymbolizer)symbolizers[0];
        TextSymbolizer text = (TextSymbolizer)symbolizers[1];
        Expression fill = polygon.getFill().getColor();
        Expression label = text.getLabel();
        String fillValue = (String)fill.evaluate(null, String.class);
        String labelValue = (String)label.evaluate(null, String.class);
        SLDStyleTest.assertEquals((String)"#96C3F5", (String)fillValue);
        SLDStyleTest.assertEquals((String)"this is a prefix; this is an expression; this is a postfix", (String)labelValue);
    }

    public void testSLDParserWithhMixedContentCDATA() throws Exception {
        URL surl = TestData.getResource((Object)((Object)this), (String)"mixedContentWithCDATA.xml");
        SLDParser stylereader = new SLDParser(this.sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        Symbolizer[] symbolizers = ((NamedLayer)sld.getStyledLayers()[0]).getStyles()[0].getFeatureTypeStyles()[0].getRules()[0].getSymbolizers();
        TextSymbolizer text = (TextSymbolizer)symbolizers[0];
        Expression label = text.getLabel();
        String labelValue = (String)label.evaluate(null, String.class);
        SLDStyleTest.assertEquals((String)"literal_1\n cdata literal_2", (String)labelValue);
    }

    public void testSLDParserWithhMixedContentCDATASpaces() throws Exception {
        URL surl = TestData.getResource((Object)((Object)this), (String)"mixedContentWithCDATASpaces.xml");
        SLDParser stylereader = new SLDParser(this.sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        Symbolizer[] symbolizers = ((NamedLayer)sld.getStyledLayers()[0]).getStyles()[0].getFeatureTypeStyles()[0].getRules()[0].getSymbolizers();
        TextSymbolizer text = (TextSymbolizer)symbolizers[0];
        Expression label = text.getLabel();
        String labelValue = (String)label.evaluate(null, String.class);
        SLDStyleTest.assertEquals((String)"literal_1\nliteral_2", (String)labelValue);
    }

    public void testSLDTransformer() throws Exception {
        StyledLayerDescriptor sld = this.sf.createStyledLayerDescriptor();
        sld.setName("SLD Name");
        sld.setTitle("SLD Title");
        UserLayer layer = this.sf.createUserLayer();
        layer.setName("UserLayer Name");
        Style style = this.sf.createStyle();
        style.setName("Style Name");
        style.setTitle("Style Title");
        Rule rule1 = this.sb.createRule((Symbolizer)this.sb.createLineSymbolizer(new Color(0), 2.0));
        FeatureTypeStyle fts1 = this.sf.createFeatureTypeStyle(new Rule[]{rule1});
        fts1.setSemanticTypeIdentifiers(new String[]{"generic:geometry"});
        style.setFeatureTypeStyles(new FeatureTypeStyle[]{fts1});
        layer.setUserStyles(new Style[]{style});
        sld.setStyledLayers((StyledLayer[])new UserLayer[]{layer});
        SLDTransformer aTransformer = new SLDTransformer();
        String xml = aTransformer.transform((Object)sld);
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        SLDParser stylereader = new SLDParser(this.sf, (InputStream)is);
        StyledLayerDescriptor sld2 = stylereader.parseSLD();
        SLDStyleTest.assertEquals((Object)sld2, (Object)sld);
    }

    public void testSLDTransformerIndentation() throws Exception {
        StyledLayerDescriptor sld = this.sf.createStyledLayerDescriptor();
        NamedLayer nl = this.sf.createNamedLayer();
        nl.setName("named_layer_1");
        sld.addStyledLayer((StyledLayer)nl);
        SLDTransformer aTransformer = new SLDTransformer();
        aTransformer.setIndentation(3);
        String xml1 = aTransformer.transform((Object)sld);
        aTransformer.setIndentation(4);
        String xml2 = aTransformer.transform((Object)sld);
        SLDStyleTest.assertEquals((int)(xml1.length() + 4), (int)xml2.length());
    }

    public void testParseSLD_NameSpaceAware() throws Exception {
        URL surl = TestData.getResource((Object)((Object)this), (String)"test-ns.sld");
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        SLDParser stylereader = new SLDParser(factory, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        SLDStyleTest.assertEquals((int)1, (int)sld.getStyledLayers().length);
        FeatureTypeStyle[] fts = SLD.featureTypeStyles((StyledLayerDescriptor)sld);
        SLDStyleTest.assertEquals((int)2, (int)fts.length);
        SLDStyleTest.assertEquals((int)1, (int)fts[0].getSemanticTypeIdentifiers().length);
        SLDStyleTest.assertEquals((int)2, (int)fts[1].getSemanticTypeIdentifiers().length);
        SLDStyleTest.assertEquals((String)"colorbrewer:default", (String)fts[1].getSemanticTypeIdentifiers()[1]);
    }

    public void testParseSLDNamedLayersOnly() throws Exception {
        NamedLayer layer;
        int i;
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        URL surl = TestData.getResource((Object)((Object)this), (String)"namedLayers.sld");
        SLDParser stylereader = new SLDParser(factory, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        int expectedLayerCount = 3;
        String[] layerNames = new String[]{"Rivers", "Roads", "Houses"};
        String[] namedStyleNames = new String[]{"CenterLine", "CenterLine", "Outline"};
        StyledLayer[] layers = sld.getStyledLayers();
        SLDStyleTest.assertEquals((int)3, (int)layers.length);
        for (i = 0; i < 3; ++i) {
            SLDStyleTest.assertTrue((boolean)(layers[i] instanceof NamedLayer));
        }
        for (i = 0; i < 3; ++i) {
            SLDStyleTest.assertEquals((String)layerNames[i], (String)layers[i].getName());
        }
        for (i = 0; i < 3; ++i) {
            layer = (NamedLayer)layers[i];
            SLDStyleTest.assertEquals((int)1, (int)layer.getStyles().length);
            SLDStyleTest.assertTrue((boolean)(layer.getStyles()[0] instanceof NamedStyle));
            SLDStyleTest.assertEquals((String)namedStyleNames[i], (String)layer.getStyles()[0].getName());
        }
        for (i = 0; i < 3; ++i) {
            layer = (NamedLayer)layers[i];
            if (!layer.getName().equals("Rivers")) continue;
            FeatureTypeConstraint[] featureTypeConstraints = layer.getLayerFeatureConstraints();
            boolean featureTypeConstraintCount = true;
            SLDStyleTest.assertEquals((int)1, (int)featureTypeConstraints.length);
            Filter filter = featureTypeConstraints[0].getFilter();
            SLDStyleTest.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
            PropertyIsEqualTo equal = (PropertyIsEqualTo)filter;
            SLDStyleTest.assertTrue((boolean)(equal.getExpression1() instanceof PropertyName));
            SLDStyleTest.assertTrue((boolean)(equal.getExpression2() instanceof Literal));
        }
    }

    public void testParseSLDNamedAndUserLayers() throws Exception {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        URL surl = TestData.getResource((Object)((Object)this), (String)"mixedLayerTypes.sld");
        SLDParser stylereader = new SLDParser(factory, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        int expectedLayerCount = 4;
        StyledLayer[] layers = sld.getStyledLayers();
        SLDStyleTest.assertEquals((int)4, (int)layers.length);
        SLDStyleTest.assertTrue((boolean)(layers[0] instanceof NamedLayer));
        SLDStyleTest.assertTrue((boolean)(layers[1] instanceof UserLayer));
        SLDStyleTest.assertTrue((boolean)(layers[2] instanceof NamedLayer));
        SLDStyleTest.assertTrue((boolean)(layers[3] instanceof UserLayer));
    }

    public void testParseGeometryFilters() throws IOException {
        String TYPE_NAME = "testType";
        String GEOMETRY_ATTR = "Polygons";
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        URL surl = TestData.getResource((Object)((Object)this), (String)"spatialFilter.xml");
        SLDParser stylereader = new SLDParser(factory, surl);
        Style[] styles = stylereader.readXML();
        boolean expectedStyleCount = true;
        SLDStyleTest.assertEquals((int)1, (int)styles.length);
        Style notDisjoint = styles[0];
        SLDStyleTest.assertEquals((int)1, (int)notDisjoint.getFeatureTypeStyles().length);
        FeatureTypeStyle fts = notDisjoint.getFeatureTypeStyles()[0];
        SLDStyleTest.assertEquals((String)"testType", (String)fts.getFeatureTypeName());
        SLDStyleTest.assertEquals((int)1, (int)fts.getRules().length);
        Filter filter = fts.getRules()[0].getFilter();
        SLDStyleTest.assertTrue((boolean)(filter instanceof Not));
        BinarySpatialOperator spatialFilter = (BinarySpatialOperator)((BinaryLogicOperator)filter).getChildren().get(0);
        SLDStyleTest.assertTrue((boolean)(spatialFilter instanceof Disjoint));
        Expression left = spatialFilter.getExpression1();
        Expression right = spatialFilter.getExpression2();
        SLDStyleTest.assertTrue((boolean)(left instanceof PropertyName));
        SLDStyleTest.assertTrue((boolean)(right instanceof Literal));
        SLDStyleTest.assertTrue((boolean)(right.evaluate(null) instanceof Geometry));
        SLDStyleTest.assertEquals((String)"Polygons", (String)((PropertyName)left).getPropertyName());
        SLDStyleTest.assertTrue((boolean)(right.evaluate(null) instanceof Polygon));
        Envelope bbox = ((Polygon)right.evaluate(null)).getEnvelopeInternal();
        SLDStyleTest.assertEquals((double)-10.0, (double)bbox.getMinX(), (double)0.0);
        SLDStyleTest.assertEquals((double)-10.0, (double)bbox.getMinY(), (double)0.0);
        SLDStyleTest.assertEquals((double)10.0, (double)bbox.getMaxX(), (double)0.0);
        SLDStyleTest.assertEquals((double)10.0, (double)bbox.getMaxY(), (double)0.0);
    }

    public void testParseFidFilter() throws IOException {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        URL surl = TestData.getResource((Object)((Object)this), (String)"fidFilter.xml");
        SLDParser stylereader = new SLDParser(factory, surl);
        Style[] styles = stylereader.readXML();
        boolean expectedStyleCount = true;
        SLDStyleTest.assertEquals((int)1, (int)styles.length);
        Style style = styles[0];
        SLDStyleTest.assertEquals((int)1, (int)style.getFeatureTypeStyles().length);
        FeatureTypeStyle fts = style.getFeatureTypeStyles()[0];
        SLDStyleTest.assertEquals((String)"Feature", (String)fts.getFeatureTypeName());
        SLDStyleTest.assertEquals((int)1, (int)fts.getRules().length);
        Filter filter = fts.getRules()[0].getFilter();
        SLDStyleTest.assertTrue((boolean)(filter instanceof Id));
        Id fidFilter = (Id)filter;
        Set ids = fidFilter.getIDs();
        Object[] fids = ids.toArray(new String[ids.size()]);
        SLDStyleTest.assertEquals((String)"Wrong number of fids", (int)5, (int)fids.length);
        Arrays.sort(fids);
        SLDStyleTest.assertEquals((String)"fid.0", (String)fids[0]);
        SLDStyleTest.assertEquals((String)"fid.1", (String)fids[1]);
        SLDStyleTest.assertEquals((String)"fid.2", (String)fids[2]);
        SLDStyleTest.assertEquals((String)"fid.3", (String)fids[3]);
        SLDStyleTest.assertEquals((String)"fid.4", (String)fids[4]);
    }

    public void testParseKmlExtensions() throws IOException {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        URL surl = TestData.getResource((Object)((Object)this), (String)"kmlSymbolizer.sld");
        SLDParser stylereader = new SLDParser(factory, surl);
        Style[] styles = stylereader.readXML();
        SLDStyleTest.assertEquals((int)1, (int)styles.length);
        SLDStyleTest.assertEquals((int)1, (int)styles[0].getFeatureTypeStyles().length);
        SLDStyleTest.assertEquals((int)1, (int)styles[0].getFeatureTypeStyles()[0].getRules().length);
        Rule rule = styles[0].getFeatureTypeStyles()[0].getRules()[0];
        SLDStyleTest.assertEquals((int)1, (int)rule.getSymbolizers().length);
        TextSymbolizer2 ts = (TextSymbolizer2)rule.getSymbolizers()[0];
        SLDStyleTest.assertEquals((String)"propertyOne", (String)((PropertyName)ts.getSnippet()).getPropertyName());
        Expression desc = ts.getFeatureDescription();
        SLDStyleTest.assertTrue((boolean)(desc instanceof Function));
        SLDStyleTest.assertEquals((String)"strConcat", (String)((Function)desc).getName());
        SLDStyleTest.assertEquals((int)2, (int)((Function)desc).getParameters().size());
        SLDStyleTest.assertTrue((boolean)(((Function)desc).getParameters().get(0) instanceof Literal));
        SLDStyleTest.assertTrue((boolean)(((Function)desc).getParameters().get(1) instanceof PropertyName));
        SLDStyleTest.assertEquals((String)"extrude", (String)ts.getOtherText().getTarget());
        SLDStyleTest.assertTrue((boolean)(ts.getOtherText().getText() instanceof Literal));
    }

    public void testParseRasterSymbolizer() throws IOException {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        URL surl = TestData.getResource((Object)((Object)this), (String)"rasterSymbolizer.sld");
        SLDParser stylereader = new SLDParser(factory, surl);
        Style[] styles = stylereader.readXML();
        SLDStyleTest.assertEquals((int)1, (int)styles.length);
        SLDStyleTest.assertEquals((int)1, (int)styles[0].getFeatureTypeStyles().length);
        SLDStyleTest.assertEquals((int)1, (int)styles[0].getFeatureTypeStyles()[0].getRules().length);
        Rule r = styles[0].getFeatureTypeStyles()[0].getRules()[0];
        SLDStyleTest.assertEquals((int)1, (int)r.getSymbolizers().length);
        RasterSymbolizer rs = (RasterSymbolizer)r.getSymbolizers()[0];
        SLDStyleTest.assertEquals((Object)0.75, (Object)SLD.opacity((RasterSymbolizer)rs));
        ChannelSelection cs = rs.getChannelSelection();
        SelectedChannelType redChannel = cs.getRGBChannels()[0];
        SelectedChannelType greenChannel = cs.getRGBChannels()[1];
        SelectedChannelType blueChannel = cs.getRGBChannels()[2];
        SLDStyleTest.assertEquals((String)"1", (String)redChannel.getChannelName());
        SLDStyleTest.assertEquals((String)"2", (String)greenChannel.getChannelName());
        SLDStyleTest.assertEquals((String)"6", (String)blueChannel.getChannelName());
        ContrastEnhancement rcs = redChannel.getContrastEnhancement();
        String type = (String)rcs.getType().evaluate(null);
        SLDStyleTest.assertEquals((String)"Histogram", (String)type);
        ContrastEnhancement gcs = greenChannel.getContrastEnhancement();
        Double ggamma = (Double)gcs.getGammaValue().evaluate(null);
        SLDStyleTest.assertEquals((Object)2.8, (Object)ggamma);
        ContrastEnhancement bcs = blueChannel.getContrastEnhancement();
        type = (String)bcs.getType().evaluate(null);
        SLDStyleTest.assertEquals((String)"Normalize", (String)type);
        Expression overlapExpr = rs.getOverlap();
        type = (String)overlapExpr.evaluate(null);
        SLDStyleTest.assertEquals((String)"LATEST_ON_TOP", (String)type);
        ContrastEnhancement ce = rs.getContrastEnhancement();
        Double v = (Double)ce.getGammaValue().evaluate(null);
        SLDStyleTest.assertEquals((Object)1.0, (Object)v);
    }

    public void testParseRasterSymbolizerColorMap() throws IOException {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        URL surl = TestData.getResource((Object)((Object)this), (String)"rasterSymbolizerColorMap.sld");
        SLDParser stylereader = new SLDParser(factory, surl);
        Style[] styles = stylereader.readXML();
        SLDStyleTest.assertEquals((int)1, (int)styles.length);
        SLDStyleTest.assertEquals((int)1, (int)styles[0].getFeatureTypeStyles().length);
        SLDStyleTest.assertEquals((int)1, (int)styles[0].getFeatureTypeStyles()[0].getRules().length);
        Rule r = styles[0].getFeatureTypeStyles()[0].getRules()[0];
        SLDStyleTest.assertEquals((int)1, (int)r.getSymbolizers().length);
        RasterSymbolizer rs = (RasterSymbolizer)r.getSymbolizers()[0];
        Double d = (Double)rs.getOpacity().evaluate(null);
        SLDStyleTest.assertEquals((Object)1.0, (Object)d);
        Expression overlapExpr = rs.getOverlap();
        String type = (String)overlapExpr.evaluate(null);
        SLDStyleTest.assertEquals((String)"AVERAGE", (String)type);
        ColorMap cMap = rs.getColorMap();
        SLDStyleTest.assertEquals((int)20, (int)cMap.getColorMapEntries().length);
        ColorMapEntry[] centeries = cMap.getColorMapEntries();
        String[] colors = new String[]{"#00ff00", "#00fa00", "#14f500", "#28f502", "#3cf505", "#50f50a", "#64f014", "#7deb32", "#78c818", "#38840c", "#2c4b04", "#ffff00", "#dcdc00", "#b47800", "#c85000", "#be4100", "#963000", "#3c0200", "#ffffff", "#ffffff"};
        int[] values = new int[]{-500, -417, -333, -250, -167, -83, -1, 0, 30, 105, 300, 400, 700, 1200, 1400, 1600, 2000, 3000, 5000, 13000};
        for (int i = 0; i < centeries.length; ++i) {
            ColorMapEntry entry = centeries[i];
            String c = (String)entry.getColor().evaluate(null);
            Integer q = (Integer)entry.getQuantity().evaluate(null);
            SLDStyleTest.assertEquals((String)colors[i], (String)c);
            SLDStyleTest.assertEquals((int)values[i], (int)q);
        }
    }
}

