/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import org.geotools.filter.AttributeExpression;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.MathExpression;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;

public class FilterVisitorExpressionWrapper
implements ExpressionVisitor {
    FilterVisitor delegate;

    public FilterVisitorExpressionWrapper(FilterVisitor delegate) {
        this.delegate = delegate;
    }

    private Object visitMath(BinaryExpression expression, Object data) {
        if (expression instanceof MathExpression) {
            this.delegate.visit((MathExpression)expression);
        }
        return data;
    }

    public Object visit(NilExpression expression, Object extraData) {
        return extraData;
    }

    public Object visit(Add expression, Object extraData) {
        return this.visitMath((BinaryExpression)expression, extraData);
    }

    public Object visit(Divide expression, Object extraData) {
        return this.visitMath((BinaryExpression)expression, extraData);
    }

    public Object visit(Multiply expression, Object extraData) {
        return this.visitMath((BinaryExpression)expression, extraData);
    }

    public Object visit(Subtract expression, Object extraData) {
        return this.visitMath((BinaryExpression)expression, extraData);
    }

    public Object visit(Function expression, Object extraData) {
        if (expression instanceof FunctionExpression) {
            this.delegate.visit((FunctionExpression)expression);
        }
        return extraData;
    }

    public Object visit(Literal expression, Object extraData) {
        if (expression instanceof LiteralExpression) {
            this.delegate.visit((LiteralExpression)expression);
        }
        return extraData;
    }

    public Object visit(PropertyName expression, Object extraData) {
        if (expression instanceof AttributeExpression) {
            this.delegate.visit((AttributeExpression)expression);
        }
        return extraData;
    }
}

