/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.HashMap;
import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.styling.DescriptionImpl;
import org.geotools.styling.FillImpl;
import org.geotools.styling.Font;
import org.geotools.styling.FontImpl;
import org.geotools.styling.Graphic;
import org.geotools.styling.HaloImpl;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LinePlacementImpl;
import org.geotools.styling.OtherText;
import org.geotools.styling.PointPlacementImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.util.Utilities;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Description;
import org.opengis.style.Fill;
import org.opengis.style.Halo;
import org.opengis.style.Symbolizer;
import org.opengis.util.Cloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSymbolizerImpl
implements TextSymbolizer2,
Cloneable {
    private DescriptionImpl desc;
    private String name;
    private Unit<Length> uom;
    private Font font;
    private final FilterFactory filterFactory;
    private FillImpl fill;
    private HaloImpl halo;
    private LabelPlacement placement;
    private String geometryPropertyName = null;
    private Expression label = null;
    private Graphic graphic = null;
    private Expression priority = null;
    private HashMap<String, String> optionsMap = null;
    private Expression abxtract = null;
    private Expression description = null;
    private OtherText otherText = null;

    protected TextSymbolizerImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    protected TextSymbolizerImpl(FilterFactory factory) {
        this(factory, null, null, null);
    }

    protected TextSymbolizerImpl(FilterFactory factory, Description desc, String name, Unit<Length> uom) {
        this.filterFactory = factory;
        this.desc = DescriptionImpl.cast(desc);
        this.uom = uom;
        this.name = name;
        this.fill = new FillImpl();
        this.fill.setColor((Expression)this.filterFactory.literal((Object)"#000000"));
        this.halo = null;
        this.placement = new PointPlacementImpl();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DescriptionImpl getDescription() {
        return this.desc;
    }

    public void setDescription(Description description) {
        this.desc = DescriptionImpl.cast(description);
    }

    public Unit<Length> getUnitOfMeasure() {
        return this.uom;
    }

    public void setUnitOfMeasure(Unit<Length> uom) {
        this.uom = uom;
    }

    public String geometryPropertyName() {
        return this.geometryPropertyName;
    }

    public FillImpl getFill() {
        return this.fill;
    }

    public void setFill(Fill fill) {
        if (this.fill == fill) {
            return;
        }
        this.fill = FillImpl.cast(fill);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(org.opengis.style.Font font) {
        if (this.font == font) {
            return;
        }
        this.font = FontImpl.cast(font);
    }

    @Deprecated
    public Font[] getFonts() {
        if (this.font == null) {
            return new Font[0];
        }
        return new Font[]{this.font};
    }

    @Deprecated
    public void addFont(Font font) {
        this.font = font;
    }

    @Deprecated
    public void setFonts(Font[] fonts) {
        this.font = fonts != null && fonts.length > 0 ? fonts[0] : null;
    }

    public HaloImpl getHalo() {
        return this.halo;
    }

    public void setHalo(Halo halo) {
        if (this.halo == halo) {
            return;
        }
        this.halo = HaloImpl.cast(halo);
    }

    public Expression getLabel() {
        return this.label;
    }

    public void setLabel(Expression label) {
        this.label = label;
    }

    @Deprecated
    public LabelPlacement getPlacement() {
        return this.getLabelPlacement();
    }

    public void setPlacement(LabelPlacement labelPlacement) {
        this.setLabelPlacement((org.opengis.style.LabelPlacement)labelPlacement);
    }

    public LabelPlacement getLabelPlacement() {
        return this.placement;
    }

    public void setLabelPlacement(org.opengis.style.LabelPlacement labelPlacement) {
        if (this.placement == labelPlacement) {
            return;
        }
        this.placement = labelPlacement instanceof LinePlacement ? LinePlacementImpl.cast(labelPlacement) : PointPlacementImpl.cast(labelPlacement);
    }

    public String getGeometryPropertyName() {
        return this.geometryPropertyName;
    }

    public void setGeometryPropertyName(String geometryPropertyName) {
        this.geometryPropertyName = geometryPropertyName;
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit((org.opengis.style.TextSymbolizer)this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((TextSymbolizer)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.fill != null) {
            result = 1000003 * result + this.fill.hashCode();
        }
        if (this.font != null) {
            result = 1000003 * result + this.font.hashCode();
        }
        if (this.uom != null) {
            result = 1000003 * result + this.uom.hashCode();
        }
        if (this.desc != null) {
            result = 1000003 * result + this.desc.hashCode();
        }
        if (this.name != null) {
            result = 1000003 * result + this.name.hashCode();
        }
        if (this.halo != null) {
            result = 1000003 * result + this.halo.hashCode();
        }
        if (this.placement != null) {
            result = 1000003 * result + this.placement.hashCode();
        }
        if (this.geometryPropertyName != null) {
            result = 1000003 * result + this.geometryPropertyName.hashCode();
        }
        if (this.label != null) {
            result = 1000003 * result + this.label.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth instanceof TextSymbolizerImpl) {
            TextSymbolizerImpl other = (TextSymbolizerImpl)oth;
            return Utilities.equals((Object)this.geometryPropertyName, (Object)other.geometryPropertyName) && Utilities.equals((Object)this.label, (Object)other.label) && Utilities.equals((Object)this.halo, (Object)other.halo) && Utilities.equals((Object)this.font, (Object)other.font) && Utilities.equals((Object)this.desc, (Object)other.desc) && Utilities.equals(this.uom, other.uom) && Utilities.equals((Object)this.placement, (Object)other.placement) && Utilities.equals((Object)this.fill, (Object)other.fill);
        }
        return false;
    }

    public void setPriority(Expression priority) {
        if (this.priority == priority) {
            return;
        }
        this.priority = priority;
    }

    public Expression getPriority() {
        return this.priority;
    }

    public void addToOptions(String key, String value) {
        if (this.optionsMap == null) {
            this.optionsMap = new HashMap();
        }
        this.optionsMap.put(key, value.trim());
    }

    public String getOption(String key) {
        if (this.optionsMap == null) {
            return null;
        }
        return this.optionsMap.get(key);
    }

    public Map<String, String> getOptions() {
        return this.optionsMap;
    }

    public Graphic getGraphic() {
        return this.graphic;
    }

    public void setGraphic(Graphic graphic) {
        if (this.graphic == graphic) {
            return;
        }
        this.graphic = graphic;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<TextSymbolizerImp property=");
        buf.append(this.geometryPropertyName);
        buf.append(" label=");
        buf.append(this.label);
        buf.append(">");
        buf.append(this.font);
        return buf.toString();
    }

    public Expression getSnippet() {
        return this.abxtract;
    }

    public void setSnippet(Expression abxtract) {
        this.abxtract = abxtract;
    }

    public Expression getFeatureDescription() {
        return this.description;
    }

    public void setFeatureDescription(Expression description) {
        this.description = description;
    }

    public OtherText getOtherText() {
        return this.otherText;
    }

    public void setOtherText(OtherText otherText) {
        this.otherText = otherText;
    }

    static TextSymbolizerImpl cast(Symbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        if (symbolizer instanceof TextSymbolizerImpl) {
            return (TextSymbolizerImpl)symbolizer;
        }
        org.opengis.style.TextSymbolizer textSymbolizer = (org.opengis.style.TextSymbolizer)symbolizer;
        TextSymbolizerImpl copy = new TextSymbolizerImpl();
        copy.setDescription(textSymbolizer.getDescription());
        copy.setFill(textSymbolizer.getFill());
        copy.setFont(textSymbolizer.getFont());
        copy.setGeometryPropertyName(textSymbolizer.getGeometryPropertyName());
        copy.setHalo(textSymbolizer.getHalo());
        copy.setLabel(textSymbolizer.getLabel());
        copy.setLabelPlacement(textSymbolizer.getLabelPlacement());
        copy.setName(textSymbolizer.getName());
        copy.setUnitOfMeasure((Unit<Length>)textSymbolizer.getUnitOfMeasure());
        return copy;
    }
}

