/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.TransactionStateDiff;
import org.geotools.data.collection.CollectionDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionDataStoreTest
extends DataTestCase {
    CollectionDataStore data;

    public CollectionDataStoreTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.data = new CollectionDataStore(DataUtilities.collection((SimpleFeature[])this.roadFeatures));
    }

    protected void tearDown() throws Exception {
        this.data = null;
    }

    public void testGetFeatureTypes() {
        Object[] names = this.data.getTypeNames();
        CollectionDataStoreTest.assertEquals((int)1, (int)names.length);
        CollectionDataStoreTest.assertTrue((boolean)this.contains(names, "road"));
    }

    boolean contains(Object[] array, Object expected) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(expected)) continue;
            return true;
        }
        return false;
    }

    boolean containsLax(SimpleFeature[] array, SimpleFeature expected) {
        if (array == null || array.length == 0) {
            return false;
        }
        SimpleFeatureType type = expected.getFeatureType();
        for (int i = 0; i < array.length; ++i) {
            if (!this.match(array[i], expected)) continue;
            return true;
        }
        return false;
    }

    boolean match(SimpleFeature expected, SimpleFeature actual) {
        SimpleFeatureType type = expected.getFeatureType();
        for (int i = 0; i < type.getAttributeCount(); ++i) {
            Geometry eg;
            Geometry ag;
            Object av = actual.getAttribute(i);
            Object ev = expected.getAttribute(i);
            if (av == null && ev != null) {
                return false;
            }
            if (ev == null && av != null) {
                return false;
            }
            if (!(av instanceof Geometry && ev instanceof Geometry ? !(ag = (Geometry)av).equals(eg = (Geometry)ev) : !av.equals(ev))) continue;
            return false;
        }
        return true;
    }

    public void testGetSchema() throws IOException {
        CollectionDataStoreTest.assertSame((Object)this.roadType, (Object)this.data.getSchema("road"));
    }

    void assertCovers(String msg, FeatureCollection<SimpleFeatureType, SimpleFeature> c1, FeatureCollection<SimpleFeatureType, SimpleFeature> c2) {
        if (c1 == c2) {
            return;
        }
        CollectionDataStoreTest.assertNotNull((String)msg, c1);
        CollectionDataStoreTest.assertNotNull((String)msg, c2);
        CollectionDataStoreTest.assertEquals((String)(msg + " size"), (int)c1.size(), (int)c2.size());
        FeatureIterator i = c1.features();
        while (i.hasNext()) {
            SimpleFeature f = (SimpleFeature)i.next();
            CollectionDataStoreTest.assertTrue((String)(msg + " " + f.getID()), (boolean)c2.contains((Object)f));
        }
    }

    public void testGetFeatureReader() throws IOException, IllegalAttributeException {
        FeatureReader reader = this.data.getFeatureReader("road");
        this.assertCovered(this.roadFeatures, (FeatureReader<SimpleFeatureType, SimpleFeature>)reader);
        CollectionDataStoreTest.assertEquals((boolean)false, (boolean)reader.hasNext());
    }

    public void testGetFeatureReaderConcurancy() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureReader reader1 = this.data.getFeatureReader("road");
        FeatureReader reader2 = this.data.getFeatureReader("road");
        while (reader1.hasNext() || reader2.hasNext()) {
            CollectionDataStoreTest.assertTrue((boolean)this.contains(this.roadFeatures, reader1.next()));
            CollectionDataStoreTest.assertTrue((boolean)this.contains(this.roadFeatures, reader2.next()));
        }
        try {
            reader1.next();
            CollectionDataStoreTest.fail((String)"next should fail with an IOException");
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            reader2.next();
            CollectionDataStoreTest.fail((String)"next should fail with an IOException");
        }
        catch (IOException expected) {
            // empty catch block
        }
        reader1.close();
        reader2.close();
    }

    public void testGetFeatureReaderFilterAutoCommit() throws NoSuchElementException, IOException, IllegalAttributeException {
        SimpleFeatureType type = this.data.getSchema("road");
        FeatureReader reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), Transaction.AUTO_COMMIT);
        CollectionDataStoreTest.assertFalse((boolean)(reader instanceof FilteringFeatureReader));
        CollectionDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        CollectionDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)Filter.EXCLUDE), Transaction.AUTO_COMMIT);
        CollectionDataStoreTest.assertTrue((boolean)(reader instanceof EmptyFeatureReader));
        CollectionDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        CollectionDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", this.rd1Filter), Transaction.AUTO_COMMIT);
        CollectionDataStoreTest.assertTrue((boolean)(reader instanceof FilteringFeatureReader));
        CollectionDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        CollectionDataStoreTest.assertEquals((int)1, (int)this.count(reader));
    }

    public void testGetFeatureReaderFilterTransaction() throws NoSuchElementException, IOException, IllegalAttributeException {
        DefaultTransaction t = new DefaultTransaction();
        SimpleFeatureType type = this.data.getSchema("road");
        FeatureReader reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)Filter.EXCLUDE), (Transaction)t);
        CollectionDataStoreTest.assertTrue((boolean)(reader instanceof EmptyFeatureReader));
        CollectionDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        CollectionDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), (Transaction)t);
        CollectionDataStoreTest.assertTrue((boolean)(reader instanceof DiffFeatureReader));
        CollectionDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        CollectionDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", this.rd1Filter), (Transaction)t);
        CollectionDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        CollectionDataStoreTest.assertEquals((int)1, (int)this.count(reader));
        TransactionStateDiff state = (TransactionStateDiff)t.getState((Object)this.data);
        FeatureWriter writer = state.writer("road", (Filter)Filter.INCLUDE);
        while (writer.hasNext()) {
            SimpleFeature feature = (SimpleFeature)writer.next();
            if (!feature.getID().equals("road.rd1")) continue;
            writer.remove();
        }
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)Filter.EXCLUDE), (Transaction)t);
        CollectionDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), (Transaction)t);
        CollectionDataStoreTest.assertEquals((int)(this.roadFeatures.length - 1), (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", this.rd1Filter), (Transaction)t);
        CollectionDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        t.rollback();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)Filter.EXCLUDE), (Transaction)t);
        CollectionDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), (Transaction)t);
        CollectionDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", this.rd1Filter), (Transaction)t);
        CollectionDataStoreTest.assertEquals((int)1, (int)this.count(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertCovered(SimpleFeature[] features, FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                CollectionDataStoreTest.assertTrue((boolean)this.contains(features, reader.next()));
                ++count;
            }
        }
        finally {
            reader.close();
        }
        CollectionDataStoreTest.assertEquals((int)features.length, (int)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean covers(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                if (!this.contains(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        return count == array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean coversLax(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                if (!this.containsLax(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        return count == array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                System.out.println(count + " feature:" + feature);
                ++count;
            }
        }
        finally {
            reader.close();
        }
    }

    void dump(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            System.out.println(i + " feature:" + array[i]);
        }
    }

    public void testGetFeatureSourceRoad() throws IOException {
        FeatureSource road = this.data.getFeatureSource("road");
        CollectionDataStoreTest.assertSame((Object)this.roadType, (Object)road.getSchema());
        CollectionDataStoreTest.assertSame((Object)this.data, (Object)road.getDataStore());
        CollectionDataStoreTest.assertEquals((int)3, (int)road.getCount(Query.ALL));
        CollectionDataStoreTest.assertEquals((Object)new Envelope(1.0, 5.0, 0.0, 4.0), (Object)road.getBounds(Query.ALL));
        FeatureCollection all = road.getFeatures();
        CollectionDataStoreTest.assertEquals((int)3, (int)all.size());
        CollectionDataStoreTest.assertEquals((Object)this.roadBounds, (Object)all.getBounds());
        FeatureCollection expected = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        this.assertCovers("all", (FeatureCollection<SimpleFeatureType, SimpleFeature>)expected, (FeatureCollection<SimpleFeatureType, SimpleFeature>)all);
        CollectionDataStoreTest.assertEquals((Object)this.roadBounds, (Object)all.getBounds());
        FeatureCollection some = road.getFeatures(this.rd12Filter);
        CollectionDataStoreTest.assertEquals((int)2, (int)some.size());
        CollectionDataStoreTest.assertEquals((Object)this.rd12Bounds, (Object)some.getBounds());
        CollectionDataStoreTest.assertEquals((Object)some.getSchema(), (Object)road.getSchema());
        DefaultQuery query = new DefaultQuery(((SimpleFeatureType)road.getSchema()).getTypeName(), this.rd12Filter, new String[]{"name"});
        FeatureCollection half = road.getFeatures((Query)query);
        CollectionDataStoreTest.assertEquals((int)2, (int)half.size());
        CollectionDataStoreTest.assertEquals((int)1, (int)((SimpleFeatureType)half.getSchema()).getAttributeCount());
        FeatureIterator reader = half.features();
        SimpleFeatureType type = (SimpleFeatureType)half.getSchema();
        reader.close();
        SimpleFeatureType actual = (SimpleFeatureType)half.getSchema();
        String name = type.getTypeName();
        CollectionDataStoreTest.assertEquals((String)name, (String)actual.getTypeName());
        CollectionDataStoreTest.assertEquals((String)type.getName().getNamespaceURI(), (String)actual.getName().getNamespaceURI());
        CollectionDataStoreTest.assertEquals((int)type.getAttributeCount(), (int)actual.getAttributeCount());
        for (int i = 0; i < type.getAttributeCount(); ++i) {
            CollectionDataStoreTest.assertEquals((Object)type.getDescriptor(i), (Object)actual.getDescriptor(i));
        }
        CollectionDataStoreTest.assertNull((Object)type.getGeometryDescriptor());
        CollectionDataStoreTest.assertEquals((Object)type.getGeometryDescriptor(), (Object)actual.getGeometryDescriptor());
        CollectionDataStoreTest.assertEquals((Object)type, (Object)actual);
        ReferencedEnvelope b = half.getBounds();
        CollectionDataStoreTest.assertEquals((Object)new Envelope(1.0, 5.0, 0.0, 4.0), (Object)b);
    }
}

