/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.matfile5;

import it.geosolutions.imageio.matfile5.sas.SASTileImageReaderSpi;
import it.geosolutions.imageio.matfile5.sas.SASTileMetadata;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverageio.BaseGridCoverage2DReader;
import org.geotools.coverageio.matfile5.MatFile5Format;
import org.geotools.coverageio.matfile5.UTMUtilities;
import org.geotools.data.DataSourceException;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class MatFile5Reader
extends BaseGridCoverage2DReader
implements GridCoverageReader {
    private static final String worldFileExt = ".wld";
    private static final Logger LOGGER = Logging.getLogger((String)MatFile5Reader.class.toString());

    public MatFile5Reader(Object input, Hints hints) throws DataSourceException {
        super(input, hints, worldFileExt, (ImageReaderSpi)new SASTileImageReaderSpi());
    }

    protected void setCoverageProperties(ImageReader reader) throws IOException {
        IIOMetadata metadata = reader.getImageMetadata(0);
        boolean isSAS = metadata instanceof SASTileMetadata;
        Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
        if (tempCRS != null) {
            this.setCoverageCRS((CoordinateReferenceSystem)tempCRS);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Using forced coordinate reference system " + this.crs.toWKT());
            }
        } else {
            if (!isSAS) {
                this.parsePRJFile();
            } else {
                this.getPropertiesFromMetadata((SASTileMetadata)metadata);
            }
            if (this.getCoverageCRS() == null) {
                this.parsePRJFile();
            }
            if (this.getCoverageCRS() == null) {
                throw new DataSourceException("Coordinate Reference System is not available");
            }
        }
        if (!isSAS) {
            this.parseWorldFile();
        } else if (this.getCoverageEnvelope() == null) {
            this.parseWorldFile();
            if (this.getCoverageEnvelope() == null) {
                throw new DataSourceException("Unavailable envelope for this coverage");
            }
        }
        this.getCoverageEnvelope().setCoordinateReferenceSystem(this.getCoverageCRS());
        this.originalEnvelope = this.getCoverageEnvelope();
        this.originalGridRange = this.getCoverageGridRange();
        this.crs = this.getCoverageCRS();
    }

    private void getPropertiesFromMetadata(SASTileMetadata metadata) throws IOException {
        block8: {
            if (this.getCoverageGridRange() == null) {
                this.setCoverageGridRange(new GridEnvelope2D(new Rectangle(0, 0, metadata.getXPixels(), metadata.getYPixels())));
            }
            double longitude = metadata.getLongitude();
            double latitude = metadata.getLatitude();
            SASTileMetadata.Channel channel = metadata.getChannel();
            double orientation = metadata.getOrientation();
            double xDim = metadata.getXPixelDim();
            double yDim = metadata.getYPixelDim();
            AffineTransform gt = null;
            try {
                CoordinateReferenceSystem crs = UTMUtilities.getProperUTM(longitude, latitude);
                this.setCoverageCRS(crs);
                MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)crs);
                double[] dest = new double[2];
                transform.transform(new double[]{longitude, latitude}, 0, dest, 0, 1);
                double easting = dest[0];
                double northing = dest[1];
                double alpha = orientation * Math.PI / 180.0;
                double cosAlpha = Math.cos(alpha);
                double sinAlpha = Math.sin(alpha);
                double[] dx = new double[2];
                double[] dy = new double[2];
                dx[0] = sinAlpha * xDim;
                dx[1] = channel == SASTileMetadata.Channel.PORT ? -cosAlpha * yDim : cosAlpha * yDim;
                dy[0] = cosAlpha * xDim;
                dy[1] = channel == SASTileMetadata.Channel.PORT ? sinAlpha * yDim : sinAlpha * -yDim;
                GeneralMatrix gm = new GeneralMatrix(3);
                gm.setElement(0, 0, dx[0]);
                gm.setElement(0, 1, dx[1]);
                gm.setElement(1, 0, dy[0]);
                gm.setElement(1, 1, dy[1]);
                gm.setElement(0, 2, easting);
                gm.setElement(1, 2, northing);
                gt = gm.toAffineTransform2D();
                this.raster2Model = ProjectiveTransform.create((AffineTransform)gt);
                MathTransform tempTransform = PixelTranslation.translate((MathTransform)this.raster2Model, (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER);
                if (this.getCoverageEnvelope() == null) {
                    GeneralEnvelope gridRange = new GeneralEnvelope(this.getCoverageGridRange().getBounds2D());
                    GeneralEnvelope coverageEnvelope = CRS.transform((MathTransform)tempTransform, (Envelope)gridRange);
                    this.setCoverageEnvelope(coverageEnvelope);
                }
            }
            catch (IllegalStateException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
            catch (TransformException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
            catch (FactoryException e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block8;
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
    }

    public Format getFormat() {
        return new MatFile5Format();
    }
}

