/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis.fidmapper;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Statement;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.fidmapper.MultiColumnFIDMapper;
import org.geotools.data.postgis.fidmapper.PostGISAutoIncrementFIDMapper;
import org.geotools.data.postgis.fidmapper.VersionedFIDMapper;
import org.opengis.feature.simple.SimpleFeature;

class VersionedAutoincrementFIDMapper
extends MultiColumnFIDMapper
implements VersionedFIDMapper {
    protected PostGISAutoIncrementFIDMapper autoIncrementMapper;

    public VersionedAutoincrementFIDMapper(String tableSchemaName, String tableName, String colName, int colType, int colSize) {
        super(tableSchemaName, tableName, new String[]{"revision", colName}, new int[]{colType, 2}, new int[]{colSize, 8}, new int[]{0, 0}, new boolean[]{false, true});
        this.returnFIDColumnsAsAttributes = true;
        this.autoIncrementMapper = new PostGISAutoIncrementFIDMapper(tableSchemaName, tableName, colName, colType);
    }

    public String getUnversionedFid(String versionedFID) {
        return this.tableName + "." + versionedFID.substring(versionedFID.lastIndexOf(38) + 1);
    }

    public String createVersionedFid(String extenalFID, long revision) {
        return revision + "&" + extenalFID.substring(this.tableName.length() + 1);
    }

    public Object[] getUnversionedPKAttributes(String FID) throws IOException {
        if (!FID.startsWith(this.tableName + ".")) {
            throw new DataSourceException("The FID is invalid, should start with '" + this.tableName + ".'");
        }
        Object[] values = this.getPKAttributes(FID.substring(this.tableName.length() + 1) + "&0");
        Object[] unversioned = new Object[values.length - 1];
        System.arraycopy(values, 0, unversioned, 0, unversioned.length);
        return unversioned;
    }

    public String createID(Connection conn, SimpleFeature feature, Statement statement) throws IOException {
        if (feature.getAttribute(this.colNames[1]) == null) {
            try {
                String id = this.autoIncrementMapper.createID(conn, feature, statement);
                feature.setAttribute(this.colNames[1], (Object)new Long(id));
            }
            catch (Exception e) {
                throw new DataSourceException("Could not generate key for the unset primary key column " + this.colNames[1], (Throwable)e);
            }
        }
        return super.createID(conn, feature, statement);
    }
}

