/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureLockException;
import org.geotools.data.FeatureWriter;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.MutableFIDFeature;
import org.geotools.data.postgis.VersionedJdbcTransactionState;
import org.geotools.data.postgis.fidmapper.VersionedFIDMapper;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VersionedFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    private static Long NON_EXPIRED = new Long(Long.MAX_VALUE);
    private FeatureWriter<SimpleFeatureType, SimpleFeature> updateWriter;
    private FeatureWriter<SimpleFeatureType, SimpleFeature> appendWriter;
    private SimpleFeatureType featureType;
    private SimpleFeature oldFeature;
    private SimpleFeature newFeature;
    private SimpleFeature liveFeature;
    private VersionedJdbcTransactionState state;
    private VersionedFIDMapper mapper;
    private FeatureListenerManager listenerManager;
    private boolean autoCommit;

    public VersionedFeatureWriter(FeatureWriter<SimpleFeatureType, SimpleFeature> updateWriter, FeatureWriter<SimpleFeatureType, SimpleFeature> appendWriter, SimpleFeatureType featureType, VersionedJdbcTransactionState state, VersionedFIDMapper mapper, boolean autoCommit) {
        this.updateWriter = updateWriter;
        this.appendWriter = appendWriter;
        this.featureType = featureType;
        this.state = state;
        this.mapper = mapper;
        this.autoCommit = autoCommit;
    }

    public void setFeatureListenerManager(FeatureListenerManager listenerManager) {
        this.listenerManager = listenerManager;
    }

    public void close() throws IOException {
        if (this.updateWriter != null) {
            this.updateWriter.close();
        }
        this.appendWriter.close();
        if (this.autoCommit && this.state.getTransaction() != null) {
            this.state.getTransaction().commit();
            this.state.getTransaction().close();
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public boolean hasNext() throws IOException {
        this.appendWriter.hasNext();
        if (this.updateWriter != null) {
            return this.updateWriter.hasNext();
        }
        return false;
    }

    public SimpleFeature next() throws IOException {
        SimpleFeature original = null;
        if (this.updateWriter != null && this.updateWriter.hasNext()) {
            this.oldFeature = (SimpleFeature)this.updateWriter.next();
            this.newFeature = (SimpleFeature)this.appendWriter.next();
            original = this.oldFeature;
            this.state.expandDirtyBounds(this.getWgs84FeatureEnvelope(this.oldFeature));
        } else {
            this.oldFeature = null;
            original = this.newFeature = (SimpleFeature)this.appendWriter.next();
        }
        try {
            this.liveFeature = DataUtilities.reType((SimpleFeatureType)this.featureType, (SimpleFeature)original);
            String unversionedId = this.liveFeature.getID();
            if (this.oldFeature != null) {
                unversionedId = this.mapper.getUnversionedFid(this.liveFeature.getID());
            }
            this.liveFeature = new MutableFIDFeature(this.liveFeature.getAttributes(), this.featureType, unversionedId);
            return this.liveFeature;
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Error casting versioned feature to external one. Should not happen, there's a bug at work", (Throwable)e);
        }
    }

    public Envelope getWgs84FeatureEnvelope(SimpleFeature feature) throws IOException {
        try {
            Envelope result = new Envelope();
            SimpleFeatureType ft = feature.getFeatureType();
            for (int i = 0; i < ft.getAttributeCount(); ++i) {
                AttributeDescriptor at = ft.getDescriptor(i);
                if (!(at instanceof GeometryDescriptor)) continue;
                GeometryDescriptor gat = (GeometryDescriptor)at;
                CoordinateReferenceSystem crs = gat.getCoordinateReferenceSystem();
                Geometry geom = (Geometry)feature.getAttribute(i);
                if (geom == null) continue;
                Envelope env = geom.getEnvelopeInternal();
                if (crs != null) {
                    env = JTS.toGeographic((Envelope)env, (CoordinateReferenceSystem)crs);
                }
                result.expandToInclude(env);
            }
            return result;
        }
        catch (TransformException e) {
            throw new DataSourceException("Error computing lat/long envelope of the current feature. This is needed to update the changeset bbox", (Throwable)e);
        }
    }

    public void remove() throws IOException {
        if (this.oldFeature == null) {
            throw new IOException("No feature available to remove");
        }
        this.listenerManager.fireFeaturesRemoved(this.getFeatureType().getTypeName(), this.state.getTransaction(), ReferencedEnvelope.reference((BoundingBox)this.oldFeature.getBounds()), false);
        this.writeOldFeature(true);
    }

    private void writeOldFeature(boolean expire) throws IOException, DataSourceException {
        try {
            if (expire) {
                this.oldFeature.setAttribute("expired", (Object)new Long(this.state.getRevision()));
            }
            this.updateWriter.write();
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Error writing expiration tag on old feature. Should not happen, there's a bug at work.", (Throwable)e);
        }
        catch (FeatureLockException fle) {
            String unversionedFid = this.mapper.getUnversionedFid(fle.getFeatureID());
            FeatureLockException mangled = new FeatureLockException(fle.getMessage(), unversionedFid, fle.getCause());
            throw mangled;
        }
    }

    public void write() throws IOException {
        Statement st = null;
        try {
            AttributeDescriptor at;
            boolean dirtyFeature = false;
            if (this.oldFeature != null) {
                boolean dirty = false;
                for (int i = 0; i < this.liveFeature.getAttributeCount(); ++i) {
                    AttributeDescriptor at2 = this.liveFeature.getFeatureType().getDescriptor(i);
                    Object newValue = this.liveFeature.getAttribute(at2.getLocalName());
                    Object oldValue = this.oldFeature.getAttribute(at2.getLocalName());
                    this.newFeature.setAttribute(at2.getLocalName(), newValue);
                    if (DataUtilities.attributesEqual((Object)newValue, (Object)oldValue)) continue;
                    dirty = true;
                }
                if (!dirty) {
                    return;
                }
            }
            String typeName = this.liveFeature.getFeatureType().getTypeName();
            String fid = this.liveFeature.getID();
            dirtyFeature = this.state.isFidDirty(typeName, fid);
            SimpleFeature writtenFeature = null;
            if (dirtyFeature) {
                for (int i = 0; i < this.liveFeature.getAttributeCount(); ++i) {
                    at = this.liveFeature.getFeatureType().getDescriptor(i);
                    this.oldFeature.setAttribute(at.getLocalName(), this.liveFeature.getAttribute(at.getLocalName()));
                }
                this.writeOldFeature(false);
                writtenFeature = this.oldFeature;
            } else {
                if (this.oldFeature != null) {
                    this.writeOldFeature(true);
                }
                for (int i = 0; i < this.liveFeature.getAttributeCount(); ++i) {
                    at = this.liveFeature.getFeatureType().getDescriptor(i);
                    this.newFeature.setAttribute(at.getLocalName(), this.liveFeature.getAttribute(at.getLocalName()));
                }
                this.newFeature.setAttribute("expired", (Object)NON_EXPIRED);
                this.newFeature.setAttribute("revision", (Object)new Long(this.state.getRevision()));
                if (this.oldFeature != null) {
                    this.newFeature.setAttribute("created", this.oldFeature.getAttribute("created"));
                } else {
                    this.newFeature.setAttribute("created", (Object)new Long(this.state.getRevision()));
                }
                String id = null;
                if (this.oldFeature != null) {
                    id = this.mapper.createVersionedFid(this.liveFeature.getID(), this.state.getRevision());
                    this.newFeature.setAttribute("created", this.oldFeature.getAttribute("created"));
                } else if (!this.mapper.hasAutoIncrementColumns()) {
                    ((MutableFIDFeature)this.newFeature).setID(this.liveFeature.getID());
                    id = this.mapper.createID(this.state.getConnection(), this.newFeature, null);
                    this.newFeature.setAttribute("created", (Object)new Long(this.state.getRevision()));
                }
                if (id != null) {
                    ((MutableFIDFeature)this.newFeature).setID(id);
                    Object[] pkatts = this.mapper.getPKAttributes(id);
                    for (int i = 0; i < pkatts.length; ++i) {
                        this.newFeature.setAttribute(this.mapper.getColumnName(i), pkatts[i]);
                    }
                }
                this.appendWriter.write();
                if (this.oldFeature == null && this.mapper.hasAutoIncrementColumns()) {
                    st = this.state.getConnection().createStatement();
                    id = this.mapper.createID(this.state.getConnection(), this.newFeature, st);
                }
                ((MutableFIDFeature)this.newFeature).setID(id);
                ((MutableFIDFeature)this.liveFeature).setID(this.mapper.getUnversionedFid(id));
                this.state.setFidDirty(this.liveFeature.getFeatureType().getTypeName(), this.liveFeature.getID());
                writtenFeature = this.newFeature;
            }
            this.state.expandDirtyBounds(this.getWgs84FeatureEnvelope(writtenFeature));
            if (this.oldFeature != null) {
                ReferencedEnvelope bounds = ReferencedEnvelope.reference((BoundingBox)this.oldFeature.getBounds());
                bounds.include(this.liveFeature.getBounds());
                this.listenerManager.fireFeaturesChanged(this.getFeatureType().getTypeName(), this.state.getTransaction(), bounds, false);
            } else {
                this.listenerManager.fireFeaturesAdded(this.getFeatureType().getTypeName(), this.state.getTransaction(), ReferencedEnvelope.reference((BoundingBox)this.liveFeature.getBounds()), false);
            }
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Error writing expiration tag on old feature. Should not happen, there's a bug at work.", (Throwable)e);
        }
        catch (SQLException e) {
            throw new DataSourceException("Error creating a new statement for primary key generation", (Throwable)e);
        }
        finally {
            JDBCUtils.close(st);
        }
    }
}

