/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.JDBCTransactionState;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.postgis.WrappedPostgisDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VersionedJdbcTransactionState
extends JDBCTransactionState {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.postgis");
    private long revision;
    private ReferencedEnvelope bbox;
    private HashSet dirtyTypes;
    private HashMap dirtyFids;
    private WrappedPostgisDataStore wrapped;
    private Transaction transaction;
    private static final double EPS = 1.0E-6;

    public VersionedJdbcTransactionState(Connection connection, WrappedPostgisDataStore wrapped) throws IOException {
        super(connection);
        this.wrapped = wrapped;
        this.reset();
    }

    private void reset() {
        this.revision = Long.MIN_VALUE;
        this.bbox = new ReferencedEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.dirtyTypes = new HashSet();
        this.dirtyFids = new HashMap();
    }

    public long getRevision() throws IOException {
        if (this.revision == Long.MIN_VALUE) {
            this.revision = this.writeRevision(this.transaction, this.bbox);
            this.transaction.putProperty((Object)"revision", (Object)new Long(this.revision));
            this.transaction.putProperty((Object)"version", (Object)String.valueOf(this.revision));
        }
        return this.revision;
    }

    public void setTypeNameDirty(String typeName) {
        this.dirtyTypes.add(typeName);
    }

    public void expandDirtyBounds(Envelope envelope) {
        this.bbox.expandToInclude(envelope);
    }

    public void setFidDirty(String typeName, String fid) {
        this.getCreateDirtyFids(typeName).add(fid);
    }

    public void setFidsDirty(String typeName, Collection<String> fids) {
        this.getCreateDirtyFids(typeName).addAll(fids);
    }

    Set<String> getCreateDirtyFids(String typeName) {
        HashSet fids = (HashSet)this.dirtyFids.get(typeName);
        if (fids == null) {
            fids = new HashSet();
            this.dirtyFids.put(typeName, fids);
        }
        return fids;
    }

    public boolean isFidDirty(String typeName, String fid) {
        Set fids = (Set)this.dirtyFids.get(typeName);
        if (fids == null) {
            return false;
        }
        return fids.contains(fid);
    }

    public void setTransaction(Transaction transaction) {
        super.setTransaction(transaction);
        this.transaction = transaction;
        if (transaction == null) {
            this.bbox = null;
            this.dirtyTypes = null;
        }
    }

    public void commit() throws IOException {
        if (!this.dirtyTypes.isEmpty()) {
            String author = (String)this.transaction.getProperty((Object)"VersioningCommitAuthor");
            String message = (String)this.transaction.getProperty((Object)"VersioningCommitMessage");
            SimpleFeature f = null;
            FeatureWriter writer = null;
            try {
                FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
                Id revisionFilter = ff.id(Collections.singleton(ff.featureId("changesets." + this.getRevision())));
                writer = this.wrapped.getFeatureWriter("changesets", (Filter)((org.geotools.filter.Filter)revisionFilter), this.transaction);
                if (!writer.hasNext()) {
                    throw new IOException("Could not find the changeset record that should have been set in the versioned datastore on versioned jdbc state creation");
                }
                f = (SimpleFeature)writer.next();
                f.setAttribute("author", (Object)author);
                f.setAttribute("message", (Object)message);
                f.setDefaultGeometry((Object)this.toLatLonRectange(this.bbox));
                writer.write();
            }
            catch (IllegalAttributeException e) {
                throw new DataSourceException("Could not set an attribute in changesets, most probably the table schema has been tampered with.", (Throwable)e);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            Statement st = null;
            try {
                st = this.getConnection().createStatement();
                for (String typeName : this.dirtyTypes) {
                    this.execute(st, "INSERT INTO tables_changed SELECT " + this.revision + ", id " + "FROM " + "versioned_tables" + " WHERE SCHEMA = '" + this.wrapped.getConfig().getDatabaseSchemaName() + "' " + "AND NAME = '" + typeName + "'");
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("Error occurred while trying to save modified tables for this changeset. This should not happen, probaly there's a bug at work here.", (Throwable)e);
            }
            finally {
                JDBCUtils.close((Statement)st);
            }
        }
        super.commit();
        this.reset();
    }

    public boolean isRevisionSet() {
        return this.revision == Long.MIN_VALUE;
    }

    Geometry toLatLonRectange(ReferencedEnvelope env) throws IOException {
        ReferencedEnvelope envelope = new ReferencedEnvelope(env);
        try {
            if (envelope == null || envelope.isEmpty()) {
                envelope = new ReferencedEnvelope(new Envelope(0.0, 1.0E-6, 0.0, 1.0E-6), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            } else if ((envelope = envelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true)).getHeight() == 0.0 || envelope.getWidth() == 0.0) {
                envelope.expandBy(1.0E-6);
            }
            GeometryFactory gf = new GeometryFactory();
            return gf.toGeometry((Envelope)envelope);
        }
        catch (Exception e) {
            throw new DataSourceException("An error occurred while trying to builds a lat/lon polygon equivalent to " + envelope, (Throwable)e);
        }
    }

    protected long writeRevision(Transaction t, ReferencedEnvelope bbox) throws IOException {
        SimpleFeature f = null;
        FeatureWriter writer = null;
        String author = (String)t.getProperty((Object)"VersioningCommitAuthor");
        String message = (String)t.getProperty((Object)"VersioningCommitMessage");
        Statement st = null;
        try {
            st = this.getConnection().createStatement();
            st.execute("LOCK TABLE changesets IN EXCLUSIVE MODE");
            writer = this.wrapped.getFeatureWriterAppend("changesets", t);
            f = (SimpleFeature)writer.next();
            f.setAttribute("author", (Object)author);
            f.setAttribute("message", (Object)message);
            f.setAttribute("date", (Object)new Date());
            f.setDefaultGeometry((Object)this.toLatLonRectange(bbox));
            writer.write();
        }
        catch (IllegalAttributeException e) {
            throw new IOException("Could not set an attribute in changesets, most probably the table schema has been tampered with.");
        }
        catch (SQLException e) {
            throw new DataSourceException("Could not set a lock on the table changesets", (Throwable)e);
        }
        finally {
            if (st != null) {
                JDBCUtils.close((Statement)st);
            }
            if (writer != null) {
                writer.close();
            }
        }
        return (Long)f.getAttribute("revision");
    }

    protected void execute(Statement st, String sql) throws SQLException {
        LOGGER.fine(sql);
        st.execute(sql);
    }

    Transaction getTransaction() {
        return this.transaction;
    }
}

