/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureDiff;
import org.opengis.feature.simple.SimpleFeature;

public class FeatureDiffImpl
implements FeatureDiff {
    public static final int INSERTED = 0;
    public static final int UPDATED = 1;
    public static final int DELETED = 2;
    String ID;
    int state;
    List changedAttributes;
    SimpleFeature feature;
    SimpleFeature oldFeature;

    public FeatureDiffImpl(SimpleFeature oldFeature, SimpleFeature newFeature) {
        if (oldFeature == null && newFeature == null) {
            throw new IllegalArgumentException("Both features are null, that's not a diff!");
        }
        this.ID = oldFeature != null ? oldFeature.getID() : newFeature.getID();
        this.feature = newFeature;
        this.oldFeature = oldFeature;
        this.changedAttributes = Collections.EMPTY_LIST;
        if (oldFeature == null) {
            this.state = 0;
        } else if (newFeature == null) {
            this.state = 2;
        } else {
            this.state = 1;
            ArrayList<String> changedAttributes = new ArrayList<String>();
            int i = 0;
            while (i < oldFeature.getAttributeCount()) {
                String attName = oldFeature.getFeatureType().getDescriptor(i).getLocalName();
                Object toAttribute = newFeature.getAttribute(attName);
                Object fromAttribute = oldFeature.getAttribute(attName);
                if (!DataUtilities.attributesEqual((Object)fromAttribute, (Object)toAttribute)) {
                    changedAttributes.add(attName);
                }
                ++i;
            }
            this.changedAttributes = Collections.unmodifiableList(changedAttributes);
        }
    }

    public List getChangedAttributes() {
        return this.changedAttributes;
    }

    public String getID() {
        return this.ID;
    }

    public int getState() {
        return this.state;
    }

    public SimpleFeature getFeature() {
        return this.feature;
    }

    public SimpleFeature getOldFeature() {
        return this.oldFeature;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ID == null ? 0 : this.ID.hashCode());
        result = 31 * result + (this.changedAttributes == null ? 0 : this.changedAttributes.hashCode());
        result = 31 * result + (this.feature == null ? 0 : this.feature.hashCode());
        result = 31 * result + (this.oldFeature == null ? 0 : this.oldFeature.hashCode());
        result = 31 * result + this.state;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureDiffImpl other = (FeatureDiffImpl)obj;
        if (this.ID == null ? other.ID != null : !this.ID.equals(other.ID)) {
            return false;
        }
        if (this.changedAttributes == null ? other.changedAttributes != null : !this.changedAttributes.equals(other.changedAttributes)) {
            return false;
        }
        if (this.feature == null ? other.feature != null : !this.feature.equals(other.feature)) {
            return false;
        }
        if (this.oldFeature == null ? other.oldFeature != null : !this.oldFeature.equals(other.oldFeature)) {
            return false;
        }
        return this.state == other.state;
    }

    public String toString() {
        return "FeatureDiffImpl [ID=" + this.ID + ", changedAttributes=" + this.changedAttributes + ", state=" + this.state + "]";
    }
}

