/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.geotools.data.AbstractFeatureStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.Transaction;
import org.geotools.data.VersioningFeatureStore;
import org.geotools.data.jdbc.MutableFIDFeature;
import org.geotools.data.postgis.FeatureDiffReaderImpl;
import org.geotools.data.postgis.ModifiedFeatureIds;
import org.geotools.data.postgis.RevisionInfo;
import org.geotools.data.postgis.VersionedJdbcTransactionState;
import org.geotools.data.postgis.VersionedPostgisDataStore;
import org.geotools.data.postgis.fidmapper.VersionedFIDMapper;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionedPostgisFeatureStore
extends AbstractFeatureStore
implements VersioningFeatureStore {
    private VersionedPostgisDataStore store;
    private FeatureLocking<SimpleFeatureType, SimpleFeature> locking;
    private SimpleFeatureType schema;

    public VersionedPostgisFeatureStore(SimpleFeatureType schema, VersionedPostgisDataStore store) throws IOException {
        this.store = store;
        this.schema = schema;
        this.locking = (FeatureLocking)store.wrapped.getFeatureSource(schema.getTypeName());
    }

    public Transaction getTransaction() {
        return this.locking.getTransaction();
    }

    public void setTransaction(Transaction transaction) {
        this.locking.setTransaction(transaction);
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this.getBounds(Query.ALL);
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        DefaultQuery versionedQuery = this.store.buildVersionedQuery(this.getTypedQuery(query));
        return this.locking.getBounds((Query)versionedQuery);
    }

    public int getCount(Query query) throws IOException {
        DefaultQuery versionedQuery = this.store.buildVersionedQuery(this.getTypedQuery(query));
        return this.locking.getCount((Query)versionedQuery);
    }

    public DataStore getDataStore() {
        return this.store;
    }

    public void addFeatureListener(FeatureListener listener) {
        this.store.listenerManager.addFeatureListener((FeatureSource)this, listener);
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.store.listenerManager.removeFeatureListener((FeatureSource)this, listener);
    }

    public void removeFeatures(Filter filter) throws IOException {
        Filter versionedFilter = this.store.buildVersionedFilter(this.schema.getTypeName(), filter, new RevisionInfo());
        Transaction t = this.getTransaction();
        boolean autoCommit = false;
        if (Transaction.AUTO_COMMIT.equals(t)) {
            t = new DefaultTransaction();
            autoCommit = true;
        }
        VersionedJdbcTransactionState state = this.store.wrapped.getVersionedJdbcTransactionState(t);
        ReferencedEnvelope bounds = this.locking.getBounds((Query)new DefaultQuery(this.schema.getTypeName(), versionedFilter));
        if (bounds != null) {
            if (bounds.getCoordinateReferenceSystem() == null) {
                bounds = new ReferencedEnvelope((Envelope)bounds, this.getSchema().getCoordinateReferenceSystem());
            }
            try {
                ReferencedEnvelope wgsBounds = null;
                wgsBounds = bounds.getCoordinateReferenceSystem() != null ? bounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true) : bounds;
                state.expandDirtyBounds((Envelope)wgsBounds);
                state.setTypeNameDirty(this.schema.getTypeName());
            }
            catch (Exception e) {
                throw new DataSourceException("Problems computing and storing the bounds affected by this feature removal", (Throwable)e);
            }
        }
        this.locking.modifyFeatures(((SimpleFeatureType)this.locking.getSchema()).getDescriptor("expired"), (Object)new Long(state.getRevision()), versionedFilter);
        if (autoCommit) {
            t.commit();
            t.close();
        }
        this.store.listenerManager.fireFeaturesRemoved(this.schema.getTypeName(), t, bounds, false);
    }

    public void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        this.removeFeatures((Filter)Filter.INCLUDE);
        this.addFeatures(reader);
    }

    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        return super.getFeatures(query);
    }

    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        return super.getFeatures(filter);
    }

    public SimpleFeatureCollection getFeatures() throws IOException {
        return super.getFeatures();
    }

    @Override
    public SimpleFeatureCollection getVersionedFeatures(Query query) throws IOException {
        SimpleFeatureType ft = this.getSchema();
        String typeName = ft.getTypeName();
        if (query.getTypeName() != null && !query.getTypeName().equals(typeName)) {
            throw new IOException("Incompatible type, this class can access only " + typeName);
        }
        if (!Arrays.asList(this.store.wrapped.getTypeNames()).contains(VersionedPostgisDataStore.getVFCViewName(typeName))) {
            this.store.createVersionedFeatureCollectionView(typeName);
        }
        DefaultQuery vq = new DefaultQuery(query);
        vq.setTypeName(VersionedPostgisDataStore.getVFCViewName(typeName));
        vq = this.store.buildVersionedQuery((Query)vq);
        SimpleFeatureCollection fc = this.store.wrapped.getFeatureSource(VersionedPostgisDataStore.getVFCViewName(typeName)).getFeatures((Query)vq);
        SimpleFeatureType fcSchema = (SimpleFeatureType)fc.getSchema();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.init(ft);
        builder.setAttributes(((SimpleFeatureType)fc.getSchema()).getAttributeDescriptors());
        SimpleFeatureType renamedFt = builder.buildFeatureType();
        return new ReTypingFeatureCollection(fc, renamedFt);
    }

    @Override
    public SimpleFeatureCollection getVersionedFeatures(Filter filter) throws IOException {
        return this.getVersionedFeatures((Query)new DefaultQuery(null, filter));
    }

    @Override
    public SimpleFeatureCollection getVersionedFeatures() throws IOException {
        return this.getVersionedFeatures((Query)new DefaultQuery(this.getSchema().getTypeName()));
    }

    public List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) throws IOException {
        LinkedList<FeatureId> addedFids = new LinkedList<FeatureId>();
        String typeName = this.getSchema().getTypeName();
        SimpleFeature feature = null;
        FeatureWriter writer = this.getDataStore().getFeatureWriterAppend(typeName, this.getTransaction());
        Iterator iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                feature = (SimpleFeature)iterator.next();
                SimpleFeature newFeature = (SimpleFeature)writer.next();
                try {
                    newFeature.setAttributes(feature.getAttributes());
                }
                catch (Exception writeProblem) {
                    throw new DataSourceException("Could not create " + typeName + " out of provided feature: " + feature.getID(), (Throwable)writeProblem);
                }
                ((MutableFIDFeature)newFeature).setID(feature.getID());
                writer.write();
                addedFids.add(newFeature.getIdentifier());
            }
        }
        finally {
            collection.close(iterator);
            writer.close();
        }
        return addedFids;
    }

    @Override
    public String getVersion() throws IOException {
        Transaction t = this.getTransaction();
        if (t == Transaction.AUTO_COMMIT) {
            return null;
        }
        return String.valueOf(this.store.wrapped.getVersionedJdbcTransactionState(t).getRevision());
    }

    @Override
    public void rollback(String toVersion, Filter filter, String[] userIds) throws IOException {
        Transaction t = this.getTransaction();
        boolean autoCommit = false;
        if (Transaction.AUTO_COMMIT.equals(t)) {
            t = new DefaultTransaction();
            autoCommit = true;
        }
        ModifiedFeatureIds mfids = this.store.getModifiedFeatureFIDs(this.schema.getTypeName(), toVersion, null, filter, userIds, t);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        VersionedJdbcTransactionState state = this.store.wrapped.getVersionedJdbcTransactionState(t);
        HashSet fidsToRemove = new HashSet(mfids.getCreated());
        fidsToRemove.removeAll(mfids.getDeleted());
        if (!fidsToRemove.isEmpty()) {
            this.removeFeatures(this.store.buildFidFilter(fidsToRemove));
            state.setTypeNameDirty(this.getSchema().getTypeName());
        }
        HashSet<String> fidsToRecreate = new HashSet<String>(mfids.getDeleted());
        fidsToRecreate.removeAll(mfids.getCreated());
        if (!fidsToRecreate.isEmpty()) {
            state.setTypeNameDirty(this.getSchema().getTypeName());
            state.setFidsDirty(this.getSchema().getTypeName(), fidsToRecreate);
            long revision = this.store.wrapped.getVersionedJdbcTransactionState(t).getRevision();
            Filter recreateFilter = this.store.buildVersionedFilter(this.schema.getTypeName(), this.store.buildFidFilter(fidsToRecreate), mfids.fromRevision);
            FeatureReader fr = null;
            FeatureWriter fw = null;
            try {
                try {
                    DefaultQuery q = new DefaultQuery(this.schema.getTypeName(), recreateFilter);
                    fr = this.store.wrapped.getFeatureReader((Query)q, t);
                    fw = this.store.wrapped.getFeatureWriterAppend(this.schema.getTypeName(), t);
                    while (fr.hasNext()) {
                        SimpleFeature original = (SimpleFeature)fr.next();
                        SimpleFeature restored = (SimpleFeature)fw.next();
                        int i = 0;
                        while (i < original.getFeatureType().getAttributeCount()) {
                            restored.setAttribute(i, original.getAttribute(i));
                            ++i;
                        }
                        restored.setAttribute("revision", (Object)new Long(revision));
                        restored.setAttribute("expired", (Object)new Long(Long.MAX_VALUE));
                        fw.write();
                    }
                }
                catch (IllegalAttributeException iae) {
                    throw new DataSourceException("Unexpected error occurred while restoring deleted featues", (Throwable)iae);
                }
            }
            finally {
                if (fr != null) {
                    fr.close();
                }
                if (fw != null) {
                    fw.close();
                }
            }
        }
        if (!mfids.getModified().isEmpty()) {
            state.setTypeNameDirty(this.getSchema().getTypeName());
            state.setFidsDirty(this.getSchema().getTypeName(), mfids.getModified());
            Filter modifiedIdFilter = this.store.buildFidFilter(mfids.getModified());
            Filter mifCurrent = this.store.buildVersionedFilter(this.schema.getTypeName(), modifiedIdFilter, new RevisionInfo());
            FeatureReader<SimpleFeatureType, SimpleFeature> fr = null;
            FeatureWriter<SimpleFeatureType, SimpleFeature> fw = null;
            try {
                try {
                    fw = this.store.getFeatureWriter(this.schema.getTypeName(), mifCurrent, t);
                    while (fw.hasNext()) {
                        SimpleFeature current = (SimpleFeature)fw.next();
                        Id currIdFilter = ff.id(Collections.singleton(ff.featureId(current.getID())));
                        Filter cidToVersion = this.store.buildVersionedFilter(this.schema.getTypeName(), (Filter)currIdFilter, mfids.fromRevision);
                        DefaultQuery q = new DefaultQuery(this.schema.getTypeName(), cidToVersion);
                        q.setVersion(mfids.fromRevision.toString());
                        fr = this.store.getFeatureReader((Query)q, t);
                        SimpleFeature original = (SimpleFeature)fr.next();
                        int i = 0;
                        while (i < original.getFeatureType().getAttributeCount()) {
                            current.setAttribute(i, original.getAttribute(i));
                            ++i;
                        }
                        fr.close();
                        fw.write();
                    }
                }
                catch (IllegalAttributeException iae) {
                    throw new DataSourceException("Unexpected error occurred while restoring deleted featues", (Throwable)iae);
                }
            }
            finally {
                if (fr != null) {
                    fr.close();
                }
                if (fw != null) {
                    fw.close();
                }
            }
        }
        if (autoCommit) {
            t.commit();
            t.close();
        }
    }

    @Override
    public SimpleFeatureCollection getLog(String fromVersion, String toVersion, Filter filter, String[] userIds, int maxRows) throws IOException {
        if (filter == null) {
            filter = Filter.INCLUDE;
        }
        RevisionInfo r1 = new RevisionInfo(fromVersion);
        RevisionInfo r2 = new RevisionInfo(toVersion);
        boolean swapped = false;
        if (r1.revision > r2.revision) {
            RevisionInfo tmpr = r1;
            r1 = r2;
            r2 = tmpr;
            String tmps = toVersion;
            toVersion = fromVersion;
            fromVersion = tmps;
            swapped = true;
        }
        ModifiedFeatureIds mfids = this.store.getModifiedFeatureFIDs(this.schema.getTypeName(), fromVersion, toVersion, filter, userIds, this.getTransaction());
        HashSet ids = new HashSet(mfids.getCreated());
        ids.addAll(mfids.getDeleted());
        ids.addAll(mfids.getModified());
        r1 = mfids.fromRevision;
        r2 = mfids.toRevision;
        if (ids.isEmpty()) {
            return new EmptyFeatureCollection(this.schema);
        }
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Filter fidFilter = this.store.buildFidFilter(ids);
        Filter transformedFidFilter = this.store.transformFidFilter(this.schema.getTypeName(), fidFilter);
        PropertyIsGreaterThan revGrR1 = ff.greater((Expression)ff.property("revision"), (Expression)ff.literal(r1.revision));
        PropertyIsLessThanOrEqualTo revLeR2 = ff.lessOrEqual((Expression)ff.property("revision"), (Expression)ff.literal(r2.revision));
        PropertyIsGreaterThan expGrR1 = ff.greater((Expression)ff.property("expired"), (Expression)ff.literal(r1.revision));
        PropertyIsLessThanOrEqualTo expLeR2 = ff.lessOrEqual((Expression)ff.property("expired"), (Expression)ff.literal(r2.revision));
        And versionFilter = ff.and(transformedFidFilter, (Filter)ff.or((Filter)ff.and((Filter)revGrR1, (Filter)revLeR2), (Filter)ff.and((Filter)expGrR1, (Filter)expLeR2)));
        DefaultQuery q = new DefaultQuery(this.schema.getTypeName(), (Filter)versionFilter, new String[]{"revision", "expired"});
        FeatureReader fr = null;
        TreeSet<Long> revisions = new TreeSet<Long>();
        try {
            try {
                fr = this.store.wrapped.getFeatureReader((Query)q, this.getTransaction());
                while (fr.hasNext()) {
                    Long expired;
                    SimpleFeature f = (SimpleFeature)fr.next();
                    Long revision = (Long)f.getAttribute(0);
                    if (revision > r1.revision) {
                        revisions.add(revision);
                    }
                    if ((expired = (Long)f.getAttribute(1)) == Long.MAX_VALUE || expired <= r1.revision) continue;
                    revisions.add(expired);
                }
            }
            catch (Exception e) {
                throw new DataSourceException("Error reading modified revisions from datastore", (Throwable)e);
            }
        }
        finally {
            if (fr != null) {
                fr.close();
            }
        }
        HashSet<FeatureId> revisionIdSet = new HashSet<FeatureId>();
        for (Long rev : revisions) {
            revisionIdSet.add(ff.featureId("changesets." + rev.toString()));
        }
        if (revisionIdSet.isEmpty()) {
            return new EmptyFeatureCollection(this.schema);
        }
        Id revisionFilter = ff.id(revisionIdSet);
        SimpleFeatureSource changesets = this.store.getFeatureSource("changesets");
        DefaultQuery sq = new DefaultQuery();
        sq.setFilter((Filter)revisionFilter);
        SortOrder order = swapped ? SortOrder.ASCENDING : SortOrder.DESCENDING;
        sq.setSortBy(new SortBy[]{ff.sort("revision", order)});
        if (maxRows > 0) {
            sq.setMaxFeatures(maxRows);
        }
        return changesets.getFeatures((Query)sq);
    }

    @Override
    public FeatureDiffReaderImpl getDifferences(String fromVersion, String toVersion, Filter filter, String[] userIds) throws IOException {
        if (filter == null) {
            filter = Filter.INCLUDE;
        }
        RevisionInfo r1 = new RevisionInfo(fromVersion);
        RevisionInfo r2 = new RevisionInfo(toVersion);
        ModifiedFeatureIds mfids = this.store.getModifiedFeatureFIDs(this.schema.getTypeName(), fromVersion, toVersion, filter, userIds, this.getTransaction());
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        VersionedFIDMapper mapper = (VersionedFIDMapper)this.store.getFIDMapper(this.schema.getTypeName());
        return new FeatureDiffReaderImpl(this.store, this.getTransaction(), this.schema, r1, r2, mapper, mfids);
    }

    private Query getTypedQuery(Query query) {
        DefaultQuery q = new DefaultQuery(query);
        q.setTypeName(this.schema.getTypeName());
        return q;
    }

    public Set getSupportedHints() {
        VersionedPostgisDataStore ds = (VersionedPostgisDataStore)this.getDataStore();
        if (ds.wrapped.isWKBEnabled()) {
            HashSet<Hints.ClassKey> set = new HashSet<Hints.ClassKey>();
            set.add(Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
            set.add(Hints.JTS_GEOMETRY_FACTORY);
            return set;
        }
        return Collections.EMPTY_SET;
    }

    public QueryCapabilities getQueryCapabilities() {
        try {
            VersionedPostgisDataStore ds = (VersionedPostgisDataStore)this.getDataStore();
            return ds.wrapped.getFeatureSource(this.schema.getTypeName()).getQueryCapabilities();
        }
        catch (Exception e) {
            throw new RuntimeException("This error should never happen", e);
        }
    }
}

