/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis.synch;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.geotools.data.AbstractDataStoreFactory;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.jdbc.datasource.DataSourceUtil;
import org.geotools.data.postgis.synch.SynchronizedPostgisDataStore;
import org.geotools.util.logging.Logging;

public class SynchronizedPostgisDataStoreFactory
extends AbstractDataStoreFactory {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.postgis");
    private static final String DRIVER_CLASS = "org.postgresql.Driver";
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "must be 'postgis-synchronized'", true, (Object)"postgis-synchronized");
    public static final DataAccessFactory.Param HOST = new DataAccessFactory.Param("host", String.class, "postgis host machine", true, (Object)"localhost");
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "postgis connection port (default is 5432)", true, (Object)new Integer(5432));
    public static final DataAccessFactory.Param DATABASE = new DataAccessFactory.Param("database", String.class, "postgis database");
    public static final DataAccessFactory.Param SCHEMA = new DataAccessFactory.Param("schema", String.class, "postgis schema", false, (Object)"public");
    public static final DataAccessFactory.Param USER = new DataAccessFactory.Param("user", String.class, "user name to login as");
    public static final DataAccessFactory.Param PASSWD = new DataAccessFactory.Param("passwd", String.class, "password used to login", false, null, new Object[]{"isPassword", true});
    public static final DataAccessFactory.Param NAMESPACE = new DataAccessFactory.Param("namespace", String.class, "namespace prefix used", false);
    public static final DataAccessFactory.Param DATASOURCE = new DataAccessFactory.Param("Data Source", DataSource.class, "Data Source", false);
    public static final DataAccessFactory.Param WKBENABLED = new DataAccessFactory.Param("wkb enabled", Boolean.class, "set to true if Well Known Binary should be used to read PostGIS data (experimental)", false, (Object)new Boolean(true));
    public static final DataAccessFactory.Param LOOSEBBOX = new DataAccessFactory.Param("loose bbox", Boolean.class, "set to true if the Bounding Box should be 'loose', faster but not as deadly accurate", false, (Object)new Boolean(true));
    public static final DataAccessFactory.Param VERSIONALL = new DataAccessFactory.Param("version enable all", Boolean.class, "set to true if you want all feature types to be version enabled on connection", false, (Object)new Boolean(false));
    static final DataAccessFactory.Param[] arrayParameters = new DataAccessFactory.Param[]{DBTYPE, HOST, PORT, DATABASE, USER, PASSWD, WKBENABLED, LOOSEBBOX, NAMESPACE, VERSIONALL, DATASOURCE};

    public boolean canProcess(Map params) {
        if (!super.canProcess(params)) {
            return false;
        }
        return ((String)params.get("dbtype")).equalsIgnoreCase("postgis-synchronized");
    }

    public DataStore createDataStore(Map params) throws IOException {
        String host = (String)HOST.lookUp(params);
        String user = (String)USER.lookUp(params);
        String passwd = (String)PASSWD.lookUp(params);
        Integer port = (Integer)PORT.lookUp(params);
        String schema = (String)SCHEMA.lookUp(params);
        String database = (String)DATABASE.lookUp(params);
        Boolean wkb_enabled = (Boolean)WKBENABLED.lookUp(params);
        Boolean is_loose_bbox = (Boolean)LOOSEBBOX.lookUp(params);
        String namespace = (String)NAMESPACE.lookUp(params);
        Boolean versionAll = (Boolean)VERSIONALL.lookUp(params);
        if (!this.canProcess(params)) {
            throw new IOException("The parameters map isn't correct!!");
        }
        DataSource source = (DataSource)DATASOURCE.lookUp(params);
        if (source == null) {
            String url = "jdbc:postgresql://" + host + ":" + port + "/" + database;
            source = DataSourceUtil.buildDefaultDataSource((String)url, (String)DRIVER_CLASS, (String)user, (String)passwd, (String)"select now()");
        }
        SynchronizedPostgisDataStore dataStore = this.createDataStoreInternal(source, namespace, schema);
        if (wkb_enabled != null) {
            dataStore.setWKBEnabled(wkb_enabled);
        }
        if (is_loose_bbox != null) {
            dataStore.setLooseBbox(is_loose_bbox);
        }
        if (versionAll != null && versionAll.booleanValue()) {
            String[] typeNames = dataStore.getTypeNames();
            int i = 0;
            while (i < typeNames.length) {
                if (!typeNames[i].equals("changesets")) {
                    try {
                        dataStore.setVersioned(typeNames[i], true, null, null);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "Could not version enable: " + typeNames[i], e);
                    }
                }
                ++i;
            }
        }
        return dataStore;
    }

    protected SynchronizedPostgisDataStore createDataStoreInternal(DataSource dataSource, String namespace, String schema) throws IOException {
        if (schema == null && namespace == null) {
            return new SynchronizedPostgisDataStore(dataSource);
        }
        if (schema == null && namespace != null) {
            return new SynchronizedPostgisDataStore(dataSource, namespace);
        }
        return new SynchronizedPostgisDataStore(dataSource, schema, namespace);
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("Postgis cannot create a new Database");
    }

    public String getDisplayName() {
        return "Versioning Postgis";
    }

    public String getDescription() {
        return "PostGIS spatial database with versioning support";
    }

    public boolean isAvailable() {
        try {
            Class.forName(DRIVER_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        return true;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return arrayParameters;
    }
}

