/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.util.Collections;
import java.util.Set;
import org.geotools.data.postgis.RevisionInfo;

public class ModifiedFeatureIds {
    RevisionInfo fromRevision;
    RevisionInfo toRevision;
    Set created;
    Set deleted;
    Set modified;

    public ModifiedFeatureIds(RevisionInfo fromRevision, RevisionInfo toRevision) {
        this(fromRevision, toRevision, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET);
    }

    public ModifiedFeatureIds(RevisionInfo fromRevision, RevisionInfo toRevision, Set created, Set deleted, Set modified) {
        this.fromRevision = fromRevision;
        this.toRevision = toRevision;
        this.deleted = deleted;
        this.created = created;
        this.modified = modified;
    }

    public Set getDeleted() {
        return Collections.unmodifiableSet(this.deleted);
    }

    public Set getCreated() {
        return Collections.unmodifiableSet(this.created);
    }

    public Set getModified() {
        return Collections.unmodifiableSet(this.modified);
    }

    public String getToVersion() {
        return this.toRevision.getVersion();
    }

    public String getFromVersion() {
        return this.fromRevision.getVersion();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Diff between: " + this.fromRevision + " and " + this.toRevision).append("\n");
        sb.append("Created: ").append(this.created).append("\n");
        sb.append("Deleted: ").append(this.deleted).append("\n");
        sb.append("Modified: ").append(this.modified);
        return sb.toString();
    }
}

