/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import org.geotools.data.DataSourceException;

class RevisionInfo {
    long revision;
    String version;

    public RevisionInfo() {
        this.revision = Long.MAX_VALUE;
    }

    public RevisionInfo(long revision) {
        this.revision = revision;
    }

    public RevisionInfo(String version) throws IOException {
        this.version = version;
        if (version == null || version.trim().equals("") || version.trim().equals("CURRENT") || version.trim().equals("LAST")) {
            this.revision = Long.MAX_VALUE;
            this.version = "LAST";
        } else if (version.trim().equals("FIRST")) {
            this.revision = 1L;
            this.version = "FIRST";
        } else {
            try {
                this.revision = Long.parseLong(version);
            }
            catch (NumberFormatException e) {
                throw new DataSourceException("Unsupported revision format '" + version + "'", (Throwable)e);
            }
        }
    }

    public boolean isLast() {
        return this.revision == Long.MAX_VALUE;
    }

    public boolean isFirst() {
        return this.revision == 1L;
    }

    public String getCanonicalVersion() {
        if (this.isLast()) {
            return "LAST";
        }
        if (this.isFirst()) {
            return "FIRST";
        }
        return String.valueOf(this.revision);
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.getCanonicalVersion();
    }
}

