/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.sql.Statement;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.postgis.AbstractPostgisOnlineTestCase;
import org.geotools.data.postgis.fidmapper.PostgisFIDMapperFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class PostgisFeatureReaderOnlineTest
extends AbstractPostgisOnlineTestCase {
    protected void createTables(Statement st) throws Exception {
        this.createTable1(st);
        this.createTable2(st);
        this.createTable3(st);
        st.execute("SELECT setval('tmp_pgtest1_fid_seq', 2000000000);");
        st.execute("SELECT setval('tmp_pgtest3_fid_seq', 6000000000);");
        String[] keys = new String[]{"name", "the_geom"};
        String[] values = new String[]{"'f1'", "GeomFromText('POINT(1294523.17592358 469418.897140173)',4326)"};
        this.addFeatureManual("tmp_pgtest1", keys, values);
        values[0] = "'f2'";
        values[1] = "GeomFromText('POINT(1281485.7108 459444.7332)',4326)";
        this.addFeatureManual("tmp_pgtest2", keys, values);
        values[0] = "'f3'";
        values[1] = "GeomFromText('POINT(1271185.71084336 454376.774827237)',4326)";
        this.addFeatureManual("tmp_pgtest3", keys, values);
    }

    protected void setupGeometryColumns(Statement st) throws Exception {
        String preSql = "INSERT INTO geometry_columns (f_table_catalog, f_table_schema, f_table_name, f_geometry_column, coord_dimension, srid, type) VALUES ('',";
        String postSql = ", 'the_geom', 2, 4326, 'POINT')";
        String sql = preSql + "'', '" + "tmp_pgtest2" + "'" + postSql;
        st.execute(sql);
        sql = preSql + "'public', '" + "tmp_pgtest3" + "'" + postSql;
        st.execute(sql);
    }

    public void testReadFid() throws Exception {
        if (((PostgisFIDMapperFactory)this.ds.getFIDMapperFactory()).isReturningTypedFIDMapper()) {
            PostgisFeatureReaderOnlineTest.assertEquals((String)"tmp_pgtest1.2000000001", (String)this.attemptRead("tmp_pgtest1"));
            PostgisFeatureReaderOnlineTest.assertEquals((String)"tmp_pgtest3.6000000001", (String)this.attemptRead("tmp_pgtest3"));
        } else {
            PostgisFeatureReaderOnlineTest.assertEquals((String)"2000000001", (String)this.attemptRead("tmp_pgtest1"));
            PostgisFeatureReaderOnlineTest.assertEquals((String)"6000000001", (String)this.attemptRead("tmp_pgtest3"));
        }
    }

    protected boolean addFeature(String table) throws Exception {
        SimpleFeature feature;
        FeatureWriter writer = this.ds.getFeatureWriter(table, Transaction.AUTO_COMMIT);
        while (writer.hasNext()) {
            feature = (SimpleFeature)writer.next();
        }
        feature = (SimpleFeature)writer.next();
        feature.setAttribute(0, (Object)"test");
        writer.write();
        String id = feature.getID();
        return id != null;
    }

    protected void addFeatureManual(String table, String[] keys, String[] values) throws Exception {
        int i;
        Statement st = this.ds.getDataSource().getConnection().createStatement();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO \"");
        sql.append(table);
        sql.append("\" (");
        for (i = 0; i < keys.length; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(keys[i]);
        }
        sql.append(") VALUES (");
        for (i = 0; i < values.length; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(values[i]);
        }
        sql.append(")");
        st.execute(sql.toString());
        st.close();
    }

    protected String attemptRead(String table) throws Exception {
        DefaultQuery query = new DefaultQuery(table);
        FeatureReader fr = this.ds.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        PostgisFeatureReaderOnlineTest.assertTrue((boolean)fr.hasNext());
        SimpleFeature feature = (SimpleFeature)fr.next();
        String id = feature.getID();
        fr.close();
        return id;
    }

    public void testGetSchema() throws Exception {
        SimpleFeatureType schema = this.ds.getSchema("tmp_pgtest1");
        PostgisFeatureReaderOnlineTest.assertNotNull((Object)schema);
        schema = this.ds.getSchema("tmp_pgtest2");
        PostgisFeatureReaderOnlineTest.assertNotNull((Object)schema);
        schema = this.ds.getSchema("tmp_pgtest3");
        PostgisFeatureReaderOnlineTest.assertNotNull((Object)schema);
    }
}

