/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.geotools.data.DataStore;
import org.geotools.data.DataTestCase;
import org.geotools.data.jdbc.datasource.ManageableDataSource;
import org.geotools.data.jdbc.fidmapper.BasicFIDMapper;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.jdbc.fidmapper.TypedFIDMapper;
import org.geotools.data.postgis.PostgisDataStore;
import org.geotools.data.postgis.PostgisDataStoreFactory;
import org.geotools.data.postgis.PostgisTests;
import org.opengis.feature.simple.SimpleFeature;

public class AbstractPostgisDataTestCase
extends DataTestCase {
    static boolean WKB_ENABLED = true;
    static boolean CHECK_TYPE = false;
    protected PostgisTests.Fixture f;
    protected ManageableDataSource pool;
    protected DataStore data;

    public AbstractPostgisDataTestCase(String name) {
        super(name);
    }

    public String getFixtureFile() {
        return "fixture.properties";
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.f = PostgisTests.newFixture(this.getFixtureFile());
        this.pool = PostgisDataStoreFactory.getDefaultDataSource((String)this.f.host, (String)this.f.user, (String)this.f.password, (int)this.f.port, (String)this.f.database, (int)10, (int)2, (boolean)false);
        this.setupDbTables();
        if (CHECK_TYPE) {
            this.checkTypesInDataBase();
            CHECK_TYPE = false;
        }
        this.data = this.newDataStore();
    }

    protected void setupDbTables() throws Exception {
        this.setUpRoadTable();
        this.setUpRiverTable();
        this.setUpLakeTable();
    }

    protected DataStore newDataStore() throws IOException {
        PostgisDataStore pg = new PostgisDataStore((DataSource)this.pool, this.f.schema, this.getName(), 1);
        pg.setWKBEnabled(WKB_ENABLED);
        pg.setEstimatedExtent(true);
        pg.setFIDMapper("road", (FIDMapper)new TypedFIDMapper((FIDMapper)new BasicFIDMapper("fid", 255, false), "road"));
        pg.setFIDMapper("river", (FIDMapper)new TypedFIDMapper((FIDMapper)new BasicFIDMapper("fid", 255, false), "river"));
        pg.setFIDMapper("testset", (FIDMapper)new TypedFIDMapper((FIDMapper)new BasicFIDMapper("gid", 255, true), "testset"));
        return pg;
    }

    protected void tearDown() throws Exception {
        this.data.dispose();
        this.data = null;
        super.tearDown();
    }

    protected void checkTypesInDataBase() throws SQLException {
        Connection conn = this.pool.getConnection();
        try {
            DatabaseMetaData md = conn.getMetaData();
            ResultSet rs = md.getTables(null, "public", "%", new String[]{"TABLE"});
            ResultSetMetaData rsmd = rs.getMetaData();
            int NUM = rsmd.getColumnCount();
            System.out.print(" ");
            int i = 1;
            while (i <= NUM) {
                System.out.print(rsmd.getColumnName(i));
                System.out.flush();
                System.out.print(":");
                System.out.flush();
                System.out.print(rsmd.getColumnClassName(i));
                System.out.flush();
                if (i < NUM) {
                    System.out.print(",");
                    System.out.flush();
                }
                ++i;
            }
            System.out.println();
            while (rs.next()) {
                System.out.print(rs.getRow());
                System.out.print(":");
                System.out.flush();
                i = 1;
                while (i <= NUM) {
                    System.out.print(rsmd.getColumnName(i));
                    System.out.flush();
                    System.out.print("=");
                    System.out.flush();
                    System.out.print(rs.getString(i));
                    System.out.flush();
                    if (i < NUM) {
                        System.out.print(",");
                        System.out.flush();
                    }
                    ++i;
                }
                System.out.println();
            }
        }
        finally {
            conn.close();
        }
    }

    protected void setUpRoadTable() throws Exception {
        Statement s2;
        Connection conn = this.pool.getConnection();
        conn.setAutoCommit(true);
        try {
            s2 = conn.createStatement();
            s2.execute("SELECT dropgeometrycolumn( '" + this.f.schema + "','road','geom')");
        }
        catch (Exception s2) {
            // empty catch block
        }
        try {
            s2 = conn.createStatement();
            s2.execute("DROP TABLE " + this.f.schema + ".road CASCADE");
        }
        catch (Exception s3) {
            // empty catch block
        }
        try {
            s2 = conn.createStatement();
            s2.execute("CREATE TABLE " + this.f.schema + ".road (fid varchar PRIMARY KEY, id int )");
            s2.execute("SELECT AddGeometryColumn('" + this.f.schema + "', 'road', 'geom', 4326, 'LINESTRING', 2);");
            s2.execute("ALTER TABLE " + this.f.schema + ".road add name varchar;");
            int i = 0;
            while (i < this.roadFeatures.length) {
                SimpleFeature feature = this.roadFeatures[i];
                String fid = feature.getID().substring("road.".length());
                String ql = "INSERT INTO " + this.f.schema + ".road (fid,id,geom,name) VALUES (" + "'" + fid + "'," + feature.getAttribute("id") + "," + "GeometryFromText('" + ((Geometry)feature.getAttribute("geom")).toText() + "', 4326 )," + "'" + feature.getAttribute("name") + "')";
                s2.execute(ql);
                ++i;
            }
            s2.execute("VACUUM ANALYZE " + this.f.schema + ".road");
        }
        finally {
            conn.close();
        }
    }

    protected void setUpLakeTable() throws Exception {
        Statement s2;
        Connection conn = this.pool.getConnection();
        conn.setAutoCommit(true);
        try {
            s2 = conn.createStatement();
            s2.execute("SELECT dropgeometrycolumn( '" + this.f.schema + "','lake','geom')");
        }
        catch (Exception s2) {
            // empty catch block
        }
        try {
            s2 = conn.createStatement();
            s2.execute("DROP TABLE " + this.f.schema + ".lake CASCADE");
        }
        catch (Exception s3) {
            // empty catch block
        }
        try {
            s2 = conn.createStatement();
            s2.execute("CREATE TABLE " + this.f.schema + ".lake ( id int ) WITH OIDS");
            s2.execute("SELECT AddGeometryColumn('" + this.f.schema + "', 'lake', 'geom', 4326, 'POLYGON', 2);");
            s2.execute("ALTER TABLE " + this.f.schema + ".lake add name varchar;");
            int i = 0;
            while (i < this.lakeFeatures.length) {
                SimpleFeature feature = this.lakeFeatures[i];
                String ql = "INSERT INTO " + this.f.schema + ".lake (id,geom,name) VALUES (" + feature.getAttribute("id") + "," + "GeometryFromText('" + ((Geometry)feature.getAttribute("geom")).toText() + "', 4326 )," + "'" + feature.getAttribute("name") + "')";
                s2.execute(ql);
                ++i;
            }
            s2.execute("VACUUM ANALYZE " + this.f.schema + ".lake");
        }
        finally {
            conn.close();
        }
    }

    protected void killTestTables() throws Exception {
        Connection conn = this.pool.getConnection();
        try {
            Statement s = conn.createStatement();
            try {
                s.execute("SELECT dropgeometrycolumn( '" + this.f.schema + "','road','geom')");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s.execute("SELECT dropgeometrycolumn( '" + this.f.schema + "','river','geom')");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s.execute("SELECT dropgeometrycolumn( '" + this.f.schema + "','lake','geom')");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s.execute("DROP TABLE " + this.f.schema + ".road");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s.execute("DROP TABLE " + this.f.schema + ".river");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s.execute("DROP TABLE " + this.f.schema + ".lake");
            }
            catch (Exception exception) {}
        }
        finally {
            conn.close();
        }
    }

    protected void setUpRiverTable() throws Exception {
        Statement s2;
        Connection conn = this.pool.getConnection();
        try {
            s2 = conn.createStatement();
            s2.execute("SELECT dropgeometrycolumn( '" + this.f.schema + "','river','geom')");
        }
        catch (Exception s2) {
            // empty catch block
        }
        try {
            s2 = conn.createStatement();
            s2.execute("DROP TABLE " + this.f.schema + ".river CASCADE");
        }
        catch (Exception s3) {
            // empty catch block
        }
        try {
            s2 = conn.createStatement();
            s2.execute("CREATE TABLE " + this.f.schema + ".river(fid varchar PRIMARY KEY, id int)");
            s2.execute("SELECT AddGeometryColumn('" + this.f.schema + "', 'river', 'geom', 4326, 'MULTILINESTRING', 2);");
            s2.execute("ALTER TABLE " + this.f.schema + ".river add river varchar");
            s2.execute("ALTER TABLE " + this.f.schema + ".river add flow float8");
            int i = 0;
            while (i < this.riverFeatures.length) {
                SimpleFeature feature = this.riverFeatures[i];
                String fid = feature.getID().substring("river.".length());
                s2.execute("INSERT INTO " + this.f.schema + ".river (fid, id, geom, river, flow) VALUES (" + "'" + fid + "'," + feature.getAttribute("id") + "," + "GeometryFromText('" + feature.getAttribute("geom").toString() + "', 4326 )," + "'" + feature.getAttribute("river") + "'," + feature.getAttribute("flow") + ")");
                ++i;
            }
            s2.execute("VACUUM ANALYZE " + this.f.schema + ".river");
        }
        finally {
            conn.close();
        }
    }
}

