/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.geotools.data.postgis.PostgisDataStore;
import org.geotools.data.postgis.PostgisOnlineTestCase;

public class AbstractPostgisOnlineTestCase
extends PostgisOnlineTestCase {
    public static final String TEST_SCHEMA = "gt_test";
    protected PostgisDataStore ds;
    protected final String table1 = "tmp_pgtest1";
    protected final String table2 = "tmp_pgtest2";
    protected final String table3 = "tmp_pgtest3";
    protected final String table4 = "tmp_pgtest4";
    protected final String table5 = "tmp_pgtest 5";
    protected final String table6 = "tmp_pgtest 6";
    protected final String table7 = "tmp_pgtest_7";
    protected final String table8 = "tmp_pgtest_8";

    protected void connect() throws Exception {
        super.connect();
        this.ds = (PostgisDataStore)this.dataStore;
        Statement st = this.getConnection().createStatement();
        this.dropTables(st);
        this.purgeGeometryColumns(st);
        this.createTables(st);
        this.setupGeometryColumns(st);
        st.close();
    }

    protected void disconnect() throws Exception {
        Statement st = this.getConnection().createStatement();
        this.purgeGeometryColumns(st);
        this.dropTables(st);
        st.close();
        super.disconnect();
    }

    public Connection getConnection() throws Exception {
        return this.ds.getDataSource().getConnection();
    }

    protected void setupGeometryColumns(Statement st) throws Exception {
        String preSql = "INSERT INTO geometry_columns (f_table_catalog, f_table_schema, f_table_name, f_geometry_column, coord_dimension, srid, type) VALUES ('',";
        String postSql = ", 'the_geom', 2, 4326, 'POINT')";
        String sql = String.valueOf(preSql) + "'public', '" + "tmp_pgtest1" + "'" + postSql;
        st.execute(sql);
        sql = String.valueOf(preSql) + "'public', '" + "tmp_pgtest2" + "'" + postSql;
        st.execute(sql);
        sql = String.valueOf(preSql) + "'public', '" + "tmp_pgtest3" + "'" + postSql;
        st.execute(sql);
        sql = String.valueOf(preSql) + "'" + TEST_SCHEMA + "', '" + "tmp_pgtest_7" + "'" + postSql;
        st.execute(sql);
        sql = String.valueOf(preSql) + "'public', '" + "tmp_pgtest_8" + "'" + postSql;
        st.execute(sql);
    }

    protected void purgeGeometryColumns(Statement st) throws Exception {
        String sql = "DELETE FROM geometry_columns WHERE f_table_name LIKE 'tmp_pgtest%'";
        st.execute(sql);
    }

    protected void createTables(Statement st) throws Exception {
        this.createTable1(st);
        this.createTable2(st);
        this.createTable3(st);
        this.createTable4(st);
        this.createTable5(st);
        this.createTable6(st);
        this.createTestSchema(st);
        this.createTable7(st);
        this.createTable8(st);
    }

    protected void createTestSchema(Statement st) throws Exception {
        String sql = "CREATE SCHEMA gt_test";
        st.execute(sql);
    }

    protected void createTable1(Statement st) throws Exception {
        String sql = "CREATE TABLE tmp_pgtest1(fid serial NOT NULL,name varchar(10), the_geom geometry, CONSTRAINT tmp_pgtest1_pkey PRIMARY KEY (fid)) WITH OIDS;";
        st.execute(sql);
    }

    protected void createTable2(Statement st) throws Exception {
        String sql = "CREATE SEQUENCE tmp_pgtest2_fid_seq INCREMENT 1 MINVALUE 1 MAXVALUE 9223372036854775807 START 1001 CACHE 1;CREATE TABLE tmp_pgtest2(fid int4 NOT NULL DEFAULT nextval('tmp_pgtest2_fid_seq'::text), name varchar(10), the_geom geometry, CONSTRAINT tmp_pgtest2_pkey PRIMARY KEY (fid)) WITH OIDS;";
        st.execute(sql);
    }

    protected void createTable3(Statement st) throws Exception {
        String sql = "CREATE TABLE tmp_pgtest3(fid bigserial NOT NULL, name varchar(10), the_geom geometry, CONSTRAINT tmp_pgtest3_pkey PRIMARY KEY (fid)) WITH OIDS;";
        st.execute(sql);
    }

    protected void createTable4(Statement st) throws Exception {
        String sql = "CREATE SEQUENCE tmp_pgtest4_fid_seq INCREMENT 1 MINVALUE 1 MAXVALUE 9223372036854775807 START 1000001 CACHE 1;CREATE TABLE tmp_pgtest4(fid int8 NOT NULL DEFAULT nextval('tmp_pgtest4_fid_seq'::text),name varchar(10),CONSTRAINT tmp_pgtest4_pkey PRIMARY KEY (fid)) WITH OIDS;";
        st.execute(sql);
    }

    protected void createTable5(Statement st) throws Exception {
        String sql = "CREATE TABLE \"tmp_pgtest 5\" (fid serial NOT NULL,name varchar(10),CONSTRAINT \"tmp_pgtest 5_pkey\" PRIMARY KEY (fid)) WITHOUT OIDS;";
        st.execute(sql);
    }

    protected void createTable6(Statement st) throws Exception {
        String sql = "CREATE SEQUENCE \"tmp_pgtest 6_fid_seq\" INCREMENT 1 MINVALUE 1 MAXVALUE 9223372036854775807 START 1001 CACHE 1;CREATE TABLE \"tmp_pgtest 6\" (fid int4 NOT NULL DEFAULT nextval('\"tmp_pgtest 6_fid_seq\"'::text),name varchar(10),CONSTRAINT \"tmp_pgtest 6_pkey\" PRIMARY KEY (fid)) WITHOUT OIDS;";
        st.execute(sql);
    }

    protected void createTable7(Statement st) throws Exception {
        String sql = "CREATE TABLE gt_test.tmp_pgtest_7(fid serial NOT NULL,name varchar(10), the_geom geometry, CONSTRAINT tmp_pgtest_7_pkey PRIMARY KEY (fid)) WITH OIDS;";
        st.execute(sql);
    }

    protected void createTable8(Statement st) throws Exception {
        String sql = "CREATE TABLE tmp_pgtest_8(name varchar(10), the_geom geometry) WITHOUT OIDS;";
        st.execute(sql);
    }

    protected void dropTables(Statement st) throws Exception {
        this.dropTable(st, "tmp_pgtest1");
        this.dropTable(st, "tmp_pgtest2");
        this.dropSequence(st, "tmp_pgtest2_fid_seq");
        this.dropTable(st, "tmp_pgtest3");
        this.dropTable(st, "tmp_pgtest4");
        this.dropSequence(st, "tmp_pgtest4_fid_seq");
        this.dropTable(st, "tmp_pgtest 5");
        this.dropTable(st, "tmp_pgtest 6");
        this.dropSequence(st, "tmp_pgtest 6_fid_seq");
        this.dropTable(st, "tmp_pgtest_7");
        this.dropTable(st, "tmp_pgtest_8");
        this.dropSequence(st, "gt_test.tmp_pgtest_7_fid_seq");
        this.dropSchema(st, TEST_SCHEMA);
    }

    protected void dropTable(Statement st, String tableName) throws Exception {
        String sql = "SELECT schemaname, tablename FROM pg_tables WHERE tablename = '" + tableName + "'";
        ResultSet rs = st.executeQuery(sql);
        boolean exists = rs.next();
        String schemaName = "public";
        if (exists) {
            schemaName = rs.getString(1);
        }
        rs.close();
        if (exists) {
            sql = "DROP TABLE \"" + schemaName + "\".\"" + tableName + "\"";
            st.execute(sql);
        }
    }

    protected void dropSequence(Statement st, String sequenceName) throws Exception {
        String sql = "SELECT COUNT(relid) FROM pg_statio_all_sequences WHERE relname = '" + sequenceName + "'";
        ResultSet rs = st.executeQuery(sql);
        rs.next();
        int exists = rs.getInt(1);
        rs.close();
        if (exists > 0) {
            sql = "DROP SEQUENCE \"" + sequenceName + "\"";
            st.execute(sql);
        }
    }

    protected String getFixtureId() {
        return "postgis.typical";
    }

    protected void dropSchema(Statement st, String schemaName) throws Exception {
        String sql = "SELECT nspname FROM pg_namespace WHERE nspname = '" + schemaName + "'";
        ResultSet rs = st.executeQuery(sql);
        boolean exists = rs.next();
        rs.close();
        if (exists) {
            sql = "DROP SCHEMA " + schemaName;
            st.execute(sql);
        }
    }
}

