/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.awt.RenderingHints;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockException;
import org.geotools.data.FeatureLockFactory;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.jdbc.fidmapper.TypedFIDMapper;
import org.geotools.data.postgis.AbstractPostgisDataTestCase;
import org.geotools.data.postgis.PostgisDataStore;
import org.geotools.data.postgis.fidmapper.OIDFidMapper;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.function.FilterFunction_geometryType;
import org.geotools.filter.function.math.FilterFunction_ceil;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgisDataStoreAPIOnlineTest
extends AbstractPostgisDataTestCase {
    private static final int LOCK_DURATION = 3600000;
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.postgis");
    String victim = null;

    public PostgisDataStoreAPIOnlineTest(String test) {
        super(test);
        if (this.victim != null && !test.equals(this.victim)) {
            throw new AssertionError((Object)("test supressed " + test));
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRoadFeaturesFixture() throws Exception {
        Connection conn = this.pool.getConnection();
        FeatureReader reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), Transaction.AUTO_COMMIT);
        ReferencedEnvelope bounds = new ReferencedEnvelope();
        try {
            while (reader.hasNext()) {
                SimpleFeature f = (SimpleFeature)reader.next();
                int index = (Integer)f.getAttribute("id") - 1;
                this.roadFeatures[index] = f;
                bounds.include(f.getBounds());
            }
        }
        finally {
            reader.close();
            conn.close();
        }
        if (!this.roadBounds.equals((Object)bounds)) {
            System.out.println("warning! Database changed bounds()");
            System.out.println("was:" + this.roadBounds);
            System.out.println("now:" + bounds);
            this.roadBounds = bounds;
        }
        ReferencedEnvelope bounds12 = new ReferencedEnvelope();
        bounds12.include(this.roadFeatures[0].getBounds());
        bounds12.include(this.roadFeatures[1].getBounds());
        if (!this.rd12Bounds.equals((Object)bounds12)) {
            System.out.println("warning! Database changed bounds of rd1 & rd2");
            System.out.println("was:" + this.rd12Bounds);
            System.out.println("now:" + bounds12);
            this.rd12Bounds = bounds12;
        }
        SimpleFeatureType schema = this.roadFeatures[0].getFeatureType();
        FilterFactory factory = FilterFactoryFinder.createFilterFactory();
        CompareFilter tFilter = factory.createCompareFilter((short)14);
        LiteralExpression rd1Literal = factory.createLiteralExpression("r1");
        tFilter.addLeftValue((org.geotools.filter.Expression)rd1Literal);
        AttributeExpression rdNameAtt = factory.createAttributeExpression(schema, "name");
        tFilter.addRightValue((org.geotools.filter.Expression)rdNameAtt);
        this.rd1Filter = tFilter;
        tFilter = factory.createCompareFilter((short)14);
        LiteralExpression rd2Literal = factory.createLiteralExpression("r2");
        tFilter.addLeftValue((org.geotools.filter.Expression)rd2Literal);
        tFilter.addRightValue((org.geotools.filter.Expression)rdNameAtt);
        this.rd2Filter = tFilter;
        this.rd12Filter = this.ff.or(this.rd2Filter, this.rd1Filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRiverFeaturesFixture() throws Exception {
        Connection conn = this.pool.getConnection();
        FeatureReader reader = this.data.getFeatureReader((Query)new DefaultQuery("river", (Filter)org.geotools.filter.Filter.INCLUDE), Transaction.AUTO_COMMIT);
        ReferencedEnvelope bounds = new ReferencedEnvelope();
        try {
            while (reader.hasNext()) {
                SimpleFeature f = (SimpleFeature)reader.next();
                int index = (Integer)f.getAttribute("id") - 1;
                this.riverFeatures[index] = f;
                bounds.include(f.getBounds());
            }
        }
        finally {
            reader.close();
            conn.close();
        }
        if (!this.riverBounds.equals((Object)bounds)) {
            System.out.println("warning! Database changed bounds of river");
            System.out.println("was:" + this.riverBounds);
            System.out.println("now:" + bounds);
            this.riverBounds = bounds;
        }
        FilterFactory factory = FilterFactoryFinder.createFilterFactory();
        CompareFilter tFilter = factory.createCompareFilter((short)14);
        LiteralExpression rvLiteral = factory.createLiteralExpression("rv1");
        tFilter.addLeftValue((org.geotools.filter.Expression)rvLiteral);
        SimpleFeatureType schema = this.riverFeatures[0].getFeatureType();
        AttributeExpression rvNameAtt = factory.createAttributeExpression(schema, "river");
        tFilter.addRightValue((org.geotools.filter.Expression)rvNameAtt);
        this.rv1Filter = tFilter;
    }

    public void testGetFeatureTypes() {
        try {
            Object[] names = this.data.getTypeNames();
            PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.contains(names, "road"));
            PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.contains(names, "river"));
        }
        catch (IOException e) {
            e.printStackTrace();
            PostgisDataStoreAPIOnlineTest.fail((String)"An IOException has been thrown!");
        }
    }

    boolean contains(Object[] array, Object expected) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(expected)) continue;
            return true;
        }
        return false;
    }

    void assertContains(Object[] array, Object expected) {
        PostgisDataStoreAPIOnlineTest.assertFalse((array == null ? 1 : 0) != 0);
        PostgisDataStoreAPIOnlineTest.assertFalse((array.length == 0 ? 1 : 0) != 0);
        PostgisDataStoreAPIOnlineTest.assertNotNull((Object)expected);
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(expected)) continue;
            return;
        }
        PostgisDataStoreAPIOnlineTest.fail((String)("Contains " + expected));
    }

    boolean containsLax(SimpleFeature[] array, SimpleFeature expected) {
        if (array == null || array.length == 0) {
            return false;
        }
        SimpleFeatureType type = expected.getFeatureType();
        for (int i = 0; i < array.length; ++i) {
            if (!this.match(array[i], expected)) continue;
            return true;
        }
        return false;
    }

    boolean match(SimpleFeature expected, SimpleFeature actual) {
        SimpleFeatureType type = expected.getFeatureType();
        for (int i = 0; i < type.getAttributeCount(); ++i) {
            Geometry eg;
            Geometry ag;
            Object av = actual.getAttribute(i);
            Object ev = expected.getAttribute(i);
            if (av == null && ev != null) {
                return false;
            }
            if (ev == null && av != null) {
                return false;
            }
            if (!(av instanceof Geometry && ev instanceof Geometry ? !(ag = (Geometry)av).equals(eg = (Geometry)ev) : !av.equals(ev))) continue;
            return false;
        }
        return true;
    }

    public void testGetSchemaRoad() throws IOException {
        SimpleFeatureType expected = this.roadType;
        SimpleFeatureType actual = this.data.getSchema("road");
        PostgisDataStoreAPIOnlineTest.assertEquals((String)"name", (Object)expected.getName(), (Object)actual.getName());
        PostgisDataStoreAPIOnlineTest.assertEquals((String)"attributeCount", (int)expected.getAttributeCount(), (int)actual.getAttributeCount());
        for (int i = 0; i < expected.getAttributeCount(); ++i) {
            AttributeDescriptor expectedAttribute = expected.getDescriptor(i);
            AttributeDescriptor actualAttribute = actual.getDescriptor(i);
            PostgisDataStoreAPIOnlineTest.assertEquals((String)("attribute " + expectedAttribute.getLocalName()), (Object)expectedAttribute, (Object)actualAttribute);
        }
        GeometryDescriptor dg = actual.getGeometryDescriptor();
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)dg.isNillable());
        PostgisDataStoreAPIOnlineTest.assertEquals((int)0, (int)dg.getMinOccurs());
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)expected, (Object)actual);
    }

    public void testGetSchemaRoadUnregisteredGeomColumn() throws Exception {
        Connection conn = this.pool.getConnection();
        conn.setAutoCommit(true);
        Statement st = conn.createStatement();
        int deleted = st.executeUpdate("DELETE FROM geometry_columns WHERE f_table_name = 'road' and f_table_schema = '" + this.f.schema + "'");
        PostgisDataStoreAPIOnlineTest.assertEquals((int)1, (int)deleted);
        this.testGetSchemaRoad();
    }

    public void testGetSchemaRiver() throws IOException {
        SimpleFeatureType expected = this.riverType;
        SimpleFeatureType actual = this.data.getSchema("river");
        PostgisDataStoreAPIOnlineTest.assertEquals((String)"name", (Object)expected.getName(), (Object)actual.getName());
        PostgisDataStoreAPIOnlineTest.assertEquals((String)"attributeCount", (int)expected.getAttributeCount(), (int)actual.getAttributeCount());
        for (int i = 0; i < expected.getAttributeCount(); ++i) {
            AttributeDescriptor expectedAttribute = expected.getDescriptor(i);
            AttributeDescriptor actualAttribute = actual.getDescriptor(i);
            PostgisDataStoreAPIOnlineTest.assertEquals((String)("attribute " + expectedAttribute.getLocalName()), (Object)expectedAttribute, (Object)actualAttribute);
        }
        GeometryDescriptor dg = actual.getGeometryDescriptor();
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)dg.isNillable());
        PostgisDataStoreAPIOnlineTest.assertEquals((int)0, (int)dg.getMinOccurs());
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)expected, (Object)actual);
    }

    public void testCreateSchema() throws Exception {
        String featureTypeName = "stuff";
        try {
            Connection conn = this.pool.getConnection();
            conn.setAutoCommit(true);
            Statement st = conn.createStatement();
            String sql = "DROP TABLE " + featureTypeName + ";";
            st.execute(sql);
            conn.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName(featureTypeName);
        ftb.add("id", Integer.class);
        ftb.add("name", String.class);
        ftb.add("the_geom", Point.class, crs);
        ftb.add("long", Long.class);
        SimpleFeatureType newFT = ftb.buildFeatureType();
        this.data.createSchema((FeatureType)newFT);
        SimpleFeatureType newSchema = this.data.getSchema(featureTypeName);
        PostgisDataStoreAPIOnlineTest.assertNotNull((Object)newSchema);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)4, (int)newSchema.getAttributeCount());
        PostgisDataStoreAPIOnlineTest.assertEquals(Integer.class, (Object)newSchema.getDescriptor("id").getType().getBinding());
        PostgisDataStoreAPIOnlineTest.assertEquals(String.class, (Object)newSchema.getDescriptor("name").getType().getBinding());
        PostgisDataStoreAPIOnlineTest.assertEquals(Long.class, (Object)newSchema.getDescriptor("long").getType().getBinding());
    }

    public static void assertEquals(String message, String expected, String actual) {
        if (expected == actual) {
            return;
        }
        PostgisDataStoreAPIOnlineTest.assertNotNull((String)message, (Object)expected);
        PostgisDataStoreAPIOnlineTest.assertNotNull((String)message, (Object)actual);
        if (!expected.equals(actual)) {
            PostgisDataStoreAPIOnlineTest.fail((String)(message + " expected:<" + expected + "> but was <" + actual + ">"));
        }
    }

    void assertCovers(String msg, SimpleFeatureCollection c1, SimpleFeatureCollection c2) {
        if (c1 == c2) {
            return;
        }
        PostgisDataStoreAPIOnlineTest.assertNotNull((String)msg, (Object)c1);
        PostgisDataStoreAPIOnlineTest.assertNotNull((String)msg, (Object)c2);
        PostgisDataStoreAPIOnlineTest.assertEquals((String)(msg + " size"), (int)c1.size(), (int)c2.size());
        SimpleFeatureIterator i = c1.features();
        while (i.hasNext()) {
            SimpleFeature f = (SimpleFeature)i.next();
            PostgisDataStoreAPIOnlineTest.assertTrue((String)(msg + " " + f.getID()), (boolean)c2.contains((Object)f));
        }
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> reader(String typeName) throws IOException {
        return this.data.getFeatureReader((Query)new DefaultQuery(typeName, (Filter)org.geotools.filter.Filter.INCLUDE), Transaction.AUTO_COMMIT);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> writer(String typeName) throws IOException {
        return this.data.getFeatureWriter(typeName, Transaction.AUTO_COMMIT);
    }

    public void testGetFeatureReader() throws IOException, IllegalAttributeException {
        this.assertCovered(this.roadFeatures, this.reader("road"));
        PostgisDataStoreAPIOnlineTest.assertEquals((int)3, (int)this.count(this.reader("road")));
    }

    public void testGeometryFactoryHintsGF() throws IOException {
        SimpleFeatureSource fs = this.data.getFeatureSource("road");
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)fs.getSupportedHints().contains(Hints.JTS_GEOMETRY_FACTORY));
        DefaultQuery q = new DefaultQuery("road");
        GeometryFactory gf = new GeometryFactory((CoordinateSequenceFactory)new LiteCoordinateSequenceFactory());
        Hints hints = new Hints((RenderingHints.Key)Hints.JTS_GEOMETRY_FACTORY, (Object)gf);
        q.setHints(hints);
        SimpleFeatureIterator it = fs.getFeatures((Query)q).features();
        SimpleFeature f = (SimpleFeature)it.next();
        it.close();
        LineString ls = (LineString)f.getDefaultGeometry();
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)(ls.getCoordinateSequence() instanceof LiteCoordinateSequence));
    }

    public void testGeometryFactoryHintsCS() throws IOException {
        SimpleFeatureSource fs = this.data.getFeatureSource("road");
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)fs.getSupportedHints().contains(Hints.JTS_COORDINATE_SEQUENCE_FACTORY));
        DefaultQuery q = new DefaultQuery("road");
        Hints hints = new Hints((RenderingHints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)new LiteCoordinateSequenceFactory());
        q.setHints(hints);
        SimpleFeatureIterator it = fs.getFeatures((Query)q).features();
        SimpleFeature f = (SimpleFeature)it.next();
        it.close();
        LineString ls = (LineString)f.getDefaultGeometry();
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)(ls.getCoordinateSequence() instanceof LiteCoordinateSequence));
    }

    public void testGetFeatureReaderFilterPrePost() throws IOException, IllegalFilterException {
        DefaultTransaction t = new DefaultTransaction();
        FilterFactory factory = FilterFactoryFinder.createFilterFactory();
        FilterFunction_geometryType geomTypeExpr = new FilterFunction_geometryType();
        geomTypeExpr.setArgs(new org.geotools.filter.Expression[]{factory.createAttributeExpression("geom")});
        CompareFilter filter = factory.createCompareFilter((short)14);
        filter.addLeftValue((org.geotools.filter.Expression)geomTypeExpr);
        filter.addRightValue((org.geotools.filter.Expression)factory.createLiteralExpression("Polygon"));
        FeatureReader reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)filter), (Transaction)t);
        PostgisDataStoreAPIOnlineTest.assertNotNull((Object)reader);
        reader.close();
        t.close();
    }

    public void testGetFeatureReaderFilterPrePost2() throws IOException, IllegalFilterException {
        DefaultTransaction t = new DefaultTransaction();
        FilterFactory factory = FilterFactoryFinder.createFilterFactory();
        FilterFunction_geometryType geomTypeExpr = new FilterFunction_geometryType();
        geomTypeExpr.setArgs(new org.geotools.filter.Expression[]{factory.createAttributeExpression("geom")});
        CompareFilter filter = factory.createCompareFilter((short)14);
        filter.addLeftValue((org.geotools.filter.Expression)geomTypeExpr);
        filter.addRightValue((org.geotools.filter.Expression)factory.createLiteralExpression("Polygon"));
        FeatureReader reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)filter), (Transaction)t);
        PostgisDataStoreAPIOnlineTest.assertNotNull((Object)reader);
        reader.close();
        t.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetFeatureReaderWipesOutInvalidFilterFids() throws IOException, IllegalFilterException {
        String fid3;
        String fid2;
        String fid1;
        FeatureReader reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), Transaction.AUTO_COMMIT);
        try {
            fid1 = ((SimpleFeature)reader.next()).getID();
            fid2 = ((SimpleFeature)reader.next()).getID();
            fid3 = ((SimpleFeature)reader.next()).getID();
        }
        finally {
            reader.close();
        }
        FilterFactory2 factory = CommonFactoryFinder.getFilterFactory2(null);
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        ids.add(factory.featureId(fid1));
        ids.add(factory.featureId(fid2));
        ids.add(factory.featureId("_" + fid3));
        Id filter = factory.id(ids);
        DefaultTransaction t = new DefaultTransaction();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)filter), (Transaction)t);
        PostgisDataStoreAPIOnlineTest.assertNotNull((Object)reader);
        try {
            HashSet<String> expected = new HashSet<String>();
            expected.add(fid1);
            expected.add(fid2);
            HashSet<String> returned = new HashSet<String>();
            PostgisDataStoreAPIOnlineTest.assertTrue((boolean)reader.hasNext());
            returned.add(((SimpleFeature)reader.next()).getID());
            PostgisDataStoreAPIOnlineTest.assertTrue((boolean)reader.hasNext());
            returned.add(((SimpleFeature)reader.next()).getID());
            PostgisDataStoreAPIOnlineTest.assertFalse((String)"expected only 2 features", (boolean)reader.hasNext());
            PostgisDataStoreAPIOnlineTest.assertEquals(expected, returned);
        }
        finally {
            reader.close();
            t.close();
        }
    }

    public void testCaseInsensitiveFilter() throws Exception {
        String riverName = this.riverType.getName().getLocalPart();
        SimpleFeatureSource rivers = this.data.getFeatureSource(riverName);
        PropertyIsEqualTo caseSensitive = this.ff.equal((Expression)this.ff.property("river"), (Expression)this.ff.literal((Object)"Rv1"), true);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)0, (int)rivers.getCount((Query)new DefaultQuery(riverName, (Filter)caseSensitive)));
        PropertyIsEqualTo caseInsensitive = this.ff.equal((Expression)this.ff.property("river"), (Expression)this.ff.literal((Object)"Rv1"), false);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)1, (int)rivers.getCount((Query)new DefaultQuery(riverName, (Filter)caseInsensitive)));
    }

    public void testGetFeatureReaderRetypeBug() throws Exception {
        DefaultTransaction t = new DefaultTransaction();
        SimpleFeatureType type = this.data.getSchema("river");
        FilterFactory ff = FilterFactoryFinder.createFilterFactory();
        CompareFilter cf = ff.createCompareFilter((short)14);
        cf.addLeftValue((org.geotools.filter.Expression)ff.createAttributeExpression("flow"));
        cf.addRightValue((org.geotools.filter.Expression)ff.createLiteralExpression(4.5));
        DefaultQuery q = new DefaultQuery("river");
        q.setPropertyNames(new String[]{"geom"});
        q.setFilter((Filter)cf);
        FeatureReader reader = this.data.getFeatureReader((Query)q, (Transaction)t);
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)reader.hasNext());
        PostgisDataStoreAPIOnlineTest.assertEquals((int)1, (int)((SimpleFeatureType)reader.getFeatureType()).getAttributeCount());
        reader.next();
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)reader.hasNext());
        reader.close();
        t.close();
    }

    public void testGetFeatureReaderRetypeBug2() throws Exception {
        DefaultTransaction t = new DefaultTransaction();
        SimpleFeatureType type = this.data.getSchema("river");
        FilterFactory ff = FilterFactoryFinder.createFilterFactory();
        CompareFilter cf = ff.createCompareFilter((short)14);
        FilterFunction_ceil ceil = new FilterFunction_ceil();
        ceil.setArgs(new org.geotools.filter.Expression[]{ff.createAttributeExpression("flow")});
        cf.addLeftValue((org.geotools.filter.Expression)ceil);
        cf.addRightValue((org.geotools.filter.Expression)ff.createLiteralExpression(5));
        DefaultQuery q = new DefaultQuery("river");
        q.setPropertyNames(new String[]{"geom"});
        q.setFilter((Filter)cf);
        FeatureReader reader = this.data.getFeatureReader((Query)q, (Transaction)t);
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)reader.hasNext());
        PostgisDataStoreAPIOnlineTest.assertEquals((int)1, (int)((SimpleFeatureType)reader.getFeatureType()).getAttributeCount());
        reader.next();
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)reader.hasNext());
        reader.close();
        t.close();
    }

    public void testGetFeatureReaderMutability() throws IOException, IllegalAttributeException {
        SimpleFeature feature;
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.reader("road");
        while (reader.hasNext()) {
            feature = (SimpleFeature)reader.next();
            feature.setAttribute("name", null);
        }
        reader.close();
        reader = this.reader("road");
        while (reader.hasNext()) {
            feature = (SimpleFeature)reader.next();
            PostgisDataStoreAPIOnlineTest.assertNotNull((Object)feature.getAttribute("name"));
        }
        reader.close();
        try {
            reader.next();
            PostgisDataStoreAPIOnlineTest.fail((String)"next should fail with an IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testGetFeatureReaderConcurrency() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureReader<SimpleFeatureType, SimpleFeature> reader1 = this.reader("road");
        FeatureReader<SimpleFeatureType, SimpleFeature> reader2 = this.reader("road");
        FeatureReader<SimpleFeatureType, SimpleFeature> reader3 = this.reader("river");
        while (reader1.hasNext() || reader2.hasNext() || reader3.hasNext()) {
            PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.contains(this.roadFeatures, reader1.next()));
            PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.contains(this.roadFeatures, reader2.next()));
            if (!reader3.hasNext()) continue;
            PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.contains(this.riverFeatures, reader3.next()));
        }
        try {
            reader1.next();
            PostgisDataStoreAPIOnlineTest.fail((String)"next should fail with an NoSuchElementException");
        }
        catch (NoSuchElementException expectedNoElement) {
            // empty catch block
        }
        try {
            reader2.next();
            PostgisDataStoreAPIOnlineTest.fail((String)"next should fail with an NoSuchElementException");
        }
        catch (NoSuchElementException expectedNoElement) {
            // empty catch block
        }
        try {
            reader3.next();
            PostgisDataStoreAPIOnlineTest.fail((String)"next should fail with an NoSuchElementException");
        }
        catch (NoSuchElementException expectedNoElement) {
            // empty catch block
        }
        reader1.close();
        reader2.close();
        reader3.close();
        try {
            reader1.next();
            PostgisDataStoreAPIOnlineTest.fail((String)"next should fail with an IOException");
        }
        catch (IOException expectedClosed) {
            // empty catch block
        }
        try {
            reader2.next();
            PostgisDataStoreAPIOnlineTest.fail((String)"next should fail with an IOException");
        }
        catch (IOException expectedClosed) {
            // empty catch block
        }
        try {
            reader3.next();
            PostgisDataStoreAPIOnlineTest.fail((String)"next should fail with an IOException");
        }
        catch (IOException expectedClosed) {
            // empty catch block
        }
    }

    public void testGetFeatureReaderFilterAutoCommit() throws NoSuchElementException, IOException, IllegalAttributeException {
        SimpleFeatureType type = this.data.getSchema("road");
        FeatureReader reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), Transaction.AUTO_COMMIT);
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)(reader instanceof FilteringFeatureReader));
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        PostgisDataStoreAPIOnlineTest.assertEquals((int)this.roadFeatures.length, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.EXCLUDE), Transaction.AUTO_COMMIT);
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)reader.hasNext());
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        PostgisDataStoreAPIOnlineTest.assertEquals((int)0, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", this.rd1Filter), Transaction.AUTO_COMMIT);
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        PostgisDataStoreAPIOnlineTest.assertEquals((int)1, (int)this.count(reader));
    }

    public void testGetFeatureReaderFilterTransaction() throws NoSuchElementException, IOException, IllegalAttributeException {
        DefaultTransaction t = new DefaultTransaction();
        SimpleFeatureType type = this.data.getSchema("road");
        FeatureReader reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.EXCLUDE), (Transaction)t);
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)reader.hasNext());
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        PostgisDataStoreAPIOnlineTest.assertEquals((int)0, (int)this.count(reader));
        reader.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), (Transaction)t);
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        PostgisDataStoreAPIOnlineTest.assertEquals((int)this.roadFeatures.length, (int)this.count(reader));
        reader.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", this.rd1Filter), (Transaction)t);
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        PostgisDataStoreAPIOnlineTest.assertEquals((int)1, (int)this.count(reader));
        reader.close();
        FeatureWriter writer = this.data.getFeatureWriter("road", (Filter)org.geotools.filter.Filter.INCLUDE, (Transaction)t);
        while (writer.hasNext()) {
            SimpleFeature feature = (SimpleFeature)writer.next();
            if (!feature.getID().equals(this.roadFeatures[0].getID())) continue;
            writer.remove();
        }
        writer.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.EXCLUDE), (Transaction)t);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)0, (int)this.count(reader));
        reader.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), (Transaction)t);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)(this.roadFeatures.length - 1), (int)this.count(reader));
        reader.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", this.rd1Filter), (Transaction)t);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)0, (int)this.count(reader));
        reader.close();
        t.rollback();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.EXCLUDE), (Transaction)t);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)0, (int)this.count(reader));
        reader.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), (Transaction)t);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)this.roadFeatures.length, (int)this.count(reader));
        reader.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", this.rd1Filter), (Transaction)t);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)1, (int)this.count(reader));
        reader.close();
        t.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertCovered(SimpleFeature[] features, FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                this.assertContains(features, reader.next());
                ++count;
            }
        }
        finally {
            reader.close();
        }
        PostgisDataStoreAPIOnlineTest.assertEquals((int)features.length, (int)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertMatched(SimpleFeature[] array, FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws Exception {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                this.assertMatch(array, feature);
                ++count;
            }
        }
        finally {
            reader.close();
        }
        PostgisDataStoreAPIOnlineTest.assertEquals((String)"array not matched by reader", (int)array.length, (int)count);
    }

    void assertMatch(SimpleFeature[] array, SimpleFeature feature) {
        int i;
        PostgisDataStoreAPIOnlineTest.assertTrue((array != null ? 1 : 0) != 0);
        PostgisDataStoreAPIOnlineTest.assertTrue((array.length != 0 ? 1 : 0) != 0);
        SimpleFeatureType schema = feature.getFeatureType();
        for (i = 0; i < array.length; ++i) {
            if (!this.match(array[i], feature)) continue;
            return;
        }
        System.out.println("not found:" + feature);
        for (i = 0; i < array.length; ++i) {
            System.out.println(i + ":" + array[i]);
        }
        PostgisDataStoreAPIOnlineTest.fail((String)("array has no match for " + feature));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean covers(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                if (!this.contains(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        return count == array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean covers(SimpleFeatureIterator reader, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                if (!this.contains(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        return count == array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean coversLax(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                if (!this.containsLax(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        return count == array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(String message, FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                String msg = message + ": feture " + count + "=" + feature;
                System.out.println(msg);
                ++count;
            }
        }
        finally {
            reader.close();
        }
    }

    void dump(String message, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            String msg = message + ": " + i + "=" + array[i];
            System.out.println(msg);
        }
    }

    public void xtestGetFeatureWriter() throws Exception {
        FeatureWriter writer = this.data.getFeatureWriter("road", (Filter)org.geotools.filter.Filter.INCLUDE, Transaction.AUTO_COMMIT);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)this.roadFeatures.length, (int)this.count(writer));
    }

    public void testGetFeatureWriterClose() throws Exception {
        FeatureWriter writer = this.data.getFeatureWriter("road", (Filter)org.geotools.filter.Filter.INCLUDE, Transaction.AUTO_COMMIT);
        writer.close();
        try {
            PostgisDataStoreAPIOnlineTest.assertFalse((boolean)writer.hasNext());
            PostgisDataStoreAPIOnlineTest.fail((String)"Should not be able to use a closed writer");
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            PostgisDataStoreAPIOnlineTest.assertNull((Object)writer.next());
            PostgisDataStoreAPIOnlineTest.fail((String)"Should not be able to use a closed writer");
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testGetFeatureWriterRemove() throws IOException, IllegalAttributeException {
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.writer("road");
        while (writer.hasNext()) {
            SimpleFeature feature = (SimpleFeature)writer.next();
            if (!feature.getID().equals(this.roadFeatures[0].getID())) continue;
            writer.remove();
        }
        writer.close();
        PostgisDataStoreAPIOnlineTest.assertEquals((int)(this.roadFeatures.length - 1), (int)this.count("road"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetFeatureWriterRemoveAll() throws IOException, IllegalAttributeException {
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.writer("road");
        try {
            while (writer.hasNext()) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                writer.remove();
            }
        }
        finally {
            writer.close();
        }
        PostgisDataStoreAPIOnlineTest.assertEquals((int)0, (int)this.count("road"));
    }

    public int count(String typeName) throws IOException {
        return this.data.getFeatureSource(typeName).getFeatures().size();
    }

    public void testGetFeaturesWriterAdd() throws IOException, IllegalAttributeException {
        SimpleFeature feature;
        FeatureWriter writer = this.data.getFeatureWriter("road", Transaction.AUTO_COMMIT);
        LOGGER.info("about to call has next on writer " + writer);
        while (writer.hasNext()) {
            feature = (SimpleFeature)writer.next();
        }
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)writer.hasNext());
        feature = (SimpleFeature)writer.next();
        feature.setAttributes(this.newRoad.getAttributes());
        writer.write();
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)writer.hasNext());
        writer.close();
        PostgisDataStoreAPIOnlineTest.assertEquals((int)(this.roadFeatures.length + 1), (int)this.count("road"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFeature findFeature(FeatureReader<SimpleFeatureType, SimpleFeature> reader, String attributeName, Object value) throws NoSuchElementException, IOException, IllegalAttributeException {
        try {
            while (reader.hasNext()) {
                SimpleFeature f = (SimpleFeature)reader.next();
                if (attributeName == null) {
                    if (!value.equals(f.getID())) continue;
                    SimpleFeature simpleFeature = f;
                    return simpleFeature;
                }
                if (!value.equals(f.getAttribute(attributeName))) continue;
                SimpleFeature simpleFeature = f;
                return simpleFeature;
            }
        }
        finally {
            reader.close();
        }
        if (attributeName == null) {
            throw new NoSuchElementException("No match for FID=" + value);
        }
        throw new NoSuchElementException("No match for " + attributeName + "=" + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFeature feature(String typeName, String fid) throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.reader(typeName);
        try {
            while (reader.hasNext()) {
                SimpleFeature f = (SimpleFeature)reader.next();
                if (!fid.equals(f.getID())) continue;
                SimpleFeature simpleFeature = f;
                return simpleFeature;
            }
        }
        finally {
            reader.close();
        }
        return null;
    }

    public void testGetFeaturesWriterModify() throws IOException, IllegalAttributeException {
        SimpleFeature feature;
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.writer("road");
        while (writer.hasNext()) {
            feature = (SimpleFeature)writer.next();
            if (!feature.getID().equals(this.roadFeatures[0].getID())) continue;
            feature.setAttribute("name", (Object)"changed");
            writer.write();
        }
        writer.close();
        feature = this.feature("road", this.roadFeatures[0].getID());
        PostgisDataStoreAPIOnlineTest.assertNotNull((Object)feature);
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)"changed", (Object)feature.getAttribute("name"));
    }

    public void testGetFeatureWriterTypeNameTransaction() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureWriter writer = this.data.getFeatureWriter("road", Transaction.AUTO_COMMIT);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)this.roadFeatures.length, (int)this.count(writer));
    }

    public void testGetFeatureWriterAppendTypeNameTransaction() throws Exception {
        FeatureWriter writer = this.data.getFeatureWriterAppend("road", Transaction.AUTO_COMMIT);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)0, (int)this.count(writer));
    }

    public void testGetFeatureWriterFilter() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureWriter writer = this.data.getFeatureWriter("road", (Filter)org.geotools.filter.Filter.EXCLUDE, Transaction.AUTO_COMMIT);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)0, (int)this.count(writer));
        writer = this.data.getFeatureWriter("road", (Filter)org.geotools.filter.Filter.INCLUDE, Transaction.AUTO_COMMIT);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)this.roadFeatures.length, (int)this.count(writer));
        writer = this.data.getFeatureWriter("road", this.rd1Filter, Transaction.AUTO_COMMIT);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)1, (int)this.count(writer));
    }

    public void testGetFeatureWriterTransaction() throws Exception {
        SimpleFeature feature;
        int i;
        DefaultTransaction t1 = new DefaultTransaction();
        DefaultTransaction t2 = new DefaultTransaction();
        FeatureWriter writer1 = this.data.getFeatureWriter("road", this.rd1Filter, (Transaction)t1);
        FeatureWriter writer2 = this.data.getFeatureWriterAppend("road", (Transaction)t2);
        SimpleFeatureType road = this.data.getSchema("road");
        SimpleFeature[] ORIGINAL = this.roadFeatures;
        SimpleFeature[] REMOVE = new SimpleFeature[ORIGINAL.length - 1];
        SimpleFeature[] ADD = new SimpleFeature[ORIGINAL.length + 1];
        SimpleFeature[] FINAL = new SimpleFeature[ORIGINAL.length];
        int index = 0;
        for (i = 0; i < ORIGINAL.length; ++i) {
            feature = ORIGINAL[i];
            if (feature.getID().equals(this.roadFeatures[0].getID())) continue;
            REMOVE[index++] = feature;
        }
        for (i = 0; i < ORIGINAL.length; ++i) {
            ADD[i] = ORIGINAL[i];
        }
        ADD[i] = this.newRoad;
        for (i = 0; i < REMOVE.length; ++i) {
            FINAL[i] = REMOVE[i];
        }
        FINAL[i] = this.newRoad;
        FeatureReader reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), Transaction.AUTO_COMMIT);
        PostgisDataStoreAPIOnlineTest.assertTrue((String)"Sanity check failed: before modification reader didn't match original content", (boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGINAL));
        reader.close();
        while (writer1.hasNext()) {
            feature = (SimpleFeature)writer1.next();
            PostgisDataStoreAPIOnlineTest.assertEquals((String)this.roadFeatures[0].getID(), (String)feature.getID());
            writer1.remove();
        }
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), Transaction.AUTO_COMMIT);
        PostgisDataStoreAPIOnlineTest.assertTrue((String)"Feature deletion managed to leak out of transaction?", (boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGINAL));
        reader.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), (Transaction)t1);
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
        reader.close();
        writer1.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), Transaction.AUTO_COMMIT);
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGINAL));
        reader.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), (Transaction)t1);
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
        reader.close();
        feature = (SimpleFeature)writer2.next();
        feature.setAttributes(this.newRoad.getAttributes());
        writer2.write();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), (Transaction)t2);
        this.newRoad = this.findFeature((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, "id", new Integer(4));
        System.out.println("newRoad:" + this.newRoad);
        ADD[ADD.length - 1] = this.newRoad;
        FINAL[FINAL.length - 1] = this.newRoad;
        reader.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), Transaction.AUTO_COMMIT);
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGINAL));
        reader.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), (Transaction)t2);
        this.assertMatched(ADD, (FeatureReader<SimpleFeatureType, SimpleFeature>)reader);
        reader.close();
        writer2.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), Transaction.AUTO_COMMIT);
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGINAL));
        reader.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), (Transaction)t2);
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ADD));
        reader.close();
        t1.commit();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), Transaction.AUTO_COMMIT);
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
        reader.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), (Transaction)t1);
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
        reader.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), (Transaction)t2);
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
        reader.close();
        t2.commit();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), Transaction.AUTO_COMMIT);
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
        reader.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), (Transaction)t1);
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
        reader.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)org.geotools.filter.Filter.INCLUDE), (Transaction)t2);
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
        reader.close();
        t1.close();
        t2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetFeatureWriterConcurrency() throws Exception {
        Connection conn = null;
        try {
            conn = this.pool.getConnection();
            int major = conn.getMetaData().getDatabaseMajorVersion();
            int minor = conn.getMetaData().getDatabaseMinorVersion();
            if (major <= 8 && (major != 8 || minor < 1)) {
                return;
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        DefaultTransaction t1 = new DefaultTransaction();
        FeatureWriter writer1 = this.data.getFeatureWriter("road", this.rd1Filter, (Transaction)t1);
        SimpleFeature f1 = (SimpleFeature)writer1.next();
        f1.setAttribute("name", (Object)new String("r1_"));
        writer1.write();
        DefaultTransaction t2 = new DefaultTransaction();
        FeatureWriter writer2 = this.data.getFeatureWriter("road", this.rd1Filter, (Transaction)t2);
        SimpleFeature f2 = (SimpleFeature)writer2.next();
        f2.setAttribute("name", (Object)new String("r1__"));
        try {
            writer2.write();
            PostgisDataStoreAPIOnlineTest.fail((String)"Feature lock should have failed");
        }
        catch (FeatureLockException e) {
            PostgisDataStoreAPIOnlineTest.assertEquals((String)"road.rd1", (String)e.getFeatureID());
        }
        t1.rollback();
        writer1.close();
        t1.close();
        t2.rollback();
        writer2.close();
        t2.close();
    }

    public void testGetFeatureSourceRoad() throws IOException {
        SimpleFeatureSource road = this.data.getFeatureSource("road");
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)this.roadType, (Object)road.getSchema());
        PostgisDataStoreAPIOnlineTest.assertSame((Object)this.data, (Object)road.getDataStore());
        int count = road.getCount(Query.ALL);
        PostgisDataStoreAPIOnlineTest.assertTrue((count == 3 || count == -1 ? 1 : 0) != 0);
        ReferencedEnvelope bounds = road.getBounds(Query.ALL);
        PostgisDataStoreAPIOnlineTest.assertTrue((bounds == null || new Envelope((Envelope)bounds).equals((Object)this.roadBounds) ? 1 : 0) != 0);
        SimpleFeatureCollection all = road.getFeatures();
        PostgisDataStoreAPIOnlineTest.assertEquals((int)3, (int)all.size());
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)this.roadBounds, (Object)new Envelope((Envelope)all.getBounds()));
        SimpleFeatureCollection expected = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        this.assertCovers("all", expected, all);
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)this.roadBounds, (Object)new Envelope((Envelope)all.getBounds()));
        SimpleFeatureCollection some = road.getFeatures(this.rd12Filter);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)2, (int)some.size());
        ReferencedEnvelope e = new ReferencedEnvelope();
        e.include(this.roadFeatures[0].getBounds());
        e.include(this.roadFeatures[1].getBounds());
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)e, (Object)new Envelope((Envelope)some.getBounds()));
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)some.getSchema(), (Object)road.getSchema());
        DefaultQuery query = new DefaultQuery("road", this.rd12Filter, new String[]{"name"});
        SimpleFeatureCollection half = road.getFeatures((Query)query);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)2, (int)half.size());
        PostgisDataStoreAPIOnlineTest.assertEquals((int)1, (int)((SimpleFeatureType)half.getSchema()).getAttributeCount());
        SimpleFeatureIterator reader = half.features();
        SimpleFeatureType type = (SimpleFeatureType)half.getSchema();
        reader.close();
        SimpleFeatureType actual = (SimpleFeatureType)half.getSchema();
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)type.getName(), (Object)actual.getName());
        PostgisDataStoreAPIOnlineTest.assertEquals((int)type.getAttributeCount(), (int)actual.getAttributeCount());
        for (int i = 0; i < type.getAttributeCount(); ++i) {
            PostgisDataStoreAPIOnlineTest.assertEquals((Object)type.getDescriptor(i), (Object)actual.getDescriptor(i));
        }
        PostgisDataStoreAPIOnlineTest.assertNull((Object)type.getGeometryDescriptor());
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)type.getGeometryDescriptor(), (Object)actual.getGeometryDescriptor());
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)type, (Object)actual);
        ReferencedEnvelope b = half.getBounds();
        ReferencedEnvelope expectedBounds = this.isEnvelopeComputingEnabled() ? this.roadBounds : new ReferencedEnvelope();
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)expectedBounds, (Object)new Envelope((Envelope)b));
    }

    public void testBoundsReproject() throws Exception {
        SimpleFeatureSource road = this.data.getFeatureSource("road");
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)new Envelope((Envelope)this.roadBounds), (Object)road.getBounds());
        CoordinateReferenceSystem epsg4326 = CRS.decode((String)"EPSG:4326");
        CoordinateReferenceSystem epsg3003 = CRS.decode((String)"EPSG:3003");
        ReferencedEnvelope rbOriginal = new ReferencedEnvelope((Envelope)this.roadBounds, epsg4326);
        ReferencedEnvelope rbReprojected = rbOriginal.transform(epsg3003, true);
        DefaultQuery q = new DefaultQuery("road");
        q.setCoordinateSystem(epsg4326);
        q.setCoordinateSystemReproject(epsg3003);
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)rbReprojected, (Object)road.getBounds((Query)q));
    }

    protected boolean isEnvelopeComputingEnabled() {
        return this.data instanceof PostgisDataStore && ((PostgisDataStore)this.data).isEstimatedExtent();
    }

    public void testGetFeatureSourceRiver() throws NoSuchElementException, IOException, IllegalAttributeException {
        SimpleFeatureSource river = this.data.getFeatureSource("river");
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)this.riverType, (Object)river.getSchema());
        PostgisDataStoreAPIOnlineTest.assertSame((Object)this.data, (Object)river.getDataStore());
        SimpleFeatureCollection all = river.getFeatures();
        PostgisDataStoreAPIOnlineTest.assertEquals((int)2, (int)all.size());
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)this.riverBounds, (Object)new Envelope((Envelope)all.getBounds()));
        PostgisDataStoreAPIOnlineTest.assertTrue((String)"rivers", (boolean)this.covers(all.features(), this.riverFeatures));
        SimpleFeatureCollection expected = DataUtilities.collection((SimpleFeature[])this.riverFeatures);
        this.assertCovers("all", expected, all);
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)this.riverBounds, (Object)new Envelope((Envelope)all.getBounds()));
    }

    public void testGetFeaturesSortBy() throws NoSuchElementException, IOException, IllegalAttributeException {
        org.opengis.filter.FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        try {
            DefaultQuery query = new DefaultQuery(this.riverType.getTypeName());
            query.setSortBy(new SortBy[]{ff.sort("nonExistentProperty", SortOrder.ASCENDING)});
            SimpleFeatureSource river = this.data.getFeatureSource("river");
            river.getFeatures((Query)query);
            PostgisDataStoreAPIOnlineTest.fail((String)"Expected a datasource exception while asking to sort by a non existent attribute");
        }
        catch (DataSourceException e) {
            PostgisDataStoreAPIOnlineTest.assertTrue((boolean)true);
        }
        String rv1 = "rv1";
        String rv2 = "rv2";
        this.testSortBy(new SortBy[]{ff.sort("river", SortOrder.ASCENDING)}, "rv1", "rv2");
        this.testSortBy(new SortBy[]{ff.sort("river", SortOrder.DESCENDING)}, "rv2", "rv1");
        this.testSortBy(new SortBy[]{SortBy.NATURAL_ORDER}, "rv1", "rv2");
        this.testSortBy(new SortBy[]{SortBy.REVERSE_ORDER}, "rv2", "rv1");
        this.testSortBy(new SortBy[]{ff.sort("geot:river", SortOrder.ASCENDING)}, "rv1", "rv2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSortBy(SortBy[] sortBy, String riverAtt1, String riverAtt2) throws IOException {
        SimpleFeatureSource river = this.data.getFeatureSource("river");
        DefaultQuery query = new DefaultQuery(this.riverType.getTypeName());
        query.setSortBy(sortBy);
        SimpleFeatureCollection features = river.getFeatures((Query)query);
        Iterator iterator = features.iterator();
        try {
            SimpleFeature f1 = (SimpleFeature)iterator.next();
            SimpleFeature f2 = (SimpleFeature)iterator.next();
            PostgisDataStoreAPIOnlineTest.assertEquals((Object)riverAtt1, (Object)f1.getAttribute("river"));
            PostgisDataStoreAPIOnlineTest.assertEquals((Object)riverAtt2, (Object)f2.getAttribute("river"));
        }
        finally {
            features.close(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetFeaturesPaging() throws NoSuchElementException, IOException, IllegalAttributeException {
        SimpleFeature f1;
        SimpleFeatureSource river = this.data.getFeatureSource("river");
        org.opengis.filter.FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        DefaultQuery query = new DefaultQuery(this.riverType.getTypeName());
        query.setStartIndex(Integer.valueOf(0));
        query.setMaxFeatures(1);
        SimpleFeatureCollection features = river.getFeatures((Query)query);
        Iterator iterator = features.iterator();
        try {
            f1 = (SimpleFeature)iterator.next();
            PostgisDataStoreAPIOnlineTest.assertEquals((int)1, (int)((Integer)f1.getAttribute("id")));
            PostgisDataStoreAPIOnlineTest.assertFalse((boolean)iterator.hasNext());
        }
        finally {
            features.close(iterator);
        }
        query.setStartIndex(Integer.valueOf(1));
        query.setMaxFeatures(1);
        features = river.getFeatures((Query)query);
        iterator = features.iterator();
        try {
            f1 = (SimpleFeature)iterator.next();
            PostgisDataStoreAPIOnlineTest.assertEquals((int)2, (int)((Integer)f1.getAttribute("id")));
            PostgisDataStoreAPIOnlineTest.assertFalse((boolean)iterator.hasNext());
        }
        finally {
            features.close(iterator);
        }
        query.setStartIndex(Integer.valueOf(1));
        query.setMaxFeatures(1);
        query.setSortBy(new SortBy[]{ff.sort("id", SortOrder.DESCENDING)});
        features = river.getFeatures((Query)query);
        iterator = features.iterator();
        try {
            f1 = (SimpleFeature)iterator.next();
            PostgisDataStoreAPIOnlineTest.assertEquals((int)1, (int)((Integer)f1.getAttribute("id")));
            PostgisDataStoreAPIOnlineTest.assertFalse((boolean)iterator.hasNext());
        }
        finally {
            features.close(iterator);
        }
    }

    public void testGetFeatureStoreModifyFeatures1() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("road");
        Integer changed = new Integer(5);
        AttributeDescriptor name = this.roadType.getDescriptor("id");
        road.modifyFeatures(name, (Object)changed, this.rd1Filter);
        SimpleFeatureCollection results = road.getFeatures(this.rd1Filter);
        SimpleFeatureIterator features = results.features();
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)changed, (Object)((SimpleFeature)features.next()).getAttribute("id"));
        results.close((FeatureIterator)features);
    }

    public void testGetFeatureStoreModifyFeatures2() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("road");
        FilterFactory factory = FilterFactoryFinder.createFilterFactory();
        this.rd1Filter = factory.createFidFilter(this.roadFeatures[0].getID());
        AttributeDescriptor name = this.roadType.getDescriptor("name");
        road.modifyFeatures(new AttributeDescriptor[]{name}, new Object[]{"changed"}, this.rd1Filter);
        SimpleFeatureCollection results = road.getFeatures(this.rd1Filter);
        SimpleFeatureIterator features = results.features();
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)"changed", (Object)((SimpleFeature)features.next()).getAttribute("name"));
        results.close((FeatureIterator)features);
    }

    public void testGetFeatureStoreModifyFeatures3() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("road");
        PropertyIsEqualTo filter = this.ff.equals((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)"r1"));
        AttributeDescriptor name = this.roadType.getDescriptor("name");
        road.modifyFeatures(new AttributeDescriptor[]{name}, new Object[]{"changed"}, (Filter)filter);
    }

    public void testGetFeatureStoreRemoveFeatures() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("road");
        road.removeFeatures(this.rd1Filter);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)0, (int)road.getFeatures(this.rd1Filter).size());
        PostgisDataStoreAPIOnlineTest.assertEquals((int)(this.roadFeatures.length - 1), (int)road.getFeatures().size());
    }

    public void testGetFeatureStoreRemoveAllFeatures() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("road");
        road.removeFeatures((Filter)org.geotools.filter.Filter.INCLUDE);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)0, (int)road.getFeatures().size());
    }

    public void testGetFeatureStoreRemoveIntersects() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("road");
        PropertyName property = this.ff.property(this.roadType.getGeometryDescriptor().getLocalName());
        Literal polygon = this.ff.literal((Object)JTS.toGeometry((Envelope)new Envelope(1.0, 2.0, 1.0, 2.0)));
        int size = road.getFeatures().size();
        road.removeFeatures((Filter)this.ff.intersects((Expression)property, (Expression)polygon));
        PostgisDataStoreAPIOnlineTest.assertEquals((int)(size - 1), (int)road.getFeatures().size());
    }

    public void testGetFeatureStoreUpdateIntersects() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("road");
        PropertyName property = this.ff.property(this.roadType.getGeometryDescriptor().getLocalName());
        Literal polygon = this.ff.literal((Object)JTS.toGeometry((Envelope)new Envelope(1.0, 2.0, 1.0, 2.0)));
        road.modifyFeatures(this.roadType.getDescriptor("name"), (Object)"r1.updated", (Filter)this.ff.intersects((Expression)property, (Expression)polygon));
        SimpleFeatureCollection fc = road.getFeatures((Filter)this.ff.id(Collections.singleton(this.ff.featureId("road.rd1"))));
        SimpleFeature rd1 = (SimpleFeature)fc.toArray()[0];
        PostgisDataStoreAPIOnlineTest.assertEquals((Object)"r1.updated", (Object)rd1.getAttribute("name"));
    }

    public void testGetFeatureStoreAddFeatures() throws IOException {
        FeatureReader reader = DataUtilities.reader((SimpleFeature[])new SimpleFeature[]{this.newRoad});
        SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("road");
        road.addFeatures((FeatureCollection)DataUtilities.collection((FeatureReader)reader));
        PostgisDataStoreAPIOnlineTest.assertEquals((int)(this.roadFeatures.length + 1), (int)this.count("road"));
    }

    public void testGetFeatureStoreSetFeatures() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureReader reader = DataUtilities.reader((SimpleFeature[])new SimpleFeature[]{this.newRoad});
        SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("road");
        PostgisDataStoreAPIOnlineTest.assertEquals((int)3, (int)this.count("road"));
        road.setFeatures(reader);
        PostgisDataStoreAPIOnlineTest.assertEquals((int)1, (int)this.count("road"));
    }

    boolean isLocked(String typeName, String fid) {
        InProcessLockingManager lockingManager = (InProcessLockingManager)this.data.getLockingManager();
        return lockingManager.isLocked(typeName, fid);
    }

    public void testLockFeatures() throws IOException {
        FeatureLock lock = FeatureLockFactory.generate((String)"test", (long)3600000L);
        FeatureLocking road = (FeatureLocking)this.data.getFeatureSource("road");
        road.setFeatureLock(lock);
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked("road", "road.rd1"));
        road.lockFeatures();
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.isLocked("road", "road.rd1"));
    }

    public void testUnLockFeatures() throws IOException {
        FeatureLock lock = FeatureLockFactory.generate((String)"test", (long)3600000L);
        FeatureLocking road = (FeatureLocking)this.data.getFeatureSource("road");
        road.setFeatureLock(lock);
        road.lockFeatures();
        try {
            road.unLockFeatures();
            PostgisDataStoreAPIOnlineTest.fail((String)"unlock should fail due on AUTO_COMMIT");
        }
        catch (IOException expected) {
            // empty catch block
        }
        DefaultTransaction t = new DefaultTransaction();
        road.setTransaction((Transaction)t);
        try {
            road.unLockFeatures();
            PostgisDataStoreAPIOnlineTest.fail((String)"unlock should fail due lack of authorization");
        }
        catch (IOException expected) {
            // empty catch block
        }
        t.addAuthorization(lock.getAuthorization());
        road.unLockFeatures();
        t.close();
    }

    public void testLockFeatureInteraction() throws IOException {
        FeatureLock lockA = FeatureLockFactory.generate((String)"LockA", (long)3600000L);
        FeatureLock lockB = FeatureLockFactory.generate((String)"LockB", (long)3600000L);
        DefaultTransaction t1 = new DefaultTransaction();
        DefaultTransaction t2 = new DefaultTransaction();
        FeatureLocking road1 = (FeatureLocking)this.data.getFeatureSource("road");
        FeatureLocking road2 = (FeatureLocking)this.data.getFeatureSource("road");
        road1.setTransaction((Transaction)t1);
        road2.setTransaction((Transaction)t2);
        road1.setFeatureLock(lockA);
        road2.setFeatureLock(lockB);
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked("road", "road.rd1"));
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked("road", "road.rd2"));
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked("road", "road.rd3"));
        road1.lockFeatures(this.rd1Filter);
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.isLocked("road", "road.rd1"));
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked("road", "road.rd2"));
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked("road", "road.rd3"));
        road2.lockFeatures(this.rd2Filter);
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.isLocked("road", "road.rd1"));
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.isLocked("road", "road.rd2"));
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked("road", "road.rd3"));
        try {
            road1.unLockFeatures(this.rd1Filter);
            PostgisDataStoreAPIOnlineTest.fail((String)"need authorization");
        }
        catch (IOException expected) {
            // empty catch block
        }
        t1.addAuthorization(lockA.getAuthorization());
        try {
            road1.unLockFeatures(this.rd2Filter);
            PostgisDataStoreAPIOnlineTest.fail((String)"need correct authorization");
        }
        catch (IOException expected) {
            // empty catch block
        }
        road1.unLockFeatures(this.rd1Filter);
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked("road", "road.rd1"));
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.isLocked("road", "road.rd2"));
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked("road", "road.rd3"));
        t2.addAuthorization(lockB.getAuthorization());
        road2.unLockFeatures(this.rd2Filter);
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked("road", "road.rd1"));
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked("road", "road.rd2"));
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked("road", "road.rd3"));
        t1.close();
        t2.close();
    }

    public void testGetFeatureLockingExpire() throws Exception {
        FeatureLock lock = FeatureLockFactory.generate((String)"Timed", (long)1000L);
        FeatureLocking road = (FeatureLocking)this.data.getFeatureSource("road");
        road.setFeatureLock(lock);
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked("road", "road.rd1"));
        road.lockFeatures(this.rd1Filter);
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)this.isLocked("road", "road.rd1"));
        long then = System.currentTimeMillis();
        do {
            Thread.sleep(1000L);
        } while (System.currentTimeMillis() - then < 1000L);
        PostgisDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked("road", "road.rd1"));
    }

    public void testOidFidMapper() throws IOException, IllegalAttributeException {
        FIDMapper mapper = ((PostgisDataStore)this.data).getFIDMapper("lake");
        FIDMapper base = null;
        base = mapper instanceof TypedFIDMapper ? ((TypedFIDMapper)mapper).getWrappedMapper() : mapper;
        PostgisDataStoreAPIOnlineTest.assertTrue((boolean)(base instanceof OIDFidMapper));
        FeatureReader reader = ((PostgisDataStore)this.data).getFeatureReader(this.data.getSchema("lake"), (Filter)org.geotools.filter.Filter.INCLUDE, Transaction.AUTO_COMMIT);
        while (reader.hasNext()) {
            SimpleFeature f = (SimpleFeature)reader.next();
            PostgisDataStoreAPIOnlineTest.assertNotNull((Object)f.getID());
        }
        reader.close();
        FeatureWriter writer = this.data.getFeatureWriterAppend("lake", Transaction.AUTO_COMMIT);
        SimpleFeature f = (SimpleFeature)writer.next();
        f.setAttributes(this.lakeFeatures[0].getAttributes());
        writer.write();
        writer.close();
        String id = f.getID();
        PostgisDataStoreAPIOnlineTest.assertNotNull((Object)id);
        PostgisDataStoreAPIOnlineTest.assertTrue((!id.trim().equals("") ? 1 : 0) != 0);
        Long.parseLong(id.substring(5));
    }
}

