/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.geotools.data.DataStore;
import org.geotools.data.DataTestCase;
import org.geotools.data.jdbc.datasource.ManageableDataSource;
import org.geotools.data.jdbc.fidmapper.BasicFIDMapper;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.jdbc.fidmapper.TypedFIDMapper;
import org.geotools.data.postgis.PostgisDataStore;
import org.geotools.data.postgis.PostgisDataStoreFactory;
import org.geotools.data.postgis.PostgisTests;
import org.opengis.feature.simple.SimpleFeature;

public class AbstractPostgisDataTestCase
extends DataTestCase {
    static boolean WKB_ENABLED = true;
    static boolean CHECK_TYPE = false;
    protected PostgisTests.Fixture f;
    protected ManageableDataSource pool;
    protected DataStore data;

    public AbstractPostgisDataTestCase(String name) {
        super(name);
    }

    public String getFixtureFile() {
        return "fixture.properties";
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.f = PostgisTests.newFixture(this.getFixtureFile());
        this.pool = PostgisDataStoreFactory.getDefaultDataSource((String)this.f.host, (String)this.f.user, (String)this.f.password, (int)this.f.port, (String)this.f.database, (int)10, (int)2, (boolean)false);
        this.setupDbTables();
        if (CHECK_TYPE) {
            this.checkTypesInDataBase();
            CHECK_TYPE = false;
        }
        this.data = this.newDataStore();
    }

    protected void setupDbTables() throws Exception {
        this.setUpRoadTable();
        this.setUpRiverTable();
        this.setUpLakeTable();
    }

    protected DataStore newDataStore() throws IOException {
        PostgisDataStore pg = new PostgisDataStore((DataSource)this.pool, this.f.schema, this.getName(), 1);
        pg.setWKBEnabled(WKB_ENABLED);
        pg.setEstimatedExtent(true);
        pg.setFIDMapper("road", (FIDMapper)new TypedFIDMapper((FIDMapper)new BasicFIDMapper("fid", 255, false), "road"));
        pg.setFIDMapper("river", (FIDMapper)new TypedFIDMapper((FIDMapper)new BasicFIDMapper("fid", 255, false), "river"));
        pg.setFIDMapper("testset", (FIDMapper)new TypedFIDMapper((FIDMapper)new BasicFIDMapper("gid", 255, true), "testset"));
        return pg;
    }

    protected void tearDown() throws Exception {
        this.data.dispose();
        this.data = null;
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTypesInDataBase() throws SQLException {
        Connection conn = this.pool.getConnection();
        try {
            int i;
            DatabaseMetaData md = conn.getMetaData();
            ResultSet rs = md.getTables(null, "public", "%", new String[]{"TABLE"});
            ResultSetMetaData rsmd = rs.getMetaData();
            int NUM = rsmd.getColumnCount();
            System.out.print(" ");
            for (i = 1; i <= NUM; ++i) {
                System.out.print(rsmd.getColumnName(i));
                System.out.flush();
                System.out.print(":");
                System.out.flush();
                System.out.print(rsmd.getColumnClassName(i));
                System.out.flush();
                if (i >= NUM) continue;
                System.out.print(",");
                System.out.flush();
            }
            System.out.println();
            while (rs.next()) {
                System.out.print(rs.getRow());
                System.out.print(":");
                System.out.flush();
                for (i = 1; i <= NUM; ++i) {
                    System.out.print(rsmd.getColumnName(i));
                    System.out.flush();
                    System.out.print("=");
                    System.out.flush();
                    System.out.print(rs.getString(i));
                    System.out.flush();
                    if (i >= NUM) continue;
                    System.out.print(",");
                    System.out.flush();
                }
                System.out.println();
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUpRoadTable() throws Exception {
        Statement s;
        Connection conn = this.pool.getConnection();
        conn.setAutoCommit(true);
        try {
            s = conn.createStatement();
            s.execute("SELECT dropgeometrycolumn( '" + this.f.schema + "','road','geom')");
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            s = conn.createStatement();
            s.execute("DROP TABLE " + this.f.schema + ".road CASCADE");
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            s = conn.createStatement();
            s.execute("CREATE TABLE " + this.f.schema + ".road (fid varchar PRIMARY KEY, id int )");
            s.execute("SELECT AddGeometryColumn('" + this.f.schema + "', 'road', 'geom', 4326, 'LINESTRING', 2);");
            s.execute("ALTER TABLE " + this.f.schema + ".road add name varchar;");
            for (int i = 0; i < this.roadFeatures.length; ++i) {
                SimpleFeature feature = this.roadFeatures[i];
                String fid = feature.getID().substring("road.".length());
                String ql = "INSERT INTO " + this.f.schema + ".road (fid,id,geom,name) VALUES (" + "'" + fid + "'," + feature.getAttribute("id") + "," + "GeometryFromText('" + ((Geometry)feature.getAttribute("geom")).toText() + "', 4326 )," + "'" + feature.getAttribute("name") + "')";
                s.execute(ql);
            }
            s.execute("VACUUM ANALYZE " + this.f.schema + ".road");
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUpLakeTable() throws Exception {
        Statement s;
        Connection conn = this.pool.getConnection();
        conn.setAutoCommit(true);
        try {
            s = conn.createStatement();
            s.execute("SELECT dropgeometrycolumn( '" + this.f.schema + "','lake','geom')");
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            s = conn.createStatement();
            s.execute("DROP TABLE " + this.f.schema + ".lake CASCADE");
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            s = conn.createStatement();
            s.execute("CREATE TABLE " + this.f.schema + ".lake ( id int ) WITH OIDS");
            s.execute("SELECT AddGeometryColumn('" + this.f.schema + "', 'lake', 'geom', 4326, 'POLYGON', 2);");
            s.execute("ALTER TABLE " + this.f.schema + ".lake add name varchar;");
            for (int i = 0; i < this.lakeFeatures.length; ++i) {
                SimpleFeature feature = this.lakeFeatures[i];
                String ql = "INSERT INTO " + this.f.schema + ".lake (id,geom,name) VALUES (" + feature.getAttribute("id") + "," + "GeometryFromText('" + ((Geometry)feature.getAttribute("geom")).toText() + "', 4326 )," + "'" + feature.getAttribute("name") + "')";
                s.execute(ql);
            }
            s.execute("VACUUM ANALYZE " + this.f.schema + ".lake");
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void killTestTables() throws Exception {
        Connection conn = this.pool.getConnection();
        try {
            Statement s = conn.createStatement();
            try {
                s.execute("SELECT dropgeometrycolumn( '" + this.f.schema + "','road','geom')");
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                s.execute("SELECT dropgeometrycolumn( '" + this.f.schema + "','river','geom')");
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                s.execute("SELECT dropgeometrycolumn( '" + this.f.schema + "','lake','geom')");
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                s.execute("DROP TABLE " + this.f.schema + ".road");
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                s.execute("DROP TABLE " + this.f.schema + ".river");
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                s.execute("DROP TABLE " + this.f.schema + ".lake");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUpRiverTable() throws Exception {
        Statement s;
        Connection conn = this.pool.getConnection();
        try {
            s = conn.createStatement();
            s.execute("SELECT dropgeometrycolumn( '" + this.f.schema + "','river','geom')");
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            s = conn.createStatement();
            s.execute("DROP TABLE " + this.f.schema + ".river CASCADE");
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            s = conn.createStatement();
            s.execute("CREATE TABLE " + this.f.schema + ".river(fid varchar PRIMARY KEY, id int)");
            s.execute("SELECT AddGeometryColumn('" + this.f.schema + "', 'river', 'geom', 4326, 'MULTILINESTRING', 2);");
            s.execute("ALTER TABLE " + this.f.schema + ".river add river varchar");
            s.execute("ALTER TABLE " + this.f.schema + ".river add flow float8");
            for (int i = 0; i < this.riverFeatures.length; ++i) {
                SimpleFeature feature = this.riverFeatures[i];
                String fid = feature.getID().substring("river.".length());
                s.execute("INSERT INTO " + this.f.schema + ".river (fid, id, geom, river, flow) VALUES (" + "'" + fid + "'," + feature.getAttribute("id") + "," + "GeometryFromText('" + feature.getAttribute("geom").toString() + "', 4326 )," + "'" + feature.getAttribute("river") + "'," + feature.getAttribute("flow") + ")");
            }
            s.execute("VACUUM ANALYZE " + this.f.schema + ".river");
        }
        finally {
            conn.close();
        }
    }
}

