/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockException;
import org.geotools.data.FeatureLocking;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.postgis.PostgisDataStore;
import org.geotools.data.postgis.PostgisFeatureStore;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.Filter;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgisFeatureLocking
extends PostgisFeatureStore
implements FeatureLocking<SimpleFeatureType, SimpleFeature> {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.postgis");
    FeatureLock featureLock = FeatureLock.TRANSACTION;

    public PostgisFeatureLocking(PostgisDataStore postgisDataStore, SimpleFeatureType featureType) throws IOException {
        super(postgisDataStore, featureType);
    }

    public void setFeatureLock(FeatureLock lock) {
        if (lock == null) {
            throw new NullPointerException("A FeatureLock is required - did you mean FeatureLock.TRANSACTION?");
        }
        this.featureLock = lock;
    }

    public int lockFeatures() throws IOException {
        return this.lockFeatures((org.opengis.filter.Filter)org.opengis.filter.Filter.INCLUDE);
    }

    public int lockFeatures(org.opengis.filter.Filter filter) throws IOException {
        return this.lockFeatures((Query)new DefaultQuery(this.getSchema().getTypeName(), filter));
    }

    public int lockFeatures(Filter filter) throws IOException {
        return this.lockFeatures((Query)new DefaultQuery(this.getSchema().getTypeName(), (org.opengis.filter.Filter)filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int lockFeatures(Query query) throws IOException {
        LockingManager lockingManager = this.getDataStore().getLockingManager();
        if (lockingManager == null) {
            throw new UnsupportedOperationException("DataStore not using lockingManager, must provide alternate implementation");
        }
        String typeName = this.getSchema().getTypeName();
        if (query.getTypeName() != null && !typeName.equals(query.getTypeName())) {
            throw new IOException("Query typeName does not match " + this.getSchema().getTypeName() + ":" + query);
        }
        DefaultQuery optimizedQuery = new DefaultQuery(typeName, query.getFilter(), query.getMaxFeatures(), Query.NO_NAMES, query.getHandle());
        FeatureIterator reader = this.getFeatures(query).features();
        int count = 0;
        LOGGER.info("got reader from query " + optimizedQuery + ", reader has next " + reader.hasNext());
        try {
            while (reader.hasNext()) {
                try {
                    SimpleFeature feature = (SimpleFeature)reader.next();
                    lockingManager.lockFeatureID(typeName, feature.getID(), this.transaction, this.featureLock);
                    ++count;
                    LOGGER.info("locked feature " + feature);
                }
                catch (FeatureLockException locked) {
                    LOGGER.info("feature lock exception");
                }
                catch (NoSuchElementException nosuch) {
                    throw new DataSourceException("Problem with " + query.getHandle() + " while locking", (Throwable)nosuch);
                    return count;
                }
            }
        }
        finally {
            reader.close();
        }
    }

    public int lockFeature(SimpleFeature feature) throws IOException {
        LockingManager lockingManager = this.getDataStore().getLockingManager();
        if (lockingManager == null) {
            throw new UnsupportedOperationException("DataStore not using lockingManager, must provide alternate implementation");
        }
        try {
            lockingManager.lockFeatureID(this.tableName, feature.getID(), this.getTransaction(), this.featureLock);
            return 1;
        }
        catch (FeatureLockException locked) {
            return 0;
        }
    }

    public void unLockFeatures() throws IOException {
        this.unLockFeatures((org.opengis.filter.Filter)org.opengis.filter.Filter.INCLUDE);
    }

    public void unLockFeatures(org.opengis.filter.Filter filter) throws IOException {
        this.unLockFeatures((Query)new DefaultQuery(this.getSchema().getTypeName(), filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unLockFeatures(Query query) throws IOException {
        LockingManager lockingManager = this.getDataStore().getLockingManager();
        if (lockingManager == null) {
            throw new UnsupportedOperationException("DataStore not using lockingManager, must provide alternate implementation");
        }
        FeatureIterator reader = this.getFeatures(query).features();
        String typeName = this.getSchema().getTypeName();
        try {
            while (reader.hasNext()) {
                try {
                    SimpleFeature feature = (SimpleFeature)reader.next();
                    lockingManager.unLockFeatureID(typeName, feature.getID(), this.getTransaction(), this.featureLock);
                }
                catch (NoSuchElementException nosuch) {
                    throw new DataSourceException("Problem with " + query.getHandle() + " while locking", (Throwable)nosuch);
                    return;
                }
            }
        }
        finally {
            reader.close();
        }
    }
}

