/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.FeatureTypeInfo;
import org.geotools.data.jdbc.JDBC1DataStore;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.JDBCFeatureLocking;
import org.geotools.data.jdbc.JDBCFeatureSource;
import org.geotools.data.jdbc.JDBCFeatureStore;
import org.geotools.data.jdbc.JDBCFeatureWriter;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.jdbc.attributeio.AttributeIO;
import org.geotools.data.jdbc.attributeio.WKTAttributeIO;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.jdbc.fidmapper.FIDMapperFactory;
import org.geotools.data.postgis.PostgisDBInfo;
import org.geotools.data.postgis.PostgisDataStoreFactory;
import org.geotools.data.postgis.PostgisFeatureLocking;
import org.geotools.data.postgis.PostgisFeatureWriter;
import org.geotools.data.postgis.PostgisSQLBuilder;
import org.geotools.data.postgis.attributeio.EWKTAttributeIO;
import org.geotools.data.postgis.attributeio.PgWKBAttributeIO;
import org.geotools.data.postgis.fidmapper.PostgisFIDMapperFactory;
import org.geotools.data.postgis.referencing.PostgisAuthorityFactory;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureTypes;
import org.geotools.filter.SQLEncoderPostgis;
import org.geotools.referencing.CRS;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgisDataStore
extends JDBCDataStore
implements DataStore {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.postgis");
    protected static GeometryFactory geometryFactory = new GeometryFactory();
    protected static WKTReader geometryReader = new WKTReader(geometryFactory);
    private static Map GEOM_TYPE_MAP = new HashMap();
    private static Map CLASS_MAPPINGS;
    private static Map GEOM_CLASS_MAPPINGS;
    public static final int OPTIMIZE_SAFE = 0;
    public static final int OPTIMIZE_SQL = 1;
    private static final int MAX_ALLOWED_VALUE = 0xA00000;
    private PostgisAuthorityFactory paf = null;
    protected PostgisDBInfo dbInfo;
    protected boolean useGeos;
    public int OPTIMIZE_MODE;
    protected boolean WKBEnabled = false;
    protected boolean byteaEnabled = false;
    protected boolean byteaWKB = false;
    protected boolean looseBbox;
    protected boolean estimatedExtent;
    protected boolean schemaEnabled = true;
    private static final Set BASE_HINTS;
    private static final Set WKB_HINTS;

    protected PostgisDataStore(DataSource dataSource) throws IOException {
        this(dataSource, null);
    }

    protected PostgisDataStore(DataSource dataSource, String namespace) throws IOException {
        this(dataSource, PostgisDataStore.schema(null), namespace);
    }

    protected PostgisDataStore(DataSource dataSource, String schema, String namespace) throws IOException {
        this(dataSource, new JDBCDataStoreConfig(namespace, PostgisDataStore.schema(schema), new HashMap(), new HashMap()), 1);
    }

    protected PostgisDataStore(DataSource dataSource, String schema, String namespace, int optimizeMode) throws IOException {
        this(dataSource, new JDBCDataStoreConfig(namespace, PostgisDataStore.schema(schema), new HashMap(), new HashMap()), optimizeMode);
    }

    protected static String schema(String schema) {
        if (schema != null && !"".equals(schema)) {
            return schema;
        }
        return (String)PostgisDataStoreFactory.SCHEMA.sample;
    }

    public PostgisDataStore(DataSource dataSource, JDBCDataStoreConfig config, int optimizeMode) throws IOException {
        super(dataSource, config);
        this.guessDataStoreOptions();
        this.OPTIMIZE_MODE = optimizeMode;
        this.setFIDMapperFactory(this.buildFIDMapperFactory(config));
    }

    protected LockingManager createLockingManager() {
        return new InProcessLockingManager();
    }

    protected PostgisSQLBuilder createSQLBuilder() {
        PostgisSQLBuilder builder = new PostgisSQLBuilder(new SQLEncoderPostgis(), this.config);
        this.initBuilder(builder);
        return builder;
    }

    protected void guessDataStoreOptions() throws IOException {
        PostgisDBInfo dbInfo = this.getDBInfo();
        if (dbInfo == null) {
            LOGGER.severe("Could not obtain PostgisDBInfo");
            this.byteaEnabled = true;
            this.byteaWKB = false;
            this.useGeos = true;
            this.schemaEnabled = true;
        } else {
            this.byteaEnabled = dbInfo.isByteaEnabled();
            if (dbInfo.getMajorVersion() >= 1) {
                this.byteaWKB = true;
            }
            this.useGeos = dbInfo.isGeosEnabled();
            this.schemaEnabled = dbInfo.isSchemaEnabled();
        }
    }

    public String[] getTypeNames() throws IOException {
        int TABLE_NAME_COL = 3;
        Connection conn = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            conn = this.getConnection(Transaction.AUTO_COMMIT);
            DatabaseMetaData meta = conn.getMetaData();
            String[] tableType = new String[]{"TABLE", "VIEW"};
            ResultSet tables = meta.getTables(null, this.config.getDatabaseSchemaName(), "%", tableType);
            while (tables.next()) {
                String tableName = tables.getString(3);
                if (!this.allowTable(tableName)) continue;
                list.add(tableName);
            }
            tables.close();
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
        catch (SQLException sqlException) {
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, (SQLException)sqlException);
            conn = null;
            String message = "Error querying database for list of tables:" + sqlException.getMessage();
            throw new DataSourceException(message, (Throwable)sqlException);
        }
        finally {
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Envelope getEnvelope(String typeName) {
        Envelope envelope;
        Connection conn = null;
        try {
            conn = this.createConnection();
            Statement st = null;
            ResultSet rs = null;
            Envelope envelope2 = null;
            SimpleFeatureType schema = this.getSchema(typeName);
            String geomName = schema.getGeometryDescriptor().getLocalName();
            if (this.getDBInfo().getMajorVersion() >= 1) {
                String dbSchema = this.config.getDatabaseSchemaName();
                String q = !this.schemaEnabled || dbSchema == null || "".equals(dbSchema) ? "SELECT AsText(force_2d(envelope(estimated_extent('" + typeName + "','" + geomName + "'))))" : "SELECT AsText(force_2d(envelope(estimated_extent('" + dbSchema + "','" + typeName + "','" + geomName + "'))))";
                st = conn.createStatement();
                rs = st.executeQuery(q);
                if (rs.next()) {
                    String wkt = rs.getString(1);
                    if (wkt != null && !wkt.trim().equals("")) {
                        envelope2 = geometryReader.read(wkt).getEnvelopeInternal();
                        double minX = envelope2.getMinX();
                        double minY = envelope2.getMinY();
                        double maxX = envelope2.getMaxX();
                        double maxY = envelope2.getMaxY();
                        double deltaX = (maxX - minX) * 0.1;
                        double deltaY = (maxY - minY) * 0.1;
                        envelope2.expandToInclude(minX - deltaX, minY - deltaY);
                        envelope2.expandToInclude(maxX + deltaX, maxY + deltaY);
                    } else {
                        LOGGER.warning("PostGIS estimated_extent function did not return a result.\nPerhaps 'ANALYZE " + typeName + ";' needs to be run or the table is empty?");
                    }
                }
                rs.close();
                st.close();
            }
            if (envelope2 == null) {
                envelope2 = new Envelope();
                int blockSize = 10;
                int fetchAllLimit = 99;
                int[] offset = new int[]{0, 10, 100, 1000, 10000, 20000, 40000};
                int hits = 0;
                int misses = 0;
                for (int i = 0; i < offset.length && misses < 4; ++i) {
                    String limit = " LIMIT 10 OFFSET " + offset[i];
                    if (i + 1 < offset.length && offset[i + 1] - offset[i] <= 10) {
                        limit = " LIMIT 20 OFFSET " + offset[i];
                        offset[i + 1] = offset[i] + 10;
                        ++i;
                    }
                    String q = "SELECT AsText(force_2d(envelope(" + geomName + "))) FROM " + typeName;
                    if (offset[i] > -1) {
                        q = q + limit;
                    }
                    st = conn.createStatement();
                    rs = st.executeQuery(q);
                    boolean gotEnvelope = false;
                    while (rs.next()) {
                        gotEnvelope = true;
                        String wkt = rs.getString(1);
                        if (wkt == null || wkt.trim().equals("")) continue;
                        Envelope e = geometryReader.read(wkt).getEnvelopeInternal();
                        if (envelope2.isNull()) {
                            envelope2.init(e);
                            continue;
                        }
                        envelope2.expandToInclude(e);
                    }
                    if (gotEnvelope) {
                        ++hits;
                    } else {
                        ++misses;
                        if (hits == 0) {
                            rs.close();
                            st.close();
                            Envelope wkt = new Envelope();
                            return wkt;
                        }
                        if (offset[i - 1] < 99) {
                            offset[i] = -1;
                        } else {
                            int min = offset[i - 1];
                            int max = offset[i];
                            if (misses == 2) {
                                min = offset[i - 2];
                                max = offset[i - 1];
                            }
                            if (misses < 3) {
                                offset[i] = (int)((double)(min + max) / 2.0);
                                int width = (int)((double)(max - min) / (double)(offset.length - i));
                                for (int j = i + 1; j < offset.length; ++j) {
                                    offset[j] = min + width * (j - i);
                                }
                            } else {
                                rs.close();
                                st.close();
                                break;
                            }
                        }
                        --i;
                    }
                    rs.close();
                    st.close();
                    if (offset[i] == -1) break;
                }
                double minX = envelope2.getMinX();
                double minY = envelope2.getMinY();
                double maxX = envelope2.getMaxX();
                double maxY = envelope2.getMaxY();
                double deltaX = (maxX - minX) * 1.0;
                double deltaY = (maxY - minY) * 1.0;
                envelope2.expandToInclude(minX - deltaX, minY - deltaY);
                envelope2.expandToInclude(maxX + deltaX, maxY + deltaY);
            }
            envelope = envelope2;
        }
        catch (Exception ignore) {
            Envelope envelope3 = null;
            return envelope3;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
        return envelope;
    }

    protected boolean allowTable(String tablename) {
        if (tablename.equals("geometry_columns")) {
            return false;
        }
        return !tablename.startsWith("spatial_ref_sys");
    }

    protected SimpleFeatureType buildSchema(String typeName, FIDMapper mapper) throws IOException {
        Connection conn = this.getConnection(Transaction.AUTO_COMMIT);
        try {
            Statement st = conn.createStatement();
            try {
                st.execute("SELECT * FROM geometry_columns LIMIT 0;");
            }
            catch (Throwable t) {
                String msg = "Error querying relation: geometry_columns. Possible cause:" + t.getLocalizedMessage();
                throw new DataSourceException(msg, t);
            }
            try {
                SQLEncoderPostgis encoder = new SQLEncoderPostgis(-1);
                encoder.setSupportsGEOS(this.useGeos);
                PostgisSQLBuilder builder = new PostgisSQLBuilder(encoder, this.config);
                this.initBuilder(builder);
                st.execute("SELECT * FROM " + builder.encodeTableName(typeName) + " LIMIT 0;");
            }
            catch (Throwable t) {
                String msg = "Error querying relation:" + typeName + "." + " Possible cause:" + t.getLocalizedMessage();
                throw new DataSourceException(msg, t);
            }
            st.close();
        }
        catch (SQLException e) {
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, (SQLException)e);
            throw new DataSourceException((Throwable)e);
        }
        finally {
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
        }
        return super.buildSchema(typeName, mapper);
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(SimpleFeatureType requestType, Filter filter, Transaction transaction) throws IOException {
        DefaultQuery query;
        String typeName = requestType.getTypeName();
        SimpleFeatureType schemaType = this.getSchema(typeName);
        int compare = DataUtilities.compare((SimpleFeatureType)requestType, (SimpleFeatureType)schemaType);
        if (compare == 0) {
            query = new DefaultQuery(typeName, filter);
        } else if (compare == 1) {
            String[] names = this.attributeNames(requestType, filter);
            query = new DefaultQuery(typeName, filter, Integer.MAX_VALUE, names, "getFeatureReader");
        } else {
            throw new IOException("Type " + typeName + " does match request");
        }
        if (filter == Filter.EXCLUDE || filter.equals(Filter.EXCLUDE)) {
            return new EmptyFeatureReader((FeatureType)requestType);
        }
        FeatureReader reader = this.getFeatureReader((Query)query, transaction);
        if (compare == 1) {
            reader = new ReTypeFeatureReader(reader, requestType, false);
        }
        return reader;
    }

    protected String[] attributeNames(SimpleFeatureType featureType, Filter filter) throws IOException {
        String typeName = featureType.getTypeName();
        SimpleFeatureType original = this.getSchema(typeName);
        SQLBuilder sqlBuilder = this.getSqlBuilder(typeName);
        if (featureType.getAttributeCount() == original.getAttributeCount()) {
            return DataUtilities.attributeNames((SimpleFeatureType)featureType);
        }
        String[] typeAttributes = DataUtilities.attributeNames((SimpleFeatureType)featureType);
        String[] filterAttributes = DataUtilities.attributeNames((Filter)sqlBuilder.getPostQueryFilter(filter));
        if (filterAttributes == null || filterAttributes.length == 0) {
            return typeAttributes;
        }
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(typeAttributes));
        set.addAll(Arrays.asList(filterAttributes));
        if (set.size() == typeAttributes.length) {
            return typeAttributes;
        }
        return set.toArray(new String[set.size()]);
    }

    public SQLBuilder getSqlBuilder(String typeName) throws IOException {
        FeatureTypeInfo info = this.typeHandler.getFeatureTypeInfo(typeName);
        int srid = -1;
        SQLEncoderPostgis encoder = new SQLEncoderPostgis();
        encoder.setSupportsGEOS(this.useGeos);
        encoder.setFIDMapper(this.typeHandler.getFIDMapper(typeName));
        if (info.getSchema().getGeometryDescriptor() != null) {
            String geom = info.getSchema().getGeometryDescriptor().getLocalName();
            srid = info.getSRID(geom);
            encoder.setDefaultGeometry(geom);
        }
        encoder.setFeatureType(info.getSchema());
        encoder.setSRID(srid);
        encoder.setLooseBbox(this.looseBbox);
        PostgisSQLBuilder builder = new PostgisSQLBuilder(encoder, this.config, info.getSchema());
        this.initBuilder(builder);
        return builder;
    }

    protected void initBuilder(PostgisSQLBuilder builder) {
        builder.setWKBEnabled(this.WKBEnabled);
        builder.setByteaEnabled(this.byteaEnabled);
        builder.setSchemaEnabled(this.schemaEnabled);
    }

    protected int determineSRID(String tableName, String geometryColumnName) throws IOException {
        Connection dbConnection;
        block9: {
            ResultSet result;
            Statement statement;
            String sqlStatement;
            StringBuffer sql;
            String dbSchema;
            block8: {
                dbConnection = null;
                dbSchema = this.config.getDatabaseSchemaName();
                sql = new StringBuffer();
                sql.append("SELECT srid FROM geometry_columns WHERE ");
                if (this.schemaEnabled && dbSchema != null && dbSchema.length() > 0) {
                    sql.append("f_table_schema='");
                    sql.append(dbSchema);
                    sql.append("' AND ");
                }
                sql.append("f_table_name='");
                sql.append(tableName);
                sql.append("' AND f_geometry_column='");
                sql.append(geometryColumnName);
                sql.append("';");
                sqlStatement = sql.toString();
                LOGGER.fine("srid statement is " + sqlStatement);
                dbConnection = this.getConnection(Transaction.AUTO_COMMIT);
                statement = dbConnection.createStatement();
                result = statement.executeQuery(sqlStatement);
                if (!result.next()) break block8;
                int retSrid = result.getInt("srid");
                JDBCUtils.close((Statement)statement);
                int n = retSrid;
                JDBCUtils.close((Connection)dbConnection, (Transaction)Transaction.AUTO_COMMIT, null);
                return n;
            }
            result.close();
            sql = new StringBuffer();
            sql.append("SELECT SRID(\"");
            sql.append(geometryColumnName);
            sql.append("\") FROM \"");
            if (this.schemaEnabled && dbSchema != null && dbSchema.length() > 0) {
                sql.append(dbSchema);
                sql.append("\".\"");
            }
            sql.append(tableName);
            sql.append("\" LIMIT 1");
            sqlStatement = sql.toString();
            result = statement.executeQuery(sqlStatement);
            if (!result.next()) break block9;
            int retSrid = result.getInt(1);
            JDBCUtils.close((Statement)statement);
            int n = retSrid;
            JDBCUtils.close((Connection)dbConnection, (Transaction)Transaction.AUTO_COMMIT, null);
            return n;
        }
        try {
            try {
                String mesg = "No geometry column row for srid in table: " + tableName + ", geometry column " + geometryColumnName;
                throw new DataSourceException(mesg);
            }
            catch (SQLException sqle) {
                String message = sqle.getMessage();
                throw new DataSourceException(message, (Throwable)sqle);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(dbConnection, (Transaction)Transaction.AUTO_COMMIT, null);
            throw throwable;
        }
    }

    protected AttributeDescriptor buildAttributeType(ResultSet metadataRs) throws IOException {
        try {
            int TABLE_NAME = 3;
            int COLUMN_NAME = 4;
            int TYPE_NAME = 6;
            int NULLABLE = 11;
            String typeName = metadataRs.getString(6);
            if (typeName.equals("geometry")) {
                String tableName = metadataRs.getString(3);
                String columnName = metadataRs.getString(4);
                int nullCode = metadataRs.getInt(11);
                boolean nillable = true;
                switch (nullCode) {
                    case 0: {
                        nillable = false;
                        break;
                    }
                    case 1: {
                        nillable = true;
                        break;
                    }
                    case 2: {
                        nillable = true;
                    }
                }
                return this.getGeometryAttribute(tableName, columnName, nillable);
            }
            return super.buildAttributeType(metadataRs);
        }
        catch (SQLException e) {
            throw new IOException("Sql error occurred: " + e.getMessage());
        }
    }

    protected FIDMapperFactory buildFIDMapperFactory(JDBCDataStoreConfig config) {
        return new PostgisFIDMapperFactory(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FIDMapper buildFIDMapper(String typeName, FIDMapperFactory factory) throws IOException {
        Connection conn = null;
        try {
            FIDMapper mapper;
            conn = this.getConnection(Transaction.AUTO_COMMIT);
            String dbSchema = this.config.getDatabaseSchemaName();
            FIDMapper fIDMapper = mapper = factory.getMapper(null, dbSchema, typeName, conn);
            return fIDMapper;
        }
        finally {
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
        }
    }

    AttributeDescriptor getGeometryAttribute(String tableName, String columnName, boolean nillable) throws IOException {
        Connection dbConnection = null;
        Class<?> type = null;
        int srid = 0;
        int dimension = 2;
        try {
            dbConnection = this.getConnection(Transaction.AUTO_COMMIT);
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT type, coord_dimension FROM geometry_columns WHERE ");
            String dbSchema = this.config.getDatabaseSchemaName();
            if (this.schemaEnabled && dbSchema != null && dbSchema.length() > 0) {
                sql.append("f_table_schema='");
                sql.append(dbSchema);
                sql.append("' AND ");
            }
            sql.append("f_table_name='");
            sql.append(tableName);
            sql.append("' AND f_geometry_column='");
            sql.append(columnName);
            sql.append("';");
            String sqlStatement = sql.toString();
            LOGGER.fine("geometry type sql statement is " + sqlStatement);
            String geometryType = null;
            Statement statement = dbConnection.createStatement();
            ResultSet result = statement.executeQuery(sqlStatement);
            if (result.next()) {
                geometryType = result.getString("type");
                dimension = result.getInt("coord_dimension");
                LOGGER.fine("geometry type is: " + geometryType);
                if (dimension < 2) {
                    dimension = 2;
                    LOGGER.warning("Geometry dimension " + dimension + " + is invalid, assuming 2");
                }
            }
            result.close();
            if (geometryType == null) {
                AttributeIO attrIO;
                Object object;
                sql = new StringBuffer();
                if (this.WKBEnabled) {
                    sql.append("SELECT encode(AsBinary(force_2d(\"");
                    sql.append(columnName);
                    sql.append("\"), 'XDR'),'base64') FROM \"");
                } else {
                    sql.append("SELECT AsText(\"");
                    sql.append(columnName);
                    sql.append("\") FROM \"");
                }
                if (this.schemaEnabled && dbSchema != null && dbSchema.length() > 0) {
                    sql.append(dbSchema);
                    sql.append("\".\"");
                }
                sql.append(tableName);
                sql.append("\" LIMIT 1");
                sqlStatement = sql.toString();
                result = statement.executeQuery(sqlStatement);
                if (result.next() && (object = (attrIO = this.getGeometryAttributeIO(null, null)).read(result, 1)) instanceof Geometry) {
                    Geometry geom = (Geometry)object;
                    geometryType = geom.getGeometryType().toUpperCase();
                    type = geom.getClass();
                    srid = geom.getSRID();
                }
                result.close();
            }
            statement.close();
            if (geometryType == null) {
                String msg = " no geometry found in the GEOMETRY_COLUMNS table for " + tableName + " of the postgis install.  A row" + " for " + columnName + " is required" + " for geotools to work correctly";
                throw new DataSourceException(msg);
            }
            if (type == null) {
                type = (Class<?>)GEOM_TYPE_MAP.get(geometryType);
            }
        }
        catch (SQLException sqe) {
            throw new IOException("An SQL exception occurred: " + sqe.getMessage());
        }
        finally {
            JDBCUtils.close((Connection)dbConnection, (Transaction)Transaction.AUTO_COMMIT, null);
        }
        if (srid < 1) {
            srid = this.determineSRID(tableName, columnName);
        }
        CoordinateReferenceSystem crs = null;
        try {
            crs = this.getPostgisAuthorityFactory().createCRS(srid);
        }
        catch (FactoryException e) {
            crs = null;
        }
        return new AttributeTypeBuilder().name(columnName).binding((Class)type).nillable(nillable).crs(crs).userData((Object)Hints.COORDINATE_DIMENSION, (Object)dimension).buildDescriptor(columnName);
    }

    private PostgisAuthorityFactory getPostgisAuthorityFactory() {
        if (this.paf == null) {
            this.paf = new PostgisAuthorityFactory(this.dataSource);
        }
        return this.paf;
    }

    private String getGeometrySQLTypeName(Class type) {
        String res = (String)GEOM_CLASS_MAPPINGS.get(type);
        if (res == null) {
            throw new RuntimeException("Unknown type name for class " + type + " please update GEOMETRY_MAPPINGS");
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        String tableName = featureType.getTypeName();
        String lcTableName = tableName.toLowerCase();
        AttributeDescriptor[] attributeType = featureType.getAttributeDescriptors().toArray(new AttributeDescriptor[featureType.getAttributeDescriptors().size()]);
        String dbSchema = this.config.getDatabaseSchemaName();
        PostgisSQLBuilder sqlb = this.createSQLBuilder();
        String fidColumn = lcTableName + "_fid";
        for (int i = 0; i < attributeType.length; ++i) {
            if (!attributeType[i].getLocalName().equalsIgnoreCase(fidColumn)) continue;
            String message = "The featuretype cannot contain the column " + fidColumn + ", since this is used as the hidden FID column";
            throw new IOException(message);
        }
        Connection con = this.getConnection(Transaction.AUTO_COMMIT);
        Statement st = null;
        boolean shouldExecute = !this.tablePresent(tableName, con);
        try {
            con.setAutoCommit(false);
            st = con.createStatement();
            StringBuffer sql = new StringBuffer("CREATE TABLE ");
            sql.append(sqlb.encodeTableName(tableName));
            sql.append(" (");
            sql.append(sqlb.encodeColumnName(fidColumn));
            sql.append(" serial PRIMARY KEY,");
            sql.append(this.makeSqlCreate(attributeType));
            sql.append(");");
            String sqlStr = sql.toString();
            LOGGER.info(sqlStr);
            if (shouldExecute) {
                st.execute(sqlStr);
            }
            sql = new StringBuffer("DELETE FROM GEOMETRY_COLUMNS WHERE f_table_catalog=''");
            sql.append(" AND f_table_schema = '");
            sql.append(dbSchema);
            sql.append("'");
            sql.append("AND f_table_name = '");
            sql.append(tableName);
            sql.append("';");
            sqlStr = sql.toString();
            LOGGER.info(sqlStr);
            if (shouldExecute) {
                st.execute(sqlStr);
            }
            for (int i = 0; i < attributeType.length; ++i) {
                block40: {
                    GeometryDescriptor geomAttribute;
                    block39: {
                        if (!(attributeType[i] instanceof GeometryDescriptor)) continue;
                        geomAttribute = (GeometryDescriptor)attributeType[i];
                        String columnName = attributeType[i].getLocalName();
                        CoordinateReferenceSystem refSys = geomAttribute.getCoordinateReferenceSystem();
                        int SRID = this.getSRID(refSys);
                        String typeName = null;
                        Class type = geomAttribute.getType().getBinding();
                        int dimension = 2;
                        typeName = this.getGeometrySQLTypeName(type);
                        GeometryDescriptor gd = geomAttribute;
                        if (gd.getUserData().get(Hints.COORDINATE_DIMENSION) instanceof Integer) {
                            dimension = (Integer)gd.getUserData().get(Hints.COORDINATE_DIMENSION);
                        }
                        if (typeName == null) break block39;
                        sql = new StringBuffer("INSERT INTO GEOMETRY_COLUMNS VALUES (");
                        sql.append("'','");
                        sql.append(dbSchema);
                        sql.append("','");
                        sql.append(tableName);
                        sql.append("','");
                        sql.append(columnName);
                        sql.append("',");
                        sql.append(dimension);
                        sql.append(",");
                        sql.append(SRID);
                        sql.append(",'");
                        sql.append(typeName);
                        sql.append("');");
                        sqlStr = sql.toString();
                        LOGGER.info(sqlStr);
                        if (shouldExecute) {
                            st.execute(sqlStr);
                        }
                        if (SRID > -1) {
                            sql = new StringBuffer("ALTER TABLE ");
                            sql.append(sqlb.encodeTableName(tableName));
                            sql.append(" ADD CONSTRAINT enforce_srid_");
                            sql.append(columnName);
                            sql.append(" CHECK (SRID(");
                            sql.append(sqlb.encodeColumnName(columnName));
                            sql.append(") = ");
                            sql.append(SRID);
                            sql.append(");");
                            sqlStr = sql.toString();
                            LOGGER.info(sqlStr);
                            if (shouldExecute) {
                                st.execute(sqlStr);
                            }
                        }
                        sql = new StringBuffer("ALTER TABLE ");
                        sql.append(sqlb.encodeTableName(tableName));
                        sql.append(" ADD CONSTRAINT enforce_dims_");
                        sql.append(columnName);
                        sql.append(" CHECK (ndims(");
                        sql.append(sqlb.encodeColumnName(columnName));
                        sql.append(") = ");
                        sql.append(dimension);
                        sql.append(");");
                        sqlStr = sql.toString();
                        LOGGER.info(sqlStr);
                        if (shouldExecute) {
                            st.execute(sqlStr);
                        }
                        if (!typeName.equals("GEOMETRY")) {
                            sql = new StringBuffer("ALTER TABLE ");
                            sql.append(sqlb.encodeTableName(tableName));
                            sql.append(" ADD CONSTRAINT enforce_geotype_");
                            sql.append(columnName);
                            sql.append(" CHECK (geometrytype(");
                            sql.append(sqlb.encodeColumnName(columnName));
                            sql.append(") = '");
                            sql.append(typeName);
                            sql.append("'::text OR ");
                            sql.append(sqlb.encodeColumnName(columnName));
                            sql.append(" IS NULL);");
                            sqlStr = sql.toString();
                            LOGGER.info(sqlStr);
                            if (shouldExecute) {
                                st.execute(sqlStr);
                            }
                        }
                        break block40;
                    }
                    LOGGER.warning("Error: " + geomAttribute.getLocalName() + " unknown type!!!");
                }
                sql = new StringBuffer("CREATE INDEX spatial_");
                sql.append(tableName);
                sql.append("_");
                sql.append(attributeType[i].getLocalName().toLowerCase());
                sql.append(" ON ");
                sql.append(sqlb.encodeTableName(tableName));
                sql.append(" USING GIST (");
                sql.append(sqlb.encodeColumnName(attributeType[i].getLocalName()));
                sql.append(");");
                sqlStr = sql.toString();
                LOGGER.info(sqlStr);
                if (!shouldExecute) continue;
                st.execute(sqlStr);
            }
            con.commit();
        }
        catch (SQLException e) {
            try {
                if (con == null) throw (IOException)new IOException(e.getMessage()).initCause(e);
                con.rollback();
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
            catch (SQLException sqle) {
                throw new IOException(sqle.getMessage());
            }
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
            finally {
                try {
                    if (con != null) {
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (SQLException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
        if (shouldExecute) return;
        throw new IOException("The table " + tableName + " already exists.");
    }

    protected int getSRID(CoordinateReferenceSystem refSys) {
        int SRID = -1;
        if (refSys != null) {
            try {
                Set ident = refSys.getIdentifiers();
                if (ident == null || ident.isEmpty()) {
                    if (refSys == DefaultGeographicCRS.WGS84) {
                        SRID = 4326;
                    } else {
                        String EPSG = CRS.lookupIdentifier((IdentifiedObject)refSys, (boolean)true);
                        SRID = new Integer(EPSG.substring(EPSG.indexOf(":") + 1));
                    }
                } else {
                    String code = ((NamedIdentifier)ident.toArray()[0]).getCode();
                    SRID = Integer.parseInt(code);
                }
            }
            catch (Exception e) {
                LOGGER.warning("SRID could not be determined");
            }
        }
        return SRID;
    }

    private StringBuffer makeSqlCreate(AttributeDescriptor[] attributeType) throws IOException {
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < attributeType.length; ++i) {
            String typeName = null;
            typeName = (String)CLASS_MAPPINGS.get(attributeType[i].getType().getBinding());
            if (typeName == null) {
                typeName = (String)GEOM_CLASS_MAPPINGS.get(attributeType[i].getType().getBinding());
            }
            if (typeName != null) {
                Object defaultValue;
                if (attributeType[i] instanceof GeometryDescriptor) {
                    typeName = "GEOMETRY";
                } else if (typeName.equals("VARCHAR")) {
                    int length = FeatureTypes.getFieldLength((AttributeDescriptor)attributeType[i]);
                    if (length < 1) {
                        LOGGER.warning("FeatureType did not specify string length; defaulted to 256");
                        length = 256;
                    } else if (length > 0xA00000) {
                        length = 0xA00000;
                    }
                    typeName = typeName + "(" + length + ")";
                }
                if (!attributeType[i].isNillable()) {
                    typeName = typeName + " NOT NULL";
                }
                if ((defaultValue = attributeType[i].getDefaultValue()) != null) {
                    typeName = typeName + " DEFAULT '" + defaultValue.toString() + "'";
                }
            } else {
                String msg = attributeType[i] == null ? "AttributeDescriptor was null!" : "Type '" + attributeType[i].getType().getBinding() + "' not supported!";
                throw new IOException(msg);
            }
            buf.append(" \"" + attributeType[i].getLocalName() + "\" " + typeName + ",");
        }
        return buf.deleteCharAt(buf.length() - 1);
    }

    private boolean tablePresent(String table, Connection con) throws IOException {
        int TABLE_NAME_COL = 3;
        Connection conn = null;
        try {
            conn = this.getConnection(Transaction.AUTO_COMMIT);
            DatabaseMetaData meta = conn.getMetaData();
            String[] tableType = new String[]{"TABLE"};
            ResultSet tables = meta.getTables(null, this.config.getDatabaseSchemaName(), "%", tableType);
            while (tables.next()) {
                String tableName = tables.getString(3);
                if (!this.allowTable(tableName) || tableName == null || !tableName.equalsIgnoreCase(table)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException sqlException) {
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, (SQLException)sqlException);
            conn = null;
            String message = "Error querying database for list of tables:" + sqlException.getMessage();
            throw new DataSourceException(message, (Throwable)sqlException);
        }
        finally {
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
        }
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        throw new IOException("PostgisDataStore.updateSchema not yet implemented");
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(String typeName) throws IOException {
        if (!this.typeHandler.getFIDMapper(typeName).isVolatile() || this.allowWriteOnVolatileFIDs) {
            LOGGER.fine("get Feature source called on " + typeName);
            if (this.OPTIMIZE_MODE == 1) {
                LOGGER.fine("returning pg feature locking");
                return this.createFeatureLockingInternal(this, this.getSchema(typeName));
            }
            if (this.getLockingManager() != null) {
                LOGGER.fine("returning jdbc feature locking");
                return new JDBCFeatureLocking((JDBC1DataStore)this, this.getSchema(typeName));
            }
            LOGGER.fine("returning jdbc feature store (lock manager is null)");
            return new JDBCFeatureStore((JDBC1DataStore)this, this.getSchema(typeName));
        }
        return new JDBCFeatureSource((JDBC1DataStore)this, this.getSchema(typeName));
    }

    public PostgisFeatureLocking createFeatureLockingInternal(PostgisDataStore ds, SimpleFeatureType type) throws IOException {
        return new PostgisFeatureLocking(ds, type);
    }

    protected JDBCFeatureWriter createFeatureWriter(FeatureReader<SimpleFeatureType, SimpleFeature> fReader, QueryData queryData) throws IOException {
        PostgisSQLBuilder sqlBuilder = (PostgisSQLBuilder)this.getSqlBuilder(((SimpleFeatureType)fReader.getFeatureType()).getTypeName());
        PostgisFeatureWriter postgisFeatureWriter = new PostgisFeatureWriter(fReader, queryData, this.WKBEnabled, this.byteaWKB, sqlBuilder);
        return postgisFeatureWriter;
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        return this.getFeatureWriter(typeName, (Filter)Filter.INCLUDE, transaction);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        FeatureWriter writer = this.getFeatureWriter(typeName, (Filter)Filter.EXCLUDE, transaction);
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }

    int getSRID(String typeName, String geomColName) throws IOException {
        return this.typeHandler.getFeatureTypeInfo(typeName).getSRID(geomColName);
    }

    protected AttributeIO getGeometryAttributeIO(AttributeDescriptor type, QueryData queryData) {
        int D;
        Hints hints;
        GeometryDescriptor geometryType = (GeometryDescriptor)type;
        CoordinateReferenceSystem crs = null;
        if (geometryType != null) {
            crs = geometryType.getCoordinateReferenceSystem();
        }
        Hints hints2 = hints = queryData != null ? queryData.getHints() : GeoTools.getDefaultHints();
        if (geometryType != null && geometryType.getUserData().get(Hints.COORDINATE_DIMENSION) instanceof Integer) {
            hints.put((Object)Hints.COORDINATE_DIMENSION, geometryType.getUserData().get(Hints.COORDINATE_DIMENSION));
        }
        int n = D = crs == null || Boolean.TRUE.equals(queryData.getHints().get((Object)Hints.FEATURE_2D)) ? 2 : crs.getCoordinateSystem().getDimension();
        if (this.WKBEnabled) {
            return new PgWKBAttributeIO(this.isByteaEnabled(), hints);
        }
        if (D == 3) {
            return new EWKTAttributeIO();
        }
        return new WKTAttributeIO();
    }

    protected int getResultSetType(boolean forWrite) {
        return 1003;
    }

    protected int getConcurrency(boolean forWrite) {
        return 1007;
    }

    public boolean isWKBEnabled() {
        return this.WKBEnabled;
    }

    public void setWKBEnabled(boolean enabled) {
        this.WKBEnabled = enabled;
    }

    public void setLooseBbox(boolean isLooseBbox) {
        this.looseBbox = isLooseBbox;
    }

    public boolean isLooseBbox() {
        return this.looseBbox;
    }

    public boolean isByteaEnabled() {
        return this.byteaEnabled;
    }

    public void setByteaWKB(boolean byteaWKB) {
        this.byteaWKB = byteaWKB;
    }

    public boolean isByteaWKB() {
        return this.byteaWKB;
    }

    public void setByteaEnabled(boolean byteaEnabled) {
        this.byteaEnabled = byteaEnabled;
    }

    public void setEstimatedExtent(boolean estimatedExtent) {
        this.estimatedExtent = estimatedExtent;
        if (estimatedExtent) {
            LOGGER.info("Setting OPTIMIZE_MODE to 'SQL'");
            this.setOptimizeMode(1);
        }
    }

    public boolean isEstimatedExtent() {
        return this.estimatedExtent;
    }

    public void setOptimizeMode(int mode) {
        this.OPTIMIZE_MODE = mode;
    }

    public int getOptimizeMode() {
        return this.OPTIMIZE_MODE;
    }

    public SimpleFeatureType getSchema(String arg0) throws IOException {
        return super.getSchema(arg0);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public PostgisDBInfo getDBInfo() {
        if (this.dbInfo == null) {
            try {
                Connection conn = this.getConnection(Transaction.AUTO_COMMIT);
                this.dbInfo = new PostgisDBInfo(conn);
            }
            catch (IOException e1) {
                LOGGER.log(Level.SEVERE, "Could not obtain DBInfo object", e1);
            }
        }
        return this.dbInfo;
    }

    public Integer getJdbcType(Class attributeTypeBinding) {
        Integer jdbcType = null;
        for (Map.Entry entry : TYPE_MAPPINGS.entrySet()) {
            Class binding = (Class)entry.getValue();
            if (!binding.equals(attributeTypeBinding)) continue;
            jdbcType = (Integer)entry.getKey();
            break;
        }
        return jdbcType;
    }

    public Set getSupportedHints() {
        if (this.isWKBEnabled()) {
            return WKB_HINTS;
        }
        return BASE_HINTS;
    }

    static {
        GEOM_TYPE_MAP.put("GEOMETRY", Geometry.class);
        GEOM_TYPE_MAP.put("POINT", Point.class);
        GEOM_TYPE_MAP.put("POINTM", Point.class);
        GEOM_TYPE_MAP.put("LINESTRING", LineString.class);
        GEOM_TYPE_MAP.put("LINESTRINGM", LineString.class);
        GEOM_TYPE_MAP.put("POLYGON", Polygon.class);
        GEOM_TYPE_MAP.put("POLYGONM", Polygon.class);
        GEOM_TYPE_MAP.put("MULTIPOINT", MultiPoint.class);
        GEOM_TYPE_MAP.put("MULTIPOINTM", MultiPoint.class);
        GEOM_TYPE_MAP.put("MULTILINESTRING", MultiLineString.class);
        GEOM_TYPE_MAP.put("MULTILINESTRINGM", MultiLineString.class);
        GEOM_TYPE_MAP.put("MULTIPOLYGON", MultiPolygon.class);
        GEOM_TYPE_MAP.put("MULTIPOLYGONM", MultiPolygon.class);
        GEOM_TYPE_MAP.put("GEOMETRYCOLLECTION", GeometryCollection.class);
        GEOM_TYPE_MAP.put("GEOMETRYCOLLECTIONM", GeometryCollection.class);
        GEOM_TYPE_MAP.put("CIRCULARSTRING", LineString.class);
        GEOM_TYPE_MAP.put("COMPOUNDCURVE", LineString.class);
        GEOM_TYPE_MAP.put("CURVEPOLYGON", Polygon.class);
        CLASS_MAPPINGS = new HashMap();
        CLASS_MAPPINGS.put(String.class, "VARCHAR");
        CLASS_MAPPINGS.put(Boolean.class, "BOOLEAN");
        CLASS_MAPPINGS.put(Integer.class, "INTEGER");
        CLASS_MAPPINGS.put(Long.class, "BIGINT");
        CLASS_MAPPINGS.put(Float.class, "REAL");
        CLASS_MAPPINGS.put(Double.class, "DOUBLE PRECISION");
        CLASS_MAPPINGS.put(BigDecimal.class, "DECIMAL");
        CLASS_MAPPINGS.put(java.sql.Date.class, "DATE");
        CLASS_MAPPINGS.put(Date.class, "DATE");
        CLASS_MAPPINGS.put(Time.class, "TIME");
        CLASS_MAPPINGS.put(Timestamp.class, "TIMESTAMP");
        GEOM_CLASS_MAPPINGS = new HashMap();
        Set keys = GEOM_TYPE_MAP.keySet();
        for (String name : keys) {
            if (name.substring(name.length() - 1).toUpperCase().equals("M")) continue;
            Class geomClass = (Class)GEOM_TYPE_MAP.get(name);
            GEOM_CLASS_MAPPINGS.put(geomClass, name);
        }
        BASE_HINTS = Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(Hints.FEATURE_DETACHED)));
        WKB_HINTS = Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(Hints.FEATURE_DETACHED, Hints.JTS_COORDINATE_SEQUENCE_FACTORY, Hints.JTS_GEOMETRY_FACTORY)));
    }
}

