/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.RasterFactory;
import javax.media.jai.TiledImage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.feature.AbstractFeatureCollectionProcess;
import org.geotools.process.feature.AbstractFeatureCollectionProcessFactory;
import org.geotools.process.raster.VectorToRasterException;
import org.geotools.process.raster.VectorToRasterFactory;
import org.geotools.referencing.CRS;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorToRasterProcess
extends AbstractFeatureCollectionProcess {
    private static final int COORD_GRID_CHUNK_SIZE = 1000;
    private TransferType transferType;
    GridCoverage2D result;
    private Number minAttValue;
    private Number maxAttValue;
    private float nodataValue;
    private ReferencedEnvelope extent;
    private Geometry extentGeometry;
    private int[] coordGridX = new int[1000];
    private int[] coordGridY = new int[1000];
    private double cellsize;
    TiledImage image;
    Graphics2D graphics;

    public VectorToRasterProcess(VectorToRasterFactory factory) {
        super(factory);
    }

    public static GridCoverage2D process(FeatureCollection<SimpleFeatureType, SimpleFeature> features, String attributeName, Dimension gridDim, ReferencedEnvelope bounds, String covName, ProgressListener monitor) throws VectorToRasterException {
        VectorToRasterFactory factory = new VectorToRasterFactory();
        VectorToRasterProcess process = factory.create();
        return process.convert(features, attributeName, gridDim, bounds, covName, monitor);
    }

    @Override
    public Map<String, Object> execute(Map<String, Object> input, ProgressListener monitor) throws VectorToRasterException {
        FeatureCollection features = (FeatureCollection)input.get(AbstractFeatureCollectionProcessFactory.FEATURES.key);
        String attributeName = (String)input.get(VectorToRasterFactory.ATTRIBUTE.key);
        Dimension gridDim = (Dimension)input.get(VectorToRasterFactory.GRID_DIM.key);
        ReferencedEnvelope env = (ReferencedEnvelope)input.get(VectorToRasterFactory.BOUNDS.key);
        String title = (String)input.get(VectorToRasterFactory.TITLE.key);
        GridCoverage2D cov = this.convert((FeatureCollection<SimpleFeatureType, SimpleFeature>)features, attributeName, gridDim, env, title, monitor);
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put(VectorToRasterFactory.RESULT.key, cov);
        return results;
    }

    @Override
    protected void processFeature(SimpleFeature feature, Map<String, Object> input) throws Exception {
        String attName = (String)input.get(VectorToRasterFactory.ATTRIBUTE.key);
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        if (geometry.intersects(this.extentGeometry)) {
            Number value = null;
            switch (this.transferType) {
                case FLOAT: {
                    value = Float.valueOf(feature.getAttribute(attName).toString());
                    if (this.minAttValue == null) {
                        this.minAttValue = this.maxAttValue = Float.valueOf(value.floatValue());
                        break;
                    }
                    if (Float.compare(value.floatValue(), this.minAttValue.floatValue()) < 0) {
                        this.minAttValue = Float.valueOf(value.floatValue());
                        break;
                    }
                    if (Float.compare(value.floatValue(), this.maxAttValue.floatValue()) <= 0) break;
                    this.maxAttValue = Float.valueOf(value.floatValue());
                    break;
                }
                case INTEGRAL: {
                    value = Integer.valueOf(feature.getAttribute(attName).toString());
                    if (this.minAttValue == null) {
                        this.minAttValue = this.maxAttValue = Integer.valueOf(value.intValue());
                        break;
                    }
                    if (value.intValue() < this.minAttValue.intValue()) {
                        this.minAttValue = value.intValue();
                        break;
                    }
                    if (value.intValue() <= this.maxAttValue.intValue()) break;
                    this.maxAttValue = value.intValue();
                }
            }
            this.graphics.setColor(this.valueToColor(value));
            if (geometry.getClass().equals(MultiPolygon.class)) {
                MultiPolygon mp = (MultiPolygon)geometry;
                for (int n = 0; n < mp.getNumGeometries(); ++n) {
                    this.drawGeometry(mp.getGeometryN(n));
                }
            } else if (geometry.getClass().equals(MultiLineString.class)) {
                MultiLineString mp = (MultiLineString)geometry;
                for (int n = 0; n < mp.getNumGeometries(); ++n) {
                    this.drawGeometry(mp.getGeometryN(n));
                }
            } else if (geometry.getClass().equals(MultiPoint.class)) {
                MultiPoint mp = (MultiPoint)geometry;
                for (int n = 0; n < mp.getNumGeometries(); ++n) {
                    this.drawGeometry(mp.getGeometryN(n));
                }
            } else {
                this.drawGeometry(geometry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridCoverage2D convert(FeatureCollection<SimpleFeatureType, SimpleFeature> features, String attributeName, Dimension gridDim, ReferencedEnvelope bounds, String covName, ProgressListener monitor) throws VectorToRasterException {
        if (monitor == null) {
            monitor = new NullProgressListener();
        }
        this.initialize(features, bounds, attributeName, gridDim);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(VectorToRasterFactory.ATTRIBUTE.key, attributeName);
        float scale = 100.0f / (float)features.size();
        monitor.started();
        FeatureIterator fi = features.features();
        try {
            int counter = 0;
            while (fi.hasNext()) {
                try {
                    this.processFeature((SimpleFeature)fi.next(), params);
                }
                catch (Exception e) {
                    monitor.exceptionOccurred((Throwable)e);
                }
                monitor.progress(scale * (float)counter++);
            }
        }
        finally {
            features.close(fi);
        }
        monitor.complete();
        this.flattenImage();
        GridCoverageFactory gcf = new GridCoverageFactory();
        return gcf.create((CharSequence)covName, (RenderedImage)this.image, (org.opengis.geometry.Envelope)this.extent);
    }

    private void initialize(FeatureCollection<SimpleFeatureType, SimpleFeature> features, ReferencedEnvelope bounds, String attributeName, Dimension gridDim) throws VectorToRasterException {
        AttributeDescriptor attDesc = ((SimpleFeatureType)features.getSchema()).getDescriptor(attributeName);
        if (attDesc == null) {
            throw new VectorToRasterException(attributeName + " not found");
        }
        Class attClass = attDesc.getType().getBinding();
        if (!Number.class.isAssignableFrom(attClass)) {
            throw new VectorToRasterException(attributeName + " is not numeric");
        }
        if (Float.class.isAssignableFrom(attClass)) {
            this.transferType = TransferType.FLOAT;
        } else if (Double.class.isAssignableFrom(attClass)) {
            this.transferType = TransferType.FLOAT;
            Logger.getLogger(VectorToRasterProcess.class.getName()).log(Level.WARNING, "coercing double feature values to float raster values");
        } else if (Long.class.isAssignableFrom(attClass)) {
            this.transferType = TransferType.INTEGRAL;
            Logger.getLogger(VectorToRasterProcess.class.getName()).log(Level.WARNING, "coercing long feature values to int raster values");
        } else {
            this.transferType = TransferType.INTEGRAL;
        }
        this.maxAttValue = null;
        this.minAttValue = null;
        this.setBounds(features, bounds, gridDim);
        this.createImage(gridDim);
    }

    private void setBounds(FeatureCollection<SimpleFeatureType, SimpleFeature> features, ReferencedEnvelope bounds, Dimension gridDim) throws VectorToRasterException {
        ReferencedEnvelope featureBounds = features.getBounds();
        if (bounds != null) {
            ReferencedEnvelope tEnv;
            CoordinateReferenceSystem featuresCRS = featureBounds.getCoordinateReferenceSystem();
            CoordinateReferenceSystem envCRS = bounds.getCoordinateReferenceSystem();
            if (!CRS.equalsIgnoreMetadata((Object)envCRS, (Object)featuresCRS)) {
                try {
                    tEnv = bounds.transform(featuresCRS, true);
                }
                catch (Exception tex) {
                    throw new VectorToRasterException(tex);
                }
            } else {
                tEnv = bounds;
            }
            Envelope intEnv = tEnv.intersection((Envelope)features.getBounds());
            if (intEnv == null) {
                throw new VectorToRasterException("Features do not lie within the requested rasterizing bounds");
            }
            this.extent = new ReferencedEnvelope(intEnv, featuresCRS);
        } else {
            this.extent = featureBounds;
        }
        GeometryFactory gf = new GeometryFactory();
        this.extentGeometry = gf.toGeometry((Envelope)this.extent);
        double xInterval = this.extent.getWidth() / gridDim.getWidth();
        double yInterval = this.extent.getHeight() / gridDim.getHeight();
        this.cellsize = Math.max(xInterval, yInterval);
    }

    private void createImage(Dimension gridDim) {
        ColorModel cm = ColorModel.getRGBdefault();
        SampleModel sm = cm.createCompatibleSampleModel(gridDim.width, gridDim.height);
        this.image = new TiledImage(0, 0, gridDim.width, gridDim.height, 0, 0, sm, cm);
        this.graphics = this.image.createGraphics();
        this.graphics.setPaintMode();
        this.graphics.setComposite(AlphaComposite.Src);
    }

    private void flattenImage() {
        if (this.transferType == TransferType.FLOAT) {
            this.flattenImageToFloat();
        } else {
            this.flattenImageToInt();
        }
    }

    private void flattenImageToInt() {
        int numXTiles = this.image.getNumXTiles();
        int numYTiles = this.image.getNumYTiles();
        SampleModel sm = RasterFactory.createPixelInterleavedSampleModel((int)3, (int)this.image.getWidth(), (int)this.image.getHeight(), (int)1);
        TiledImage destImage = new TiledImage(0, 0, this.image.getWidth(), this.image.getHeight(), 0, 0, sm, null);
        for (int yt = 0; yt < numYTiles; ++yt) {
            for (int xt = 0; xt < numXTiles; ++xt) {
                Raster srcTile = this.image.getTile(xt, yt);
                WritableRaster destTile = destImage.getWritableTile(xt, yt);
                int[] data = new int[srcTile.getDataBuffer().getSize()];
                srcTile.getDataElements(srcTile.getMinX(), srcTile.getMinY(), srcTile.getWidth(), srcTile.getHeight(), data);
                Rectangle bounds = destTile.getBounds();
                destTile.setPixels(bounds.x, bounds.y, bounds.width, bounds.height, data);
                destImage.releaseWritableTile(xt, yt);
            }
        }
        this.image = destImage;
    }

    private void flattenImageToFloat() {
        int numXTiles = this.image.getNumXTiles();
        int numYTiles = this.image.getNumYTiles();
        SampleModel sm = RasterFactory.createPixelInterleavedSampleModel((int)4, (int)this.image.getWidth(), (int)this.image.getHeight(), (int)1);
        TiledImage destImage = new TiledImage(0, 0, this.image.getWidth(), this.image.getHeight(), 0, 0, sm, null);
        for (int yt = 0; yt < numYTiles; ++yt) {
            for (int xt = 0; xt < numXTiles; ++xt) {
                Raster srcTile = this.image.getTile(xt, yt);
                WritableRaster destTile = destImage.getWritableTile(xt, yt);
                int[] data = new int[srcTile.getDataBuffer().getSize()];
                srcTile.getDataElements(srcTile.getMinX(), srcTile.getMinY(), data);
                Rectangle bounds = destTile.getBounds();
                int k = 0;
                int dy = bounds.y;
                for (int drow = 0; drow < bounds.height; ++drow) {
                    int dx = bounds.x;
                    for (int dcol = 0; dcol < bounds.width; ++dcol) {
                        destTile.setSample(dx, dy, 0, Float.intBitsToFloat(data[k]));
                        ++dx;
                    }
                    ++dy;
                }
                destImage.releaseWritableTile(xt, yt);
            }
        }
        this.image = destImage;
    }

    private void drawGeometry(Geometry geometry) {
        int n;
        Coordinate[] coords = geometry.getCoordinates();
        if (coords.length > this.coordGridX.length) {
            n = coords.length / 1000 + 1;
            this.coordGridX = new int[n * 1000];
            this.coordGridY = new int[n * 1000];
        }
        for (n = 0; n < coords.length; ++n) {
            this.coordGridX[n] = (int)((coords[n].x - this.extent.getMinX()) / this.cellsize);
            this.coordGridY[n] = (int)((coords[n].y - this.extent.getMinY()) / this.cellsize);
            this.coordGridY[n] = this.image.getHeight() - this.coordGridY[n];
        }
        if (geometry.getClass().equals(Polygon.class)) {
            this.graphics.fillPolygon(this.coordGridX, this.coordGridY, coords.length);
        } else if (geometry.getClass().equals(LinearRing.class)) {
            this.graphics.drawPolyline(this.coordGridX, this.coordGridY, coords.length);
        } else if (geometry.getClass().equals(LineString.class)) {
            this.graphics.drawPolyline(this.coordGridX, this.coordGridY, coords.length);
        } else if (geometry.getClass().equals(Point.class)) {
            this.graphics.drawPolyline(this.coordGridX, this.coordGridY, coords.length);
        }
    }

    private Color valueToColor(Number value) {
        int intBits = this.transferType == TransferType.FLOAT ? Float.floatToIntBits(value.floatValue()) : value.intValue();
        return new Color(intBits, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TransferType {
        INTEGRAL,
        FLOAT;

    }
}

