/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.renderer.style.DynamicSymbolFactoryFinder;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.OverlapBehavior;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.UserLayer;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.NilExpression;
import org.opengis.style.GraphicalSymbol;

public class MetaBufferEstimator
extends FilterAttributeExtractor
implements StyleVisitor {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.rendering");
    FilterAttributeExtractor attributeExtractor = new FilterAttributeExtractor();
    boolean estimateAccurate = true;
    int buffer = 0;

    public void reset() {
        this.estimateAccurate = true;
        this.buffer = 0;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public boolean isEstimateAccurate() {
        return this.estimateAccurate;
    }

    public void visit(Style style) {
        FeatureTypeStyle[] ftStyles = style.getFeatureTypeStyles();
        for (int i = 0; i < ftStyles.length; ++i) {
            ftStyles[i].accept((StyleVisitor)this);
        }
    }

    public void visit(Rule rule) {
        Graphic[] legendGraphics;
        Symbolizer[] symbolizers;
        Filter filter = rule.getFilter();
        if (filter != null) {
            filter.accept((FilterVisitor)this, null);
        }
        if ((symbolizers = rule.getSymbolizers()) != null) {
            for (int i = 0; i < symbolizers.length; ++i) {
                Symbolizer symbolizer = symbolizers[i];
                symbolizer.accept((StyleVisitor)this);
            }
        }
        if ((legendGraphics = rule.getLegendGraphic()) != null) {
            // empty if block
        }
    }

    public void visit(FeatureTypeStyle fts) {
        Rule[] rules = fts.getRules();
        for (int i = 0; i < rules.length; ++i) {
            Rule rule = rules[i];
            rule.accept((StyleVisitor)this);
        }
    }

    public void visit(Fill fill) {
    }

    public void visit(Stroke stroke) {
        try {
            Expression width = stroke.getWidth();
            if (!this.isNull(width)) {
                this.evaluateWidth(width);
            }
            if (stroke.getGraphicStroke() != null) {
                stroke.getGraphicStroke().accept((StyleVisitor)this);
            }
        }
        catch (ClassCastException e) {
            this.estimateAccurate = false;
            LOGGER.info("Could not parse stroke width, it's a literal but not a Number...");
        }
    }

    protected boolean isNull(Expression exp) {
        return exp == null || exp instanceof NilExpression;
    }

    public void visit(Symbolizer sym) {
        if (sym instanceof PointSymbolizer) {
            this.visit((PointSymbolizer)sym);
        }
        if (sym instanceof LineSymbolizer) {
            this.visit((LineSymbolizer)sym);
        }
        if (sym instanceof PolygonSymbolizer) {
            this.visit((PolygonSymbolizer)sym);
        }
        if (sym instanceof TextSymbolizer) {
            this.visit((TextSymbolizer)sym);
        }
        if (sym instanceof RasterSymbolizer) {
            this.visit((RasterSymbolizer)sym);
        }
    }

    public void visit(RasterSymbolizer rs) {
        if (rs.getGeometryPropertyName() != null) {
            this.attributeNames.add(rs.getGeometryPropertyName());
        }
        if (rs.getImageOutline() != null) {
            rs.getImageOutline().accept((StyleVisitor)this);
        }
        if (rs.getOpacity() != null) {
            rs.getOpacity().accept((ExpressionVisitor)this, null);
        }
    }

    public void visit(PointSymbolizer ps) {
        if (ps.getGraphic() != null) {
            ps.getGraphic().accept((StyleVisitor)this);
        }
    }

    public void visit(LineSymbolizer line) {
        if (line.getStroke() != null) {
            line.getStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(PolygonSymbolizer poly) {
        if (poly.getStroke() != null) {
            poly.getStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(TextSymbolizer text) {
        Graphic graphic;
        if (text instanceof TextSymbolizer2 && (graphic = ((TextSymbolizer2)text).getGraphic()) != null) {
            graphic.accept((StyleVisitor)this);
        }
    }

    public void visit(Graphic gr) {
        block13: {
            try {
                Expression grSize = gr.getSize();
                if (!this.isNull(grSize)) {
                    this.evaluateWidth(grSize);
                    break block13;
                }
                for (GraphicalSymbol gs : gr.graphicalSymbols()) {
                    if (gs instanceof ExternalGraphic) {
                        ExternalGraphic eg = (ExternalGraphic)gs;
                        String location = eg.getLocation().toExternalForm();
                        Expression expanded = ExpressionExtractor.extractCqlExpressions(location);
                        if (!(expanded instanceof Literal)) {
                            this.estimateAccurate = false;
                            return;
                        }
                        Iterator<ExternalGraphicFactory> it = DynamicSymbolFactoryFinder.getExternalGraphicFactories();
                        while (it.hasNext()) {
                            try {
                                Icon icon = it.next().getIcon(null, expanded, eg.getFormat(), -1);
                                if (icon == null) continue;
                                int size = Math.max(icon.getIconHeight(), icon.getIconWidth());
                                if (size > this.buffer) {
                                    this.buffer = size;
                                }
                                return;
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.FINE, "Error occurred evaluating external graphic", e);
                            }
                        }
                        continue;
                    }
                    if (!(gs instanceof Mark)) continue;
                    Mark m = (Mark)gs;
                    if (m.getSize() instanceof Literal) {
                        int size = (int)Math.ceil((Double)m.getSize().evaluate(null, Double.class));
                        if (size > this.buffer) {
                            this.buffer = size;
                        }
                        return;
                    }
                    this.estimateAccurate = false;
                    return;
                }
                this.estimateAccurate = false;
            }
            catch (ClassCastException e) {
                this.estimateAccurate = false;
                LOGGER.info("Could not parse graphic size, it's a literal but not a Number...");
            }
            catch (Exception e) {
                this.estimateAccurate = false;
                LOGGER.log(Level.INFO, "Error occured during the graphic size estimation, meta buffer estimate cannot be performed", e);
            }
        }
    }

    private void evaluateWidth(Expression width) {
        this.attributeExtractor.clear();
        width.accept((ExpressionVisitor)this.attributeExtractor, null);
        if (this.attributeExtractor.isConstantExpression()) {
            Double result = (Double)width.evaluate(null, Double.class);
            if (result != null) {
                int size = (int)Math.ceil(result);
                if (size > this.buffer) {
                    this.buffer = size;
                }
            } else {
                this.estimateAccurate = false;
            }
        } else {
            this.estimateAccurate = false;
        }
    }

    public void visit(Mark mark) {
    }

    public void visit(ExternalGraphic exgr) {
    }

    public void visit(PointPlacement pp) {
    }

    public void visit(AnchorPoint ap) {
    }

    public void visit(Displacement dis) {
    }

    public void visit(LinePlacement lp) {
    }

    public void visit(Halo halo) {
    }

    public void visit(StyledLayerDescriptor sld) {
        StyledLayer[] layers = sld.getStyledLayers();
        for (int i = 0; i < layers.length; ++i) {
            if (layers[i] instanceof NamedLayer) {
                ((NamedLayer)layers[i]).accept((StyleVisitor)this);
                continue;
            }
            if (!(layers[i] instanceof UserLayer)) continue;
            ((UserLayer)layers[i]).accept((StyleVisitor)this);
        }
    }

    public void visit(NamedLayer layer) {
        Style[] styles = layer.getStyles();
        for (int i = 0; i < styles.length; ++i) {
            styles[i].accept((StyleVisitor)this);
        }
    }

    public void visit(UserLayer layer) {
        Style[] styles = layer.getUserStyles();
        for (int i = 0; i < styles.length; ++i) {
            styles[i].accept((StyleVisitor)this);
        }
    }

    public void visit(FeatureTypeConstraint ftc) {
        ftc.accept((StyleVisitor)this);
    }

    public void visit(ColorMap map) {
    }

    public void visit(ColorMapEntry entry) {
    }

    public void visit(ContrastEnhancement contrastEnhancement) {
    }

    public void visit(ImageOutline outline) {
        outline.accept((StyleVisitor)this);
    }

    public void visit(ChannelSelection cs) {
    }

    public void visit(OverlapBehavior ob) {
    }

    public void visit(SelectedChannelType sct) {
    }

    public void visit(ShadedRelief sr) {
    }
}

