/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontCache {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.rendering");
    static FontCache defaultInstance;
    Set<String> systemFonts = new HashSet<String>();
    Map<String, Font> loadedFonts = new ConcurrentHashMap<String, Font>();

    public static FontCache getDefaultInsance() {
        return FontCache.getDefaultInstance();
    }

    public static FontCache getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new FontCache();
        }
        return defaultInstance;
    }

    public synchronized Font getFont(String requestedFont) {
        Font javaFont = null;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("trying to load " + requestedFont);
        }
        if (this.loadedFonts.containsKey(requestedFont)) {
            return this.loadedFonts.get(requestedFont);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("not already loaded");
        }
        if (this.getSystemFonts().contains(requestedFont)) {
            javaFont = new Font(requestedFont, 0, 12);
        } else {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("not a system font");
            }
            javaFont = this.loadFromUrl(requestedFont);
        }
        if (javaFont == null) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.fine("Could not load font " + requestedFont);
            }
        } else {
            this.loadedFonts.put(requestedFont, javaFont);
        }
        return javaFont;
    }

    Font loadFromUrl(String fontUrl) {
        InputStream is;
        block17: {
            is = null;
            if (fontUrl.startsWith("http") || fontUrl.startsWith("file:")) {
                try {
                    URL url = new URL(fontUrl);
                    is = url.openStream();
                }
                catch (MalformedURLException mue) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("Bad url in SLDStyleFactory " + fontUrl + "\n" + mue);
                    }
                    break block17;
                }
                catch (IOException ioe) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("IO error in SLDStyleFactory " + fontUrl + "\n" + ioe);
                    }
                    break block17;
                }
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("not a URL");
            }
            File file = new File(fontUrl);
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException fne) {
                if (!LOGGER.isLoggable(Level.INFO)) break block17;
                LOGGER.info("Bad file name in SLDStyleFactory" + fontUrl + "\n" + fne);
            }
        }
        if (is == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("null input stream, could not load the font");
            }
            return null;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("about to load");
        }
        try {
            return Font.createFont(0, is);
        }
        catch (FontFormatException ffe) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Font format error in SLDStyleFactory " + fontUrl + "\n" + ffe);
            }
            return null;
        }
        catch (IOException ioe) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("IO error in SLDStyleFactory " + fontUrl + "\n" + ioe);
            }
            return null;
        }
    }

    public void registerFont(Font f) {
        this.loadedFonts.put(f.getName(), f);
    }

    public synchronized void resetCache() {
        if (this.systemFonts != null) {
            this.systemFonts.clear();
        }
        if (this.loadedFonts != null) {
            this.loadedFonts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getSystemFonts() {
        if (this.systemFonts.size() == 0) {
            Set<String> set = this.systemFonts;
            synchronized (set) {
                if (this.systemFonts.size() == 0) {
                    Font[] fonts;
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    HashSet<String> fontset = new HashSet<String>();
                    for (Font font : fonts = ge.getAllFonts()) {
                        fontset.add(font.getName());
                        fontset.add(font.getFamily());
                    }
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("there are " + fontset.size() + " fonts available");
                    }
                    this.systemFonts.addAll(fontset);
                }
            }
        }
        return this.systemFonts;
    }

    public Set<String> getAvailableFonts() {
        HashSet<String> availableFonts = new HashSet<String>();
        availableFonts.addAll(this.getSystemFonts());
        availableFonts.addAll(this.loadedFonts.keySet());
        return availableFonts;
    }
}

