/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.text.Bidi;
import javax.swing.Icon;
import org.geotools.renderer.style.GraphicStyle2D;
import org.geotools.renderer.style.IconStyle2D;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.Style2D;
import org.geotools.resources.Classes;

public class TextStyle2D
extends Style2D {
    GlyphVector textGlyphVector;
    Shape haloShape;
    String label;
    Font font;
    double rotation;
    boolean pointPlacement = true;
    int perpendicularOffset = 0;
    double anchorX;
    double anchorY;
    double displacementX;
    double displacementY;
    Paint haloFill;
    Composite haloComposite;
    float haloRadius;
    Style2D graphic;
    private Paint fill;
    private Composite composite;

    public TextStyle2D() {
    }

    public TextStyle2D(TextStyle2D t) {
        this.anchorX = t.anchorX;
        this.anchorY = t.anchorY;
        this.composite = t.composite;
        this.displacementX = t.displacementX;
        this.displacementY = t.displacementY;
        this.fill = t.fill;
        this.font = t.font;
        this.graphic = t.graphic;
        this.haloComposite = t.haloComposite;
        this.haloFill = t.haloFill;
        this.haloRadius = t.haloRadius;
        this.haloShape = t.haloShape;
        this.label = t.label;
        this.maxScale = t.maxScale;
        this.minScale = t.minScale;
        this.perpendicularOffset = t.perpendicularOffset;
        this.pointPlacement = t.pointPlacement;
        this.rotation = t.rotation;
        this.textGlyphVector = t.textGlyphVector;
    }

    public double getAnchorX() {
        return this.anchorX;
    }

    public double getAnchorY() {
        return this.anchorY;
    }

    public Font getFont() {
        return this.font;
    }

    public Composite getHaloComposite() {
        return this.haloComposite;
    }

    public Paint getHaloFill() {
        return this.haloFill;
    }

    public float getHaloRadius() {
        return this.haloRadius;
    }

    public double getRotation() {
        return this.rotation;
    }

    public GlyphVector getTextGlyphVector(Graphics2D graphics) {
        int length;
        char[] chars = this.label.toCharArray();
        this.textGlyphVector = Bidi.requiresBidi(chars, 0, length = this.label.length()) && new Bidi(this.label, -2).isRightToLeft() ? this.font.layoutGlyphVector(graphics.getFontRenderContext(), chars, 0, length, 1) : this.font.createGlyphVector(graphics.getFontRenderContext(), chars);
        return this.textGlyphVector;
    }

    public Shape getHaloShape(Graphics2D graphics) {
        GlyphVector gv = this.getTextGlyphVector(graphics);
        this.haloShape = new BasicStroke(2.0f * this.haloRadius, 1, 1).createStrokedShape(gv.getOutline());
        return this.haloShape;
    }

    public void setAnchorX(double f) {
        this.anchorX = f;
    }

    public void setAnchorY(double f) {
        this.anchorY = f;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setHaloComposite(Composite composite) {
        this.haloComposite = composite;
    }

    public void setHaloFill(Paint paint) {
        this.haloFill = paint;
    }

    public void setHaloRadius(float f) {
        this.haloRadius = f;
    }

    public void setRotation(double f) {
        this.rotation = f;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isPointPlacement() {
        return this.pointPlacement;
    }

    public void setPointPlacement(boolean pointPlacement) {
        this.pointPlacement = pointPlacement;
    }

    public double getDisplacementX() {
        return this.displacementX;
    }

    public void setDisplacementX(double displacementX) {
        this.displacementX = displacementX;
    }

    public double getDisplacementY() {
        return this.displacementY;
    }

    public void setDisplacementY(double displacementY) {
        this.displacementY = displacementY;
    }

    public Paint getFill() {
        return this.fill;
    }

    public void setFill(Paint fill) {
        this.fill = fill;
    }

    public void setPerpendicularOffset(int displace) {
        this.perpendicularOffset = displace;
    }

    public int getPerpendicularOffset() {
        return this.perpendicularOffset;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public String toString() {
        return Classes.getShortClassName((Object)this) + "[\"" + this.label + "\"]";
    }

    public void setGraphic(Style2D s) {
        this.graphic = s;
    }

    public Style2D getGraphic() {
        return this.graphic;
    }

    public Rectangle getGraphicDimensions() {
        if (this.graphic instanceof MarkStyle2D) {
            return ((MarkStyle2D)this.graphic).getTransformedShape(0.0f, 0.0f).getBounds();
        }
        if (this.graphic instanceof GraphicStyle2D) {
            BufferedImage i = ((GraphicStyle2D)this.graphic).getImage();
            return new Rectangle(i.getWidth(), i.getHeight());
        }
        if (this.graphic instanceof IconStyle2D) {
            Icon icon = ((IconStyle2D)this.graphic).getIcon();
            return new Rectangle(icon.getIconWidth(), icon.getIconWidth());
        }
        throw new RuntimeException("Can't render graphic which is not a MarkStyle2D or a GraphicStyle2D");
    }
}

