/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Canvas;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

public final class ImageLoader
implements Runnable {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.rendering");
    private static Map images = new HashMap();
    private static Canvas obs = new Canvas();
    private static MediaTracker tracker = new MediaTracker(obs);
    private static int imageID = 1;
    private static long timeout = 10000L;
    private URL location;
    private boolean waiting = true;

    public static long getTimeout() {
        return timeout;
    }

    public static void setTimeout(long newTimeout) {
        timeout = newTimeout;
    }

    private void add(URL location, boolean interactive) {
        int imgId = imageID;
        this.location = location;
        LOGGER.finest("adding image, interactive? " + interactive);
        Thread t = new Thread(this);
        t.start();
        if (interactive) {
            LOGGER.finest("fast return");
            return;
        }
        this.waiting = true;
        long elapsed = 0L;
        long step = 500L;
        while (this.waiting && (elapsed < timeout || timeout < 0L)) {
            LOGGER.finest("waiting..." + this.waiting);
            try {
                Thread.sleep(500L);
                elapsed += 500L;
                if (!LOGGER.isLoggable(Level.FINEST)) continue;
                LOGGER.finest("Waiting for image " + location + ", elapsed " + elapsed + " milliseconds");
            }
            catch (InterruptedException e) {
                LOGGER.warning(e.toString());
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(imgId + " complete?: " + this.isFlagUp(imgId, 8));
            LOGGER.finest(imgId + " abort?: " + this.isFlagUp(imgId, 2));
            LOGGER.finest(imgId + " error?: " + this.isFlagUp(imgId, 4));
            LOGGER.finest(imgId + " loading?: " + this.isFlagUp(imgId, 1));
            LOGGER.finest(imgId + "slow return " + this.waiting);
        }
    }

    private boolean isFlagUp(int id, int flag) {
        return (tracker.statusID(id, true) & flag) == flag;
    }

    public BufferedImage get(URL location, boolean interactive) {
        if (images.containsKey(location)) {
            LOGGER.finest("found it");
            return (BufferedImage)images.get(location);
        }
        if (!interactive) {
            images.put(location, null);
        }
        LOGGER.finest("adding " + location);
        this.add(location, interactive);
        return (BufferedImage)images.get(location);
    }

    public void run() {
        int myID = 0;
        Image img = null;
        try {
            img = Toolkit.getDefaultToolkit().createImage(this.location);
            myID = imageID++;
            tracker.addImage(img, myID);
        }
        catch (Exception e) {
            LOGGER.warning("Exception fetching image from " + this.location + "\n" + e);
            images.remove(this.location);
            this.waiting = false;
            return;
        }
        try {
            while ((tracker.statusID(myID, true) & 1) != 0) {
                tracker.waitForID(myID, 500L);
                LOGGER.finest(myID + "loading - waiting....");
            }
        }
        catch (InterruptedException ie) {
            LOGGER.warning(ie.toString());
        }
        int state = tracker.statusID(myID, true);
        if (state == 4) {
            LOGGER.finer("" + myID + " Error loading");
            this.waiting = false;
            return;
        }
        if ((state & 8) == 8) {
            LOGGER.finest("" + myID + "completed load");
            int iw = img.getWidth(obs);
            int ih = img.getHeight(obs);
            BufferedImage bi = new BufferedImage(iw, ih, 2);
            Graphics2D big = bi.createGraphics();
            big.drawImage(img, 0, 0, obs);
            images.put(this.location, bi);
            this.waiting = false;
            return;
        }
        LOGGER.finer("" + myID + " whoops - some other outcome " + state);
        this.waiting = false;
    }

    public void reset() {
        images.clear();
    }
}

