/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.awt.Color;
import java.util.ArrayList;
import org.geotools.filter.SEFunctionTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class InterpolateFunctionTest
extends SEFunctionTestBase {
    private static final double TOL = 1.0E-6;
    private final Double[] data = new Double[]{10.0, 20.0, 40.0, 80.0};
    private final Double[] values = new Double[]{1.0, 2.0, 3.0, 4.0};
    private final Color[] colors = new Color[]{Color.RED, Color.ORANGE, Color.GREEN, Color.BLUE};

    @Before
    public void setup() {
        this.parameters = new ArrayList();
    }

    @Test
    public void testFindInterpolateFunction() throws Exception {
        System.out.println("   testFindInterpolateFunction");
        Literal fallback = this.ff2.literal((Object)"NOT_FOUND");
        this.setupParameters(this.data, this.values);
        Function fn = this.finder.findFunction("interpolate", this.parameters, fallback);
        Object result = fn.evaluate((Object)this.feature(0));
        Assert.assertFalse((String)"Could not locate 'interpolate' function", (boolean)result.equals(fallback.getValue()));
    }

    @Test
    public void testLinearNumericInterpolation() throws Exception {
        double expected;
        Double result;
        int i;
        System.out.println("   testLinearNumericInterpolation");
        this.setupParameters(this.data, this.values);
        this.parameters.add(this.ff2.literal((Object)"numeric"));
        this.parameters.add(this.ff2.literal((Object)"linear"));
        Function fn = this.finder.findFunction("interpolate", this.parameters);
        for (i = 1; i < this.data.length; ++i) {
            double testValue = (this.data[i] + this.data[i - 1]) / 2.0;
            result = (Double)fn.evaluate((Object)this.feature(testValue), Double.class);
            expected = (this.values[i] + this.values[i - 1]) / 2.0;
            Assert.assertEquals((double)expected, (double)result, (double)1.0E-6);
        }
        for (i = 0; i < this.data.length; ++i) {
            result = (Double)fn.evaluate((Object)this.feature((double)this.data[i]), Double.class);
            expected = this.values[i];
            Assert.assertEquals((double)expected, (double)result, (double)1.0E-6);
        }
        result = (Double)fn.evaluate((Object)this.feature(this.data[0] - 10.0), Double.class);
        Assert.assertEquals((double)this.values[0], (double)result, (double)1.0E-6);
        result = (Double)fn.evaluate((Object)this.feature(this.data[this.data.length - 1] + 10.0), Double.class);
        Assert.assertEquals((double)this.values[this.values.length - 1], (double)result, (double)1.0E-6);
    }

    @Test
    public void testLinearColorInterpolation() throws Exception {
        int i;
        System.out.println("   testLinearColorInterpolation");
        this.setupParameters(this.data, this.colors);
        this.parameters.add(this.ff2.literal((Object)"color"));
        this.parameters.add(this.ff2.literal((Object)"linear"));
        Function fn = this.finder.findFunction("interpolate", this.parameters);
        Color result = null;
        for (i = 1; i < this.data.length; ++i) {
            double testValue = (this.data[i] + this.data[i - 1]) / 2.0;
            result = (Color)fn.evaluate((Object)this.feature(testValue), Color.class);
            Color expected = new Color((int)Math.round((double)(this.colors[i].getRed() + this.colors[i - 1].getRed()) / 2.0), (int)Math.round((double)(this.colors[i].getGreen() + this.colors[i - 1].getGreen()) / 2.0), (int)Math.round((double)(this.colors[i].getBlue() + this.colors[i - 1].getBlue()) / 2.0));
            Assert.assertEquals((Object)expected, (Object)result);
        }
        for (i = 0; i < this.data.length; ++i) {
            result = (Color)fn.evaluate((Object)this.feature(this.data[i]), Color.class);
            Assert.assertEquals((Object)this.colors[i], (Object)result);
        }
        result = (Color)fn.evaluate((Object)this.feature(this.data[0] - 10.0), Color.class);
        Assert.assertEquals((Object)this.colors[0], (Object)result);
        result = (Color)fn.evaluate((Object)this.feature(this.data[this.data.length - 1] + 10.0), Color.class);
        Assert.assertEquals((Object)this.colors[this.colors.length - 1], (Object)result);
    }

    @Test
    public void testCosineNumericInterpolation() throws Exception {
        double expected;
        Double result;
        int i;
        System.out.println("   testCosineNumericInterpolation");
        this.setupParameters(this.data, this.values);
        this.parameters.add(this.ff2.literal((Object)"numeric"));
        this.parameters.add(this.ff2.literal((Object)"cosine"));
        Function fn = this.finder.findFunction("interpolate", this.parameters);
        double t = 0.1;
        for (i = 1; i < this.data.length; ++i) {
            double testValue = this.data[i - 1] + t * (this.data[i] - this.data[i - 1]);
            result = (Double)fn.evaluate((Object)this.feature(testValue), Double.class);
            expected = this.values[i - 1] + (this.values[i] - this.values[i - 1]) * (1.0 - Math.cos(t * Math.PI)) * 0.5;
            Assert.assertEquals((double)expected, (double)result, (double)1.0E-6);
        }
        for (i = 0; i < this.data.length; ++i) {
            result = (Double)fn.evaluate((Object)this.feature((double)this.data[i]), Double.class);
            expected = this.values[i];
            Assert.assertEquals((double)expected, (double)result, (double)1.0E-6);
        }
        result = (Double)fn.evaluate((Object)this.feature(this.data[0] - 10.0), Double.class);
        Assert.assertEquals((double)this.values[0], (double)result, (double)1.0E-6);
        result = (Double)fn.evaluate((Object)this.feature(this.data[this.data.length - 1] + 10.0), Double.class);
        Assert.assertEquals((double)this.values[this.values.length - 1], (double)result, (double)1.0E-6);
    }

    @Test
    public void testCubicNumericInterpolation() throws Exception {
        Double result;
        System.out.println("   testCubicNumericInterpolation");
        this.setupParameters(this.data, this.values);
        this.parameters.add(this.ff2.literal((Object)"numeric"));
        this.parameters.add(this.ff2.literal((Object)"cubic"));
        Function fn = this.finder.findFunction("interpolate", this.parameters);
        double t = 0.1;
        for (int i = 2; i < this.data.length - 2; ++i) {
            double testValue = this.data[i - 1] + t * (this.data[i] - this.data[i - 1]);
            result = (Double)fn.evaluate((Object)this.feature(testValue), Double.class);
            double expected = InterpolateFunctionTest.cubic(testValue, new double[]{this.data[i - 2], this.data[i - 1], this.data[i], this.data[i + 1]}, new double[]{this.values[i - 2], this.values[i - 1], this.values[i], this.values[i + 1]});
            Assert.assertEquals((double)expected, (double)result, (double)1.0E-6);
        }
        result = (Double)fn.evaluate((Object)this.feature(this.data[0] - 10.0), Double.class);
        Assert.assertEquals((double)this.values[0], (double)result, (double)1.0E-6);
        result = (Double)fn.evaluate((Object)this.feature(this.data[this.data.length - 1] + 10.0), Double.class);
        Assert.assertEquals((double)this.values[this.values.length - 1], (double)result, (double)1.0E-6);
    }

    @Test
    public void testAsRasterData() throws Exception {
        int i;
        System.out.println("   testRasterData");
        this.setupParameters(this.data, this.colors);
        this.parameters.set(0, this.ff2.literal((Object)"RasterData"));
        this.parameters.add(this.ff2.literal((Object)"color"));
        this.parameters.add(this.ff2.literal((Object)"linear"));
        Function fn = this.finder.findFunction("interpolate", this.parameters);
        Color result = null;
        for (i = 1; i < this.data.length; ++i) {
            double rasterValue = (this.data[i] + this.data[i - 1]) / 2.0;
            result = (Color)fn.evaluate((Object)rasterValue, Color.class);
            Color expected = new Color((int)Math.round((double)(this.colors[i].getRed() + this.colors[i - 1].getRed()) / 2.0), (int)Math.round((double)(this.colors[i].getGreen() + this.colors[i - 1].getGreen()) / 2.0), (int)Math.round((double)(this.colors[i].getBlue() + this.colors[i - 1].getBlue()) / 2.0));
            Assert.assertEquals((Object)expected, (Object)result);
        }
        for (i = 0; i < this.data.length; ++i) {
            result = (Color)fn.evaluate((Object)this.data[i], Color.class);
            Assert.assertEquals((Object)this.colors[i], (Object)result);
        }
        result = (Color)fn.evaluate((Object)(this.data[0] - 10.0), Color.class);
        Assert.assertEquals((Object)this.colors[0], (Object)result);
        result = (Color)fn.evaluate((Object)(this.data[this.data.length - 1] + 10.0), Color.class);
        Assert.assertEquals((Object)this.colors[this.colors.length - 1], (Object)result);
    }

    @Test
    public void testForOutOfRangeColorValues() {
        System.out.println("   out of range color values");
        this.parameters = new ArrayList();
        this.parameters.add(this.ff2.literal((Object)"RasterData"));
        double[] x = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        int[] reds = new int[]{128, 0, 0, 255, 255, 128};
        for (int i = 0; i < x.length; ++i) {
            this.parameters.add(this.ff2.literal(x[i]));
            String color = String.format("#%02x0000", reds[i]);
            this.parameters.add(this.ff2.literal((Object)color));
        }
        this.parameters.add(this.ff2.literal((Object)"color"));
        this.parameters.add(this.ff2.literal((Object)"cubic"));
        Function fn = this.finder.findFunction("interpolate", this.parameters);
        Color result = (Color)fn.evaluate((Object)1.5, Color.class);
        Assert.assertEquals((long)0L, (long)result.getRed());
        result = (Color)fn.evaluate((Object)3.5, Color.class);
        Assert.assertEquals((long)255L, (long)result.getRed());
    }

    @Test
    public void testNoMethodParameter() throws Exception {
        System.out.println("   testNoMethodParameter");
        this.setupParameters(this.data, this.values);
        this.parameters.add(this.ff2.literal((Object)"linear"));
        Function fn = this.finder.findFunction("interpolate", this.parameters);
        for (int i = 1; i < this.data.length; ++i) {
            double testValue = (this.data[i] + this.data[i - 1]) / 2.0;
            Double result = (Double)fn.evaluate((Object)this.feature(testValue), Double.class);
            double expected = (this.values[i] + this.values[i - 1]) / 2.0;
            Assert.assertEquals((double)expected, (double)result, (double)1.0E-6);
        }
    }

    @Test
    public void testNoModeParameter() throws Exception {
        System.out.println("   testNoModeParameter");
        this.setupParameters(this.data, this.values);
        this.parameters.add(this.ff2.literal((Object)"numeric"));
        Function fn = this.finder.findFunction("interpolate", this.parameters);
        for (int i = 1; i < this.data.length; ++i) {
            double testValue = (this.data[i] + this.data[i - 1]) / 2.0;
            Double result = (Double)fn.evaluate((Object)this.feature(testValue), Double.class);
            double expected = (this.values[i] + this.values[i - 1]) / 2.0;
            Assert.assertEquals((double)expected, (double)result, (double)1.0E-6);
        }
    }

    @Test
    public void testColorValuesNumericMethodMismatch() throws Exception {
        System.out.println("   testColorValuesNumericMethodMismatch");
        this.setupParameters(this.data, this.colors);
        Function fn = this.finder.findFunction("interpolate", this.parameters);
        boolean gotEx = false;
        try {
            fn.evaluate((Object)this.feature(this.data[1]), Color.class);
        }
        catch (IllegalArgumentException ex) {
            gotEx = true;
        }
        Assert.assertTrue((boolean)gotEx);
    }

    @Test
    public void testNumericValuesColorMethodMismatch() throws Exception {
        System.out.println("   testNumericValuesColorMethodMismatch");
        this.setupParameters(this.data, this.values);
        this.parameters.add(this.ff2.literal((Object)"color"));
        Function fn = this.finder.findFunction("interpolate", this.parameters);
        boolean gotEx = false;
        try {
            fn.evaluate((Object)this.feature(this.data[1]), Double.class);
        }
        catch (IllegalArgumentException ex) {
            gotEx = true;
        }
        Assert.assertTrue((boolean)gotEx);
    }

    private void setupParameters(Object[] data, Object[] values) {
        if (data.length != values.length) {
            throw new IllegalArgumentException("data and values arrays should be the same length");
        }
        this.parameters = new ArrayList();
        this.parameters.add(this.ff2.property("value"));
        for (int i = 0; i < data.length; ++i) {
            this.parameters.add(this.ff2.literal(data[i]));
            this.parameters.add(this.ff2.literal(values[i]));
        }
    }

    private static double cubic(double x, double[] xi, double[] yi) {
        double span01 = xi[1] - xi[0];
        double span12 = xi[2] - xi[1];
        double span23 = xi[3] - xi[2];
        double t = (x - xi[1]) / span12;
        double t2 = t * t;
        double t3 = t2 * t;
        double m1 = 0.5 * ((yi[2] - yi[1]) / span12 + (yi[1] - yi[0]) / span01);
        double m2 = 0.5 * ((yi[3] - yi[2]) / span23 + (yi[2] - yi[1]) / span12);
        double y = (2.0 * t3 - 3.0 * t2 + 1.0) * yi[1] + (t3 - 2.0 * t2 + t) * span12 * m1 + (-2.0 * t3 + 3.0 * t2) * yi[2] + (t3 - t2) * span12 * m2;
        return y;
    }
}

