/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import junit.framework.TestCase;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.resources.XMath;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class RenderUtilitiesTest
extends TestCase {
    public void testScaleOutsideCrsDefinition() throws Exception {
        CoordinateReferenceSystem utm1N = CRS.decode((String)"EPSG:32601");
        ReferencedEnvelope re = new ReferencedEnvelope(new Envelope(0.0, 0.0, 100.0, 100.0), utm1N);
        try {
            RendererUtilities.calculateScale((ReferencedEnvelope)re, (int)100, (int)100, (double)75.0);
            RenderUtilitiesTest.fail((String)"Should have failed, envelope outside of the source crs validity area");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScaleProjected() throws Exception {
        CoordinateReferenceSystem utm1N = CRS.decode((String)"EPSG:32601");
        ReferencedEnvelope re = new ReferencedEnvelope(new Envelope(200000.0, 200100.0, 0.0, 100.0), utm1N);
        double scale = RendererUtilities.calculateScale((ReferencedEnvelope)re, (int)100, (int)100, (double)2.54);
        RenderUtilitiesTest.assertEquals((double)100.0, (double)scale, (double)0.1);
    }

    public void testScaleCartesian() throws Exception {
        ReferencedEnvelope re = new ReferencedEnvelope(new Envelope(0.0, 10.0, 0.0, 10.0), (CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D);
        double scale = RendererUtilities.calculateScale((ReferencedEnvelope)re, (int)1000, (int)1000, (double)2.54);
        RenderUtilitiesTest.assertEquals((double)1.0, (double)scale, (double)1.0E-5);
    }

    public void testScaleGeneric() throws Exception {
        ReferencedEnvelope re = new ReferencedEnvelope(new Envelope(0.0, 10.0, 0.0, 10.0), (CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D);
        double scale = RendererUtilities.calculateScale((ReferencedEnvelope)re, (int)1000, (int)1000, (double)2.54);
        RenderUtilitiesTest.assertEquals((double)1.0, (double)scale, (double)1.0E-5);
    }

    public void testOGCScaleProjected() throws Exception {
        ReferencedEnvelope re = new ReferencedEnvelope(new Envelope(0.0, 10.0, 0.0, 10.0), (CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D);
        int tenMetersPixels = (int)Math.round(35714.28571428572);
        double scale = RendererUtilities.calculateOGCScale((ReferencedEnvelope)re, (int)tenMetersPixels, new HashMap());
        RenderUtilitiesTest.assertEquals((double)1.0, (double)scale, (double)1.0E-4);
    }

    public void testOGCScaleGeographic() throws Exception {
        ReferencedEnvelope re = new ReferencedEnvelope(new Envelope(0.0, 2.0, 0.0, 2.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        double scale = RendererUtilities.calculateOGCScale((ReferencedEnvelope)re, (int)600, new HashMap());
        RenderUtilitiesTest.assertEquals((double)1325232.03, (double)scale, (double)0.01);
    }

    public void testOGCScaleAffineProjected() throws Exception {
        AffineTransform screenToWord = AffineTransform.getScaleInstance(500.0, 500.0);
        AffineTransform worldToScreen = screenToWord.createInverse();
        DefaultEngineeringCRS crs = DefaultEngineeringCRS.CARTESIAN_2D;
        double scale = RendererUtilities.calculateOGCScaleAffine((CoordinateReferenceSystem)crs, (AffineTransform)worldToScreen, new HashMap());
        RenderUtilitiesTest.assertEquals((double)1785714.285714286, (double)scale, (double)1.0E-4);
        worldToScreen.rotate(1.0);
        scale = RendererUtilities.calculateOGCScaleAffine((CoordinateReferenceSystem)crs, (AffineTransform)worldToScreen, new HashMap());
        RenderUtilitiesTest.assertEquals((double)1785714.285714286, (double)scale, (double)1.0E-4);
        worldToScreen.translate(100.0, 100.0);
        scale = RendererUtilities.calculateOGCScaleAffine((CoordinateReferenceSystem)crs, (AffineTransform)worldToScreen, new HashMap());
        RenderUtilitiesTest.assertEquals((double)1785714.285714286, (double)scale, (double)1.0E-4);
    }

    public void testOGCScaleAffineGeographic() throws Exception {
        AffineTransform screenToWord = AffineTransform.getScaleInstance(0.5, 0.5);
        AffineTransform worldToScreen = screenToWord.createInverse();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        double scale = RendererUtilities.calculateOGCScaleAffine((CoordinateReferenceSystem)crs, (AffineTransform)worldToScreen, new HashMap());
        RenderUtilitiesTest.assertEquals((double)1.9878480498798856E8, (double)scale, (double)1.0E-4);
        worldToScreen.rotate(1.0);
        scale = RendererUtilities.calculateOGCScaleAffine((CoordinateReferenceSystem)crs, (AffineTransform)worldToScreen, new HashMap());
        RenderUtilitiesTest.assertEquals((double)1.9878480498798856E8, (double)scale, (double)1.0E-4);
        worldToScreen.translate(100.0, 100.0);
        scale = RendererUtilities.calculateOGCScaleAffine((CoordinateReferenceSystem)crs, (AffineTransform)worldToScreen, new HashMap());
        RenderUtilitiesTest.assertEquals((double)1.9878480498798856E8, (double)scale, (double)1.0E-4);
    }

    public void testCreateMapEnvelope() throws Exception {
        double offset = 10000.0;
        Rectangle paintArea = new Rectangle(0, 0, 800, 600);
        AffineTransform worldToScreen = AffineTransform.getScaleInstance(0.5, 0.5);
        worldToScreen.translate(-10000.0, -10000.0);
        AffineTransform at = new AffineTransform(worldToScreen);
        Envelope env = RendererUtilities.createMapEnvelope((Rectangle)paintArea, (AffineTransform)at);
        this.assertEnvelopeEquals(new Envelope(10000.0, 11600.0, 10000.0, 11200.0), env, 0.001);
        at.translate(20000.0, 20000.0);
        env = RendererUtilities.createMapEnvelope((Rectangle)paintArea, (AffineTransform)at);
        this.assertEnvelopeEquals(new Envelope(-10000.0, -8400.0, -10000.0, -8800.0), env, 0.001);
        at.translate(-20000.0, -20000.0);
        at.rotate(1.5707963267948966, 10000.0, 10000.0);
        env = RendererUtilities.createMapEnvelope((Rectangle)paintArea, (AffineTransform)at);
        this.assertEnvelopeEquals(new Envelope(10000.0, 11200.0, 8400.0, 10000.0), env, 1.0E-4);
        at = new AffineTransform(worldToScreen);
        at.rotate(0.7853981633974483, 10000.0, 10000.0);
        env = RendererUtilities.createMapEnvelope((Rectangle)paintArea, (AffineTransform)at);
        this.assertEnvelopeEquals(new Envelope(10000.0, 10000.0 + Math.cos(0.7853981633974483) * 1600.0 + Math.sin(0.7853981633974483) * 1200.0, 10000.0 - Math.sin(0.7853981633974483) * 1600.0, 10000.0 + Math.cos(0.7853981633974483) * 1200.0), env, 1.0E-4);
    }

    private void assertEnvelopeEquals(Envelope expected, Envelope actual, double delta) {
        if (expected.equals((Object)actual)) {
            return;
        }
        boolean equals = true;
        equals &= Math.abs(expected.getMinX() - actual.getMinX()) <= delta;
        equals &= Math.abs(expected.getMaxX() - actual.getMaxX()) <= delta;
        equals &= Math.abs(expected.getMinY() - actual.getMinY()) <= delta;
        if (!(equals &= Math.abs(expected.getMaxY() - actual.getMaxY()) <= delta)) {
            RenderUtilitiesTest.failNotEquals(null, (Object)expected, (Object)actual);
        }
    }

    public void testCenterTile() throws Exception {
        Envelope centerTile = new Envelope(0.0, 36.0, -18.0, 18.0);
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        double scale = RendererUtilities.calculateScale((Envelope)centerTile, (CoordinateReferenceSystem)crs, (int)512, (int)512, (double)72.0);
        double groundDistance = XMath.hypot((double)36.0, (double)36.0) * 111120.0;
        double pixelDistance = XMath.hypot((double)512.0, (double)512.0) * 3.5277777777777776E-4;
        double expected = groundDistance / pixelDistance;
        RenderUtilitiesTest.assertEquals((double)expected, (double)scale, (double)(expected * 0.05));
    }
}

