/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.renderer.GTRenderer;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.test.TestData;

public abstract class RendererBaseTest {
    protected static void showRender(String testName, Object renderer, long timeOut, ReferencedEnvelope bounds) throws Exception {
        int w = 300;
        int h = 300;
        final BufferedImage image = new BufferedImage(300, 300, 2);
        Graphics g = image.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, 300, 300);
        RendererBaseTest.render(renderer, g, new Rectangle(300, 300), bounds);
        String headless = System.getProperty("java.awt.headless", "false");
        if (!headless.equalsIgnoreCase("true") && TestData.isInteractiveTest()) {
            try {
                Frame frame = new Frame(testName);
                frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        e.getWindow().dispose();
                    }
                });
                Panel p = new Panel(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.setPreferredSize(new Dimension(300, 300));
                    }

                    public void paint(Graphics g) {
                        g.drawImage(image, 0, 0, this);
                    }
                };
                frame.add(p);
                frame.pack();
                frame.setVisible(true);
                Thread.sleep(timeOut);
                frame.dispose();
            }
            catch (HeadlessException exception) {
                return;
            }
        }
        boolean hasData = false;
        for (int y = 0; y < 300; ++y) {
            for (int x = 0; x < 300; ++x) {
                if (image.getRGB(x, y) == 0) continue;
                hasData = true;
            }
        }
        assert (hasData);
    }

    private static void render(Object obj, Graphics g, Rectangle rect, ReferencedEnvelope bounds) {
        if (obj instanceof GTRenderer) {
            GTRenderer renderer = (GTRenderer)obj;
            if (bounds == null) {
                renderer.paint((Graphics2D)g, rect, new AffineTransform());
            } else {
                renderer.paint((Graphics2D)g, rect, bounds);
            }
        }
    }

    protected static Style loadStyle(Object loader, String sldFilename) throws IOException {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        URL surl = TestData.getResource((Object)loader, (String)sldFilename);
        SLDParser stylereader = new SLDParser(factory, surl);
        Style style = stylereader.readXML()[0];
        return style;
    }
}

