/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingRendererTest
extends TestCase {
    private SimpleFeatureType testFeatureType;
    private SimpleFeatureType testPointFeatureType;
    private GeometryFactory gf = new GeometryFactory();
    protected int errors;
    protected int features;

    protected void setUp() throws Exception {
        super.setUp();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Lines");
        builder.add("geom", LineString.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.testFeatureType = builder.buildFeatureType();
        builder = new SimpleFeatureTypeBuilder();
        builder.setName("Points");
        builder.add("geom", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.testPointFeatureType = builder.buildFeatureType();
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> createLineCollection() throws Exception {
        FeatureCollection fc = FeatureCollections.newCollection();
        fc.add((Feature)this.createLine(-177.0, 0.0, -177.0, 10.0));
        fc.add((Feature)this.createLine(-177.0, 0.0, -200.0, 0.0));
        fc.add((Feature)this.createLine(-177.0, 0.0, -177.0, 100.0));
        return fc;
    }

    private SimpleFeature createLine(double x1, double y1, double x2, double y2) {
        Coordinate[] coords = new Coordinate[]{new Coordinate(x1, y1), new Coordinate(x2, y2)};
        return SimpleFeatureBuilder.build((SimpleFeatureType)this.testFeatureType, (Object[])new Object[]{this.gf.createLineString(coords)}, null);
    }

    private SimpleFeature createPoint(double x, double y) {
        Coordinate coord = new Coordinate(x, y);
        return SimpleFeatureBuilder.build((SimpleFeatureType)this.testPointFeatureType, (Object[])new Object[]{this.gf.createPoint(coord)}, null);
    }

    private Style createLineStyle() {
        StyleBuilder sb = new StyleBuilder();
        return sb.createStyle((Symbolizer)sb.createLineSymbolizer());
    }

    private Style createPointStyle() {
        StyleBuilder sb = new StyleBuilder();
        return sb.createStyle((Symbolizer)sb.createPointSymbolizer());
    }

    @Test
    public void testRenderStuff() throws Exception {
        DefaultMapContext mapContext = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mapContext.addLayer(this.createLineCollection(), this.createLineStyle());
        ReferencedEnvelope reWgs = new ReferencedEnvelope(new Envelope(-180.0, -170.0, 20.0, 40.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        CoordinateReferenceSystem utm1N = CRS.decode((String)"EPSG:32601");
        System.out.println(CRS.getGeographicBoundingBox((CoordinateReferenceSystem)utm1N));
        ReferencedEnvelope reUtm = reWgs.transform(utm1N, true);
        BufferedImage image = new BufferedImage(200, 200, 6);
        StreamingRenderer sr = new StreamingRenderer();
        sr.setContext((MapContext)mapContext);
        sr.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
                ++StreamingRendererTest.this.features;
            }

            public void errorOccurred(Exception e) {
                ++StreamingRendererTest.this.errors;
            }
        });
        this.errors = 0;
        this.features = 0;
        sr.paint((Graphics2D)image.getGraphics(), new Rectangle(200, 200), reUtm);
        StreamingRendererTest.assertTrue((this.features > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testInfiniteLoopAvoidance() throws Exception {
        final RuntimeException sentinel = new RuntimeException("This is the one that should be thrown in hasNext()");
        Iterator it2 = (Iterator)EasyMock.createNiceMock(Iterator.class);
        EasyMock.expect((Object)it2.hasNext()).andThrow((Throwable)sentinel).anyTimes();
        EasyMock.replay((Object[])new Object[]{it2});
        FeatureCollection fc = (FeatureCollection)EasyMock.createNiceMock(FeatureCollection.class);
        EasyMock.expect((Object)fc.iterator()).andReturn((Object)it2);
        EasyMock.expect((Object)fc.size()).andReturn((Object)200);
        EasyMock.expect((Object)fc.getSchema()).andReturn((Object)this.testFeatureType).anyTimes();
        EasyMock.replay((Object[])new Object[]{fc});
        FeatureSource fs = (FeatureSource)EasyMock.createNiceMock(FeatureSource.class);
        EasyMock.expect((Object)fs.getFeatures((Query)EasyMock.anyObject())).andReturn((Object)fc);
        EasyMock.expect((Object)fs.getSchema()).andReturn((Object)this.testFeatureType).anyTimes();
        EasyMock.expect((Object)fs.getSupportedHints()).andReturn(new HashSet()).anyTimes();
        EasyMock.replay((Object[])new Object[]{fs});
        DefaultMapContext mapContext = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mapContext.addLayer(fs, this.createLineStyle());
        final StreamingRenderer sr = new StreamingRenderer();
        sr.setContext((MapContext)mapContext);
        sr.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
                ++StreamingRendererTest.this.features;
            }

            public void errorOccurred(Exception e) {
                Throwable t;
                ++StreamingRendererTest.this.errors;
                if (StreamingRendererTest.this.errors > 2) {
                    sr.stopRendering();
                }
                for (t = e; t != sentinel && t.getCause() != null; t = t.getCause()) {
                }
                Assert.assertSame((Object)sentinel, (Object)t);
            }
        });
        this.errors = 0;
        this.features = 0;
        BufferedImage image = new BufferedImage(200, 200, 6);
        ReferencedEnvelope reWgs = new ReferencedEnvelope(new Envelope(-180.0, -170.0, 20.0, 40.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        sr.paint((Graphics2D)image.getGraphics(), new Rectangle(200, 200), reWgs);
        StreamingRendererTest.assertEquals((int)0, (int)this.features);
        StreamingRendererTest.assertEquals((int)1, (int)this.errors);
    }

    @Test
    public void testRotatedTransform() throws Exception {
        Rectangle screen = new Rectangle(0, 0, 100, 50);
        Envelope world = new Envelope(0.0, 50.0, 0.0, -100.0);
        AffineTransform worldToScreen = AffineTransform.getRotateInstance(Math.toRadians(90.0), 0.0, 0.0);
        FeatureCollection fc = FeatureCollections.newCollection();
        fc.add((Feature)this.createPoint(0.0, 0.0));
        fc.add((Feature)this.createPoint(world.getMaxX(), world.getMinY()));
        DefaultMapContext mapContext = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mapContext.addLayer(fc, this.createPointStyle());
        BufferedImage image = new BufferedImage(screen.width, screen.height, 6);
        StreamingRenderer sr = new StreamingRenderer();
        sr.setContext((MapContext)mapContext);
        sr.paint(image.createGraphics(), screen, worldToScreen);
        StreamingRendererTest.assertTrue((String)"Pixel should be drawn at 0,0 ", (image.getRGB(0, 0) != 0 ? 1 : 0) != 0);
        StreamingRendererTest.assertTrue((String)"Pixel should not be drawn in image centre ", (image.getRGB(screen.width / 2, screen.height / 2) == 0 ? 1 : 0) != 0);
        StreamingRendererTest.assertTrue((String)"Pixel should be drawn at image max corner ", (image.getRGB(screen.width - 1, screen.height - 1) != 0 ? 1 : 0) != 0);
    }
}

