/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageReader;
import it.geosolutions.imageio.plugins.arcgrid.spi.AsciiGridsImageReaderSpi;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.stream.FileImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import junit.framework.TestCase;
import org.geotools.TestData;
import org.geotools.renderer.lite.gridcoverage2d.LinearColorMap;
import org.geotools.renderer.lite.gridcoverage2d.LinearColorMapElement;
import org.geotools.renderer.lite.gridcoverage2d.RasterClassifier;
import org.geotools.renderer.lite.gridcoverage2d.RasterSymbolizerTest;
import org.geotools.resources.image.ComponentColorModelJAI;
import org.geotools.util.NumberRange;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.operation.TransformException;

public class TestLinearClassifier
extends TestCase {
    private static final int TEST_NUM = 1;

    @Before
    protected void setUp() throws Exception {
        File file = TestData.copy((Object)((Object)this), (String)"arcgrid/arcgrid.zip");
        TestLinearClassifier.assertTrue((boolean)file.exists());
        TestData.unzipFile((Object)((Object)this), (String)"arcgrid/arcgrid.zip");
    }

    @Test
    public void Synthetic_Double() throws IOException {
        BufferedImage image = this.getSynthetic_Double();
        for (int i = 0; i < 1; ++i) {
            LinearColorMapElement c0 = LinearColorMapElement.create((CharSequence)"c0", (Color)Color.BLACK, (NumberRange)NumberRange.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)10.0, (boolean)true), (int)0);
            LinearColorMapElement c1 = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.blue, (NumberRange)NumberRange.create((double)10.0, (boolean)false, (double)100.0, (boolean)true), (int)1);
            LinearColorMapElement c3 = LinearColorMapElement.create((CharSequence)"c3", (Color)Color.green, (NumberRange)NumberRange.create((double)100.0, (boolean)false, (double)300.0, (boolean)true), (int)2);
            LinearColorMapElement c4 = LinearColorMapElement.create((CharSequence)"c4", (Color[])new Color[]{Color.green, Color.red}, (NumberRange)NumberRange.create((double)300.0, (boolean)false, (double)400.0, (boolean)true), (NumberRange)NumberRange.create((int)3, (int)1000));
            LinearColorMapElement c5 = LinearColorMapElement.create((CharSequence)"c5", (Color[])new Color[]{Color.red, Color.white}, (NumberRange)NumberRange.create((double)400.0, (boolean)false, (double)1000.0, (boolean)true), (NumberRange)NumberRange.create((int)1001, (int)2000));
            LinearColorMapElement c6 = LinearColorMapElement.create((CharSequence)"c6", (Color)Color.red, (double)1001.0, (int)2001);
            LinearColorMapElement c7 = LinearColorMapElement.create((CharSequence)"nodata", (Color)new Color(0, 0, 0, 0), (NumberRange)NumberRange.create((double)Double.NaN, (double)Double.NaN), (int)2201);
            LinearColorMap list = new LinearColorMap("", new LinearColorMapElement[]{c0, c1, c3, c4, c5, c6}, new LinearColorMapElement[]{c7});
            ParameterBlockJAI pbj = new ParameterBlockJAI("org.geotools.RasterClassifier");
            pbj.addSource((Object)image);
            pbj.setParameter("Domain1D", (Object)list);
            RenderedOp finalimage = JAI.create((String)"org.geotools.RasterClassifier", (ParameterBlock)pbj);
            if (TestData.isInteractiveTest()) {
                RasterSymbolizerTest.visualize((RenderedImage)finalimage, "synthetic");
            } else {
                finalimage.getTiles();
            }
            finalimage.dispose();
        }
    }

    private BufferedImage getSynthetic_Double() {
        int width = 500;
        int height = 500;
        WritableRaster raster = RasterFactory.createBandedRaster((int)5, (int)500, (int)500, (int)1, null);
        for (int y = 0; y < 500; ++y) {
            for (int x = 0; x < 500; ++x) {
                raster.setSample(x, y, 0, x + y);
            }
        }
        ComponentColorModelJAI cm = new ComponentColorModelJAI(ColorSpace.getInstance(1003), false, false, 1, 5);
        BufferedImage image = new BufferedImage((ColorModel)cm, raster, false, null);
        return image;
    }

    @Test
    public void Synthetic_Float() throws IOException {
        BufferedImage image = this.getSynthetic_Float();
        for (int i = 0; i < 1; ++i) {
            LinearColorMapElement c0 = LinearColorMapElement.create((CharSequence)"c0", (Color)Color.BLACK, (NumberRange)NumberRange.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)10.0, (boolean)true), (int)0);
            LinearColorMapElement c1 = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.blue, (NumberRange)NumberRange.create((float)10.0f, (boolean)false, (float)100.0f, (boolean)true), (int)1);
            LinearColorMapElement c3 = LinearColorMapElement.create((CharSequence)"c3", (Color)Color.green, (NumberRange)NumberRange.create((float)100.0f, (boolean)false, (float)300.0f, (boolean)true), (int)2);
            LinearColorMapElement c4 = LinearColorMapElement.create((CharSequence)"c4", (Color[])new Color[]{Color.green, Color.red}, (NumberRange)NumberRange.create((float)300.0f, (boolean)false, (float)400.0f, (boolean)true), (NumberRange)NumberRange.create((int)3, (int)1000));
            LinearColorMapElement c5 = LinearColorMapElement.create((CharSequence)"c5", (Color[])new Color[]{Color.red, Color.white}, (NumberRange)NumberRange.create((float)400.0f, (boolean)false, (float)1000.0f, (boolean)true), (NumberRange)NumberRange.create((int)1001, (int)2000));
            LinearColorMapElement c6 = LinearColorMapElement.create((CharSequence)"c6", (Color)Color.red, (float)1001.0f, (int)2001);
            LinearColorMapElement c7 = LinearColorMapElement.create((CharSequence)"nodata", (Color)new Color(0, 0, 0, 0), (NumberRange)NumberRange.create((double)Double.NaN, (double)Double.NaN), (int)2201);
            LinearColorMap list = new LinearColorMap("", new LinearColorMapElement[]{c0, c1, c3, c4, c5, c6}, new LinearColorMapElement[]{c7});
            ParameterBlockJAI pbj = new ParameterBlockJAI("org.geotools.RasterClassifier");
            pbj.addSource((Object)image);
            pbj.setParameter("Domain1D", (Object)list);
            RenderedOp finalimage = JAI.create((String)"org.geotools.RasterClassifier", (ParameterBlock)pbj);
            if (TestData.isInteractiveTest()) {
                RasterSymbolizerTest.visualize((RenderedImage)finalimage, "synthetic");
            } else {
                finalimage.getTiles();
            }
            finalimage.dispose();
        }
    }

    private BufferedImage getSynthetic_Float() {
        int width = 500;
        int height = 500;
        WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)500, (int)500, (int)1, null);
        for (int y = 0; y < 500; ++y) {
            for (int x = 0; x < 500; ++x) {
                raster.setSample(x, y, 0, x + y);
            }
        }
        ComponentColorModelJAI cm = new ComponentColorModelJAI(ColorSpace.getInstance(1003), false, false, 1, 4);
        BufferedImage image = new BufferedImage((ColorModel)cm, raster, false, null);
        return image;
    }

    @Test
    public void spearfish() throws IOException {
        RenderedImage image = this.getSpearfhisDemo();
        for (int i = 0; i < 1; ++i) {
            LinearColorMapElement c0 = LinearColorMapElement.create((CharSequence)"c0", (Color)Color.yellow, (NumberRange)NumberRange.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)1100.0, (boolean)true), (int)5);
            LinearColorMapElement c1 = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.blue, (NumberRange)NumberRange.create((double)1100.0, (boolean)false, (double)1200.0, (boolean)true), (int)1);
            LinearColorMapElement c3 = LinearColorMapElement.create((CharSequence)"c3", (Color)Color.green, (NumberRange)NumberRange.create((double)1200.0, (boolean)false, (double)1400.0, (boolean)true), (int)7);
            LinearColorMapElement c4 = LinearColorMapElement.create((CharSequence)"c4", (Color)Color.blue, (NumberRange)NumberRange.create((double)1400.0, (boolean)false, (double)1600.0, (boolean)true), (int)1);
            LinearColorMapElement c5 = LinearColorMapElement.create((CharSequence)"c4", (Color)Color.CYAN, (NumberRange)NumberRange.create((double)1600.0, (boolean)false, (double)Double.POSITIVE_INFINITY, (boolean)true), (int)11);
            LinearColorMapElement c6 = LinearColorMapElement.create((CharSequence)"nodata", (Color)new Color(0, 0, 0, 0), (NumberRange)NumberRange.create((double)Double.NaN, (double)Double.NaN), (int)0);
            LinearColorMap list = new LinearColorMap("", new LinearColorMapElement[]{c0, c1, c3, c4, c5}, new LinearColorMapElement[]{c6});
            ParameterBlockJAI pbj = new ParameterBlockJAI("org.geotools.RasterClassifier");
            pbj.addSource((Object)image);
            pbj.setParameter("Domain1D", (Object)list);
            RenderedOp finalimage = JAI.create((String)"org.geotools.RasterClassifier", (ParameterBlock)pbj);
            if (TestData.isInteractiveTest()) {
                RasterSymbolizerTest.visualize((RenderedImage)finalimage, "spearfish");
            } else {
                finalimage.getTiles();
            }
            finalimage.dispose();
        }
    }

    private RenderedImage getSpearfhisDemo() throws IOException, FileNotFoundException {
        AsciiGridsImageReader reader = (AsciiGridsImageReader)new AsciiGridsImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(TestData.file((Object)((Object)this), (String)"arcgrid/spearfish_dem.arx")));
        RenderedImage image = reader.readAsRenderedImage(0, null);
        return image;
    }

    @Test
    public void SWAN() throws IOException {
        RenderedImage image = this.getSWAN();
        for (int i = 0; i < 1; ++i) {
            LinearColorMapElement c0 = LinearColorMapElement.create((CharSequence)"c0", (Color)Color.green, (NumberRange)NumberRange.create((double)Double.NEGATIVE_INFINITY, (double)0.3), (int)51);
            LinearColorMapElement c1 = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.yellow, (NumberRange)NumberRange.create((double)0.3, (boolean)false, (double)0.6, (boolean)true), (int)1);
            LinearColorMapElement c1b = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.BLACK, (NumberRange)NumberRange.create((double)0.3, (boolean)false, (double)0.6, (boolean)true), (int)1);
            LinearColorMapElement c1c = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.yellow, (NumberRange)NumberRange.create((double)0.3, (boolean)false, (double)0.6, (boolean)true), (int)1);
            TestLinearClassifier.assertFalse((boolean)c1.equals((Object)c1b));
            TestLinearClassifier.assertTrue((boolean)c1.equals((Object)c1c));
            LinearColorMapElement c3 = LinearColorMapElement.create((CharSequence)"c3", (Color)Color.red, (NumberRange)NumberRange.create((double)0.6, (boolean)false, (double)0.9, (boolean)true), (int)2);
            LinearColorMapElement c4 = LinearColorMapElement.create((CharSequence)"c4", (Color)Color.BLUE, (NumberRange)NumberRange.create((double)0.9, (boolean)false, (double)Double.POSITIVE_INFINITY, (boolean)true), (int)3);
            LinearColorMapElement nodata = LinearColorMapElement.create((CharSequence)"nodata", (Color)new Color(0, 0, 0, 0), (NumberRange)NumberRange.create((double)-9.0, (double)-9.0), (int)4);
            LinearColorMap list = new LinearColorMap((CharSequence)"testSWAN", new LinearColorMapElement[]{c0, c1, c3, c4}, new LinearColorMapElement[]{nodata}, new Color(0, 0, 0));
            TestLinearClassifier.assertEquals((int)list.getSourceDimensions(), (int)1);
            TestLinearClassifier.assertEquals((int)list.getTargetDimensions(), (int)1);
            TestLinearClassifier.assertEquals((String)list.getName().toString(), (String)"testSWAN");
            TestLinearClassifier.assertNotNull((Object)c0.toString());
            ParameterBlockJAI pbj = new ParameterBlockJAI("org.geotools.RasterClassifier");
            pbj.addSource((Object)image);
            pbj.setParameter("Domain1D", (Object)list);
            try {
                pbj.setParameter("bandIndex", (Object)new Integer(2));
                RenderedOp d = JAI.create((String)"org.geotools.RasterClassifier", (ParameterBlock)pbj);
                d.getTiles();
                TestLinearClassifier.assertTrue((boolean)false);
            }
            catch (Exception e) {
                // empty catch block
            }
            pbj.setParameter("bandIndex", (Object)new Integer(0));
            RenderedOp finalImage = JAI.create((String)"org.geotools.RasterClassifier", (ParameterBlock)pbj);
            if (TestData.isInteractiveTest()) {
                RasterSymbolizerTest.visualize((RenderedImage)finalImage, "testSWAN1");
            } else {
                finalImage.getTiles();
            }
            finalImage.dispose();
        }
    }

    @Test
    public void SWANGAP() throws IOException {
        RenderedImage image = this.getSWAN();
        for (int i = 0; i < 1; ++i) {
            LinearColorMapElement c0 = LinearColorMapElement.create((CharSequence)"c0", (Color)Color.green, (NumberRange)NumberRange.create((double)Double.NEGATIVE_INFINITY, (double)0.3), (int)51);
            LinearColorMapElement c1 = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.yellow, (NumberRange)NumberRange.create((double)0.3, (boolean)false, (double)0.6, (boolean)true), (int)1);
            LinearColorMapElement c3 = LinearColorMapElement.create((CharSequence)"c3", (Color)Color.red, (NumberRange)NumberRange.create((double)0.7, (boolean)false, (double)0.9, (boolean)true), (int)2);
            LinearColorMapElement c4 = LinearColorMapElement.create((CharSequence)"c4", (Color)Color.BLUE, (NumberRange)NumberRange.create((double)0.9, (boolean)false, (double)Double.POSITIVE_INFINITY, (boolean)true), (int)3);
            LinearColorMapElement nodata = LinearColorMapElement.create((CharSequence)"nodata", (Color)Color.red, (NumberRange)NumberRange.create((double)-9.0, (double)-9.0), (int)4);
            LinearColorMap list = new LinearColorMap((CharSequence)"testSWAN", new LinearColorMapElement[]{c0, c1, c3, c4}, new LinearColorMapElement[]{nodata}, new Color(0, 0, 0, 0));
            ParameterBlockJAI pbj = new ParameterBlockJAI("org.geotools.RasterClassifier");
            pbj.addSource((Object)image);
            pbj.setParameter("Domain1D", (Object)list);
            try {
                pbj.setParameter("bandIndex", (Object)new Integer(2));
                RenderedOp d = JAI.create((String)"org.geotools.RasterClassifier", (ParameterBlock)pbj);
                d.getTiles();
                TestLinearClassifier.assertTrue((boolean)false);
            }
            catch (Exception e) {
                // empty catch block
            }
            pbj.setParameter("bandIndex", (Object)new Integer(0));
            RenderedOp finalImage = JAI.create((String)"org.geotools.RasterClassifier", (ParameterBlock)pbj);
            IndexColorModel icm = (IndexColorModel)finalImage.getColorModel();
            TestLinearClassifier.assertEquals((int)icm.getRed(4), (int)255);
            TestLinearClassifier.assertEquals((int)icm.getRed(2), (int)255);
            if (TestData.isInteractiveTest()) {
                RasterSymbolizerTest.visualize((RenderedImage)finalImage, "testSWANGAP");
            } else {
                finalImage.getTiles();
            }
            finalImage.dispose();
        }
    }

    private RenderedImage getSWAN() throws IOException, FileNotFoundException {
        AsciiGridsImageReader reader = (AsciiGridsImageReader)new AsciiGridsImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(TestData.file((Object)((Object)this), (String)"arcgrid/SWAN_NURC_LigurianSeaL07_HSIGN.asc")));
        RenderedImage image = reader.readAsRenderedImage(0, null);
        return image;
    }

    @Test
    public void noDataOnly() throws IOException, TransformException {
        for (int i = 0; i < 1; ++i) {
            LinearColorMapElement n0 = LinearColorMapElement.create((CharSequence)"nodata", (Color)new Color(0, 0, 0, 0), (NumberRange)NumberRange.create((double)Double.NaN, (double)Double.NaN), (int)9999);
            LinearColorMap list = new LinearColorMap((CharSequence)"", new LinearColorMapElement[]{n0});
            double testNum = Math.random();
            try {
                TestLinearClassifier.assertEquals((double)list.transform(testNum), (double)testNum, (double)0.0);
                TestLinearClassifier.assertTrue((boolean)false);
            }
            catch (Exception e) {
                // empty catch block
            }
            TestLinearClassifier.assertEquals((double)list.transform(Double.NaN), (double)9999.0, (double)0.0);
        }
    }

    static {
        RasterClassifier.register((JAI)JAI.getDefaultInstance());
    }
}

